/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreAdminHandler
extends RequestHandlerBase {
    @Override
    public final void init(NamedList args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    public abstract CoreContainer getCoreContainer();

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        boolean do_persist = false;
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.STATUS;
        String a = params.get("action");
        if (a != null && (action = CoreAdminParams.CoreAdminAction.get((String)a)) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown 'action' value.  Use: " + CoreAdminParams.CoreAdminAction.values());
        }
        String cname = params.get("core");
        switch (action) {
            case CREATE: {
                String name = params.get("name");
                CoreDescriptor dcore = new CoreDescriptor(cores, name, params.get("instanceDir"));
                String opts = params.get("config");
                if (opts != null) {
                    dcore.setConfigName(opts);
                }
                if ((opts = params.get("schema")) != null) {
                    dcore.setSchemaName(opts);
                }
                SolrCore core = cores.create(dcore);
                cores.register(name, core, false);
                rsp.add("core", core.getName());
                do_persist = cores.isPersistent();
                break;
            }
            case RENAME: {
                SolrCore core;
                String name = params.get("other");
                if (cname.equals(name) || (core = cores.getCore(cname)) == null) break;
                do_persist = cores.isPersistent();
                cores.register(name, core, false);
                cores.remove(cname);
                core.close();
                break;
            }
            case ALIAS: {
                SolrCore core;
                String name = params.get("other");
                if (cname.equals(name) || (core = cores.getCore(cname)) == null) break;
                do_persist = cores.isPersistent();
                cores.register(name, core, false);
                break;
            }
            case UNLOAD: {
                SolrCore core = cores.remove(cname);
                core.close();
                do_persist = cores.isPersistent();
                break;
            }
            case STATUS: {
                SimpleOrderedMap status = new SimpleOrderedMap();
                if (cname == null) {
                    for (String name : cores.getCoreNames()) {
                        status.add(name, CoreAdminHandler.getCoreStatus(cores, name));
                    }
                } else {
                    status.add(cname, CoreAdminHandler.getCoreStatus(cores, cname));
                }
                rsp.add("status", status);
                do_persist = false;
                break;
            }
            case PERSIST: {
                String fileName = params.get("file");
                if (fileName != null) {
                    File file = new File(cores.getConfigFile().getParentFile(), fileName);
                    cores.persistFile(file);
                    rsp.add("saved", file.getAbsolutePath());
                    do_persist = false;
                    break;
                }
                if (!cores.isPersistent()) {
                    throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Persistence is not enabled");
                }
                do_persist = true;
                break;
            }
            case RELOAD: {
                cores.reload(cname);
                do_persist = false;
                break;
            }
            case SWAP: {
                do_persist = params.getBool("persistent", cores.isPersistent());
                String other = required.get("other");
                cores.swap(cname, other);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "TODO: IMPLEMENT: " + action);
            }
        }
        if (do_persist) {
            cores.persist();
            rsp.add("saved", cores.getConfigFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedList<Object> getCoreStatus(CoreContainer cores, String cname) throws IOException {
        SimpleOrderedMap info = new SimpleOrderedMap();
        SolrCore core = cores.getCore(cname);
        if (core != null) {
            try {
                info.add("name", (Object)core.getName());
                info.add("instanceDir", (Object)core.getResourceLoader().getInstanceDir());
                info.add("dataDir", (Object)core.getDataDir());
                info.add("startTime", (Object)new Date(core.getStartTime()));
                info.add("uptime", (Object)(System.currentTimeMillis() - core.getStartTime()));
                RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                info.add("index", LukeRequestHandler.getIndexInfo(searcher.get().getReader(), false));
                searcher.decref();
            }
            finally {
                core.close();
            }
        }
        return info;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public String getVersion() {
        return "$Revision: 688427 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: CoreAdminHandler.java 688427 2008-08-23 22:58:16Z shalin $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/admin/CoreAdminHandler.java $";
    }
}

