/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class RangeMapFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float min;
    protected final float max;
    protected final float target;

    public RangeMapFloatFunction(ValueSource source, float min, float max, float target) {
        this.source = source;
        this.min = min;
        this.max = max;
        this.target = target;
    }

    public String description() {
        return "map(" + this.source.description() + "," + this.min + "," + this.max + "," + this.target + ")";
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(reader);
        return new DocValues(){

            public float floatVal(int doc) {
                float val = vals.floatVal(doc);
                return val >= RangeMapFloatFunction.this.min && val <= RangeMapFloatFunction.this.max ? RangeMapFloatFunction.this.target : val;
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return "map(" + vals.toString(doc) + ",min=" + RangeMapFloatFunction.this.min + ",max=" + RangeMapFloatFunction.this.max + ",target=" + RangeMapFloatFunction.this.target + ")";
            }
        };
    }

    public int hashCode() {
        int h = this.source.hashCode();
        h ^= h << 10 | h >>> 23;
        Float.floatToIntBits(this.min);
        h ^= h << 14 | h >>> 19;
        h += Float.floatToIntBits(this.max);
        h ^= h << 13 | h >>> 20;
        return h += Float.floatToIntBits(this.target);
    }

    public boolean equals(Object o) {
        if (RangeMapFloatFunction.class != o.getClass()) {
            return false;
        }
        RangeMapFloatFunction other = (RangeMapFloatFunction)o;
        return this.min == other.min && this.max == other.max && this.target == other.target && this.source.equals(other.source);
    }
}

