/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.PatternTokenizer;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DateTimePatternGenerator
implements Freezable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int QUARTER = 2;
    public static final int MONTH = 3;
    public static final int WEEK_OF_YEAR = 4;
    public static final int WEEK_OF_MONTH = 5;
    public static final int WEEKDAY = 6;
    public static final int DAY = 7;
    public static final int DAY_OF_YEAR = 8;
    public static final int DAY_OF_WEEK_IN_MONTH = 9;
    public static final int DAYPERIOD = 10;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int FRACTIONAL_SECOND = 14;
    public static final int ZONE = 15;
    public static final int TYPE_LIMIT = 16;
    private TreeMap skeleton2pattern = new TreeMap();
    private TreeMap basePattern_pattern = new TreeMap();
    private String decimal = "?";
    private String dateTimeFormat = "{0} {1}";
    private String[] appendItemFormats = new String[16];
    private String[] appendItemNames = new String[16];
    private transient DateTimeMatcher current;
    private transient FormatParser fp;
    private transient DistanceInfo _distanceInfo;
    private transient DateTimeMatcher skipMatcher;
    private transient boolean frozen;
    private transient boolean chineseMonthHack;
    private static final int FRACTIONAL_MASK = 16384;
    private static final int SECOND_AND_FRACTIONAL_MASK = 24576;
    private static String[] CLDR_FIELD_APPEND = new String[]{"Era", "Year", "Quarter", "Month", "Week", "*", "Day-Of-Week", "Day", "*", "*", "*", "Hour", "Minute", "Second", "*", "Timezone"};
    private static String[] CLDR_FIELD_NAME = new String[]{"era", "year", "*", "month", "week", "*", "weekday", "day", "*", "*", "dayperiod", "hour", "minute", "second", "*", "zone"};
    private static String[] FIELD_NAME = new String[]{"Era", "Year", "Quarter", "Month", "Week_in_Year", "Week_in_Month", "Weekday", "Day", "Day_Of_Year", "Day_of_Week_in_Month", "Dayperiod", "Hour", "Minute", "Second", "Fractional_Second", "Zone"};
    private static String[] CANONICAL_ITEMS = new String[]{"G", "y", "Q", "M", "w", "W", "e", "d", "D", "F", "H", "m", "s", "S", "v"};
    private static Set CANONICAL_SET = new HashSet<String>(Arrays.asList(CANONICAL_ITEMS));
    private Set cldrAvailableFormatKeys;
    private static final int DATE_MASK = 1023;
    private static final int TIME_MASK = 64512;
    private static final int DELTA = 16;
    private static final int NUMERIC = 256;
    private static final int NONE = 0;
    private static final int NARROW = -257;
    private static final int SHORT = -258;
    private static final int LONG = -259;
    private static final int EXTRA_FIELD = 65536;
    private static final int MISSING_FIELD = 4096;
    private static int[][] types;

    static {
        int[][] nArrayArray = new int[54][];
        int[] nArray = new int[5];
        nArray[0] = 71;
        nArray[2] = -258;
        nArray[3] = 1;
        nArray[4] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 71;
        nArray2[2] = -259;
        nArray2[3] = 4;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{121, 1, 256, 1, 20};
        nArrayArray[3] = new int[]{89, 1, 272, 1, 20};
        nArrayArray[4] = new int[]{117, 1, 288, 1, 20};
        nArrayArray[5] = new int[]{81, 2, 256, 1, 2};
        nArrayArray[6] = new int[]{81, 2, -258, 3};
        nArrayArray[7] = new int[]{81, 2, -259, 4};
        nArrayArray[8] = new int[]{113, 2, 272, 1, 2};
        nArrayArray[9] = new int[]{113, 2, -242, 3};
        nArrayArray[10] = new int[]{113, 2, -243, 4};
        nArrayArray[11] = new int[]{77, 3, 256, 1, 2};
        nArrayArray[12] = new int[]{77, 3, -258, 3};
        nArrayArray[13] = new int[]{77, 3, -259, 4};
        nArrayArray[14] = new int[]{77, 3, -257, 5};
        nArrayArray[15] = new int[]{76, 3, 272, 1, 2};
        nArrayArray[16] = new int[]{76, 3, -274, 3};
        nArrayArray[17] = new int[]{76, 3, -275, 4};
        nArrayArray[18] = new int[]{76, 3, -273, 5};
        nArrayArray[19] = new int[]{119, 4, 256, 1, 2};
        nArrayArray[20] = new int[]{87, 5, 272, 1};
        nArrayArray[21] = new int[]{101, 6, 272, 1, 2};
        nArrayArray[22] = new int[]{101, 6, -274, 3};
        nArrayArray[23] = new int[]{101, 6, -275, 4};
        nArrayArray[24] = new int[]{101, 6, -273, 5};
        nArrayArray[25] = new int[]{69, 6, -258, 1, 3};
        nArrayArray[26] = new int[]{69, 6, -259, 4};
        nArrayArray[27] = new int[]{69, 6, -257, 5};
        nArrayArray[28] = new int[]{99, 6, 288, 1, 2};
        nArrayArray[29] = new int[]{99, 6, -290, 3};
        nArrayArray[30] = new int[]{99, 6, -291, 4};
        nArrayArray[31] = new int[]{99, 6, -289, 5};
        nArrayArray[32] = new int[]{100, 7, 256, 1, 2};
        nArrayArray[33] = new int[]{68, 8, 272, 1, 3};
        nArrayArray[34] = new int[]{70, 9, 288, 1};
        nArrayArray[35] = new int[]{103, 7, 304, 1, 20};
        nArrayArray[36] = new int[]{97, 10, -258, 1};
        nArrayArray[37] = new int[]{72, 11, 416, 1, 2};
        nArrayArray[38] = new int[]{107, 11, 432, 1, 2};
        nArrayArray[39] = new int[]{104, 11, 256, 1, 2};
        nArrayArray[40] = new int[]{75, 11, 272, 1, 2};
        nArrayArray[41] = new int[]{106, 11, 576, 1, 2};
        nArrayArray[42] = new int[]{109, 12, 256, 1, 2};
        nArrayArray[43] = new int[]{115, 13, 256, 1, 2};
        nArrayArray[44] = new int[]{83, 14, 272, 1, 1000};
        nArrayArray[45] = new int[]{65, 13, 288, 1, 1000};
        nArrayArray[46] = new int[]{118, 15, -290, 1};
        nArrayArray[47] = new int[]{118, 15, -291, 4};
        nArrayArray[48] = new int[]{122, 15, -258, 1, 3};
        nArrayArray[49] = new int[]{122, 15, -259, 4};
        nArrayArray[50] = new int[]{90, 15, -274, 1, 3};
        nArrayArray[51] = new int[]{90, 15, -275, 4};
        nArrayArray[52] = new int[]{86, 15, -274, 1, 3};
        nArrayArray[53] = new int[]{86, 15, -275, 4};
        types = nArrayArray;
    }

    public static DateTimePatternGenerator getEmptyInstance() {
        return new DateTimePatternGenerator();
    }

    protected DateTimePatternGenerator() {
        int i = 0;
        while (i < 16) {
            this.appendItemFormats[i] = "{0} \u251c{2}: {1}\u2524";
            this.appendItemNames[i] = "F" + i;
            ++i;
        }
        this.current = new DateTimeMatcher();
        this.fp = new FormatParser();
        this._distanceInfo = new DistanceInfo();
        this.skipMatcher = null;
        this.frozen = false;
        this.chineseMonthHack = false;
        this.complete();
        this.cldrAvailableFormatKeys = new HashSet(20);
    }

    public static DateTimePatternGenerator getInstance() {
        return DateTimePatternGenerator.getInstance(ULocale.getDefault());
    }

    public static DateTimePatternGenerator getInstance(ULocale uLocale) {
        String value;
        DateTimePatternGenerator result = new DateTimePatternGenerator();
        String lang = uLocale.getLanguage();
        if (lang.equals("zh") || lang.equals("ko") || lang.equals("ja")) {
            result.chineseMonthHack = true;
        }
        PatternInfo returnInfo = new PatternInfo();
        String hackPattern = null;
        int i = 0;
        while (i <= 3) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(i, uLocale);
            result.addPattern(df.toPattern(), false, returnInfo);
            df = (SimpleDateFormat)DateFormat.getTimeInstance(i, uLocale);
            result.addPattern(df.toPattern(), false, returnInfo);
            if (i == 2) {
                hackPattern = df.toPattern();
            }
            ++i;
        }
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", uLocale);
        rb = rb.getWithFallback("calendar");
        ICUResourceBundle gregorianBundle = rb.getWithFallback("gregorian");
        ICUResourceBundle itemBundle = gregorianBundle.getWithFallback("appendItems");
        int i2 = 0;
        while (i2 < itemBundle.getSize()) {
            ICUResourceBundle formatBundle = (ICUResourceBundle)itemBundle.get(i2);
            String formatName = itemBundle.get(i2).getKey();
            value = formatBundle.getString();
            result.setAppendItemFormat(DateTimePatternGenerator.getAppendFormatNumber(formatName), value);
            ++i2;
        }
        itemBundle = gregorianBundle.getWithFallback("fields");
        int i3 = 0;
        while (i3 < 16) {
            if (DateTimePatternGenerator.isCLDRFieldName(i3)) {
                ICUResourceBundle fieldBundle = itemBundle.getWithFallback(CLDR_FIELD_NAME[i3]);
                ICUResourceBundle dnBundle = fieldBundle.getWithFallback("dn");
                value = dnBundle.getString();
                result.setAppendItemName(i3, value);
            }
            ++i3;
        }
        try {
            ICUResourceBundle formatBundle = gregorianBundle.getWithFallback("availableFormats");
            int i4 = 0;
            while (i4 < formatBundle.getSize()) {
                String formatKey = formatBundle.get(i4).getKey();
                String formatValue = formatBundle.get(i4).getString();
                result.setAvailableFormat(formatKey);
                result.addPattern(formatValue, false, returnInfo);
                ++i4;
            }
        }
        catch (Exception exception) {}
        ULocale parentLocale = uLocale;
        while ((parentLocale = parentLocale.getFallback()) != null) {
            ICUResourceBundle prb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", parentLocale);
            prb = prb.getWithFallback("calendar");
            ICUResourceBundle pGregorianBundle = prb.getWithFallback("gregorian");
            try {
                ICUResourceBundle formatBundle = pGregorianBundle.getWithFallback("availableFormats");
                int i5 = 0;
                while (i5 < formatBundle.getSize()) {
                    String formatKey = formatBundle.get(i5).getKey();
                    String formatValue = formatBundle.get(i5).getString();
                    if (!result.isAvailableFormatSet(formatKey)) {
                        result.setAvailableFormat(formatKey);
                        result.addPattern(formatValue, false, returnInfo);
                    }
                    ++i5;
                }
            }
            catch (Exception exception) {}
        }
        if (hackPattern != null) {
            DateTimePatternGenerator.hackTimes(result, returnInfo, hackPattern);
        }
        Calendar cal = Calendar.getInstance(uLocale);
        CalendarData calData = new CalendarData(uLocale, cal.getType());
        String[] patterns = calData.get("DateTimePatterns").getStringArray();
        result.setDateTimeFormat(patterns[8]);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(uLocale);
        result.setDecimal(String.valueOf(dfs.getDecimalSeparator()));
        return result;
    }

    private static void hackTimes(DateTimePatternGenerator result, PatternInfo returnInfo, String hackPattern) {
        result.fp.set(hackPattern);
        String mmss = new String();
        boolean gotMm = false;
        int i = 0;
        while (i < result.fp.items.size()) {
            Object item = result.fp.items.get(i);
            if (item instanceof String) {
                if (gotMm) {
                    mmss = String.valueOf(mmss) + result.fp.quoteLiteral(item.toString());
                }
            } else {
                char ch = item.toString().charAt(0);
                if (ch == 'm') {
                    gotMm = true;
                    mmss = String.valueOf(mmss) + item;
                } else {
                    if (ch == 's') {
                        if (!gotMm) break;
                        mmss = String.valueOf(mmss) + item;
                        result.addPattern(mmss, false, returnInfo);
                        break;
                    }
                    if (gotMm || ch == 'z' || ch == 'Z' || ch == 'v' || ch == 'V') break;
                }
            }
            ++i;
        }
        BitSet variables = new BitSet();
        BitSet nuke = new BitSet();
        int i2 = 0;
        while (i2 < result.fp.items.size()) {
            Object item = result.fp.items.get(i2);
            if (item instanceof VariableField) {
                variables.set(i2);
                char ch = item.toString().charAt(0);
                if (ch == 's' || ch == 'S') {
                    nuke.set(i2);
                    int j = i2 - 1;
                    while (j >= 0) {
                        if (variables.get(j)) break;
                        nuke.set(i2);
                        ++j;
                    }
                }
            }
            ++i2;
        }
        String hhmm = DateTimePatternGenerator.getFilteredPattern(result.fp, nuke);
        result.addPattern(hhmm, false, returnInfo);
    }

    private static String getFilteredPattern(FormatParser fp, BitSet nuke) {
        String result = new String();
        int i = 0;
        while (i < fp.items.size()) {
            if (!nuke.get(i)) {
                Object item = fp.items.get(i);
                result = item instanceof String ? String.valueOf(result) + fp.quoteLiteral(item.toString()) : String.valueOf(result) + item.toString();
            }
            ++i;
        }
        return result;
    }

    private static int getAppendFormatNumber(String string) {
        int i = 0;
        while (i < CLDR_FIELD_APPEND.length) {
            if (CLDR_FIELD_APPEND[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isCLDRFieldName(int index) {
        if (index < 0 && index >= 16) {
            return false;
        }
        return CLDR_FIELD_NAME[index].charAt(0) != '*';
    }

    public String getBestPattern(String skeleton) {
        int monidx;
        if (this.chineseMonthHack && (monidx = skeleton.indexOf("MMM")) >= 0) {
            StringBuffer tmp = new StringBuffer(skeleton.substring(0, monidx));
            tmp.append("MM");
            monidx += 3;
            while (monidx < skeleton.length()) {
                if (skeleton.charAt(monidx) != 'M') break;
                ++monidx;
            }
            tmp.append(skeleton.substring(monidx));
            skeleton = tmp.toString();
        }
        this.current.set(skeleton, this.fp);
        String best = this.getBestRaw(this.current, -1, this._distanceInfo);
        if (this._distanceInfo.missingFieldMask == 0 && this._distanceInfo.extraFieldMask == 0) {
            return this.adjustFieldTypes(best, this.current, false);
        }
        int neededFields = this.current.getFieldMask();
        String datePattern = this.getBestAppending(neededFields & 0x3FF);
        String timePattern = this.getBestAppending(neededFields & 0xFC00);
        if (datePattern == null) {
            return timePattern == null ? "" : timePattern;
        }
        if (timePattern == null) {
            return datePattern;
        }
        return MessageFormat.format(this.getDateTimeFormat(), new Object[]{timePattern, datePattern});
    }

    public DateTimePatternGenerator addPattern(String pattern, boolean override, PatternInfo returnInfo) {
        String previousValue;
        this.checkFrozen();
        DateTimeMatcher matcher = new DateTimeMatcher().set(pattern, this.fp);
        String basePattern = matcher.getBasePattern();
        String previousPatternWithSameBase = (String)this.basePattern_pattern.get(basePattern);
        if (previousPatternWithSameBase != null) {
            returnInfo.status = 1;
            returnInfo.conflictingPattern = previousPatternWithSameBase;
            if (!override) {
                return this;
            }
        }
        if ((previousValue = (String)this.skeleton2pattern.get(matcher)) != null) {
            returnInfo.status = 2;
            returnInfo.conflictingPattern = previousValue;
            if (!override) {
                return this;
            }
        }
        returnInfo.status = 0;
        returnInfo.conflictingPattern = "";
        this.skeleton2pattern.put(matcher, pattern);
        this.basePattern_pattern.put(basePattern, pattern);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp);
            return this.current.getBasePattern();
        }
    }

    public Map getSkeletons(Map result) {
        if (result == null) {
            result = new HashMap<String, String>();
        }
        Iterator it = this.skeleton2pattern.keySet().iterator();
        while (it.hasNext()) {
            DateTimeMatcher item = (DateTimeMatcher)it.next();
            String pattern = (String)this.skeleton2pattern.get(item);
            if (CANONICAL_SET.contains(pattern)) continue;
            result.put(item.toString(), pattern);
        }
        return result;
    }

    public Set getBaseSkeletons(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(this.basePattern_pattern.keySet());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceFieldTypes(String pattern, String skeleton) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            return this.adjustFieldTypes(pattern, this.current.set(skeleton, this.fp), false);
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.checkFrozen();
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDecimal(String decimal) {
        this.checkFrozen();
        this.decimal = decimal;
    }

    public String getDecimal() {
        return this.decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRedundants(Collection output) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            if (output == null) {
                output = new HashSet<String>();
            }
            Iterator it = this.skeleton2pattern.keySet().iterator();
            while (it.hasNext()) {
                DateTimeMatcher cur = (DateTimeMatcher)it.next();
                String pattern = (String)this.skeleton2pattern.get(cur);
                if (CANONICAL_SET.contains(pattern)) continue;
                this.skipMatcher = cur;
                String trial = this.getBestPattern(cur.toString());
                if (!trial.equals(pattern)) continue;
                output.add(pattern);
            }
            return output;
        }
    }

    public void setAppendItemFormat(int field, String value) {
        this.checkFrozen();
        this.appendItemFormats[field] = value;
    }

    public String getAppendItemFormat(int field) {
        return this.appendItemFormats[field];
    }

    public void setAppendItemName(int field, String value) {
        this.checkFrozen();
        this.appendItemNames[field] = value;
    }

    public String getAppendItemName(int field) {
        return this.appendItemNames[field];
    }

    public static boolean isSingleField(String skeleton) {
        char first = skeleton.charAt(0);
        int i = 1;
        while (i < skeleton.length()) {
            if (skeleton.charAt(i) != first) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setAvailableFormat(String key) {
        this.checkFrozen();
        this.cldrAvailableFormatKeys.add(key);
    }

    private boolean isAvailableFormatSet(String key) {
        return this.cldrAvailableFormatKeys.contains(key);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Object freeze() {
        this.frozen = true;
        return this;
    }

    public Object cloneAsThawed() {
        DateTimePatternGenerator result = (DateTimePatternGenerator)this.clone();
        this.frozen = false;
        return result;
    }

    public Object clone() {
        try {
            DateTimePatternGenerator result = (DateTimePatternGenerator)super.clone();
            result.skeleton2pattern = (TreeMap)this.skeleton2pattern.clone();
            result.basePattern_pattern = (TreeMap)this.basePattern_pattern.clone();
            result.appendItemFormats = (String[])this.appendItemFormats.clone();
            result.appendItemNames = (String[])this.appendItemNames.clone();
            result.current = new DateTimeMatcher();
            result.fp = new FormatParser();
            result._distanceInfo = new DistanceInfo();
            result.frozen = false;
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("Internal Error");
        }
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private String getBestAppending(int missingFields) {
        String resultPattern = null;
        if (missingFields != 0) {
            resultPattern = this.getBestRaw(this.current, missingFields, this._distanceInfo);
            resultPattern = this.adjustFieldTypes(resultPattern, this.current, false);
            while (this._distanceInfo.missingFieldMask != 0) {
                if ((this._distanceInfo.missingFieldMask & 0x6000) == 16384 && (missingFields & 0x6000) == 24576) {
                    resultPattern = this.adjustFieldTypes(resultPattern, this.current, true);
                    this._distanceInfo.missingFieldMask &= 0xFFFFBFFF;
                    continue;
                }
                int startingMask = this._distanceInfo.missingFieldMask;
                String temp = this.getBestRaw(this.current, this._distanceInfo.missingFieldMask, this._distanceInfo);
                temp = this.adjustFieldTypes(temp, this.current, false);
                int foundMask = startingMask & ~this._distanceInfo.missingFieldMask;
                int topField = this.getTopBitNumber(foundMask);
                resultPattern = MessageFormat.format(this.getAppendFormat(topField), new Object[]{resultPattern, temp, this.getAppendName(topField)});
            }
        }
        return resultPattern;
    }

    private String getAppendName(int foundMask) {
        return "'" + this.appendItemNames[foundMask] + "'";
    }

    private String getAppendFormat(int foundMask) {
        return this.appendItemFormats[foundMask];
    }

    private int getTopBitNumber(int foundMask) {
        int i = 0;
        while (foundMask != 0) {
            foundMask >>>= 1;
            ++i;
        }
        return i - 1;
    }

    private void complete() {
        PatternInfo patternInfo = new PatternInfo();
        int i = 0;
        while (i < CANONICAL_ITEMS.length) {
            this.addPattern(String.valueOf(CANONICAL_ITEMS[i]), false, patternInfo);
            ++i;
        }
    }

    private String getBestRaw(DateTimeMatcher source, int includeMask, DistanceInfo missingFields) {
        int bestDistance = Integer.MAX_VALUE;
        String bestPattern = "";
        DistanceInfo tempInfo = new DistanceInfo();
        Iterator it = this.skeleton2pattern.keySet().iterator();
        while (it.hasNext()) {
            int distance;
            DateTimeMatcher trial = (DateTimeMatcher)it.next();
            if (trial.equals(this.skipMatcher) || (distance = source.getDistance(trial, includeMask, tempInfo)) >= bestDistance) continue;
            bestDistance = distance;
            bestPattern = (String)this.skeleton2pattern.get(trial);
            missingFields.setTo(tempInfo);
            if (distance == 0) break;
        }
        return bestPattern;
    }

    private String adjustFieldTypes(String pattern, DateTimeMatcher inputRequest, boolean fixFractionalSeconds) {
        this.fp.set(pattern);
        StringBuffer newPattern = new StringBuffer();
        Iterator it = this.fp.getItems().iterator();
        while (it.hasNext()) {
            String newField;
            Object item = it.next();
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            VariableField variableField = (VariableField)item;
            String field = variableField.toString();
            int type = variableField.getType();
            if (fixFractionalSeconds && type == 13) {
                newField = inputRequest.original[14];
                field = String.valueOf(field) + this.decimal + newField;
            } else if (inputRequest.type[type] != 0) {
                newField = inputRequest.original[type];
                if (type != 11) {
                    field = newField;
                } else if (field.length() != newField.length()) {
                    char c = field.charAt(0);
                    field = "";
                    int i = newField.length();
                    while (i > 0) {
                        field = String.valueOf(field) + c;
                        --i;
                    }
                }
            }
            newPattern.append(field);
        }
        return newPattern.toString();
    }

    public String getFields(String pattern) {
        this.fp.set(pattern);
        StringBuffer newPattern = new StringBuffer();
        Iterator it = this.fp.getItems().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            newPattern.append("{" + DateTimePatternGenerator.getName(item.toString()) + "}");
        }
        return newPattern.toString();
    }

    private static String showMask(int mask) {
        String result = "";
        int i = 0;
        while (i < 16) {
            if ((mask & 1 << i) != 0) {
                if (result.length() != 0) {
                    result = String.valueOf(result) + " | ";
                }
                result = String.valueOf(result) + FIELD_NAME[i] + " ";
            }
            ++i;
        }
        return result;
    }

    private static String getName(String s) {
        boolean string;
        int i = DateTimePatternGenerator.getCanonicalIndex(s, true);
        String name = FIELD_NAME[types[i][1]];
        int subtype = types[i][2];
        boolean bl = string = subtype < 0;
        if (string) {
            subtype = -subtype;
        }
        name = subtype < 0 ? String.valueOf(name) + ":S" : String.valueOf(name) + ":N";
        return name;
    }

    private static int getCanonicalIndex(String s, boolean strict) {
        int len = s.length();
        if (len == 0) {
            return -1;
        }
        char ch = s.charAt(0);
        int i = 1;
        while (i < len) {
            if (s.charAt(i) != ch) {
                return -1;
            }
            ++i;
        }
        int bestRow = -1;
        int i2 = 0;
        while (i2 < types.length) {
            int[] row = types[i2];
            if (row[0] == ch) {
                bestRow = i2;
                if (row[3] <= len && row[row.length - 1] >= len) {
                    return i2;
                }
            }
            ++i2;
        }
        return strict ? -1 : bestRow;
    }

    private static class DateTimeMatcher
    implements Comparable {
        private int[] type = new int[16];
        private String[] original = new String[16];
        private String[] baseOriginal = new String[16];

        private DateTimeMatcher() {
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < 16) {
                if (this.original[i].length() != 0) {
                    result.append(this.original[i]);
                }
                ++i;
            }
            return result.toString();
        }

        String getBasePattern() {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < 16) {
                if (this.baseOriginal[i].length() != 0) {
                    result.append(this.baseOriginal[i]);
                }
                ++i;
            }
            return result.toString();
        }

        DateTimeMatcher set(String pattern, FormatParser fp) {
            int i = 0;
            while (i < 16) {
                this.type[i] = 0;
                this.original[i] = "";
                this.baseOriginal[i] = "";
                ++i;
            }
            fp.set(pattern);
            Iterator it = fp.getItems().iterator();
            while (it.hasNext()) {
                VariableField item;
                String field;
                Object obj = it.next();
                if (!(obj instanceof VariableField) || (field = (item = (VariableField)obj).toString()).charAt(0) == 'a') continue;
                int canonicalIndex = item.getCanonicalIndex();
                int[] row = types[canonicalIndex];
                int typeValue = row[1];
                if (this.original[typeValue].length() != 0) {
                    throw new IllegalArgumentException("Conflicting fields:\t" + this.original[typeValue] + ", " + field + "\t in " + pattern);
                }
                this.original[typeValue] = field;
                char repeatChar = (char)row[0];
                int repeatCount = row[3];
                if (repeatCount > 3) {
                    repeatCount = 3;
                }
                if ("GEzvQ".indexOf(repeatChar) >= 0) {
                    repeatCount = 1;
                }
                this.baseOriginal[typeValue] = Utility.repeat(String.valueOf(repeatChar), repeatCount);
                int subTypeValue = row[2];
                if (subTypeValue > 0) {
                    subTypeValue += field.length();
                }
                this.type[typeValue] = (byte)subTypeValue;
            }
            return this;
        }

        int getFieldMask() {
            int result = 0;
            int i = 0;
            while (i < this.type.length) {
                if (this.type[i] != 0) {
                    result |= 1 << i;
                }
                ++i;
            }
            return result;
        }

        void extractFrom(DateTimeMatcher source, int fieldMask) {
            int i = 0;
            while (i < this.type.length) {
                if ((fieldMask & 1 << i) != 0) {
                    this.type[i] = source.type[i];
                    this.original[i] = source.original[i];
                } else {
                    this.type[i] = 0;
                    this.original[i] = "";
                }
                ++i;
            }
        }

        int getDistance(DateTimeMatcher other, int includeMask, DistanceInfo distanceInfo) {
            int result = 0;
            distanceInfo.clear();
            int i = 0;
            while (i < this.type.length) {
                int otherType;
                int myType = (includeMask & 1 << i) == 0 ? 0 : this.type[i];
                if (myType != (otherType = other.type[i])) {
                    if (myType == 0) {
                        result += 65536;
                        distanceInfo.addExtra(i);
                    } else if (otherType == 0) {
                        result += 4096;
                        distanceInfo.addMissing(i);
                    } else {
                        result += Math.abs(myType - otherType);
                    }
                }
                ++i;
            }
            return result;
        }

        public int compareTo(Object o) {
            DateTimeMatcher that = (DateTimeMatcher)o;
            int i = 0;
            while (i < this.original.length) {
                int comp = this.original[i].compareTo(that.original[i]);
                if (comp != 0) {
                    return -comp;
                }
                ++i;
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            DateTimeMatcher that = (DateTimeMatcher)other;
            int i = 0;
            while (i < this.original.length) {
                if (!this.original[i].equals(that.original[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            int result = 0;
            int i = 0;
            while (i < this.original.length) {
                result ^= this.original[i].hashCode();
                ++i;
            }
            return result;
        }
    }

    private static class DistanceInfo {
        int missingFieldMask;
        int extraFieldMask;

        private DistanceInfo() {
        }

        void clear() {
            this.extraFieldMask = 0;
            this.missingFieldMask = 0;
        }

        void setTo(DistanceInfo other) {
            this.missingFieldMask = other.missingFieldMask;
            this.extraFieldMask = other.extraFieldMask;
        }

        void addMissing(int field) {
            this.missingFieldMask |= 1 << field;
        }

        void addExtra(int field) {
            this.extraFieldMask |= 1 << field;
        }

        public String toString() {
            return "missingFieldMask: " + DateTimePatternGenerator.showMask(this.missingFieldMask) + ", extraFieldMask: " + DateTimePatternGenerator.showMask(this.extraFieldMask);
        }
    }

    public static class FormatParser {
        private transient PatternTokenizer tokenizer = new PatternTokenizer().setSyntaxCharacters(new UnicodeSet("[a-zA-Z]")).setExtraQuotingCharacters(new UnicodeSet("[[[:script=Latn:][:script=Cyrl:]]&[[:L:][:M:]]]")).setUsingQuote(true);
        private List items = new ArrayList();

        public final FormatParser set(String string) {
            return this.set(string, false);
        }

        public FormatParser set(String string, boolean strict) {
            this.items.clear();
            if (string.length() == 0) {
                return this;
            }
            this.tokenizer.setPattern(string);
            StringBuffer buffer = new StringBuffer();
            StringBuffer variable = new StringBuffer();
            while (true) {
                buffer.setLength(0);
                int status = this.tokenizer.next(buffer);
                if (status == 0) break;
                if (status == 1) {
                    if (variable.length() != 0 && buffer.charAt(0) != variable.charAt(0)) {
                        this.addVariable(variable, false);
                    }
                    variable.append(buffer);
                    continue;
                }
                this.addVariable(variable, false);
                this.items.add(buffer.toString());
            }
            this.addVariable(variable, false);
            return this;
        }

        private void addVariable(StringBuffer variable, boolean strict) {
            if (variable.length() != 0) {
                this.items.add(new VariableField(variable.toString(), strict));
                variable.setLength(0);
            }
        }

        public List getItems() {
            return this.items;
        }

        public String toString() {
            return this.toString(0, this.items.size());
        }

        public String toString(int start, int limit) {
            StringBuffer result = new StringBuffer();
            int i = start;
            while (i < limit) {
                Object item = this.items.get(i);
                if (item instanceof String) {
                    String itemString = (String)item;
                    result.append(this.tokenizer.quoteLiteral(itemString));
                } else {
                    result.append(this.items.get(i).toString());
                }
                ++i;
            }
            return result.toString();
        }

        public boolean hasDateAndTimeFields() {
            boolean isTime;
            int foundMask = 0;
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (!(item instanceof VariableField)) continue;
                int type = ((VariableField)item).getType();
                foundMask |= 1 << type;
            }
            boolean isDate = (foundMask & 0x3FF) != 0;
            boolean bl = isTime = (foundMask & 0xFC00) != 0;
            return isDate && isTime;
        }

        public Object quoteLiteral(String string) {
            return this.tokenizer.quoteLiteral(string);
        }
    }

    public static final class PatternInfo {
        public static final int OK = 0;
        public static final int BASE_CONFLICT = 1;
        public static final int CONFLICT = 2;
        public int status;
        public String conflictingPattern;
    }

    public static class VariableField {
        private final String string;
        private final int canonicalIndex;

        public VariableField(String string) {
            this(string, false);
        }

        public VariableField(String string, boolean strict) {
            this.canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(string, strict);
            if (this.canonicalIndex < 0) {
                throw new IllegalArgumentException("Illegal datetime field:\t" + string);
            }
            this.string = string;
        }

        public int getType() {
            return types[this.canonicalIndex][1];
        }

        private int getCanonicalIndex() {
            return this.canonicalIndex;
        }

        public String toString() {
            return this.string;
        }
    }
}

