/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class RandomSortField
extends FieldType {
    private static int hash(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key >>> 1;
    }

    private static int getSeed(String fieldName, IndexReader r) {
        return (int)((long)fieldName.hashCode() ^ r.getVersion());
    }

    public SortField getSortField(SchemaField field, boolean reverse) {
        return new RandomSort(field.getName(), reverse);
    }

    public ValueSource getValueSource(SchemaField field) {
        return new RandomValueSource(field.getName());
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
    }

    private static class RandomComparator
    implements ScoreDocComparator {
        final int seed;

        RandomComparator(int seed) {
            this.seed = seed;
        }

        public int compare(ScoreDoc i, ScoreDoc j) {
            return RandomSortField.hash(i.doc + this.seed) - RandomSortField.hash(j.doc + this.seed);
        }

        public Comparable sortValue(ScoreDoc i) {
            return new Integer(RandomSortField.hash(i.doc + this.seed));
        }

        public int sortType() {
            return 9;
        }
    }

    private static class RandomSort
    extends SortField {
        public RandomSort(String n, boolean reverse) {
            super(n, 9, reverse);
        }

        public SortComparatorSource getFactory() {
            return new RandomComparatorSource(this.getField());
        }

        static class RandomComparatorSource
        implements SortComparatorSource {
            final String field;

            public RandomComparatorSource(String field) {
                this.field = field;
            }

            public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
                return new RandomComparator(RandomSortField.getSeed(this.field, reader));
            }

            public int hashCode() {
                return this.field.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof RandomComparatorSource)) {
                    return false;
                }
                RandomComparatorSource other = (RandomComparatorSource)o;
                return this.field.equals(other.field);
            }
        }
    }

    public class RandomValueSource
    extends ValueSource {
        private final String field;

        public RandomValueSource(String field) {
            this.field = field;
        }

        public String description() {
            return this.field;
        }

        public DocValues getValues(final IndexReader reader) throws IOException {
            return new DocValues(){
                private final int seed;
                {
                    this.seed = RandomSortField.getSeed(RandomValueSource.this.field, reader);
                }

                public float floatVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                public int intVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                public long longVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                public double doubleVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                public String strVal(int doc) {
                    return Integer.toString(RandomSortField.hash(doc + this.seed));
                }

                public String toString(int doc) {
                    return RandomValueSource.this.description() + '=' + this.intVal(doc);
                }
            };
        }

        public boolean equals(Object o) {
            if (!(o instanceof RandomValueSource)) {
                return false;
            }
            RandomValueSource other = (RandomValueSource)o;
            return this.field.equals(other.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }
}

