/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.HitCollector;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.util.OpenBitSet;

final class DocSetHitCollector
extends HitCollector {
    final float HASHSET_INVERSE_LOAD_FACTOR;
    final int HASHDOCSET_MAXSIZE;
    int pos = 0;
    OpenBitSet bits;
    final int maxDoc;
    final int[] scratch;

    DocSetHitCollector(float inverseLoadFactor, int maxSize, int maxDoc) {
        this.maxDoc = maxDoc;
        this.HASHSET_INVERSE_LOAD_FACTOR = inverseLoadFactor;
        this.HASHDOCSET_MAXSIZE = maxSize;
        this.scratch = new int[this.HASHDOCSET_MAXSIZE];
    }

    public void collect(int doc, float score) {
        if (this.pos < this.scratch.length) {
            this.scratch[this.pos] = doc;
        } else {
            if (this.bits == null) {
                this.bits = new OpenBitSet(this.maxDoc);
            }
            this.bits.fastSet(doc);
        }
        ++this.pos;
    }

    public DocSet getDocSet() {
        if (this.pos <= this.scratch.length) {
            return new HashDocSet(this.scratch, 0, this.pos, this.HASHSET_INVERSE_LOAD_FACTOR);
        }
        for (int i = 0; i < this.scratch.length; ++i) {
            this.bits.fastSet(this.scratch[i]);
        }
        return new BitDocSet(this.bits, this.pos);
    }
}

