/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;
import org.apache.solr.util.BitUtil;

public final class HashDocSet
extends DocSetBase {
    static float DEFAULT_INVERSE_LOAD_FACTOR = 1.3333334f;
    private static final int EMPTY = -1;
    private final int[] table;
    private final int size;
    private final int mask;

    public HashDocSet(int[] docs, int offset, int len) {
        this(docs, offset, len, DEFAULT_INVERSE_LOAD_FACTOR);
    }

    public HashDocSet(int[] docs, int offset, int len, float inverseLoadFactor) {
        int i;
        int tsize = Math.max(BitUtil.nextHighestPowerOfTwo(len), 1);
        if ((float)tsize < (float)len * inverseLoadFactor) {
            tsize <<= 1;
        }
        this.mask = tsize - 1;
        this.table = new int[tsize];
        for (i = tsize - 1; i >= 0; --i) {
            this.table[i] = -1;
        }
        for (i = offset; i < len; ++i) {
            this.put(docs[i]);
        }
        this.size = len;
    }

    void put(int doc) {
        int s = doc & this.mask;
        while (this.table[s] != -1) {
            s = s + (doc >> 7 | 1) & this.mask;
        }
        this.table[s] = doc;
    }

    public boolean exists(int doc) {
        int s = doc & this.mask;
        int v;
        while ((v = this.table[s]) != -1) {
            if (v == doc) {
                return true;
            }
            s = s + (doc >> 7 | 1) & this.mask;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public DocIterator iterator() {
        return new DocIterator(){
            int pos = 0;
            int doc;
            {
                this.goNext();
            }

            public boolean hasNext() {
                return this.pos < HashDocSet.this.table.length;
            }

            public Integer next() {
                return this.nextDoc();
            }

            public void remove() {
            }

            void goNext() {
                while (this.pos < HashDocSet.this.table.length && HashDocSet.this.table[this.pos] == -1) {
                    ++this.pos;
                }
            }

            public int nextDoc() {
                int doc = HashDocSet.this.table[this.pos];
                ++this.pos;
                this.goNext();
                return doc;
            }

            public float score() {
                return 0.0f;
            }
        };
    }

    public long memSize() {
        return (this.table.length << 2) + 20;
    }

    public DocSet intersection(DocSet other) {
        if (other instanceof HashDocSet) {
            HashDocSet a = this.size() <= other.size() ? this : (HashDocSet)other;
            HashDocSet b = this.size() <= other.size() ? (HashDocSet)other : this;
            int[] result = new int[a.size()];
            int resultCount = 0;
            for (int i = 0; i < a.table.length; ++i) {
                int id = a.table[i];
                if (id < 0 || !b.exists(id)) continue;
                result[resultCount++] = id;
            }
            return new HashDocSet(result, 0, resultCount);
        }
        int[] result = new int[this.size()];
        int resultCount = 0;
        for (int i = 0; i < this.table.length; ++i) {
            int id = this.table[i];
            if (id < 0 || !other.exists(id)) continue;
            result[resultCount++] = id;
        }
        return new HashDocSet(result, 0, resultCount);
    }

    public int intersectionSize(DocSet other) {
        if (other instanceof HashDocSet) {
            HashDocSet a = this.size() <= other.size() ? this : (HashDocSet)other;
            HashDocSet b = this.size() <= other.size() ? (HashDocSet)other : this;
            int resultCount = 0;
            for (int i = 0; i < a.table.length; ++i) {
                int id = a.table[i];
                if (id < 0 || !b.exists(id)) continue;
                ++resultCount;
            }
            return resultCount;
        }
        int resultCount = 0;
        for (int i = 0; i < this.table.length; ++i) {
            int id = this.table[i];
            if (id < 0 || !other.exists(id)) continue;
            ++resultCount;
        }
        return resultCount;
    }

    public DocSet andNot(DocSet other) {
        int[] result = new int[this.size()];
        int resultCount = 0;
        for (int i = 0; i < this.table.length; ++i) {
            int id = this.table[i];
            if (id < 0 || other.exists(id)) continue;
            result[resultCount++] = id;
        }
        return new HashDocSet(result, 0, resultCount);
    }

    public DocSet union(DocSet other) {
        if (other instanceof HashDocSet) {
            int id;
            int i;
            HashDocSet a = this.size() <= other.size() ? this : (HashDocSet)other;
            HashDocSet b = this.size() <= other.size() ? (HashDocSet)other : this;
            int[] result = new int[a.size() + b.size()];
            int resultCount = 0;
            for (i = 0; i < b.table.length; ++i) {
                id = b.table[i];
                if (id < 0) continue;
                result[resultCount++] = id;
            }
            for (i = 0; i < a.table.length; ++i) {
                id = a.table[i];
                if (id < 0 || b.exists(id)) continue;
                result[resultCount++] = id;
            }
            return new HashDocSet(result, 0, resultCount);
        }
        return other.union(this);
    }
}

