/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TimeLimitedCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetHitCollector;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.LuceneQueryOptimizer;
import org.apache.solr.search.QueryResultKey;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.ScorePriorityQueue;
import org.apache.solr.search.SolrCache;
import org.apache.solr.util.OpenBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrIndexSearcher
extends Searcher
implements SolrInfoMBean {
    private static Logger log = Logger.getLogger(SolrIndexSearcher.class.getName());
    private final SolrCore core;
    private final IndexSchema schema;
    private final String name;
    private long openTime = System.currentTimeMillis();
    private long registerTime = 0L;
    private long warmupTime = 0L;
    private final IndexSearcher searcher;
    private final IndexReader reader;
    private final boolean closeReader;
    private final int queryResultWindowSize;
    private final int queryResultMaxDocsCached;
    private final boolean useFilterForSortedQuery;
    public final boolean enableLazyFieldLoading;
    private final boolean cachingEnabled;
    private final SolrCache filterCache;
    private final SolrCache queryResultCache;
    private final SolrCache documentCache;
    private final LuceneQueryOptimizer optimizer;
    private final float HASHSET_INVERSE_LOAD_FACTOR;
    private final int HASHDOCSET_MAXSIZE;
    private final HashMap<String, SolrCache> cacheMap;
    private static final HashMap<String, SolrCache> noGenericCaches = new HashMap(0);
    private final SolrCache[] cacheList;
    private static final SolrCache[] noCaches = new SolrCache[0];
    private static Query matchAllDocsQuery = new MatchAllDocsQuery();
    private static final int NO_CHECK_QCACHE = Integer.MIN_VALUE;
    private static final int GET_DOCSET = 0x40000000;
    private static final int NO_CHECK_FILTERCACHE = 0x20000000;
    public static final int GET_SCORES = 1;

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, String path, boolean enableCache) throws IOException {
        this(core, schema, name, IndexReader.open((String)path), true, enableCache);
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, Directory directory, boolean enableCache) throws IOException {
        this(core, schema, name, IndexReader.open((Directory)directory), true, enableCache);
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, IndexReader r, boolean enableCache) {
        this(core, schema, name, r, false, enableCache);
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, IndexReader r, boolean closeReader, boolean enableCache) {
        this.core = core;
        this.schema = schema;
        this.name = "Searcher@" + Integer.toHexString(this.hashCode()) + (name != null ? " " + name : "");
        log.info("Opening " + this.name);
        this.reader = r;
        this.searcher = new IndexSearcher(r);
        this.closeReader = closeReader;
        this.searcher.setSimilarity(schema.getSimilarity());
        SolrConfig solrConfig = schema.getSolrConfig();
        this.queryResultWindowSize = solrConfig.queryResultWindowSize;
        this.queryResultMaxDocsCached = solrConfig.queryResultMaxDocsCached;
        this.useFilterForSortedQuery = solrConfig.useFilterForSortedQuery;
        this.enableLazyFieldLoading = solrConfig.enableLazyFieldLoading;
        this.cachingEnabled = enableCache;
        if (this.cachingEnabled) {
            ArrayList<SolrCache> clist = new ArrayList<SolrCache>();
            SolrCache solrCache = this.filterCache = solrConfig.filterCacheConfig == null ? null : solrConfig.filterCacheConfig.newInstance();
            if (this.filterCache != null) {
                clist.add(this.filterCache);
            }
            SolrCache solrCache2 = this.queryResultCache = solrConfig.queryResultCacheConfig == null ? null : solrConfig.queryResultCacheConfig.newInstance();
            if (this.queryResultCache != null) {
                clist.add(this.queryResultCache);
            }
            SolrCache solrCache3 = this.documentCache = solrConfig.documentCacheConfig == null ? null : solrConfig.documentCacheConfig.newInstance();
            if (this.documentCache != null) {
                clist.add(this.documentCache);
            }
            if (solrConfig.userCacheConfigs == null) {
                this.cacheMap = noGenericCaches;
            } else {
                this.cacheMap = new HashMap(solrConfig.userCacheConfigs.length);
                for (CacheConfig userCacheConfig : solrConfig.userCacheConfigs) {
                    SolrCache cache = null;
                    if (userCacheConfig != null) {
                        cache = userCacheConfig.newInstance();
                    }
                    if (cache == null) continue;
                    this.cacheMap.put(cache.name(), cache);
                    clist.add(cache);
                }
            }
            this.cacheList = clist.toArray(new SolrCache[clist.size()]);
        } else {
            this.filterCache = null;
            this.queryResultCache = null;
            this.documentCache = null;
            this.cacheMap = noGenericCaches;
            this.cacheList = noCaches;
        }
        this.optimizer = solrConfig.filtOptEnabled ? new LuceneQueryOptimizer(solrConfig.filtOptCacheSize, solrConfig.filtOptThreshold) : null;
        this.HASHSET_INVERSE_LOAD_FACTOR = solrConfig.hashSetInverseLoadFactor;
        this.HASHDOCSET_MAXSIZE = solrConfig.hashDocSetMaxSize;
    }

    public String toString() {
        return this.name;
    }

    public void register() {
        this.core.getInfoRegistry().put("searcher", this);
        this.core.getInfoRegistry().put(this.name, this);
        for (SolrCache cache : this.cacheList) {
            cache.setState(SolrCache.State.LIVE);
            this.core.getInfoRegistry().put(cache.name(), cache);
        }
        this.registerTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.cachingEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("Closing ").append(this.name);
            for (SolrCache cache : this.cacheList) {
                sb.append("\n\t");
                sb.append(cache);
            }
            log.info(sb.toString());
        } else {
            log.fine("Closing " + this.name);
        }
        this.core.getInfoRegistry().remove(this.name);
        try {
            this.searcher.close();
        }
        finally {
            if (this.closeReader) {
                this.reader.close();
            }
            for (SolrCache cache : this.cacheList) {
                cache.close();
            }
        }
    }

    public IndexReader getReader() {
        return this.reader;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public static void initRegenerators(SolrConfig solrConfig) {
        if (solrConfig.filterCacheConfig != null && solrConfig.filterCacheConfig.getRegenerator() == null) {
            solrConfig.filterCacheConfig.setRegenerator(new CacheRegenerator(){

                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    newSearcher.cacheDocSet((Query)oldKey, null, false);
                    return true;
                }
            });
        }
        if (solrConfig.queryResultCacheConfig != null && solrConfig.queryResultCacheConfig.getRegenerator() == null) {
            final int queryResultWindowSize = solrConfig.queryResultWindowSize;
            solrConfig.queryResultCacheConfig.setRegenerator(new CacheRegenerator(){

                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    QueryResultKey key = (QueryResultKey)oldKey;
                    int nDocs = 1;
                    if (queryResultWindowSize <= 1) {
                        DocList oldList = (DocList)oldVal;
                        int oldnDocs = oldList.offset() + oldList.size();
                        nDocs = Math.min(oldnDocs, 40);
                    }
                    int flags = Integer.MIN_VALUE | key.nc_flags;
                    QueryCommand qc = new QueryCommand();
                    qc.setQuery(key.query).setFilterList(key.filters).setSort(key.sort).setLen(nDocs).setSupersetMaxDoc(nDocs).setFlags(flags);
                    QueryResult qr = new QueryResult();
                    newSearcher.getDocListC(qr, qc);
                    return true;
                }
            });
        }
    }

    public QueryResult search(QueryResult qr, QueryCommand cmd) throws IOException {
        this.getDocListC(qr, cmd);
        return qr;
    }

    public Hits search(Query query, Filter filter, Sort sort) throws IOException {
        if (this.optimizer == null || filter != null || !(query instanceof BooleanQuery)) {
            return this.searcher.search(query, filter, sort);
        }
        Query[] newQuery = new Query[1];
        Filter[] newFilter = new Filter[1];
        this.optimizer.optimize((BooleanQuery)query, (Searcher)this.searcher, 0, newQuery, newFilter);
        return this.searcher.search(newQuery[0], newFilter[0], sort);
    }

    public Hits search(Query query, Filter filter) throws IOException {
        return this.searcher.search(query, filter);
    }

    public Hits search(Query query, Sort sort) throws IOException {
        return this.searcher.search(query, sort);
    }

    public void search(Query query, HitCollector results) throws IOException {
        this.searcher.search(query, results);
    }

    public void setSimilarity(Similarity similarity) {
        this.searcher.setSimilarity(similarity);
    }

    public Similarity getSimilarity() {
        return this.searcher.getSimilarity();
    }

    public int docFreq(Term term) throws IOException {
        return this.searcher.docFreq(term);
    }

    public Document doc(int i) throws IOException {
        return this.doc(i, (Set<String>)null);
    }

    public Document doc(int n, FieldSelector fieldSelector) throws IOException {
        return this.searcher.getIndexReader().document(n, fieldSelector);
    }

    public Document doc(int i, Set<String> fields) throws IOException {
        Document d;
        if (this.documentCache != null && (d = (Document)this.documentCache.get(i)) != null) {
            return d;
        }
        d = !this.enableLazyFieldLoading || fields == null ? this.searcher.getIndexReader().document(i) : this.searcher.getIndexReader().document(i, (FieldSelector)new SetNonLazyFieldSelector(fields));
        if (this.documentCache != null) {
            this.documentCache.put(i, d);
        }
        return d;
    }

    public void readDocs(Document[] docs, DocList ids) throws IOException {
        this.readDocs(docs, ids, null);
    }

    public void readDocs(Document[] docs, DocList ids, Set<String> fields) throws IOException {
        DocIterator iter = ids.iterator();
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = this.doc(iter.nextDoc(), fields);
        }
    }

    public int maxDoc() throws IOException {
        return this.searcher.maxDoc();
    }

    public TopDocs search(Weight weight, Filter filter, int i) throws IOException {
        return this.searcher.search(weight, filter, i);
    }

    public void search(Weight weight, Filter filter, HitCollector hitCollector) throws IOException {
        this.searcher.search(weight, filter, hitCollector);
    }

    public Query rewrite(Query original) throws IOException {
        return this.searcher.rewrite(original);
    }

    public Explanation explain(Weight weight, int i) throws IOException {
        return this.searcher.explain(weight, i);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int i, Sort sort) throws IOException {
        return this.searcher.search(weight, filter, i, sort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstMatch(Term t) throws IOException {
        TermDocs tdocs = null;
        try {
            tdocs = this.reader.termDocs(t);
            if (!tdocs.next()) {
                int n = -1;
                return n;
            }
            int n = tdocs.doc();
            return n;
        }
        finally {
            if (tdocs != null) {
                tdocs.close();
            }
        }
    }

    public void cacheDocSet(Query query, DocSet optionalAnswer, boolean mustCache) throws IOException {
        if (optionalAnswer != null) {
            if (this.filterCache != null) {
                this.filterCache.put(query, optionalAnswer);
            }
            return;
        }
        this.getDocSet(query);
    }

    public DocSet getDocSet(Query query) throws IOException {
        DocSet answer;
        DocSet absAnswer;
        boolean positive;
        Query absQ = QueryUtils.getAbs(query);
        boolean bl = positive = query == absQ;
        if (this.filterCache != null && (absAnswer = (DocSet)this.filterCache.get(absQ)) != null) {
            if (positive) {
                return absAnswer;
            }
            return this.getPositiveDocSet(matchAllDocsQuery).andNot(absAnswer);
        }
        absAnswer = this.getDocSetNC(absQ, null);
        DocSet docSet = answer = positive ? absAnswer : this.getPositiveDocSet(matchAllDocsQuery).andNot(absAnswer);
        if (this.filterCache != null) {
            this.filterCache.put(absQ, absAnswer);
        }
        return answer;
    }

    DocSet getPositiveDocSet(Query q) throws IOException {
        DocSet answer;
        if (this.filterCache != null && (answer = (DocSet)this.filterCache.get(q)) != null) {
            return answer;
        }
        answer = this.getDocSetNC(q, null);
        if (this.filterCache != null) {
            this.filterCache.put(q, answer);
        }
        return answer;
    }

    public DocSet getDocSet(List<Query> queries) throws IOException {
        int i;
        if (queries == null) {
            return null;
        }
        if (queries.size() == 1) {
            return this.getDocSet(queries.get(0));
        }
        DocSet answer = null;
        boolean[] neg = new boolean[queries.size()];
        DocSet[] sets = new DocSet[queries.size()];
        int smallestIndex = -1;
        int smallestCount = Integer.MAX_VALUE;
        for (i = 0; i < sets.length; ++i) {
            Query q = queries.get(i);
            Query posQuery = QueryUtils.getAbs(q);
            sets[i] = this.getPositiveDocSet(posQuery);
            if (q == posQuery) {
                neg[i] = false;
                int sz = sets[i].size();
                if (sz >= smallestCount) continue;
                smallestCount = sz;
                smallestIndex = i;
                answer = sets[i];
                continue;
            }
            neg[i] = true;
        }
        if (answer == null) {
            answer = this.getPositiveDocSet(matchAllDocsQuery);
        }
        for (i = 0; i < sets.length; ++i) {
            if (!neg[i]) continue;
            answer = answer.andNot(sets[i]);
        }
        for (i = 0; i < sets.length; ++i) {
            if (neg[i] || i == smallestIndex) continue;
            answer = answer.intersection(sets[i]);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocSet getDocSetNC(Query query, DocSet filter) throws IOException {
        if (filter == null) {
            DocSetHitCollector hc = new DocSetHitCollector(this.HASHSET_INVERSE_LOAD_FACTOR, this.HASHDOCSET_MAXSIZE, this.maxDoc());
            if (query instanceof TermQuery) {
                Term t = ((TermQuery)query).getTerm();
                TermDocs tdocs = null;
                try {
                    tdocs = this.reader.termDocs(t);
                    while (tdocs.next()) {
                        hc.collect(tdocs.doc(), 0.0f);
                    }
                }
                finally {
                    if (tdocs != null) {
                        tdocs.close();
                    }
                }
            } else {
                this.searcher.search(query, null, (HitCollector)hc);
            }
            return hc.getDocSet();
        }
        final DocSetHitCollector hc = new DocSetHitCollector(this.HASHSET_INVERSE_LOAD_FACTOR, this.HASHDOCSET_MAXSIZE, this.maxDoc());
        final DocSet filt = filter;
        this.searcher.search(query, null, new HitCollector(){

            public void collect(int doc, float score) {
                if (filt.exists(doc)) {
                    hc.collect(doc, score);
                }
            }
        });
        return hc.getDocSet();
    }

    public DocSet getDocSet(Query query, DocSet filter) throws IOException {
        boolean positive;
        if (filter == null) {
            return this.getDocSet(query);
        }
        Query absQ = QueryUtils.getAbs(query);
        boolean bl = positive = absQ == query;
        if (this.filterCache != null) {
            DocSet first = (DocSet)this.filterCache.get(absQ);
            if (first == null) {
                first = this.getDocSetNC(absQ, null);
                this.filterCache.put(absQ, first);
            }
            return positive ? first.intersection(filter) : filter.andNot(first);
        }
        return positive ? this.getDocSetNC(absQ, filter) : filter.andNot(this.getPositiveDocSet(absQ));
    }

    public DocSet convertFilter(Filter lfilter) throws IOException {
        BitSet bs = lfilter.bits(this.reader);
        OpenBitSet obs = new OpenBitSet(bs.size());
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            obs.fastSet(i);
            i = bs.nextSetBit(i + 1);
        }
        return new BitDocSet(obs);
    }

    public DocList getDocList(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    public DocList getDocList(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    private void getDocListC(QueryResult qr, QueryCommand cmd) throws IOException {
        DocList superset;
        DocListAndSet out = new DocListAndSet();
        qr.setDocListAndSet(out);
        QueryResultKey key = null;
        int maxDocRequested = cmd.getOffset() + cmd.getLen();
        if (maxDocRequested < 0 || maxDocRequested > this.maxDoc()) {
            maxDocRequested = this.maxDoc();
        }
        int supersetMaxDoc = maxDocRequested;
        if (this.queryResultCache != null && cmd.getFilter() == null) {
            key = new QueryResultKey(cmd.getQuery(), cmd.getFilterList(), cmd.getSort(), cmd.getFlags());
            if ((cmd.getFlags() & Integer.MIN_VALUE) == 0) {
                superset = (DocList)this.queryResultCache.get(key);
                if (superset != null && ((cmd.getFlags() & 1) == 0 || superset.hasScores())) {
                    out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
                }
                if (out.docList != null) {
                    if (out.docSet == null && (cmd.getFlags() & 0x40000000) != 0) {
                        if (cmd.getFilterList() == null) {
                            out.docSet = this.getDocSet(cmd.getQuery());
                        } else {
                            ArrayList<Query> newList = new ArrayList<Query>(cmd.getFilterList().size() + 1);
                            newList.add(cmd.getQuery());
                            newList.addAll(cmd.getFilterList());
                            out.docSet = this.getDocSet(newList);
                        }
                    }
                    return;
                }
            }
            if (maxDocRequested < this.queryResultWindowSize) {
                supersetMaxDoc = this.queryResultWindowSize;
            } else {
                supersetMaxDoc = ((maxDocRequested - 1) / this.queryResultWindowSize + 1) * this.queryResultWindowSize;
                if (supersetMaxDoc < 0) {
                    supersetMaxDoc = maxDocRequested;
                }
            }
        }
        boolean useFilterCache = false;
        if ((cmd.getFlags() & 0x20000001) == 0 && this.useFilterForSortedQuery && cmd.getSort() != null && this.filterCache != null) {
            SortField[] sfields;
            useFilterCache = true;
            for (SortField sf : sfields = cmd.getSort().getSort()) {
                if (sf.getType() != 0) continue;
                useFilterCache = false;
                break;
            }
        }
        if (useFilterCache) {
            if (out.docSet == null) {
                out.docSet = this.getDocSet(cmd.getQuery(), cmd.getFilter());
                DocSet bigFilt = this.getDocSet(cmd.getFilterList());
                if (bigFilt != null) {
                    out.docSet = out.docSet.intersection(bigFilt);
                }
            }
            superset = this.sortDocSet(out.docSet, cmd.getSort(), supersetMaxDoc);
            out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
        } else {
            cmd.setSupersetMaxDoc(supersetMaxDoc);
            if ((cmd.getFlags() & 0x40000000) != 0) {
                DocSet qDocSet = this.getDocListAndSetNC(qr, cmd);
                if (this.filterCache != null && !qr.isPartialResults()) {
                    this.filterCache.put(cmd.getQuery(), qDocSet);
                }
            } else {
                this.getDocListNC(qr, cmd);
            }
            superset = out.docList;
            out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
        }
        if (key != null && superset.size() <= this.queryResultMaxDocsCached && !qr.isPartialResults()) {
            this.queryResultCache.put(key, superset);
        }
    }

    private void getDocListNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        DocSet filt;
        DocSet filter = cmd.getFilter() != null ? cmd.getFilter() : this.getDocSet(cmd.getFilterList());
        long timeAllowed = cmd.getTimeAllowed();
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        final int lastDocRequested = last;
        Query query = QueryUtils.makeQueryable(cmd.getQuery());
        if (lastDocRequested <= 0) {
            filt = filter;
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            final int[] numHits = new int[1];
            HitCollector hc = new HitCollector(){

                public void collect(int doc, float score) {
                    if (filt != null && !filt.exists(doc)) {
                        return;
                    }
                    numHits[0] = numHits[0] + 1;
                    if (score > topscore[0]) {
                        topscore[0] = score;
                    }
                }
            };
            if (timeAllowed > 0L) {
                hc = new TimeLimitedCollector(hc, timeAllowed);
            }
            try {
                this.searcher.search(query, hc);
            }
            catch (TimeLimitedCollector.TimeExceededException x) {
                log.warning("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
        } else if (cmd.getSort() != null) {
            filt = filter;
            final int[] numHits = new int[1];
            final FieldSortedHitQueue hq = new FieldSortedHitQueue(this.reader, cmd.getSort().getSort(), len);
            HitCollector hc = new HitCollector(){

                public void collect(int doc, float score) {
                    if (filt != null && !filt.exists(doc)) {
                        return;
                    }
                    numHits[0] = numHits[0] + 1;
                    hq.insert(new FieldDoc(doc, score));
                }
            };
            if (timeAllowed > 0L) {
                hc = new TimeLimitedCollector(hc, timeAllowed);
            }
            try {
                this.searcher.search(query, hc);
            }
            catch (TimeLimitedCollector.TimeExceededException x) {
                log.warning("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? hq.getMaxScore() : 0.0f;
            nDocsReturned = hq.size();
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            for (int i = nDocsReturned - 1; i >= 0; --i) {
                FieldDoc fieldDoc = (FieldDoc)hq.pop();
                ids[i] = fieldDoc.doc;
                if (scores == null) continue;
                scores[i] = fieldDoc.score;
            }
        } else {
            filt = filter;
            final ScorePriorityQueue hq = new ScorePriorityQueue(lastDocRequested);
            final int[] numHits = new int[1];
            HitCollector hc = new HitCollector(){
                float minScore = Float.NEGATIVE_INFINITY;

                public void collect(int doc, float score) {
                    if (filt != null && !filt.exists(doc)) {
                        return;
                    }
                    int n = numHits[0];
                    numHits[0] = n + 1;
                    if (n < lastDocRequested || score >= this.minScore) {
                        hq.insert(new ScoreDoc(doc, score));
                        this.minScore = ((ScoreDoc)hq.top()).score;
                    }
                }
            };
            if (timeAllowed > 0L) {
                hc = new TimeLimitedCollector(hc, timeAllowed);
            }
            try {
                this.searcher.search(query, hc);
            }
            catch (TimeLimitedCollector.TimeExceededException x) {
                log.warning("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            totalHits = numHits[0];
            nDocsReturned = hq.size();
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            ScoreDoc sdoc = null;
            for (int i = nDocsReturned - 1; i >= 0; --i) {
                sdoc = (ScoreDoc)hq.pop();
                ids[i] = sdoc.doc;
                if (scores == null) continue;
                scores[i] = sdoc.score;
            }
            maxScore = sdoc == null ? 0.0f : sdoc.score;
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore));
    }

    private DocSet getDocListAndSetNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        DocSet filt;
        int len = cmd.getSupersetMaxDoc();
        DocSet filter = cmd.getFilter() != null ? cmd.getFilter() : this.getDocSet(cmd.getFilterList());
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        final int lastDocRequested = last;
        DocSetHitCollector setHC = new DocSetHitCollector(this.HASHSET_INVERSE_LOAD_FACTOR, this.HASHDOCSET_MAXSIZE, this.maxDoc());
        final DocSetHitCollector hitCollector = cmd.getTimeAllowed() > 0L ? new TimeLimitedCollector((HitCollector)setHC, cmd.getTimeAllowed()) : setHC;
        Query query = QueryUtils.makeQueryable(cmd.getQuery());
        if (lastDocRequested <= 0) {
            filt = filter;
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            final int[] numHits = new int[1];
            try {
                this.searcher.search(query, new HitCollector(){

                    public void collect(int doc, float score) {
                        hitCollector.collect(doc, score);
                        if (filt != null && !filt.exists(doc)) {
                            return;
                        }
                        numHits[0] = numHits[0] + 1;
                        if (score > topscore[0]) {
                            topscore[0] = score;
                        }
                    }
                });
            }
            catch (TimeLimitedCollector.TimeExceededException x) {
                log.warning("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
        } else if (cmd.getSort() != null) {
            filt = filter;
            final int[] numHits = new int[1];
            final FieldSortedHitQueue hq = new FieldSortedHitQueue(this.reader, cmd.getSort().getSort(), len);
            try {
                this.searcher.search(query, new HitCollector(){

                    public void collect(int doc, float score) {
                        hitCollector.collect(doc, score);
                        if (filt != null && !filt.exists(doc)) {
                            return;
                        }
                        numHits[0] = numHits[0] + 1;
                        hq.insert(new FieldDoc(doc, score));
                    }
                });
            }
            catch (TimeLimitedCollector.TimeExceededException x) {
                log.warning("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? hq.getMaxScore() : 0.0f;
            nDocsReturned = hq.size();
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            for (int i = nDocsReturned - 1; i >= 0; --i) {
                FieldDoc fieldDoc = (FieldDoc)hq.pop();
                ids[i] = fieldDoc.doc;
                if (scores == null) continue;
                scores[i] = fieldDoc.score;
            }
        } else {
            filt = filter;
            final ScorePriorityQueue hq = new ScorePriorityQueue(lastDocRequested);
            final int[] numHits = new int[1];
            try {
                this.searcher.search(query, new HitCollector(){
                    float minScore = Float.NEGATIVE_INFINITY;

                    public void collect(int doc, float score) {
                        hitCollector.collect(doc, score);
                        if (filt != null && !filt.exists(doc)) {
                            return;
                        }
                        int n = numHits[0];
                        numHits[0] = n + 1;
                        if (n < lastDocRequested || score >= this.minScore) {
                            hq.insert(new ScoreDoc(doc, score));
                            this.minScore = ((ScoreDoc)hq.top()).score;
                        }
                    }
                });
            }
            catch (TimeLimitedCollector.TimeExceededException x) {
                log.warning("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            totalHits = numHits[0];
            nDocsReturned = hq.size();
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            ScoreDoc sdoc = null;
            for (int i = nDocsReturned - 1; i >= 0; --i) {
                sdoc = (ScoreDoc)hq.pop();
                ids[i] = sdoc.doc;
                if (scores == null) continue;
                scores[i] = sdoc.score;
            }
            maxScore = sdoc == null ? 0.0f : sdoc.score;
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore));
        DocSet qDocSet = setHC.getDocSet();
        qr.setDocSet(filter == null ? qDocSet : qDocSet.intersection(filter));
        return qDocSet;
    }

    public DocList getDocList(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    protected DocList sortDocSet(DocSet set, Sort sort, int nDocs) throws IOException {
        FieldSortedHitQueue hq = new FieldSortedHitQueue(this.reader, sort.getSort(), nDocs);
        DocIterator iter = set.iterator();
        int hits = 0;
        while (iter.hasNext()) {
            int doc = iter.nextDoc();
            ++hits;
            hq.insert(new FieldDoc(doc, 1.0f));
        }
        int numCollected = hq.size();
        int[] ids = new int[numCollected];
        for (int i = numCollected - 1; i >= 0; --i) {
            FieldDoc fieldDoc = (FieldDoc)hq.pop();
            ids[i] = fieldDoc.doc;
        }
        return new DocSlice(0, numCollected, ids, null, hits, 0.0f);
    }

    public int numDocs(Query a, DocSet b) throws IOException {
        Query absQ = QueryUtils.getAbs(a);
        DocSet positiveA = this.getPositiveDocSet(absQ);
        return a == absQ ? b.intersectionSize(positiveA) : b.andNotSize(positiveA);
    }

    public int numDocs(Query a, Query b) throws IOException {
        Query absA = QueryUtils.getAbs(a);
        Query absB = QueryUtils.getAbs(b);
        DocSet positiveA = this.getPositiveDocSet(absA);
        DocSet positiveB = this.getPositiveDocSet(absB);
        if (a == absA) {
            if (b == absB) {
                return positiveA.intersectionSize(positiveB);
            }
            return positiveA.andNotSize(positiveB);
        }
        if (b == absB) {
            return positiveB.andNotSize(positiveA);
        }
        DocSet all = this.getPositiveDocSet(matchAllDocsQuery);
        return all.andNotSize(positiveA.union(positiveB));
    }

    public Document[] readDocs(DocList ids) throws IOException {
        Document[] docs = new Document[ids.size()];
        this.readDocs(docs, ids);
        return docs;
    }

    public void warm(SolrIndexSearcher old) throws IOException {
        boolean logme = log.isLoggable(Level.INFO);
        long warmingStartTime = System.currentTimeMillis();
        for (int i = 0; i < this.cacheList.length; ++i) {
            if (logme) {
                log.info("autowarming " + this + " from " + old + "\n\t" + old.cacheList[i]);
            }
            this.cacheList[i].warm(this, old.cacheList[i]);
            if (!logme) continue;
            log.info("autowarming result for " + this + "\n\t" + this.cacheList[i]);
        }
        this.warmupTime = System.currentTimeMillis() - warmingStartTime;
    }

    public SolrCache getCache(String cacheName) {
        return this.cacheMap.get(cacheName);
    }

    public Object cacheLookup(String cacheName, Object key) {
        SolrCache cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.get(key);
    }

    public Object cacheInsert(String cacheName, Object key, Object val) {
        SolrCache cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.put(key, val);
    }

    public long getOpenTime() {
        return this.openTime;
    }

    @Override
    public String getName() {
        return SolrIndexSearcher.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "index searcher";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSourceId() {
        return "$Id: SolrIndexSearcher.java 689514 2008-08-27 16:27:26Z yonik $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/search/SolrIndexSearcher.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("searcherName", (Object)this.name);
        lst.add("caching", (Object)this.cachingEnabled);
        lst.add("numDocs", (Object)this.reader.numDocs());
        lst.add("maxDoc", (Object)this.reader.maxDoc());
        lst.add("readerImpl", (Object)this.reader.getClass().getSimpleName());
        lst.add("readerDir", (Object)this.reader.directory());
        lst.add("indexVersion", (Object)this.reader.getVersion());
        lst.add("openedAt", (Object)new Date(this.openTime));
        if (this.registerTime != 0L) {
            lst.add("registeredAt", (Object)new Date(this.registerTime));
        }
        lst.add("warmupTime", (Object)this.warmupTime);
        return lst;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryCommand {
        private Query query;
        private List<Query> filterList;
        private DocSet filter;
        private Sort sort;
        private int offset;
        private int len;
        private int supersetMaxDoc;
        private int flags;
        private long timeAllowed = -1L;
        private boolean needDocSet;

        public Query getQuery() {
            return this.query;
        }

        public QueryCommand setQuery(Query query) {
            this.query = query;
            return this;
        }

        public List<Query> getFilterList() {
            return this.filterList;
        }

        public QueryCommand setFilterList(List<Query> filterList) {
            if (this.filter != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filterList = filterList;
            return this;
        }

        public QueryCommand setFilterList(Query f) {
            if (this.filter != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filterList = null;
            if (f != null) {
                this.filterList = new ArrayList<Query>(2);
                this.filterList.add(f);
            }
            return this;
        }

        public DocSet getFilter() {
            return this.filter;
        }

        public QueryCommand setFilter(DocSet filter) {
            if (this.filterList != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filter = filter;
            return this;
        }

        public Sort getSort() {
            return this.sort;
        }

        public QueryCommand setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public int getOffset() {
            return this.offset;
        }

        public QueryCommand setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public int getLen() {
            return this.len;
        }

        public QueryCommand setLen(int len) {
            this.len = len;
            return this;
        }

        public int getSupersetMaxDoc() {
            return this.supersetMaxDoc;
        }

        public QueryCommand setSupersetMaxDoc(int supersetMaxDoc) {
            this.supersetMaxDoc = supersetMaxDoc;
            return this;
        }

        public int getFlags() {
            return this.flags;
        }

        public QueryCommand replaceFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public QueryCommand setFlags(int flags) {
            this.flags |= flags;
            return this;
        }

        public QueryCommand clearFlags(int flags) {
            this.flags &= ~flags;
            return this;
        }

        public long getTimeAllowed() {
            return this.timeAllowed;
        }

        public QueryCommand setTimeAllowed(long timeAllowed) {
            this.timeAllowed = timeAllowed;
            return this;
        }

        public boolean isNeedDocSet() {
            return (this.flags & 0x40000000) != 0;
        }

        public QueryCommand setNeedDocSet(boolean needDocSet) {
            return needDocSet ? this.setFlags(0x40000000) : this.clearFlags(0x40000000);
        }
    }

    public static class QueryResult {
        private boolean partialResults;
        private DocListAndSet docListAndSet;

        public DocList getDocList() {
            return this.docListAndSet.docList;
        }

        public void setDocList(DocList list) {
            if (this.docListAndSet == null) {
                this.docListAndSet = new DocListAndSet();
            }
            this.docListAndSet.docList = list;
        }

        public DocSet getDocSet() {
            return this.docListAndSet.docSet;
        }

        public void setDocSet(DocSet set) {
            if (this.docListAndSet == null) {
                this.docListAndSet = new DocListAndSet();
            }
            this.docListAndSet.docSet = set;
        }

        public boolean isPartialResults() {
            return this.partialResults;
        }

        public void setPartialResults(boolean partialResults) {
            this.partialResults = partialResults;
        }

        public void setDocListAndSet(DocListAndSet listSet) {
            this.docListAndSet = listSet;
        }

        public DocListAndSet getDocListAndSet() {
            return this.docListAndSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetNonLazyFieldSelector
    implements FieldSelector {
        private Set<String> fieldsToLoad;

        SetNonLazyFieldSelector(Set<String> toLoad) {
            this.fieldsToLoad = toLoad;
        }

        public FieldSelectorResult accept(String fieldName) {
            if (this.fieldsToLoad.contains(fieldName)) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.LAZY_LOAD;
        }
    }
}

