/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.AppendedSolrParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.function.FunctionQuery;
import org.apache.solr.util.CommonParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrPluginUtils {
    @Deprecated
    public static String FL = "fl";
    private static final Pattern splitList = Pattern.compile(",| ");
    private static final Pattern DANGLING_OP_PATTERN = Pattern.compile("\\s+[-+\\s]+$");
    private static final Pattern CONSECUTIVE_OP_PATTERN = Pattern.compile("\\s+[+-](?:\\s*[+-]+)+");

    public static void setDefaults(SolrQueryRequest req, SolrParams defaults) {
        SolrPluginUtils.setDefaults(req, defaults, null, null);
    }

    public static void setDefaults(SolrQueryRequest req, SolrParams defaults, SolrParams appends, SolrParams invariants) {
        SolrParams p = req.getParams();
        if (defaults != null) {
            p = new DefaultSolrParams(p, defaults);
        }
        if (appends != null) {
            p = new AppendedSolrParams(p, appends);
        }
        if (invariants != null) {
            p = new DefaultSolrParams(invariants, p);
        }
        req.setParams(p);
    }

    public static int numDocs(SolrIndexSearcher s, Query q, Query f) throws IOException {
        return null == f ? s.getDocSet(q).size() : s.numDocs(q, f);
    }

    public static String getParam(SolrQueryRequest req, String param, String def) {
        String v = req.getParam(param);
        if (null == v || "".equals(v.trim())) {
            return def;
        }
        return v;
    }

    public static Number getNumberParam(SolrQueryRequest req, String param, Number def) {
        Number r = def;
        String v = req.getParam(param);
        if (null == v || "".equals(v.trim())) {
            return r;
        }
        try {
            r = new Float(v);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return r;
    }

    public static boolean getBooleanParam(SolrQueryRequest req, String param, boolean def) {
        String v = req.getParam(param);
        if (null == v || "".equals(v.trim())) {
            return def;
        }
        return !"false".equals(v.trim());
    }

    public static String[] split(String value) {
        return splitList.split(value.trim(), 0);
    }

    public static int setReturnFields(SolrQueryRequest req, SolrQueryResponse res) {
        return SolrPluginUtils.setReturnFields(req.getParam(FL), res);
    }

    public static int setReturnFields(String fl, SolrQueryResponse res) {
        String[] flst;
        int flags = 0;
        if (fl != null && (flst = SolrPluginUtils.split(fl)).length > 0 && (flst.length != 1 || flst[0].length() != 0)) {
            HashSet<String> set = new HashSet<String>();
            for (String fname : flst) {
                if ("score".equalsIgnoreCase(fname)) {
                    flags |= 1;
                }
                set.add(fname);
            }
            res.setReturnFields(set);
        }
        return flags;
    }

    public static void optimizePreFetchDocs(DocList docs, Query query, SolrQueryRequest req, SolrQueryResponse res) throws IOException {
        SolrIndexSearcher searcher = req.getSearcher();
        if (!searcher.enableLazyFieldLoading) {
            return;
        }
        HashSet<String> fieldFilter = null;
        Set<String> returnFields = res.getReturnFields();
        if (returnFields != null) {
            SchemaField keyField;
            fieldFilter = new HashSet<String>(returnFields);
            SolrHighlighter highligher = req.getCore().getHighlighter();
            if (highligher.isHighlightingEnabled(req.getParams())) {
                for (String field : highligher.getHighlightFields(query, req, null)) {
                    fieldFilter.add(field);
                }
            }
            if (null != (keyField = req.getSearcher().getSchema().getUniqueKeyField())) {
                fieldFilter.add(keyField.getName());
            }
        }
        DocIterator iter = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            searcher.doc(iter.nextDoc(), fieldFilter);
        }
    }

    public static NamedList doStandardDebug(SolrQueryRequest req, String userQuery, Query query, DocList results, CommonParams params) throws IOException {
        String debug = SolrPluginUtils.getParam(req, "debugQuery", params.debugQuery);
        SimpleOrderedMap dbg = null;
        if (debug != null) {
            dbg = new SimpleOrderedMap();
            dbg.add("rawquerystring", (Object)req.getQueryString());
            dbg.add("querystring", (Object)userQuery);
            dbg.add("parsedquery", (Object)QueryParsing.toString(query, req.getSchema()));
            dbg.add("parsedquery_toString", (Object)query.toString());
            dbg.add("explain", (Object)SolrPluginUtils.getExplainList(query, results, req.getSearcher(), req.getSchema()));
            String otherQueryS = req.getParam("explainOther");
            if (otherQueryS != null && otherQueryS.length() > 0) {
                DocList otherResults = SolrPluginUtils.doSimpleQuery(otherQueryS, req.getSearcher(), req.getSchema(), 0, 10);
                dbg.add("otherQuery", (Object)otherQueryS);
                dbg.add("explainOther", (Object)SolrPluginUtils.getExplainList(query, otherResults, req.getSearcher(), req.getSchema()));
            }
        }
        return dbg;
    }

    public static NamedList doStandardDebug(SolrQueryRequest req, String userQuery, Query query, DocList results) throws IOException {
        String debug = req.getParam("debugQuery");
        SimpleOrderedMap dbg = null;
        if (debug != null) {
            dbg = new SimpleOrderedMap();
            dbg.add("rawquerystring", (Object)req.getQueryString());
            dbg.add("querystring", (Object)userQuery);
            dbg.add("parsedquery", (Object)QueryParsing.toString(query, req.getSchema()));
            dbg.add("parsedquery_toString", (Object)query.toString());
            dbg.add("explain", (Object)SolrPluginUtils.getExplainList(query, results, req.getSearcher(), req.getSchema()));
            String otherQueryS = req.getParam("explainOther");
            if (otherQueryS != null && otherQueryS.length() > 0) {
                DocList otherResults = SolrPluginUtils.doSimpleQuery(otherQueryS, req.getSearcher(), req.getSchema(), 0, 10);
                dbg.add("otherQuery", (Object)otherQueryS);
                dbg.add("explainOther", (Object)SolrPluginUtils.getExplainList(query, otherResults, req.getSearcher(), req.getSchema()));
            }
        }
        return dbg;
    }

    public static NamedList getExplainList(Query query, DocList docs, SolrIndexSearcher searcher, IndexSchema schema) throws IOException {
        SimpleOrderedMap explainList = new SimpleOrderedMap();
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int id = iterator.nextDoc();
            Explanation explain = searcher.explain(query, id);
            Document doc = searcher.doc(id);
            String strid = schema.printableUniqueKey(doc);
            explainList.add(strid, (Object)("\n" + explain.toString()));
        }
        return explainList;
    }

    public static DocList doSimpleQuery(String sreq, SolrIndexSearcher searcher, IndexSchema schema, int start, int limit) throws IOException {
        List commands = StrUtils.splitSmart((String)sreq, (char)';');
        String qs = commands.size() >= 1 ? (String)commands.get(0) : "";
        Query query = QueryParsing.parseQuery(qs, schema);
        Sort sort = null;
        if (commands.size() >= 2) {
            sort = QueryParsing.parseSort((String)commands.get(1), schema);
        }
        DocList results = searcher.getDocList(query, (DocSet)null, sort, start, limit);
        return results;
    }

    public static Map<String, Float> parseFieldBoosts(String in) {
        return SolrPluginUtils.parseFieldBoosts(new String[]{in});
    }

    public static Map<String, Float> parseFieldBoosts(String[] fieldLists) {
        if (null == fieldLists || 0 == fieldLists.length) {
            return new HashMap<String, Float>();
        }
        HashMap<String, Float> out = new HashMap<String, Float>(7);
        for (String in : fieldLists) {
            String[] bb;
            if (null == in || "".equals(in.trim())) continue;
            for (String s : bb = in.trim().split("\\s+")) {
                String[] bbb = s.split("\\^");
                out.put(bbb[0], 1 == bbb.length ? null : Float.valueOf(bbb[1]));
            }
        }
        return out;
    }

    public static List<Query> parseFuncs(IndexSchema s, String in) throws ParseException {
        Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(in);
        ArrayList<Query> funcs = new ArrayList<Query>(ff.keySet().size());
        for (String f : ff.keySet()) {
            FunctionQuery fq = QueryParsing.parseFunction(f, s);
            Float b = ff.get(f);
            if (null != b) {
                fq.setBoost(b.floatValue());
            }
            funcs.add(fq);
        }
        return funcs;
    }

    public static void setMinShouldMatch(BooleanQuery q, String spec) {
        int optionalClauses = 0;
        for (BooleanClause c : q.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = SolrPluginUtils.calculateMinShouldMatch(optionalClauses, spec);
        if (0 < msm) {
            q.setMinimumNumberShouldMatch(msm);
        }
    }

    static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int result = optionalClauseCount;
        if (-1 < spec.indexOf("<")) {
            for (String s : spec.trim().split(" ")) {
                String[] parts = s.split("<");
                int upperBound = new Integer(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = SolrPluginUtils.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        if (-1 < spec.indexOf("%")) {
            int percent = new Integer(spec.replace("%", ""));
            float calc = (float)(result * percent) / 100.0f;
            result = calc < 0.0f ? result + (int)calc : (int)calc;
        } else {
            int calc = new Integer(spec);
            int n = result = calc < 0 ? result + calc : calc;
        }
        return optionalClauseCount < result ? optionalClauseCount : (result < 0 ? 0 : result);
    }

    public static void flattenBooleanQuery(BooleanQuery to, BooleanQuery from) {
        for (BooleanClause clause : from.clauses()) {
            Query cq = clause.getQuery();
            cq.setBoost(cq.getBoost() * from.getBoost());
            if (cq instanceof BooleanQuery && !clause.isRequired() && !clause.isProhibited()) {
                SolrPluginUtils.flattenBooleanQuery(to, (BooleanQuery)cq);
                continue;
            }
            to.add(clause);
        }
    }

    public static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public static CharSequence stripIllegalOperators(CharSequence s) {
        String temp = CONSECUTIVE_OP_PATTERN.matcher(s).replaceAll(" ");
        return DANGLING_OP_PATTERN.matcher(temp).replaceAll("");
    }

    public static CharSequence stripUnbalancedQuotes(CharSequence s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\"') continue;
            ++count;
        }
        if (!(count & true)) {
            return s;
        }
        return ((Object)s).toString().replace("\"", "");
    }

    public static Sort getSort(SolrQueryRequest req) {
        String sort = req.getParam("sort");
        if (null == sort || sort.equals("")) {
            return null;
        }
        SolrException sortE = null;
        Sort ss = null;
        try {
            ss = QueryParsing.parseSort(sort, req.getSchema());
        }
        catch (SolrException e) {
            sortE = e;
        }
        if (null == ss || null != sortE) {
            SolrCore.log.log(Level.WARNING, "Invalid sort \"" + sort + "\" was specified, ignoring", sortE);
            return null;
        }
        return ss;
    }

    public static List<Query> parseFilterQueries(SolrQueryRequest req) throws ParseException {
        return SolrPluginUtils.parseQueryStrings(req, req.getParams().getParams("fq"));
    }

    public static List<Query> parseQueryStrings(SolrQueryRequest req, String[] queries) throws ParseException {
        if (null == queries || 0 == queries.length) {
            return null;
        }
        LinkedList<Query> out = new LinkedList<Query>();
        for (String q : queries) {
            if (null == q || 0 == q.trim().length()) continue;
            out.add(QParser.getParser(q, null, req).getQuery());
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisjunctionMaxQueryParser
    extends SolrQueryParser {
        protected Map<String, Alias> aliases = new HashMap<String, Alias>(3);

        public DisjunctionMaxQueryParser(IndexSchema s, String defaultField) {
            super(s, defaultField);
            this.setDefaultOperator(QueryParser.Operator.OR);
        }

        public DisjunctionMaxQueryParser(IndexSchema s) {
            this(s, null);
        }

        public void addAlias(String field, float tiebreaker, Map<String, Float> fieldBoosts) {
            Alias a = new Alias();
            a.tie = tiebreaker;
            a.fields = fieldBoosts;
            this.aliases.put(field, a);
        }

        @Override
        protected Query getFieldQuery(String field, String queryText) throws ParseException {
            if (this.aliases.containsKey(field)) {
                Alias a = this.aliases.get(field);
                DisjunctionMaxQuery q = new DisjunctionMaxQuery(a.tie);
                boolean ok = false;
                for (String f : a.fields.keySet()) {
                    Query sub = this.getFieldQuery(f, queryText);
                    if (null == sub) continue;
                    if (null != a.fields.get(f)) {
                        sub.setBoost(a.fields.get(f).floatValue());
                    }
                    q.add(sub);
                    ok = true;
                }
                return ok ? q : null;
            }
            return super.getFieldQuery(field, queryText);
        }

        protected static class Alias {
            public float tie;
            public Map<String, Float> fields;

            protected Alias() {
            }
        }
    }

    public static class IdentityRegenerator
    implements CacheRegenerator {
        public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
            newCache.put(oldKey, oldVal);
            return true;
        }
    }
}

