/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

class ServiceTypeReply
extends ReplyMessage {
    List serviceTypes;

    ServiceTypeReply(ServiceTypeRequest serviceTypeRequest, List list) {
        this.funcID = (byte)10;
        this.locale = serviceTypeRequest.locale;
        this.xid = serviceTypeRequest.xid;
        this.address = serviceTypeRequest.address;
        this.port = serviceTypeRequest.port;
        this.errorCode = 0;
        this.serviceTypes = list;
    }

    ServiceTypeReply(DataInputStream dataInputStream) throws IOException {
        this.errorCode = dataInputStream.readShort();
        this.serviceTypes = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeShort(this.errorCode);
        dataOutputStream.writeUTF(SLPMessage.listToString(this.serviceTypes, ","));
    }

    int getSize() {
        return this.getHeaderSize() + 2 + 2 + SLPMessage.listToString(this.serviceTypes, ",").length();
    }

    List getResult() {
        return this.serviceTypes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", errorCode " + this.errorCode);
        stringBuffer.append(", ServiceTypeCount " + this.serviceTypes.size());
        stringBuffer.append(", ServiceTypes " + this.serviceTypes);
        return stringBuffer.toString();
    }
}

