/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ForwardedTCPIPDaemon;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.Util;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.Vector;

public class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    private static final int TIMEOUT = 10000;
    SocketFactory factory = null;
    private Socket socket = null;
    private ForwardedTCPIPDaemon daemon = null;
    String target;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.io = new IO();
        this.connected = true;
    }

    public void run() {
        try {
            if (this.lport == -1) {
                Class<?> c = Class.forName(this.target);
                this.daemon = (ForwardedTCPIPDaemon)c.newInstance();
                PipedOutputStream out = new PipedOutputStream();
                this.io.setInputStream(new Channel.PassiveInputStream(out, 32768), false);
                this.daemon.setChannel(this, this.getInputStream(), out);
                Object[] foo = ChannelForwardedTCPIP.getPort(this.session, this.rport);
                this.daemon.setArg((Object[])foo[3]);
                new Thread(this.daemon).start();
            } else {
                this.socket = this.factory == null ? Util.createSocket(this.target, this.lport, 10000) : this.factory.createSocket(this.target, this.lport);
                this.socket.setTcpNoDelay(true);
                this.io.setInputStream(this.socket.getInputStream());
                this.io.setOutputStream(this.socket.getOutputStream());
            }
            this.sendOpenConfirmation();
        }
        catch (Exception e) {
            this.sendOpenFailure(1);
            this.close = true;
            this.disconnect();
            return;
        }
        this.thread = Thread.currentThread();
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 32 - 20);
                if (i <= 0) {
                    this.eof();
                } else {
                    packet.reset();
                    if (!this.close) {
                        buf.putByte((byte)94);
                        buf.putInt(this.recipient);
                        buf.putInt(i);
                        buf.skip(i);
                        this.session.write(packet, this, i);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getInt());
        this.setRemotePacketSize(buf.getInt());
        byte[] addr = buf.getString();
        int port = buf.getInt();
        byte[] orgaddr = buf.getString();
        int orgport = buf.getInt();
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                Object[] foo = (Object[])pool.elementAt(i);
                if (foo[0] == this.session && (Integer)foo[1] == port) {
                    this.rport = port;
                    this.target = (String)foo[2];
                    this.lport = foo[3] == null || foo[3] instanceof Object[] ? -1 : (Integer)foo[3];
                    if (foo.length < 5) break;
                    this.factory = (SocketFactory)foo[4];
                    break;
                }
                ++i;
            }
            if (this.target == null) {
                System.err.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] getPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session && (Integer)bar[1] == rport) {
                    return bar;
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> foo = new Vector<String>();
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session) {
                    if (bar[3] == null) {
                        foo.addElement(bar[1] + ":" + bar[2] + ":");
                    } else {
                        foo.addElement(bar[1] + ":" + bar[2] + ":" + bar[3]);
                    }
                }
                ++i;
            }
        }
        String[] bar = new String[foo.size()];
        int i = 0;
        while (i < foo.size()) {
            bar[i] = (String)foo.elementAt(i);
            ++i;
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int port, String target, int lport, SocketFactory factory) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), target, new Integer(lport), factory};
            pool.addElement(foo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int port, String daemon, Object[] arg) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), daemon, arg};
            pool.addElement(foo);
        }
    }

    static void delPort(ChannelForwardedTCPIP c) {
        ChannelForwardedTCPIP.delPort(c.session, c.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            Object[] foo = null;
            int i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session && (Integer)bar[1] == rport) {
                    foo = bar;
                    break;
                }
                ++i;
            }
            if (foo == null) {
                return;
            }
            pool.removeElement(foo);
        }
        Buffer buf = new Buffer(100);
        Packet packet = new Packet(buf);
        try {
            packet.reset();
            buf.putByte((byte)80);
            buf.putString("cancel-tcpip-forward".getBytes());
            buf.putByte((byte)0);
            buf.putString("0.0.0.0".getBytes());
            buf.putInt(rport);
            session.write(packet);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int i;
        int[] rport = null;
        int count = 0;
        Vector vector = pool;
        synchronized (vector) {
            rport = new int[pool.size()];
            i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session) {
                    rport[count++] = (Integer)bar[1];
                }
                ++i;
            }
        }
        i = 0;
        while (i < count) {
            ChannelForwardedTCPIP.delPort(session, rport[i]);
            ++i;
        }
    }

    public int getRemotePort() {
        return this.rport;
    }

    void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    static {
        LOCAL_WINDOW_SIZE_MAX = 131072;
        LOCAL_MAXIMUM_PACKET_SIZE = 16384;
        TIMEOUT = 10000;
    }
}

