//### This file created by BYACC 1.8(/Java extension  1.13)
//### Java capabilities added 7 Jan 97, Bob Jamison
//### Updated : 27 Nov 97  -- Bob Jamison, Joe Nieten
//###           01 Jan 98  -- Bob Jamison -- fixed generic semantic constructor
//###           01 Jun 99  -- Bob Jamison -- added Runnable support
//###           06 Aug 00  -- Bob Jamison -- made state variables class-global
//###           03 Jan 01  -- Bob Jamison -- improved flags, tracing
//###           16 May 01  -- Bob Jamison -- added custom stack sizing
//###           04 Mar 02  -- Yuval Oren  -- improved java performance, added options
//###           14 Mar 02  -- Tomas Hurka -- -d support, static initializer workaround
//### Please send bug reports to tom@hukatronic.cz
//### static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";



package com.thoughtworks.qdox.parser.impl;



//#line 2 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
import com.thoughtworks.qdox.parser.*;
import com.thoughtworks.qdox.parser.structs.*;
import java.io.IOException;
import java.util.LinkedList;
//#line 22 "Parser.java"




public class Parser
{

boolean yydebug;        //do I want debug output?
int yynerrs;            //number of errors so far
int yyerrflag;          //was there an error?
int yychar;             //the current working character

//########## MESSAGES ##########
//###############################################################
// method: debug
//###############################################################
void debug(String msg)
{
  if (yydebug)
    System.out.println(msg);
}

//########## STATE STACK ##########
final static int YYSTACKSIZE = 500;  //maximum stack size
int statestk[] = new int[YYSTACKSIZE]; //state stack
int stateptr;
int stateptrmax;                     //highest index of stackptr
int statemax;                        //state when highest index reached
//###############################################################
// methods: state stack push,pop,drop,peek
//###############################################################
final void state_push(int state)
{
  try {
		stateptr++;
		statestk[stateptr]=state;
	 }
	 catch (ArrayIndexOutOfBoundsException e) {
     int oldsize = statestk.length;
     int newsize = oldsize * 2;
     int[] newstack = new int[newsize];
     System.arraycopy(statestk,0,newstack,0,oldsize);
     statestk = newstack;
     statestk[stateptr]=state;
  }
}
final int state_pop()
{
  return statestk[stateptr--];
}
final void state_drop(int cnt)
{
  stateptr -= cnt; 
}
final int state_peek(int relative)
{
  return statestk[stateptr-relative];
}
//###############################################################
// method: init_stacks : allocate and prepare stacks
//###############################################################
final boolean init_stacks()
{
  stateptr = -1;
  val_init();
  return true;
}
//###############################################################
// method: dump_stacks : show n levels of the stacks
//###############################################################
void dump_stacks(int count)
{
int i;
  System.out.println("=index==state====value=     s:"+stateptr+"  v:"+valptr);
  for (i=0;i<count;i++)
    System.out.println(" "+i+"    "+statestk[i]+"      "+valstk[i]);
  System.out.println("======================");
}


//########## SEMANTIC VALUES ##########
//## **user defined:Value
String   yytext;//user variable to return contextual strings
Value yyval; //used to return semantic vals from action routines
Value yylval;//the 'lval' (result) I got from yylex()
Value valstk[] = new Value[YYSTACKSIZE];
int valptr;
//###############################################################
// methods: value stack push,pop,drop,peek.
//###############################################################
final void val_init()
{
  yyval=new Value();
  yylval=new Value();
  valptr=-1;
}
final void val_push(Value val)
{
  try {
    valptr++;
    valstk[valptr]=val;
  }
  catch (ArrayIndexOutOfBoundsException e) {
    int oldsize = valstk.length;
    int newsize = oldsize*2;
    Value[] newstack = new Value[newsize];
    System.arraycopy(valstk,0,newstack,0,oldsize);
    valstk = newstack;
    valstk[valptr]=val;
  }
}
final Value val_pop()
{
  return valstk[valptr--];
}
final void val_drop(int cnt)
{
  valptr -= cnt;
}
final Value val_peek(int relative)
{
  return valstk[valptr-relative];
}
//#### end semantic value section ####
public final static short SEMI=257;
public final static short DOT=258;
public final static short DOTDOTDOT=259;
public final static short COMMA=260;
public final static short STAR=261;
public final static short EQUALS=262;
public final static short ANNOSTRING=263;
public final static short ANNOCHAR=264;
public final static short SLASH=265;
public final static short PLUS=266;
public final static short MINUS=267;
public final static short PACKAGE=268;
public final static short IMPORT=269;
public final static short PUBLIC=270;
public final static short PROTECTED=271;
public final static short PRIVATE=272;
public final static short STATIC=273;
public final static short FINAL=274;
public final static short ABSTRACT=275;
public final static short NATIVE=276;
public final static short STRICTFP=277;
public final static short SYNCHRONIZED=278;
public final static short TRANSIENT=279;
public final static short VOLATILE=280;
public final static short CLASS=281;
public final static short INTERFACE=282;
public final static short ENUM=283;
public final static short ANNOINTERFACE=284;
public final static short THROWS=285;
public final static short EXTENDS=286;
public final static short IMPLEMENTS=287;
public final static short SUPER=288;
public final static short DEFAULT=289;
public final static short BRACEOPEN=290;
public final static short BRACECLOSE=291;
public final static short SQUAREOPEN=292;
public final static short SQUARECLOSE=293;
public final static short PARENOPEN=294;
public final static short PARENCLOSE=295;
public final static short LESSTHAN=296;
public final static short GREATERTHAN=297;
public final static short AMPERSAND=298;
public final static short QUERY=299;
public final static short AT=300;
public final static short JAVADOCSTART=301;
public final static short JAVADOCEND=302;
public final static short JAVADOCEOL=303;
public final static short CODEBLOCK=304;
public final static short PARENBLOCK=305;
public final static short IDENTIFIER=306;
public final static short JAVADOCTAG=307;
public final static short JAVADOCTOKEN=308;
public final static short ANNOTATION=309;
public final static short BOOLEAN_LITERAL=310;
public final static short INTEGER_LITERAL=311;
public final static short FLOAT_LITERAL=312;
public final static short YYERRCODE=256;
final static short yylhs[] = {                           -1,
    0,   15,    0,   14,   14,   14,   14,   14,   14,   16,
   17,   17,   18,   21,   23,   23,   24,   24,   22,   22,
   26,   25,    1,    1,    1,   13,   10,   10,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,   27,
   27,   27,    7,    7,    7,    7,    7,    7,    7,    8,
    8,    8,    8,    8,    8,   29,   29,   31,   28,   33,
   30,   32,   32,   34,   34,   35,   35,   36,    9,    9,
   37,    9,    9,   38,   39,   39,   12,    3,    4,    4,
    5,    5,   40,   40,   41,   41,   42,   42,   42,   42,
   43,   43,   44,   45,   45,   46,   46,   47,   47,   20,
   48,   49,   49,   51,   51,   51,   53,   53,   54,   54,
   54,   54,   19,   56,   57,   57,   57,   58,   58,   59,
   59,   50,   50,   60,   60,   52,   62,   52,   61,   61,
   61,   61,   61,   61,   61,   61,    6,    6,   66,   68,
   63,   67,   69,   67,   64,   64,   65,   70,   71,   71,
   73,   73,   72,   72,   74,   74,   75,   11,   11,   55,
   55,   76,   76,
};
final static short yylen[] = {                            2,
    0,    0,    3,    1,    1,    1,    1,    1,    1,    3,
    3,    4,    4,    1,    0,    2,    1,    1,    0,    2,
    0,    3,    1,    3,    3,    2,    0,    3,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
    2,    0,    1,    1,    1,    1,    3,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    0,    2,    0,
    3,    0,    3,    1,    1,    1,    3,    3,    3,    1,
    0,    2,    1,    3,    1,    3,    3,    2,    1,    3,
    1,    3,    0,    3,    1,    3,    1,    1,    3,    3,
    0,    1,    3,    1,    3,    1,    3,    1,    3,    4,
    4,    1,    3,    0,    1,    3,    2,    2,    1,    2,
    2,    3,    4,    6,    1,    1,    1,    0,    2,    1,
    3,    0,    2,    1,    3,    0,    0,    3,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    2,    0,
    6,    0,    0,    4,    8,    7,    5,    3,    0,    2,
    1,    3,    0,    1,    1,    3,    5,    0,    1,    0,
    2,    0,    2,
};
final static short yydefred[] = {                         1,
    2,    0,    9,    0,    0,   15,    3,    4,    5,    6,
    7,    8,    0,    0,    0,   23,    0,    0,    0,   19,
    0,   29,   30,   31,   32,   33,   34,   35,   39,   36,
   38,   37,  115,  116,    0,  117,   40,   41,    0,    0,
    0,  126,   10,    0,    0,   11,    0,   18,   17,   16,
    0,   60,   59,    0,    0,    0,    0,    0,    0,    0,
   25,   24,   12,   13,   21,   20,    0,  101,    0,    0,
    0,   92,    0,  107,  100,  126,    0,  161,  108,  113,
    0,   15,   81,    0,    0,    0,    0,    0,   61,    0,
    0,   94,    0,    0,  110,    0,    0,  106,  136,  129,
  134,  135,    0,  128,  130,  131,  132,  133,    0,    0,
    0,   78,    0,    0,   48,   49,    0,    0,    0,   45,
   44,   43,    0,   56,   64,    0,    0,    0,   66,    0,
   73,    0,    0,   93,    0,    0,  114,  112,  139,    0,
    0,    0,    0,   80,    0,   87,    0,   85,   82,    0,
   75,    0,    0,    0,    0,   52,   53,   54,   55,   50,
   51,    0,   63,    0,   72,   98,    0,   95,    0,    0,
    0,   27,    0,  140,    0,    0,    0,    0,   84,    0,
   74,   69,   68,   47,   57,    0,   67,    0,    0,    0,
    0,    0,  155,    0,    0,    0,    0,   27,  142,    0,
   89,   90,   86,   76,   99,    0,  148,  160,    0,    0,
  137,  138,  147,    0,    0,    0,   27,  163,    0,  156,
    0,   28,    0,  143,  141,    0,  159,    0,    0,  146,
    0,    0,   27,  157,  144,  145,
};
final static short yydgoto[] = {                          1,
  123,   37,  141,   85,   86,  213,  124,  162,  125,  197,
  228,  146,  174,    7,    2,    8,    9,   55,   11,   12,
   20,   47,   21,   50,   66,   82,   13,   38,  126,   53,
   39,   89,   69,  127,  128,  129,  130,  131,  152,  112,
  147,  148,   71,   72,   91,   92,  167,   14,   56,   68,
   57,   60,   58,   74,   59,   15,   40,   94,  136,   87,
  104,   81,  105,  106,  107,  108,  216,  199,  231,  171,
  195,  191,  210,  192,  193,  206,
};
final static short yysindex[] = {                         0,
    0,  -48,    0,  -84, -267,    0,    0,    0,    0,    0,
    0,    0,  157, -257,   -5,    0, -240,  -84, -220,    0,
 -273,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   25,    0,    0,    0,  -20,   30,
  -69,    0,    0, -215,   13,    0, -127,    0,    0,    0,
    4,    0,    0,   51,   40,    1,   92,   90,   40,   60,
    0,    0,    0,    0,    0,    0,   46,    0,   59,   48,
   69,    0,  -63,    0,    0,    0,  -69,    0,    0,    0,
 -133,    0,    0,   99,   62,  102,  101, -118,    0,   76,
 -160,    0,   46,    4,    0,   61,    0,    0,    0,    0,
    0,    0,  105,    0,    0,    0,    0,    0, -273,   57,
 -286,    0,   58,   46,    0,    0,  -99,  -99,  104,    0,
    0,    0,  109,    0,    0,  -15,  107,  143,    0,  -20,
    0,   46,   48,    0,   99,  144,    0,    0,    0,  111,
 -247,  100,   46,    0,   -9,    0, -134,    0,    0,   99,
    0,  -64,  112,  -99,  -78,    0,    0,    0,    0,    0,
    0, -183,    0,  106,    0,    0,  110,    0,   46,    0,
  125,    0,  111,    0,  108,   46,   46, -286,    0,  -99,
    0,    0,    0,    0,    0,  104,    0,   46,   99,    0,
  118,  155,    0,  -84, -207,  124,  124,    0,    0,  111,
    0,    0,    0,    0,    0,  120,    0,    0,  159,  158,
    0,    0,    0,  126, -269, -235,    0,    0,  161,    0,
  -84,    0, -207,    0,    0, -269,    0,  115,  159,    0,
  115, -207,    0,    0,    0,    0,
};
final static short yyrindex[] = {                         0,
    0,   24,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  113,    0,    0,    0,    0,    0,    0,    0,
  -77,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -216,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  133,    0,    0,  -14,    0,    0,  134,  -22,  113, -162,
    0,    0,    0,    0,    0,    0,    0,    0, -122,    0,
 -186,    0, -155,    0,    0,    0, -216,    0,    0,    0,
  -16,    0,    0,  -71,  -61,  -82,  152,  135,    0, -130,
    0,    0,    0,  133,    0,  -17, -217,    0,    0,    0,
    0,    0,  113,    0,    0,    0,    0,    0,  -58,    0,
    0,    0,    0,    0,    0,    0,  135,  135,   74,    0,
    0,    0,   77,    0,    0,  -89,    0,  129,    0,    0,
    0,    0,    0,    0, -245,   -3,    0,    0,    0, -224,
  -59,    0,    0,    0,  -79,    0,    0,    0,    0,  -56,
    0,    0,    0,  135,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -74,    0,    0,   39,
 -206,    0, -161,    0,    0,    0,    0,    0,    0,  135,
    0,    0,    0,    0,    0,    0,    0,    0,  -12,   50,
    0,  148,    0,    0,    0, -212, -125,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -233, -179,
    0,    0,    0,    0, -206,    0,    0,    0,  139,    0,
    0,    0,    0,    0,    0, -206,    0,    0, -231,    0,
    0,    0,    0,    0,    0,    0,
};
final static short yygindex[] = {                         0,
   -4,  240,  -62,    0,    0, -204,  285,    0, -110,  -32,
    0, -100,   55,    0,    0,    0,    0,    2,  367,  368,
    0,    0,  369,    0,    0,    0,  371,  -57,    0,  320,
    0,    0,    0,    0,    0,  289,    0,    0,    0,  313,
    0,  277,    0,  353,    0,  324,    0,    0,    0,  364,
  382,  384,    0,  402,  -67,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -164,
 -205,    0,    0,    0,  254,    0,
};
final static int YYTABLESIZE=462;
static short yytable[];
static { yytable();}
static void yytable(){
yytable = new short[]{                         17,
   19,   78,  142,   10,   84,   18,  151,  153,  198,  223,
  110,  225,  145,   45,  120,  194,   43,   44,  230,   83,
  232,  211,  214,  151,  224,  152,  151,  236,  152,   48,
  135,  166,   41,   81,   49,  217,   46,   44,   16,  127,
  104,  120,  175,  183,  120,   61,   77,   77,  111,  211,
  149,  150,  127,  127,  127,  127,  127,  127,  127,  127,
  127,  127,  127,  127,  127,  127,  127,   81,  212,  204,
  151,   81,  152,  103,  104,  201,  202,  150,  127,  115,
  116,   81,  100,  127,   77,   77,  127,  205,  127,  160,
   62,  127,  160,   77,  127,   27,  212,  149,   27,  133,
  118,  109,  190,  118,  109,  219,  189,  127,  127,  127,
  127,  127,  127,  127,  127,  127,  127,  127,  127,  127,
  127,  127,   16,   99,  150,  178,  120,  121,  122,   96,
   27,   26,   78,  127,   26,  109,  134,   62,  127,  196,
  190,  127,   27,  127,  115,  116,  127,   62,   62,   62,
   62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
   62,   62,  179,  115,  116,  215,   96,    6,   62,   26,
   70,  117,   62,   62,   64,  118,   79,   79,   26,   65,
   88,   62,   61,   62,  226,   97,   62,  119,  124,  209,
  117,  120,  121,  122,  118,  180,   83,   83,   83,   83,
   83,   70,  184,  125,   79,   70,   16,   79,    3,   79,
  120,  121,  122,   79,   79,   79,  229,   88,  124,    4,
    5,   16,   97,   79,   14,   83,  181,   62,   83,   14,
   83,    6,   83,  125,  105,   83,   83,   83,   83,  111,
   95,   96,  111,   22,   83,  156,   83,  121,   22,  157,
  158,  159,    6,   42,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   42,   42,   42,   42,  105,   63,
   44,   91,   91,  111,  121,   91,  176,  121,  177,   42,
  160,  161,  234,  119,   42,  235,  119,   42,   52,   42,
   67,   75,   42,   42,   42,   42,   42,   42,   42,   42,
   42,   42,   42,   42,   42,   42,   42,   42,  160,  160,
  160,  160,  160,  160,  160,  160,  160,  160,  160,  162,
  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
   51,   23,   42,  153,   23,   54,   46,   46,   23,   23,
   23,   46,   46,   46,  160,   73,   70,  160,   76,   77,
   80,   83,   88,   90,   93,  162,  110,  111,   58,  113,
  114,  132,  144,  149,  138,  154,  155,   46,   23,   23,
   23,   46,   46,   46,   22,   23,   24,   25,   26,   27,
   28,   29,   30,   31,   32,   33,   34,   35,   36,   22,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   70,  163,  164,  169,  170,  173,  182,  188,  139,  194,
  140,  186,  207,  200,  208,  214,   44,  221,  222,  227,
  233,   58,  122,   65,  102,   83,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,  123,  154,   71,  158,  218,  185,  101,  102,  165,
  109,  103,  187,  172,  203,  143,  168,  137,   98,   97,
   79,  220,
};
}
static short yycheck[];
static { yycheck(); }
static void yycheck() {
yycheck = new short[] {                          4,
    5,   59,  103,    2,   67,  273,  117,  118,  173,  215,
  258,  216,  299,   18,  260,  285,  257,  258,  223,  306,
  226,  257,  292,  257,  260,  257,  260,  232,  260,  303,
   93,  132,  290,  258,  308,  200,  257,  258,  306,  257,
  257,  287,  143,  154,  290,  261,  259,  260,  296,  257,
  257,  114,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  292,  304,  180,
  304,  296,  304,  291,  291,  176,  177,  257,  296,  263,
  264,  306,   81,  301,  297,  298,  304,  188,  306,  306,
  306,  309,  309,  306,  257,  257,  304,  304,  260,  260,
  287,  257,  170,  290,  260,  206,  169,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  306,  257,  304,  260,  310,  311,  312,  260,
  292,  257,  190,  296,  260,  291,  297,  260,  301,  172,
  208,  304,  304,  306,  263,  264,  309,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  297,  263,  264,  198,  297,  301,  291,  295,
  260,  290,  295,  296,  302,  294,  259,  260,  304,  307,
  260,  304,  261,  306,  217,  260,  309,  306,  260,  194,
  290,  310,  311,  312,  294,  260,  258,  259,  260,  259,
  260,  291,  281,  260,  287,  295,  306,  290,  257,  292,
  310,  311,  312,  296,  297,  298,  221,  297,  290,  268,
  269,  306,  297,  306,  302,  287,  291,  306,  290,  307,
  292,  301,  292,  290,  257,  297,  298,  297,  298,  257,
  304,  305,  260,  302,  306,  261,  306,  260,  307,  265,
  266,  267,  301,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  291,  257,
  258,  286,  287,  291,  287,  290,  286,  290,  288,  296,
  296,  297,  228,  287,  290,  231,  290,  304,  309,  306,
  287,  291,  309,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  306,  258,  309,  295,  261,  306,  260,  261,  265,  266,
  267,  265,  266,  267,  306,  306,  296,  309,  257,  260,
  291,  306,  294,  306,  286,  306,  258,  296,  309,  258,
  260,  286,  306,  306,  304,  262,  258,  291,  295,  296,
  297,  295,  296,  297,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  296,  295,  260,  260,  294,  306,  295,  298,  304,  285,
  306,  306,  295,  306,  260,  292,  258,  260,  293,  259,
  306,  309,  290,  295,  291,  306,  270,  271,  272,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  290,  295,  309,  306,  206,  162,   81,   81,  130,
   82,   81,  164,  141,  178,  103,  133,   94,   77,   76,
   59,  208,
};
}
final static short YYFINAL=1;
final static short YYMAXTOKEN=312;
final static String yyname[] = {
"end-of-file",null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,
null,null,null,"SEMI","DOT","DOTDOTDOT","COMMA","STAR","EQUALS","ANNOSTRING",
"ANNOCHAR","SLASH","PLUS","MINUS","PACKAGE","IMPORT","PUBLIC","PROTECTED",
"PRIVATE","STATIC","FINAL","ABSTRACT","NATIVE","STRICTFP","SYNCHRONIZED",
"TRANSIENT","VOLATILE","CLASS","INTERFACE","ENUM","ANNOINTERFACE","THROWS",
"EXTENDS","IMPLEMENTS","SUPER","DEFAULT","BRACEOPEN","BRACECLOSE","SQUAREOPEN",
"SQUARECLOSE","PARENOPEN","PARENCLOSE","LESSTHAN","GREATERTHAN","AMPERSAND",
"QUERY","AT","JAVADOCSTART","JAVADOCEND","JAVADOCEOL","CODEBLOCK","PARENBLOCK",
"IDENTIFIER","JAVADOCTAG","JAVADOCTOKEN","ANNOTATION","BOOLEAN_LITERAL",
"INTEGER_LITERAL","FLOAT_LITERAL",
};
final static String yyrule[] = {
"$accept : file",
"file :",
"$$1 :",
"file : file $$1 filepart",
"filepart : package",
"filepart : import",
"filepart : javadoc",
"filepart : class",
"filepart : enum",
"filepart : SEMI",
"package : PACKAGE fullidentifier SEMI",
"import : IMPORT fullidentifier SEMI",
"import : IMPORT STATIC fullidentifier SEMI",
"javadoc : JAVADOCSTART javadocdescription javadoctags JAVADOCEND",
"javadocdescription : javadoctokens",
"javadoctokens :",
"javadoctokens : javadoctokens javadoctoken",
"javadoctoken : JAVADOCTOKEN",
"javadoctoken : JAVADOCEOL",
"javadoctags :",
"javadoctags : javadoctags javadoctag",
"$$2 :",
"javadoctag : JAVADOCTAG $$2 javadoctokens",
"fullidentifier : IDENTIFIER",
"fullidentifier : fullidentifier DOT IDENTIFIER",
"fullidentifier : fullidentifier DOT STAR",
"arrayidentifier : IDENTIFIER dimensions",
"dimensions :",
"dimensions : dimensions SQUAREOPEN SQUARECLOSE",
"modifier : PUBLIC",
"modifier : PROTECTED",
"modifier : PRIVATE",
"modifier : STATIC",
"modifier : FINAL",
"modifier : ABSTRACT",
"modifier : NATIVE",
"modifier : SYNCHRONIZED",
"modifier : VOLATILE",
"modifier : TRANSIENT",
"modifier : STRICTFP",
"modifiers : modifiers modifier",
"modifiers : modifiers annotation",
"modifiers :",
"annotationValueConstant : FLOAT_LITERAL",
"annotationValueConstant : INTEGER_LITERAL",
"annotationValueConstant : BOOLEAN_LITERAL",
"annotationValueConstant : fullidentifier",
"annotationValueConstant : fullidentifier DOT CLASS",
"annotationValueConstant : ANNOSTRING",
"annotationValueConstant : ANNOCHAR",
"annotationSymConstant : LESSTHAN",
"annotationSymConstant : GREATERTHAN",
"annotationSymConstant : STAR",
"annotationSymConstant : SLASH",
"annotationSymConstant : PLUS",
"annotationSymConstant : MINUS",
"annotationValueConstants : annotationValueConstant",
"annotationValueConstants : annotationValueConstants annotationSymConstant annotationValueConstant",
"$$3 :",
"annotation : $$3 annotationWork",
"$$4 :",
"annotationWork : ANNOTATION $$4 annoParens",
"annoParens :",
"annoParens : PARENOPEN annoParenContents PARENCLOSE",
"annoParenContents : annoElementValue",
"annoParenContents : annoElementValuePairs",
"annoElementValuePairs : annoElementValuePair",
"annoElementValuePairs : annoElementValuePairs COMMA annoElementValuePair",
"annoElementValuePair : IDENTIFIER EQUALS annoElementValue",
"annoElementValue : PARENOPEN annoElementValue PARENCLOSE",
"annoElementValue : annotationValueConstants",
"$$5 :",
"annoElementValue : $$5 annotationWork",
"annoElementValue : annoElementValueArrayInitializer",
"annoElementValueArrayInitializer : BRACEOPEN annoElementValues BRACECLOSE",
"annoElementValues : annoElementValue",
"annoElementValues : annoElementValues COMMA annoElementValue",
"type : classtype opt_typearguments dimensions",
"classtype : typedeclspecifier opt_typearguments",
"typedeclspecifier : typename",
"typedeclspecifier : classtype DOT IDENTIFIER",
"typename : IDENTIFIER",
"typename : typename DOT IDENTIFIER",
"opt_typearguments :",
"opt_typearguments : LESSTHAN typearglist GREATERTHAN",
"typearglist : typearg",
"typearglist : typearglist COMMA typearg",
"typearg : type",
"typearg : QUERY",
"typearg : QUERY EXTENDS type",
"typearg : QUERY SUPER type",
"opt_typeparams :",
"opt_typeparams : typeparams",
"typeparams : LESSTHAN typeparamlist GREATERTHAN",
"typeparamlist : typeparam",
"typeparamlist : typeparamlist COMMA typeparam",
"typeparam : IDENTIFIER",
"typeparam : IDENTIFIER EXTENDS typeboundlist",
"typeboundlist : type",
"typeboundlist : typeboundlist AMPERSAND type",
"enum : enum_definition BRACEOPEN enum_body BRACECLOSE",
"enum_definition : modifiers ENUM IDENTIFIER opt_implements",
"enum_body : enum_values",
"enum_body : enum_values SEMI members",
"enum_values :",
"enum_values : enum_value",
"enum_values : enum_value COMMA enum_values",
"enum_value : javadoc enum_constructor",
"enum_value : opt_annotations enum_constructor",
"enum_constructor : IDENTIFIER",
"enum_constructor : IDENTIFIER CODEBLOCK",
"enum_constructor : IDENTIFIER PARENBLOCK",
"enum_constructor : IDENTIFIER PARENBLOCK CODEBLOCK",
"class : classdefinition BRACEOPEN members BRACECLOSE",
"classdefinition : modifiers classorinterface IDENTIFIER opt_typeparams opt_extends opt_implements",
"classorinterface : CLASS",
"classorinterface : INTERFACE",
"classorinterface : ANNOINTERFACE",
"opt_extends :",
"opt_extends : EXTENDS extendslist",
"extendslist : classtype",
"extendslist : extendslist COMMA classtype",
"opt_implements :",
"opt_implements : IMPLEMENTS implementslist",
"implementslist : classtype",
"implementslist : implementslist COMMA classtype",
"members :",
"$$6 :",
"members : members $$6 member",
"member : javadoc",
"member : fields",
"member : method",
"member : constructor",
"member : static_block",
"member : class",
"member : enum",
"member : SEMI",
"memberend : SEMI",
"memberend : CODEBLOCK",
"static_block : modifiers CODEBLOCK",
"$$7 :",
"fields : modifiers type arrayidentifier $$7 extrafields memberend",
"extrafields :",
"$$8 :",
"extrafields : extrafields COMMA $$8 arrayidentifier",
"method : modifiers typeparams type IDENTIFIER methoddef dimensions opt_exceptions memberend",
"method : modifiers type IDENTIFIER methoddef dimensions opt_exceptions memberend",
"constructor : modifiers IDENTIFIER methoddef opt_exceptions memberend",
"methoddef : PARENOPEN opt_params PARENCLOSE",
"opt_exceptions :",
"opt_exceptions : THROWS exceptionlist",
"exceptionlist : fullidentifier",
"exceptionlist : exceptionlist COMMA fullidentifier",
"opt_params :",
"opt_params : paramlist",
"paramlist : param",
"paramlist : paramlist COMMA param",
"param : opt_annotations opt_parammodifiers type varargs arrayidentifier",
"varargs :",
"varargs : DOTDOTDOT",
"opt_annotations :",
"opt_annotations : opt_annotations annotation",
"opt_parammodifiers :",
"opt_parammodifiers : opt_parammodifiers modifier",
};

//#line 406 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"

private Lexer lexer;
private Builder builder;
private StringBuffer textBuffer = new StringBuffer();
private ClassDef cls = new ClassDef();
private MethodDef mth = new MethodDef();
private AnnoDef ano = new AnnoDef();
private FieldDef param = new FieldDef();
private java.util.Set modifiers = new java.util.HashSet();
private TypeDef fieldType;
private int line;
private int column;
private boolean debugLexer;

private LinkedList annoConstants = new LinkedList();
private LinkedList annoValues = new LinkedList();

private void appendToBuffer(String word) {
    if (textBuffer.length() > 0) {
        char lastChar = textBuffer.charAt(textBuffer.length() - 1);
        if (!Character.isWhitespace(lastChar)) {
            textBuffer.append(' ');
        }
    }
    textBuffer.append(word);
}

private String buffer() {
    String result = textBuffer.toString().trim();
    textBuffer.setLength(0);
    return result;
}

public Parser(Lexer lexer, Builder builder) {
    this.lexer = lexer;
    this.builder = builder;
}

public void setDebugParser(boolean debug) {
    yydebug = debug;
}

public void setDebugLexer(boolean debug) {
    debugLexer = debug;
}

/**
 * Parse file. Return true if successful.
 */
public boolean parse() {
    return yyparse() == 0;
}

private int yylex() {
    try {
        final int result = lexer.lex();
        yylval = new Value();
        yylval.sval = lexer.text();
        if (debugLexer) {
            System.err.println("Token: " + yyname[result] + " \"" + yylval.sval + "\"");
        }
        return result;
    }
    catch(IOException e) {
        return 0;
    }
}

private void yyerror(String msg) {
    throw new ParseException(msg, lexer.getLine(), lexer.getColumn());
}

private class Value {
	Object oval;
    String sval;
    int ival;
	boolean bval;
    TypeDef type;
}

private void makeField(TypeDef field, String body) {
    FieldDef fd = new FieldDef();
    fd.lineNumber = line;
    fd.modifiers.addAll(modifiers); 
    fd.type = fieldType.name; 
    fd.dimensions = fieldType.dimensions + field.dimensions;
    fd.name = field.name;
    fd.body = body;
    builder.addField(fd);
}

//#line 679 "Parser.java"
//###############################################################
// method: yylexdebug : check lexer state
//###############################################################
void yylexdebug(int state,int ch)
{
String s=null;
  if (ch < 0) ch=0;
  if (ch <= YYMAXTOKEN) //check index bounds
     s = yyname[ch];    //now get it
  if (s==null)
    s = "illegal-symbol";
  debug("state "+state+", reading "+ch+" ("+s+")");
}





//The following are now global, to aid in error reporting
int yyn;       //next next thing to do
int yym;       //
int yystate;   //current parsing state from state table
String yys;    //current token string


//###############################################################
// method: yyparse : parse input and execute indicated items
//###############################################################
int yyparse()
{
boolean doaction;
  init_stacks();
  yynerrs = 0;
  yyerrflag = 0;
  yychar = -1;          //impossible char forces a read
  yystate=0;            //initial state
  state_push(yystate);  //save it
  while (true) //until parsing is done, either correctly, or w/error
    {
    doaction=true;
    if (yydebug) debug("loop"); 
    //#### NEXT ACTION (from reduction table)
    for (yyn=yydefred[yystate];yyn==0;yyn=yydefred[yystate])
      {
      if (yydebug) debug("yyn:"+yyn+"  state:"+yystate+"  yychar:"+yychar);
      if (yychar < 0)      //we want a char?
        {
        yychar = yylex();  //get next token
        if (yydebug) debug(" next yychar:"+yychar);
        //#### ERROR CHECK ####
        if (yychar < 0)    //it it didn't work/error
          {
          yychar = 0;      //change it to default string (no -1!)
          if (yydebug)
            yylexdebug(yystate,yychar);
          }
        }//yychar<0
      yyn = yysindex[yystate];  //get amount to shift by (shift index)
      if ((yyn != 0) && (yyn += yychar) >= 0 &&
          yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
        {
        if (yydebug)
          debug("state "+yystate+", shifting to state "+yytable[yyn]);
        //#### NEXT STATE ####
        yystate = yytable[yyn];//we are in a new state
        state_push(yystate);   //save it
        val_push(yylval);      //push our lval as the input for next rule
        yychar = -1;           //since we have 'eaten' a token, say we need another
        if (yyerrflag > 0)     //have we recovered an error?
           --yyerrflag;        //give ourselves credit
        doaction=false;        //but don't process yet
        break;   //quit the yyn=0 loop
        }

    yyn = yyrindex[yystate];  //reduce
    if ((yyn !=0 ) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
      {   //we reduced!
      if (yydebug) debug("reduce");
      yyn = yytable[yyn];
      doaction=true; //get ready to execute
      break;         //drop down to actions
      }
    else //ERROR RECOVERY
      {
      if (yyerrflag==0)
        {
        yyerror("syntax error");
        yynerrs++;
        }
      if (yyerrflag < 3) //low error count?
        {
        yyerrflag = 3;
        while (true)   //do until break
          {
          if (stateptr<0)   //check for under & overflow here
            {
            yyerror("stack underflow. aborting...");  //note lower case 's'
            return 1;
            }
          yyn = yysindex[state_peek(0)];
          if ((yyn != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
            if (yydebug)
              debug("state "+state_peek(0)+", error recovery shifting to state "+yytable[yyn]+" ");
            yystate = yytable[yyn];
            state_push(yystate);
            val_push(yylval);
            doaction=false;
            break;
            }
          else
            {
            if (yydebug)
              debug("error recovery discarding state "+state_peek(0)+" ");
            if (stateptr<0)   //check for under & overflow here
              {
              yyerror("Stack underflow. aborting...");  //capital 'S'
              return 1;
              }
            state_pop();
            val_pop();
            }
          }
        }
      else            //discard this token
        {
        if (yychar == 0)
          return 1; //yyabort
        if (yydebug)
          {
          yys = null;
          if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
          if (yys == null) yys = "illegal-symbol";
          debug("state "+yystate+", error recovery discards token "+yychar+" ("+yys+")");
          }
        yychar = -1;  //read another
        }
      }//end error recovery
    }//yyn=0 loop
    if (!doaction)   //any reason not to proceed?
      continue;      //skip action
    yym = yylen[yyn];          //get count of terminals on rhs
    if (yydebug)
      debug("state "+yystate+", reducing "+yym+" by rule "+yyn+" ("+yyrule[yyn]+")");
    if (yym>0)                 //if count of rhs not 'nil'
      yyval = val_peek(yym-1); //get current semantic value
    switch(yyn)
      {
//########## USER-SUPPLIED ACTIONS ##########
case 2:
//#line 31 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ line = lexer.getLine(); }
break;
case 10:
//#line 37 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ builder.addPackage(val_peek(1).sval); }
break;
case 11:
//#line 40 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ builder.addImport(val_peek(1).sval); }
break;
case 12:
//#line 41 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ builder.addImport(val_peek(1).sval); }
break;
case 14:
//#line 49 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ 
        builder.addJavaDoc(buffer()); 
    }
break;
case 17:
//#line 56 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        appendToBuffer(val_peek(0).sval);
    }
break;
case 18:
//#line 59 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        textBuffer.append('\n');
    }
break;
case 21:
//#line 66 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ line = lexer.getLine(); }
break;
case 22:
//#line 67 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        builder.addJavaDocTag(new TagDef(val_peek(2).sval.substring(1), buffer(), line)); 
    }
break;
case 23:
//#line 76 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 24:
//#line 77 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(2).sval + '.' + val_peek(0).sval; }
break;
case 25:
//#line 78 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(2).sval + ".*"; }
break;
case 26:
//#line 81 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        yyval.type = new TypeDef(val_peek(1).sval,val_peek(0).ival);
    }
break;
case 27:
//#line 86 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.ival = 0; }
break;
case 28:
//#line 87 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        yyval.ival = val_peek(2).ival + 1; 
    }
break;
case 29:
//#line 93 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "public"; }
break;
case 30:
//#line 94 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "protected"; }
break;
case 31:
//#line 95 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "private"; }
break;
case 32:
//#line 96 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "static"; }
break;
case 33:
//#line 97 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "final"; }
break;
case 34:
//#line 98 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "abstract"; }
break;
case 35:
//#line 99 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "native"; }
break;
case 36:
//#line 100 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "synchronized"; }
break;
case 37:
//#line 101 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "volatile"; }
break;
case 38:
//#line 102 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "transient"; }
break;
case 39:
//#line 103 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "strictfp"; }
break;
case 40:
//#line 106 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ modifiers.add(val_peek(0).sval); }
break;
case 43:
//#line 114 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 44:
//#line 115 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 45:
//#line 116 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 46:
//#line 117 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 47:
//#line 118 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(2).sval + ".class"; }
break;
case 48:
//#line 119 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
		/* would prefer to set this as a returned token in flex... how?*/
		String str = lexer.getCodeBody();
		str = str.substring( 1, str.length() - 1 );
		yyval.sval = str;
	}
break;
case 49:
//#line 125 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
		String str = lexer.getCodeBody();
		str = str.substring( 1, str.length() - 1 );
		yyval.sval = str;
	}
break;
case 50:
//#line 132 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "<"; }
break;
case 51:
//#line 133 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = ">"; }
break;
case 52:
//#line 134 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "*"; }
break;
case 53:
//#line 135 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "/"; }
break;
case 54:
//#line 136 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "+"; }
break;
case 55:
//#line 137 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = "/"; }
break;
case 56:
//#line 140 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
		annoConstants.add( val_peek(0).sval );
	}
break;
case 57:
//#line 142 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
		annoConstants.add( val_peek(1).sval );
		annoConstants.add( val_peek(0).sval );
	}
break;
case 58:
//#line 148 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ ano = new AnnoDef(); }
break;
case 59:
//#line 148 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ builder.addAnnotation(ano); }
break;
case 60:
//#line 151 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        ano.lineNumber = line;
		ano.name = val_peek(0).sval.substring(1).trim();
	}
break;
case 64:
//#line 161 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ ano.args.put( "value", val_peek(0).oval ); }
break;
case 68:
//#line 169 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ ano.args.put( val_peek(2).sval, val_peek(0).oval ); }
break;
case 69:
//#line 172 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.oval = val_peek(1).oval; }
break;
case 70:
//#line 173 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.oval = annoConstants; annoConstants = new LinkedList(); }
break;
case 71:
//#line 174 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{	AnnoDef tmpAno = new AnnoDef();
		tmpAno.tempAnno = ano;
		ano = tmpAno;
	}
break;
case 72:
//#line 177 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.oval = ano; ano = ano.tempAnno; }
break;
case 73:
//#line 178 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.oval = annoValues; annoValues = new LinkedList(); }
break;
case 75:
//#line 184 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ annoValues.add( val_peek(0).oval ); }
break;
case 76:
//#line 185 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ annoValues.add( val_peek(0).oval ); }
break;
case 77:
//#line 190 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        yyval.type = new TypeDef(val_peek(2).sval,val_peek(0).ival);
    }
break;
case 78:
//#line 195 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        yyval.sval = val_peek(1).sval; 
    }
break;
case 79:
//#line 200 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 80:
//#line 201 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(2).sval + '.' + val_peek(0).sval; }
break;
case 81:
//#line 204 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(0).sval; }
break;
case 82:
//#line 205 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.sval = val_peek(2).sval + '.' + val_peek(0).sval; }
break;
case 100:
//#line 237 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
  builder.endClass();
}
break;
case 101:
//#line 241 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
    cls.lineNumber = line;
    cls.modifiers.addAll(modifiers); modifiers.clear();
    cls.name = val_peek(1).sval;
    cls.type = ClassDef.ENUM;
    builder.beginClass(cls);
    cls = new ClassDef();
}
break;
case 113:
//#line 268 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        builder.endClass(); 
    }
break;
case 114:
//#line 273 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        cls.lineNumber = line;
        cls.modifiers.addAll(modifiers); modifiers.clear(); 
        cls.name = val_peek(3).sval;
        builder.beginClass(cls); 
        cls = new ClassDef(); 
    }
break;
case 115:
//#line 282 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.type = ClassDef.CLASS; }
break;
case 116:
//#line 283 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.type = ClassDef.INTERFACE; }
break;
case 117:
//#line 284 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.type = ClassDef.ANNOTATION_TYPE; }
break;
case 120:
//#line 289 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.extendz.add(val_peek(0).sval); }
break;
case 121:
//#line 290 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.extendz.add(val_peek(0).sval); }
break;
case 124:
//#line 295 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.implementz.add(val_peek(0).sval); }
break;
case 125:
//#line 296 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ cls.implementz.add(val_peek(0).sval); }
break;
case 127:
//#line 298 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ line = lexer.getLine(); }
break;
case 137:
//#line 311 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
      yyval.sval = "";
    }
break;
case 138:
//#line 314 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
	  yyval.sval = lexer.getCodeBody();
    }
break;
case 139:
//#line 319 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ modifiers.clear(); }
break;
case 140:
//#line 324 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        fieldType = val_peek(1).type;
        makeField(val_peek(0).type, lexer.getCodeBody());
    }
break;
case 141:
//#line 328 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        modifiers.clear();
    }
break;
case 143:
//#line 333 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ line = lexer.getLine(); }
break;
case 144:
//#line 333 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        makeField(val_peek(0).type, lexer.getCodeBody());
    }
break;
case 145:
//#line 341 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        mth.lineNumber = line;
        mth.modifiers.addAll(modifiers); modifiers.clear(); 
        mth.returns = val_peek(5).type.name;
        mth.dimensions = val_peek(2).ival + val_peek(5).type.dimensions; /* return dimensions can be specified after return type OR after params*/
        mth.name = val_peek(4).sval;
        mth.body = val_peek(0).sval;
        builder.addMethod(mth);
        mth = new MethodDef(); 
    }
break;
case 146:
//#line 351 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        mth.lineNumber = line;
        mth.modifiers.addAll(modifiers); modifiers.clear();
        mth.returns = val_peek(5).type.name;
        mth.dimensions = val_peek(2).ival + val_peek(5).type.dimensions; /* return dimensions can be specified after return type OR after params*/
        mth.name = val_peek(4).sval;
        mth.body = val_peek(0).sval;
        builder.addMethod(mth);
        mth = new MethodDef();
    }
break;
case 147:
//#line 363 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        mth.lineNumber = line;
        mth.modifiers.addAll(modifiers); modifiers.clear(); 
        mth.constructor = true; mth.name = val_peek(3).sval;
        mth.body = val_peek(0).sval;
        builder.addMethod(mth);
        mth = new MethodDef(); 
    }
break;
case 151:
//#line 377 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ mth.exceptions.add(val_peek(0).sval); }
break;
case 152:
//#line 378 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ mth.exceptions.add(val_peek(0).sval); }
break;
case 157:
//#line 387 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{
        param.name = val_peek(0).type.name;
        param.type = val_peek(2).type.name;
        param.dimensions = val_peek(2).type.dimensions + val_peek(0).type.dimensions;
        param.isVarArgs = val_peek(1).bval;
        mth.params.add(param);
        param = new FieldDef();
    }
break;
case 158:
//#line 397 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.bval = false; }
break;
case 159:
//#line 398 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ yyval.bval = true; }
break;
case 163:
//#line 403 "/Users/mauro/svn/qdox/target/checkout/src/grammar/parser.y"
{ param.modifiers.add(val_peek(0).sval); }
break;
//#line 1274 "Parser.java"
//########## END OF USER-SUPPLIED ACTIONS ##########
    }//switch
    //#### Now let's reduce... ####
    if (yydebug) debug("reduce");
    state_drop(yym);             //we just reduced yylen states
    yystate = state_peek(0);     //get new state
    val_drop(yym);               //corresponding value drop
    yym = yylhs[yyn];            //select next TERMINAL(on lhs)
    if (yystate == 0 && yym == 0)//done? 'rest' state and at first TERMINAL
      {
      if (yydebug) debug("After reduction, shifting from state 0 to state "+YYFINAL+"");
      yystate = YYFINAL;         //explicitly say we're done
      state_push(YYFINAL);       //and save it
      val_push(yyval);           //also save the semantic value of parsing
      if (yychar < 0)            //we want another character?
        {
        yychar = yylex();        //get next character
        if (yychar<0) yychar=0;  //clean, if necessary
        if (yydebug)
          yylexdebug(yystate,yychar);
        }
      if (yychar == 0)          //Good exit (if lex returns 0 ;-)
         break;                 //quit the loop--all DONE
      }//if yystate
    else                        //else not done yet
      {                         //get next state and push, for next yydefred[]
      yyn = yygindex[yym];      //find out where to go
      if ((yyn != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn]; //get new state
      else
        yystate = yydgoto[yym]; //else go to new defred
      if (yydebug) debug("after reduction, shifting from state "+state_peek(0)+" to state "+yystate+"");
      state_push(yystate);     //going again, so push state & val...
      val_push(yyval);         //for next action
      }
    }//main loop
  return 0;//yyaccept!!
}
//## end of method parse() ######################################



//## run() --- for Thread #######################################
//## The -Jnorun option was used ##
//## end of method run() ########################################



//## Constructors ###############################################
//## The -Jnoconstruct option was used ##
//###############################################################



}
//################### END OF CLASS ##############################
