/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;

public class ParallelReader
extends IndexReader {
    private List readers = new ArrayList();
    private List decrefOnClose = new ArrayList();
    boolean incRefReaders = false;
    private SortedMap fieldToReader = new TreeMap();
    private Map readerToFields = new HashMap();
    private List storedFieldReaders = new ArrayList();
    private int maxDoc;
    private int numDocs;
    private boolean hasDeletions;

    public ParallelReader() throws IOException {
        this(true);
    }

    public ParallelReader(boolean closeSubReaders) throws IOException {
        this.incRefReaders = !closeSubReaders;
    }

    public void add(IndexReader reader) throws IOException {
        this.ensureOpen();
        this.add(reader, false);
    }

    public void add(IndexReader reader, boolean ignoreStoredFields) throws IOException {
        this.ensureOpen();
        if (this.readers.size() == 0) {
            this.maxDoc = reader.maxDoc();
            this.numDocs = reader.numDocs();
            this.hasDeletions = reader.hasDeletions();
        }
        if (reader.maxDoc() != this.maxDoc) {
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + reader.maxDoc());
        }
        if (reader.numDocs() != this.numDocs) {
            throw new IllegalArgumentException("All readers must have same numDocs: " + this.numDocs + "!=" + reader.numDocs());
        }
        Collection fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
        this.readerToFields.put(reader, fields);
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (this.fieldToReader.get(field) != null) continue;
            this.fieldToReader.put(field, reader);
        }
        if (!ignoreStoredFields) {
            this.storedFieldReaders.add(reader);
        }
        this.readers.add(reader);
        if (this.incRefReaders) {
            reader.incRef();
        }
        this.decrefOnClose.add(this.incRefReaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader reopen() throws CorruptIndexException, IOException {
        ParallelReader parallelReader;
        block20: {
            boolean success;
            ArrayList<Boolean> newDecrefOnClose;
            ArrayList<IndexReader> newReaders;
            boolean reopened;
            block18: {
                ParallelReader parallelReader2;
                block19: {
                    this.ensureOpen();
                    reopened = false;
                    newReaders = new ArrayList<IndexReader>();
                    newDecrefOnClose = new ArrayList<Boolean>();
                    success = false;
                    for (int i = 0; i < this.readers.size(); ++i) {
                        IndexReader oldReader = (IndexReader)this.readers.get(i);
                        IndexReader newReader = oldReader.reopen();
                        newReaders.add(newReader);
                        if (newReader == oldReader) continue;
                        reopened = true;
                    }
                    if (!reopened) break block18;
                    ParallelReader pr = new ParallelReader();
                    for (int i = 0; i < this.readers.size(); ++i) {
                        IndexReader oldReader = (IndexReader)this.readers.get(i);
                        IndexReader newReader = (IndexReader)newReaders.get(i);
                        if (newReader == oldReader) {
                            newDecrefOnClose.add(Boolean.TRUE);
                            newReader.incRef();
                        } else {
                            newDecrefOnClose.add(Boolean.FALSE);
                        }
                        pr.add(newReader, !this.storedFieldReaders.contains(oldReader));
                    }
                    pr.decrefOnClose = newDecrefOnClose;
                    pr.incRefReaders = this.incRefReaders;
                    success = true;
                    parallelReader2 = pr;
                    Object var10_13 = null;
                    if (success || !reopened) break block19;
                    for (int i = 0; i < newReaders.size(); ++i) {
                        IndexReader r = (IndexReader)newReaders.get(i);
                        if (r == null) continue;
                        try {
                            if (((Boolean)newDecrefOnClose.get(i)).booleanValue()) {
                                r.decRef();
                                continue;
                            }
                            r.close();
                            continue;
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                }
                return parallelReader2;
            }
            try {
                success = true;
                parallelReader = this;
                Object var10_14 = null;
                if (success || !reopened) break block20;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (!success && reopened) {
                    for (int i = 0; i < newReaders.size(); ++i) {
                        IndexReader r = (IndexReader)newReaders.get(i);
                        if (r == null) continue;
                        try {
                            if (((Boolean)newDecrefOnClose.get(i)).booleanValue()) {
                                r.decRef();
                                continue;
                            }
                            r.close();
                            continue;
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < newReaders.size(); ++i) {
                IndexReader r = (IndexReader)newReaders.get(i);
                if (r == null) continue;
                try {
                    if (((Boolean)newDecrefOnClose.get(i)).booleanValue()) {
                        r.decRef();
                        continue;
                    }
                    r.close();
                    continue;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
        return parallelReader;
    }

    public int numDocs() {
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    public boolean isDeleted(int n) {
        if (this.readers.size() > 0) {
            return ((IndexReader)this.readers.get(0)).isDeleted(n);
        }
        return false;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).deleteDocument(n);
        }
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).undeleteAll();
        }
        this.hasDeletions = false;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        Document result = new Document();
        for (int i = 0; i < this.storedFieldReaders.size(); ++i) {
            boolean include;
            IndexReader reader = (IndexReader)this.storedFieldReaders.get(i);
            boolean bl = include = fieldSelector == null;
            if (!include) {
                Iterator it = ((Collection)this.readerToFields.get(reader)).iterator();
                while (it.hasNext()) {
                    if (fieldSelector.accept((String)it.next()) == FieldSelectorResult.NO_LOAD) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            Iterator fieldIterator = reader.document(n, fieldSelector).getFields().iterator();
            while (fieldIterator.hasNext()) {
                result.add((Fieldable)fieldIterator.next());
            }
        }
        return result;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        ArrayList<TermFreqVector> results = new ArrayList<TermFreqVector>();
        Iterator i = this.fieldToReader.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String field = (String)e.getKey();
            IndexReader reader = (IndexReader)e.getValue();
            TermFreqVector vector = reader.getTermFreqVector(n, field);
            if (vector == null) continue;
            results.add(vector);
        }
        return results.toArray(new TermFreqVector[results.size()]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getTermFreqVector(n, field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.getTermFreqVector(docNumber, field, mapper);
        }
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        this.ensureOpen();
        Iterator i = this.fieldToReader.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String field = (String)e.getKey();
            IndexReader reader = (IndexReader)e.getValue();
            reader.getTermFreqVector(docNumber, field, mapper);
        }
    }

    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? false : reader.hasNorms(field);
    }

    public byte[] norms(String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.norms(field);
    }

    public void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.norms(field, result, offset);
        }
    }

    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.doSetNorm(n, field, value);
        }
    }

    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum();
    }

    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum(term);
    }

    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(term.field());
        return reader == null ? 0 : reader.docFreq(term);
    }

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs(term);
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs();
    }

    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions(term);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            if (((IndexReader)this.readers.get(i)).isCurrent()) continue;
            return false;
        }
        return true;
    }

    public boolean isOptimized() {
        for (int i = 0; i < this.readers.size(); ++i) {
            if (((IndexReader)this.readers.get(i)).isOptimized()) continue;
            return false;
        }
        return true;
    }

    public long getVersion() {
        throw new UnsupportedOperationException("ParallelReader does not support this method.");
    }

    IndexReader[] getSubReaders() {
        return this.readers.toArray(new IndexReader[this.readers.size()]);
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).commit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            if (((Boolean)this.decrefOnClose.get(i)).booleanValue()) {
                ((IndexReader)this.readers.get(i)).decRef();
                continue;
            }
            ((IndexReader)this.readers.get(i)).close();
        }
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    private class ParallelTermDocs
    implements TermDocs {
        protected TermDocs termDocs;

        public ParallelTermDocs() {
        }

        public ParallelTermDocs(Term term) throws IOException {
            this.seek(term);
        }

        public int doc() {
            return this.termDocs.doc();
        }

        public int freq() {
            return this.termDocs.freq();
        }

        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termDocs(term) : null;
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        public boolean next() throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.next();
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            if (this.termDocs == null) {
                return 0;
            }
            return this.termDocs.read(docs, freqs);
        }

        public boolean skipTo(int target) throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.skipTo(target);
        }

        public void close() throws IOException {
            if (this.termDocs != null) {
                this.termDocs.close();
            }
        }
    }

    private class ParallelTermEnum
    extends TermEnum {
        private String field;
        private Iterator fieldIterator;
        private TermEnum termEnum;

        public ParallelTermEnum() throws IOException {
            this.field = (String)ParallelReader.this.fieldToReader.firstKey();
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
            }
        }

        public ParallelTermEnum(Term term) throws IOException {
            this.field = term.field();
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(this.field);
            if (reader != null) {
                this.termEnum = reader.terms(term);
            }
        }

        public boolean next() throws IOException {
            if (this.termEnum == null) {
                return false;
            }
            if (this.termEnum.next() && this.termEnum.term().field() == this.field) {
                return true;
            }
            this.termEnum.close();
            if (this.fieldIterator == null) {
                this.fieldIterator = ParallelReader.this.fieldToReader.tailMap(this.field).keySet().iterator();
                this.fieldIterator.next();
            }
            while (this.fieldIterator.hasNext()) {
                this.field = (String)this.fieldIterator.next();
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms(new Term(this.field));
                Term term = this.termEnum.term();
                if (term != null && term.field() == this.field) {
                    return true;
                }
                this.termEnum.close();
            }
            return false;
        }

        public Term term() {
            if (this.termEnum == null) {
                return null;
            }
            return this.termEnum.term();
        }

        public int docFreq() {
            if (this.termEnum == null) {
                return 0;
            }
            return this.termEnum.docFreq();
        }

        public void close() throws IOException {
            if (this.termEnum != null) {
                this.termEnum.close();
            }
        }
    }

    private class ParallelTermPositions
    extends ParallelTermDocs
    implements TermPositions {
        public ParallelTermPositions() {
        }

        public ParallelTermPositions(Term term) throws IOException {
            this.seek(term);
        }

        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termPositions(term) : null;
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.termDocs).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.termDocs).getPayloadLength();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.termDocs).getPayload(data, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.termDocs).isPayloadAvailable();
        }
    }
}

