/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import org.apache.solr.common.params.ModifiableSolrParams;

public class SolrQuery
extends ModifiableSolrParams {
    public SolrQuery() {
    }

    public SolrQuery(String q) {
        this();
        this.set("q", new String[]{q});
    }

    public SolrQuery addFacetField(String ... fields) {
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            this.add("facet.field", new String[]{f});
            ++n2;
        }
        this.set("facet", true);
        return this;
    }

    public String[] getFacetFields() {
        return this.getParams("facet.field");
    }

    public boolean removeFacetField(String name) {
        boolean b = this.remove("facet.field", name);
        if (this.get("facet.field") == null && this.get("facet.query") == null) {
            this.setFacet(false);
        }
        return b;
    }

    public SolrQuery setFacet(boolean b) {
        if (b) {
            this.set("facet", true);
        } else {
            this.remove("facet");
            this.remove("facet.mincount");
            this.remove("facet.field");
            this.remove("facet.limit");
            this.remove("facet.missing");
            this.remove("facet.offset");
            this.remove("facet.prefix");
            this.remove("facet.query");
            this.remove("facet.sort");
            this.remove("facet.zeros");
            this.remove("facet.prefix");
        }
        return this;
    }

    public SolrQuery setFacetPrefix(String prefix) {
        this.set("facet.prefix", new String[]{prefix});
        return this;
    }

    public SolrQuery setFacetPrefix(String field, String prefix) {
        this.set("f." + field + "." + "facet.prefix", new String[]{prefix});
        return this;
    }

    public SolrQuery addFacetQuery(String f) {
        this.add("facet.query", new String[]{f});
        return this;
    }

    public String[] getFacetQuery() {
        return this.getParams("facet.query");
    }

    public boolean removeFacetQuery(String q) {
        boolean b = this.remove("facet.query", q);
        if (this.get("facet.field") == null && this.get("facet.query") == null) {
            this.setFacet(false);
        }
        return b;
    }

    public SolrQuery setFacetLimit(int lim) {
        this.set("facet.limit", lim);
        return this;
    }

    public int getFacetLimit() {
        return this.getInt("facet.limit", 25);
    }

    public SolrQuery setFacetMinCount(int cnt) {
        this.set("facet.mincount", cnt);
        return this;
    }

    public int getFacetMinCount() {
        return this.getInt("facet.limit", 1);
    }

    public SolrQuery setMissing(String fld) {
        this.set("facet.missing", new String[]{fld});
        return this;
    }

    public boolean getFacetSort() {
        return this.getBool("facet.sort", true);
    }

    public SolrQuery setFacetSort(Boolean sort) {
        this.set("facet.sort", sort);
        return this;
    }

    public SolrQuery addHighlightField(String f) {
        this.add("hl.fl", new String[]{f});
        this.set("hl", true);
        return this;
    }

    public boolean removeHighlightField(String f) {
        boolean b = this.remove("hl.fl", f);
        if (this.get("hl.fl") == null) {
            this.setHighlight(false);
        }
        return b;
    }

    public String[] getHighlightFields() {
        return this.getParams("hl.fl");
    }

    public SolrQuery setHighlightSnippets(int num) {
        this.set("hl.snippets", num);
        return this;
    }

    public int getHighlightSnippets() {
        return this.getInt("hl.snippets", 1);
    }

    public SolrQuery setHighlightFragsize(int num) {
        this.set("hl.fragsize", num);
        return this;
    }

    public int getHighlightFragsize() {
        return this.getInt("hl.fragsize", 100);
    }

    public SolrQuery setHighlightRequireFieldMatch(boolean flag) {
        this.set("hl.requireFieldMatch", flag);
        return this;
    }

    public boolean setHighlightRequireFieldMatch() {
        return this.getBool("hl.requireFieldMatch", false);
    }

    public SolrQuery setHighlightSimplePre(String f) {
        this.set("hl.simple.pre", new String[]{f});
        return this;
    }

    public String getHighlightSimplePre() {
        return this.get("hl.simple.pre", "");
    }

    public SolrQuery setHighlightSimplePost(String f) {
        this.set("hl.simple.post", new String[]{f});
        return this;
    }

    public String getHighlightSimplePost() {
        return this.get("hl.simple.post", "");
    }

    public SolrQuery setSortField(String field, ORDER order) {
        this.remove("sort");
        this.addValueToParam("sort", this.toSortString(field, order));
        return this;
    }

    public SolrQuery addSortField(String field, ORDER order) {
        return this.addValueToParam("sort", this.toSortString(field, order));
    }

    public SolrQuery removeSortField(String field, ORDER order) {
        String s = this.get("sort");
        String removeSort = this.toSortString(field, order);
        if (s != null) {
            String[] sorts = s.split(",");
            if ((s = this.join(sorts, ", ", removeSort)).length() == 0) {
                s = null;
            }
            this.set("sort", new String[]{s});
        }
        return this;
    }

    public String[] getSortFields() {
        String s = this.getSortField();
        if (s == null) {
            return null;
        }
        return s.split(",");
    }

    public String getSortField() {
        return this.get("sort");
    }

    public SolrQuery setFilterQueries(String ... fq) {
        this.set("fq", fq);
        return this;
    }

    public SolrQuery addFilterQuery(String ... fq) {
        this.add("fq", fq);
        return this;
    }

    public boolean removeFilterQuery(String fq) {
        return this.remove("fq", fq);
    }

    public String[] getFilterQueries() {
        return this.getParams("fq");
    }

    public boolean getHighlight() {
        return this.getBool("hl", false);
    }

    public SolrQuery setHighlight(boolean b) {
        if (b) {
            this.set("hl", true);
        } else {
            this.remove("hl");
            this.remove("hl.requireFieldMatch");
            this.remove("hl.fl");
            this.remove("hl.formatter");
            this.remove("hl.fragsize");
            this.remove("hl.simple.post");
            this.remove("hl.simple.pre");
            this.remove("hl.snippets");
        }
        return this;
    }

    public SolrQuery setFields(String ... fields) {
        if (fields == null || fields.length == 0) {
            this.remove("fl");
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fields[0]);
        int i = 1;
        while (i < fields.length) {
            sb.append(',');
            sb.append(fields[i]);
            ++i;
        }
        this.set("fl", new String[]{sb.toString()});
        return this;
    }

    public SolrQuery addField(String field) {
        return this.addValueToParam("fl", field);
    }

    public String getFields() {
        String fields = this.get("fl");
        if (fields != null && fields.equals("score")) {
            fields = "*, score";
        }
        return fields;
    }

    public SolrQuery setIncludeScore(boolean includeScore) {
        if (includeScore) {
            this.add("fl", new String[]{"score"});
        } else {
            this.remove("fl", "score");
        }
        return this;
    }

    public SolrQuery setQuery(String query) {
        this.set("q", new String[]{query});
        return this;
    }

    public String getQuery() {
        return this.get("q");
    }

    public SolrQuery setRows(Integer rows) {
        if (rows == null) {
            this.remove("rows");
        } else {
            this.set("rows", rows);
        }
        return this;
    }

    public Integer getRows() {
        return this.getInt("rows");
    }

    public void setShowDebugInfo(boolean showDebugInfo) {
        this.set("debugQuery", new String[]{String.valueOf(showDebugInfo)});
    }

    public SolrQuery setStart(Integer start) {
        if (start == null) {
            this.remove("start");
        } else {
            this.set("start", start);
        }
        return this;
    }

    public Integer getStart() {
        return this.getInt("start");
    }

    public SolrQuery setQueryType(String qt) {
        this.set("qt", new String[]{qt});
        return this;
    }

    public String getQueryType() {
        return this.get("qt");
    }

    public SolrQuery setParam(String name, String ... values) {
        this.set(name, values);
        return this;
    }

    public SolrQuery setParam(String name, boolean value) {
        this.set(name, value);
        return this;
    }

    public SolrQuery getCopy() {
        SolrQuery q = new SolrQuery();
        for (String name : this.getParameterNames()) {
            q.setParam(name, this.getParams(name));
        }
        return q;
    }

    public SolrQuery setTimeAllowed(Integer milliseconds) {
        if (milliseconds == null) {
            this.remove("timeAllowed");
        } else {
            this.set("timeAllowed", milliseconds);
        }
        return this;
    }

    public Integer getTimeAllowed() {
        return this.getInt("timeAllowed");
    }

    private String toSortString(String field, ORDER order) {
        return String.valueOf(field.trim()) + ' ' + String.valueOf((Object)order).trim();
    }

    private String join(String a, String b, String sep) {
        StringBuilder sb = new StringBuilder();
        if (a != null && a.length() > 0) {
            sb.append(a);
            sb.append(sep);
        }
        if (b != null && b.length() > 0) {
            sb.append(b);
        }
        return sb.toString().trim();
    }

    private SolrQuery addValueToParam(String name, String value) {
        String tmp = this.get(name);
        tmp = this.join(tmp, value, ",");
        this.set(name, new String[]{tmp});
        return this;
    }

    private String join(String[] vals, String sep, String removeVal) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < vals.length) {
            if (removeVal == null || !vals[i].equals(removeVal)) {
                sb.append(vals[i]);
                if (i < vals.length - 1) {
                    sb.append(sep);
                }
            }
            ++i;
        }
        return sb.toString().trim();
    }

    public static enum ORDER {
        desc,
        asc;


        public ORDER reverse() {
            return this == asc ? desc : asc;
        }
    }
}

