/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.util.xslt.TransformerProvider;

public class XSLTResponseWriter
implements QueryResponseWriter {
    public static final String DEFAULT_CONTENT_TYPE = "text/xml";
    public static final String TRANSFORM_PARAM = "tr";
    public static final String CONTEXT_TRANSFORMER_KEY = "xsltwriter.transformer";
    private Integer xsltCacheLifetimeSeconds = null;
    public static final int XSLT_CACHE_DEFAULT = 60;
    private static final String XSLT_CACHE_PARAM = "xsltCacheLifetimeSeconds";
    private static final Logger log = Logger.getLogger(XSLTResponseWriter.class.getName());

    public void init(NamedList n) {
        SolrParams p = SolrParams.toSolrParams((NamedList)n);
        this.xsltCacheLifetimeSeconds = p.getInt(XSLT_CACHE_PARAM, 60);
        log.info("xsltCacheLifetimeSeconds=" + this.xsltCacheLifetimeSeconds);
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        Transformer t = null;
        try {
            t = this.getTransformer(request);
        }
        catch (Exception e) {
            throw new RuntimeException("getTransformer fails in getContentType", e);
        }
        String mediaTypeFromXslt = t.getOutputProperty("media-type");
        if (mediaTypeFromXslt == null || mediaTypeFromXslt.length() == 0) {
            return DEFAULT_CONTENT_TYPE;
        }
        return mediaTypeFromXslt;
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        Transformer t = this.getTransformer(request);
        CharArrayWriter w = new CharArrayWriter();
        XMLWriter.writeResponse(w, request, response);
        BufferedReader r = new BufferedReader(new CharArrayReader(w.toCharArray()));
        StreamSource source = new StreamSource(r);
        StreamResult result = new StreamResult(writer);
        try {
            t.transform(source, result);
        }
        catch (TransformerException te) {
            IOException ioe = new IOException("XSLT transformation error");
            ioe.initCause(te);
            throw ioe;
        }
    }

    protected Transformer getTransformer(SolrQueryRequest request) throws IOException {
        String xslt = request.getParams().get(TRANSFORM_PARAM, null);
        if (xslt == null) {
            throw new IOException("'tr' request parameter is required to use the XSLTResponseWriter");
        }
        SolrConfig solrConfig = request.getSearcher().getSchema().getSolrConfig();
        Map<Object, Object> ctx = request.getContext();
        Transformer result = (Transformer)ctx.get(CONTEXT_TRANSFORMER_KEY);
        if (result == null) {
            result = TransformerProvider.instance.getTransformer(solrConfig, xslt, this.xsltCacheLifetimeSeconds);
            ctx.put(CONTEXT_TRANSFORMER_KEY, result);
        }
        return result;
    }
}

