/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Similarity;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexSchema {
    public static final String DEFAULT_SCHEMA_FILE = "schema.xml";
    static final Logger log = Logger.getLogger(IndexSchema.class.getName());
    private final SolrConfig solrConfig;
    private final String resourceName;
    private String name;
    private float version;
    private final HashMap<String, SchemaField> fields = new HashMap();
    private final HashMap<String, FieldType> fieldTypes = new HashMap();
    private final List<SchemaField> fieldsWithDefaultValue = new ArrayList<SchemaField>();
    private final Collection<SchemaField> requiredFields = new HashSet<SchemaField>();
    private SimilarityFactory similarityFactory;
    private Analyzer analyzer;
    private Analyzer queryAnalyzer;
    private String defaultSearchFieldName = null;
    private String queryParserDefaultOperator = "OR";
    private SchemaField uniqueKeyField;
    private String uniqueKeyFieldName;
    private FieldType uniqueKeyFieldType;
    private DynamicField[] dynamicFields;
    private final Map<String, SchemaField[]> copyFields = new HashMap<String, SchemaField[]>();
    private DynamicCopy[] dynamicCopyFields;
    private Map<SchemaField, Integer> copyFieldTargetCounts = new HashMap<SchemaField, Integer>();

    @Deprecated
    public IndexSchema(SolrConfig solrConfig, String name) {
        this(solrConfig, name, null);
    }

    public IndexSchema(SolrConfig solrConfig, String name, InputStream is) {
        this.solrConfig = solrConfig;
        if (name == null) {
            name = DEFAULT_SCHEMA_FILE;
        }
        this.resourceName = name;
        SolrResourceLoader loader = solrConfig.getResourceLoader();
        InputStream lis = is;
        if (lis == null) {
            lis = loader.openSchema(name);
        }
        this.readSchema(lis);
        if (lis != is) {
            try {
                lis.close();
            }
            catch (IOException xio) {
                // empty catch block
            }
        }
        loader.inform(loader);
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getSchemaName() {
        return this.name;
    }

    float getVersion() {
        return this.version;
    }

    @Deprecated
    public InputStream getInputStream() {
        return this.solrConfig.getResourceLoader().openResource(this.resourceName);
    }

    @Deprecated
    public String getSchemaFile() {
        return this.resourceName;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public Map<String, SchemaField> getFields() {
        return this.fields;
    }

    public Map<String, FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SchemaField> getFieldsWithDefaultValue() {
        return this.fieldsWithDefaultValue;
    }

    public Collection<SchemaField> getRequiredFields() {
        return this.requiredFields;
    }

    public Similarity getSimilarity() {
        return this.similarityFactory.getSimilarity();
    }

    public SimilarityFactory getSimilarityFactory() {
        return this.similarityFactory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public SolrQueryParser getSolrQueryParser(String defaultField) {
        SolrQueryParser qp = new SolrQueryParser(this, defaultField);
        String operator = this.getQueryParserDefaultOperator();
        qp.setDefaultOperator("AND".equals(operator) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
        return qp;
    }

    @Deprecated
    public String getDefaultSearchFieldName() {
        return this.defaultSearchFieldName;
    }

    @Deprecated
    public String getQueryParserDefaultOperator() {
        return this.queryParserDefaultOperator;
    }

    public SchemaField getUniqueKeyField() {
        return this.uniqueKeyField;
    }

    public Fieldable getUniqueKeyField(org.apache.lucene.document.Document doc) {
        return doc.getFieldable(this.uniqueKeyFieldName);
    }

    public String printableUniqueKey(org.apache.lucene.document.Document doc) {
        Fieldable f = doc.getFieldable(this.uniqueKeyFieldName);
        return f == null ? null : this.uniqueKeyFieldType.toExternal(f);
    }

    private SchemaField getIndexedField(String fname) {
        SchemaField f = this.getFields().get(fname);
        if (f == null) {
            throw new RuntimeException("unknown field '" + fname + "'");
        }
        if (!f.indexed()) {
            throw new RuntimeException("'" + fname + "' is not an indexed field:" + f);
        }
        return f;
    }

    public void refreshAnalyzers() {
        this.analyzer = new SolrIndexAnalyzer();
        this.queryAnalyzer = new SolrQueryAnalyzer();
    }

    private void readSchema(InputStream is) {
        log.info("Reading Solr Schema");
        try {
            NamedNodeMap attrs;
            Config schemaConf = new Config(this.solrConfig.getResourceLoader(), "schema", is, "/schema/");
            Document document = schemaConf.getDocument();
            final XPath xpath = schemaConf.getXPath();
            Node nd = (Node)xpath.evaluate("/schema/@name", document, XPathConstants.NODE);
            if (nd == null) {
                log.warning("schema has no name!");
            } else {
                this.name = nd.getNodeValue();
                log.info("Schema name=" + this.name);
            }
            this.version = schemaConf.getFloat("/schema/@version", 1.0f);
            final IndexSchema schema = this;
            AbstractPluginLoader<FieldType> loader = new AbstractPluginLoader<FieldType>("[schema.xml] fieldType", true, true){

                @Override
                protected FieldType create(ResourceLoader loader, String name, String className, Node node) throws Exception {
                    FieldType ft = (FieldType)loader.newInstance(className, new String[0]);
                    ft.setTypeName(name);
                    String expression = "./analyzer[@type='query']";
                    Node anode = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
                    Analyzer queryAnalyzer = IndexSchema.this.readAnalyzer(anode);
                    expression = "./analyzer[not(@type)] | ./analyzer[@type='index']";
                    anode = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
                    Analyzer analyzer = IndexSchema.this.readAnalyzer(anode);
                    if (queryAnalyzer == null) {
                        queryAnalyzer = analyzer;
                    }
                    if (analyzer == null) {
                        analyzer = queryAnalyzer;
                    }
                    if (analyzer != null) {
                        ft.setAnalyzer(analyzer);
                        ft.setQueryAnalyzer(queryAnalyzer);
                    }
                    return ft;
                }

                @Override
                protected void init(FieldType plugin, Node node) throws Exception {
                    Map params = DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"name", "class"});
                    plugin.setArgs(schema, params);
                }

                @Override
                protected FieldType register(String name, FieldType plugin) throws Exception {
                    log.finest("fieldtype defined: " + plugin);
                    return IndexSchema.this.fieldTypes.put(name, plugin);
                }
            };
            String expression = "/schema/types/fieldtype | /schema/types/fieldType";
            NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            loader.load(this.solrConfig.getResourceLoader(), nodes);
            HashMap<String, Boolean> explicitRequiredProp = new HashMap<String, Boolean>();
            ArrayList<DynamicField> dFields = new ArrayList<DynamicField>();
            expression = "/schema/fields/field | /schema/fields/dynamicField";
            nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                attrs = node.getAttributes();
                String name = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"name", (String)"field definition");
                log.finest("reading field def " + name);
                String type = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"type", (String)("field " + name));
                FieldType ft = this.fieldTypes.get(type);
                if (ft == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fieldtype '" + type + "' specified on field " + name, false);
                }
                Map args = DOMUtil.toMapExcept((NamedNodeMap)attrs, (String[])new String[]{"name", "type"});
                if (args.get("required") != null) {
                    explicitRequiredProp.put(name, Boolean.valueOf((String)args.get("required")));
                }
                SchemaField f = SchemaField.create(name, ft, args);
                if (node.getNodeName().equals("field")) {
                    SchemaField old = this.fields.put(f.getName(), f);
                    if (old != null) {
                        String msg = "[schema.xml] Duplicate field definition for '" + f.getName() + "' ignoring: " + old.toString();
                        SolrException t = new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                        SolrException.logOnce((Logger)log, null, (Throwable)t);
                        SolrConfig.severeErrors.add(t);
                    }
                    log.fine("field defined: " + f);
                    if (f.getDefaultValue() != null) {
                        log.fine(name + " contains default value: " + f.getDefaultValue());
                        this.fieldsWithDefaultValue.add(f);
                    }
                    if (!f.isRequired()) continue;
                    log.fine(name + " is required in this schema");
                    this.requiredFields.add(f);
                    continue;
                }
                if (node.getNodeName().equals("dynamicField")) {
                    boolean dup = false;
                    for (DynamicField df : dFields) {
                        if (!df.regex.equals(f.name)) continue;
                        String msg = "[schema.xml] Duplicate DynamicField definition for '" + f.getName() + "' ignoring: " + f.toString();
                        SolrException t = new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                        SolrException.logOnce((Logger)log, null, (Throwable)t);
                        SolrConfig.severeErrors.add(t);
                        dup = true;
                        break;
                    }
                    if (dup) continue;
                    dFields.add(new DynamicField(f));
                    log.fine("dynamic field defined: " + f);
                    continue;
                }
                throw new RuntimeException("Unknown field type");
            }
            this.requiredFields.addAll(this.getFieldsWithDefaultValue());
            Collections.sort(dFields);
            log.finest("Dynamic Field Ordering:" + dFields);
            this.dynamicFields = dFields.toArray(new DynamicField[dFields.size()]);
            Node node = (Node)xpath.evaluate("/schema/similarity", document, XPathConstants.NODE);
            if (node == null) {
                this.similarityFactory = new SimilarityFactory(){

                    public Similarity getSimilarity() {
                        return Similarity.getDefault();
                    }
                };
                log.fine("using default similarity");
            } else {
                final Object obj = this.solrConfig.getResourceLoader().newInstance(((Element)node).getAttribute("class"), new String[0]);
                if (obj instanceof SimilarityFactory) {
                    SolrParams params = SolrParams.toSolrParams((NamedList)DOMUtil.childNodesToNamedList((Node)node));
                    this.similarityFactory = (SimilarityFactory)obj;
                    this.similarityFactory.init(params);
                } else {
                    this.similarityFactory = new SimilarityFactory(){

                        public Similarity getSimilarity() {
                            return (Similarity)obj;
                        }
                    };
                }
                log.fine("using similarity factory" + this.similarityFactory.getClass().getName());
            }
            node = (Node)xpath.evaluate("/schema/defaultSearchField/text()", document, XPathConstants.NODE);
            if (node == null) {
                log.warning("no default search field specified in schema.");
            } else {
                SchemaField defaultSearchField;
                this.defaultSearchFieldName = node.getNodeValue().trim();
                if (!(this.defaultSearchFieldName == null || (defaultSearchField = this.getFields().get(this.defaultSearchFieldName)) != null && defaultSearchField.indexed())) {
                    String msg = "default search field '" + this.defaultSearchFieldName + "' not defined or not indexed";
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                log.info("default search field is " + this.defaultSearchFieldName);
            }
            node = (Node)xpath.evaluate("/schema/solrQueryParser/@defaultOperator", document, XPathConstants.NODE);
            if (node == null) {
                log.fine("using default query parser operator (OR)");
            } else {
                this.queryParserDefaultOperator = node.getNodeValue().trim();
                log.info("query parser default operator is " + this.queryParserDefaultOperator);
            }
            node = (Node)xpath.evaluate("/schema/uniqueKey/text()", document, XPathConstants.NODE);
            if (node == null) {
                log.warning("no uniqueKey specified in schema.");
            } else {
                this.uniqueKeyField = this.getIndexedField(node.getNodeValue().trim());
                this.uniqueKeyFieldName = this.uniqueKeyField.getName();
                this.uniqueKeyFieldType = this.uniqueKeyField.getType();
                log.info("unique key field: " + this.uniqueKeyFieldName);
                if (Boolean.FALSE != explicitRequiredProp.get(this.uniqueKeyFieldName)) {
                    this.uniqueKeyField.required = true;
                    this.requiredFields.add(this.uniqueKeyField);
                }
            }
            this.dynamicCopyFields = new DynamicCopy[0];
            expression = "//copyField";
            nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                attrs = node.getAttributes();
                String source = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"source", (String)"copyField definition");
                String dest = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"dest", (String)"copyField definition");
                this.registerCopyField(source, dest);
            }
            for (Map.Entry<SchemaField, Integer> entry : this.copyFieldTargetCounts.entrySet()) {
                if (entry.getValue() <= 1 || entry.getKey().multiValued()) continue;
                log.warning("Field " + entry.getKey().name + " is not multivalued " + "and destination for multiple copyFields (" + entry.getValue() + ")");
            }
        }
        catch (SolrException e) {
            SolrConfig.severeErrors.add(e);
            throw e;
        }
        catch (Exception e) {
            SolrConfig.severeErrors.add(e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Schema Parsing Failed", (Throwable)e, false);
        }
        this.refreshAnalyzers();
    }

    public void registerCopyField(String source, String dest) {
        boolean sourceIsPattern = IndexSchema.isWildCard(source);
        boolean destIsPattern = IndexSchema.isWildCard(dest);
        log.fine("copyField source='" + source + "' dest='" + dest + "'");
        SchemaField d = this.getField(dest);
        if (sourceIsPattern) {
            if (destIsPattern) {
                DynamicField df = null;
                for (DynamicField dd : this.dynamicFields) {
                    if (!dd.regex.equals(dest)) continue;
                    df = dd;
                    break;
                }
                if (df == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "copyField dynamic destination must match a dynamicField.");
                }
                this.registerDynamicCopyField(new DynamicDestCopy(source, df));
            } else {
                this.registerDynamicCopyField(new DynamicCopy(source, d));
            }
        } else {
            if (destIsPattern) {
                String msg = "copyField only supports a dynamic destination if the source is also dynamic";
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            SchemaField f = this.getField(source);
            Object[] destArr = this.copyFields.get(source);
            destArr = destArr == null ? new SchemaField[]{d} : (SchemaField[])IndexSchema.append(destArr, d);
            this.copyFields.put(source, (SchemaField[])destArr);
            this.copyFieldTargetCounts.put(d, this.copyFieldTargetCounts.containsKey(d) ? this.copyFieldTargetCounts.get(d) + 1 : 1);
        }
    }

    private void registerDynamicCopyField(DynamicCopy dcopy) {
        if (this.dynamicCopyFields == null) {
            this.dynamicCopyFields = new DynamicCopy[]{dcopy};
        } else {
            DynamicCopy[] temp = new DynamicCopy[this.dynamicCopyFields.length + 1];
            System.arraycopy(this.dynamicCopyFields, 0, temp, 0, this.dynamicCopyFields.length);
            temp[temp.length - 1] = dcopy;
            this.dynamicCopyFields = temp;
        }
        log.finest("Dynamic Copy Field:" + dcopy);
    }

    private static Object[] append(Object[] orig, Object item) {
        Object[] newArr = (Object[])Array.newInstance(orig.getClass().getComponentType(), orig.length + 1);
        System.arraycopy(orig, 0, newArr, 0, orig.length);
        newArr[orig.length] = item;
        return newArr;
    }

    private Analyzer readAnalyzer(Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        String analyzerName = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"class");
        if (analyzerName != null) {
            return (Analyzer)this.solrConfig.getResourceLoader().newInstance(analyzerName, new String[0]);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        final ArrayList tokenizers = new ArrayList(1);
        AbstractPluginLoader<TokenizerFactory> tokenizerLoader = new AbstractPluginLoader<TokenizerFactory>("[schema.xml] analyzer/tokenizer", false, false){

            @Override
            protected void init(TokenizerFactory plugin, Node node) throws Exception {
                if (!tokenizers.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The schema defines multiple tokenizers for: " + node);
                }
                plugin.init(DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"class"}));
                tokenizers.add(plugin);
            }

            @Override
            protected TokenizerFactory register(String name, TokenizerFactory plugin) throws Exception {
                return null;
            }
        };
        tokenizerLoader.load(this.solrConfig.getResourceLoader(), (NodeList)xpath.evaluate("./tokenizer", node, XPathConstants.NODESET));
        if (tokenizers.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "analyzer without class or tokenizer & filter list");
        }
        final ArrayList filters = new ArrayList();
        AbstractPluginLoader<TokenFilterFactory> filterLoader = new AbstractPluginLoader<TokenFilterFactory>("[schema.xml] analyzer/filter", false, false){

            @Override
            protected void init(TokenFilterFactory plugin, Node node) throws Exception {
                if (plugin != null) {
                    plugin.init(DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"class"}));
                    filters.add(plugin);
                }
            }

            @Override
            protected TokenFilterFactory register(String name, TokenFilterFactory plugin) throws Exception {
                return null;
            }
        };
        filterLoader.load(this.solrConfig.getResourceLoader(), (NodeList)xpath.evaluate("./filter", node, XPathConstants.NODESET));
        return new TokenizerChain((TokenizerFactory)tokenizers.get(0), filters.toArray(new TokenFilterFactory[filters.size()]));
    }

    public SchemaField[] getDynamicFieldPrototypes() {
        SchemaField[] df = new SchemaField[this.dynamicFields.length];
        for (int i = 0; i < this.dynamicFields.length; ++i) {
            df[i] = this.dynamicFields[i].prototype;
        }
        return df;
    }

    public String getDynamicPattern(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.regex;
        }
        return null;
    }

    public boolean hasExplicitField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return true;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return true;
        }
        return false;
    }

    public SchemaField getFieldOrNull(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.makeSchemaField(fieldName);
        }
        return f;
    }

    public SchemaField getField(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.makeSchemaField(fieldName);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field " + fieldName);
    }

    public FieldType getFieldType(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.getDynamicFieldType(fieldName);
    }

    public FieldType getFieldTypeNoEx(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.dynFieldType(fieldName);
    }

    public FieldType getDynamicFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field " + fieldName);
    }

    private FieldType dynFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        return null;
    }

    public SchemaField[] getCopySources(String destField) {
        SchemaField f = this.getField(destField);
        if (!this.isCopyFieldTarget(f)) {
            return new SchemaField[0];
        }
        ArrayList<SchemaField> sf = new ArrayList<SchemaField>();
        for (Map.Entry<String, SchemaField[]> cfs : this.copyFields.entrySet()) {
            for (SchemaField cf : cfs.getValue()) {
                if (!cf.getName().equals(destField)) continue;
                sf.add(this.getField(cfs.getKey()));
            }
        }
        return sf.toArray(new SchemaField[1]);
    }

    public SchemaField[] getCopyFields(String sourceField) {
        ArrayList<SchemaField> matchCopyFields = new ArrayList<SchemaField>();
        for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
            if (!dynamicCopy.matches(sourceField)) continue;
            matchCopyFields.add(dynamicCopy.getTargetField(sourceField));
        }
        SchemaField[] fixedCopyFields = this.copyFields.get(sourceField);
        boolean appendFixed = this.copyFields.containsKey(sourceField);
        SchemaField[] results = new SchemaField[matchCopyFields.size() + (appendFixed ? fixedCopyFields.length : 0)];
        matchCopyFields.toArray(results);
        if (appendFixed) {
            System.arraycopy(fixedCopyFields, 0, results, matchCopyFields.size(), fixedCopyFields.length);
        }
        return results;
    }

    public boolean isCopyFieldTarget(SchemaField f) {
        return this.copyFieldTargetCounts.containsKey(f);
    }

    private static boolean isWildCard(String name) {
        return name.startsWith("*") || name.endsWith("*");
    }

    static class DynamicCopy
    extends DynamicReplacement {
        final SchemaField targetField;

        DynamicCopy(String regex, SchemaField targetField) {
            super(regex);
            this.targetField = targetField;
        }

        public SchemaField getTargetField(String sourceField) {
            return this.targetField;
        }

        public String toString() {
            return this.targetField.toString();
        }
    }

    static class DynamicDestCopy
    extends DynamicCopy {
        final DynamicField dynamic;
        final int dtype;
        final String dstr;

        DynamicDestCopy(String source, DynamicField dynamic) {
            super(source, dynamic.prototype);
            this.dynamic = dynamic;
            String dest = dynamic.regex;
            if (dest.startsWith("*")) {
                this.dtype = 2;
                this.dstr = dest.substring(1);
            } else if (dest.endsWith("*")) {
                this.dtype = 1;
                this.dstr = dest.substring(0, dest.length() - 1);
            } else {
                throw new RuntimeException("dynamic copyField destination name must start or end with *");
            }
        }

        public SchemaField getTargetField(String sourceField) {
            String dyn = this.type == 1 ? sourceField.substring(this.str.length()) : sourceField.substring(0, sourceField.length() - this.str.length());
            String name = this.dtype == 1 ? this.dstr + dyn : dyn + this.dstr;
            return this.dynamic.makeSchemaField(name);
        }

        public String toString() {
            return this.targetField.toString();
        }
    }

    static final class DynamicField
    extends DynamicReplacement {
        final SchemaField prototype;

        DynamicField(SchemaField prototype) {
            super(prototype.name);
            this.prototype = prototype;
        }

        SchemaField makeSchemaField(String name) {
            return new SchemaField(this.prototype, name);
        }

        public String toString() {
            return this.prototype.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DynamicReplacement
    implements Comparable<DynamicReplacement> {
        static final int STARTS_WITH = 1;
        static final int ENDS_WITH = 2;
        final String regex;
        final int type;
        final String str;

        protected DynamicReplacement(String regex) {
            this.regex = regex;
            if (regex.startsWith("*")) {
                this.type = 2;
                this.str = regex.substring(1);
            } else if (regex.endsWith("*")) {
                this.type = 1;
                this.str = regex.substring(0, regex.length() - 1);
            } else {
                throw new RuntimeException("dynamic field name must start or end with *");
            }
        }

        public boolean matches(String name) {
            if (this.type == 1 && name.startsWith(this.str)) {
                return true;
            }
            return this.type == 2 && name.endsWith(this.str);
        }

        @Override
        public int compareTo(DynamicReplacement other) {
            return other.regex.length() - this.regex.length();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SolrIndexAnalyzer
    extends Analyzer {
        protected final HashMap<String, Analyzer> analyzers = this.analyzerCache();

        SolrIndexAnalyzer() {
        }

        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        protected Analyzer getAnalyzer(String fieldName) {
            Analyzer analyzer = this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getAnalyzer();
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
        }

        public int getPositionIncrementGap(String fieldName) {
            return this.getAnalyzer(fieldName).getPositionIncrementGap(fieldName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SolrQueryAnalyzer
    extends SolrIndexAnalyzer {
        private SolrQueryAnalyzer() {
        }

        @Override
        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getQueryAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        @Override
        protected Analyzer getAnalyzer(String fieldName) {
            Analyzer analyzer = (Analyzer)this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getQueryAnalyzer();
        }
    }
}

