/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class BoostedQuery
extends Query {
    private Query q;
    private ValueSource boostVal;

    public BoostedQuery(Query subQuery, ValueSource boostVal) {
        this.q = subQuery;
        this.boostVal = boostVal;
    }

    public Query getQuery() {
        return this.q;
    }

    public ValueSource getValueSource() {
        return this.boostVal;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.q.rewrite(reader);
        if (newQ == this.q) {
            return this;
        }
        BoostedQuery bq = (BoostedQuery)((Object)this.clone());
        bq.q = newQ;
        return bq;
    }

    public void extractTerms(Set terms) {
        this.q.extractTerms(terms);
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new BoostedWeight(searcher);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("boost(").append(this.q.toString(field)).append(',').append(this.boostVal).append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BoostedQuery other = (BoostedQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.q.equals(other.q) && this.boostVal.equals(other.boostVal);
    }

    public int hashCode() {
        int h = this.q.hashCode();
        h ^= h << 17 | h >>> 16;
        h += this.boostVal.hashCode();
        h ^= h << 8 | h >>> 25;
        return h += Float.floatToIntBits(this.getBoost());
    }

    private class BoostedWeight
    implements Weight {
        Searcher searcher;
        Weight qWeight;

        public BoostedWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            this.qWeight = BoostedQuery.this.q.weight(searcher);
        }

        public Query getQuery() {
            return BoostedQuery.this;
        }

        public float getValue() {
            return BoostedQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum = this.qWeight.sumOfSquaredWeights();
            return sum *= BoostedQuery.this.getBoost() * BoostedQuery.this.getBoost();
        }

        public void normalize(float norm) {
            this.qWeight.normalize(norm *= BoostedQuery.this.getBoost());
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer subQueryScorer = this.qWeight.scorer(reader);
            return new CustomScorer(BoostedQuery.this.getSimilarity(this.searcher), reader, this, subQueryScorer, BoostedQuery.this.boostVal);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.scorer(reader).explain(doc);
        }
    }

    private class CustomScorer
    extends Scorer {
        private final BoostedWeight weight;
        private final float qWeight;
        private final Scorer scorer;
        private final DocValues vals;
        private final IndexReader reader;

        private CustomScorer(Similarity similarity, IndexReader reader, BoostedWeight w, Scorer scorer, ValueSource vs) throws IOException {
            super(similarity);
            this.weight = w;
            this.qWeight = w.getValue();
            this.scorer = scorer;
            this.reader = reader;
            this.vals = vs.getValues(reader);
        }

        public boolean next() throws IOException {
            return this.scorer.next();
        }

        public int doc() {
            return this.scorer.doc();
        }

        public float score() throws IOException {
            return this.qWeight * this.scorer.score() * this.vals.floatVal(this.scorer.doc());
        }

        public boolean skipTo(int target) throws IOException {
            return this.scorer.skipTo(target);
        }

        public Explanation explain(int doc) throws IOException {
            Explanation subQueryExpl = this.weight.qWeight.explain(this.reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            float sc = subQueryExpl.getValue() * this.vals.floatVal(doc);
            ComplexExplanation res = new ComplexExplanation(true, sc, BoostedQuery.this.toString() + ", product of:");
            res.addDetail(subQueryExpl);
            res.addDetail(this.vals.explain(doc));
            return res;
        }
    }
}

