/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ExtendedFieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;

public class DoubleFieldSource
extends FieldCacheSource {
    protected ExtendedFieldCache.DoubleParser parser;

    public DoubleFieldSource(String field) {
        this(field, null);
    }

    public DoubleFieldSource(String field, ExtendedFieldCache.DoubleParser parser) {
        super(field);
        this.parser = parser;
    }

    public String description() {
        return "double(" + this.field + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final double[] arr = this.parser == null ? ((ExtendedFieldCache)this.cache).getDoubles(reader, this.field) : ((ExtendedFieldCache)this.cache).getDoubles(reader, this.field, this.parser);
        return new DocValues(){

            public float floatVal(int doc) {
                return (float)arr[doc];
            }

            public int intVal(int doc) {
                return (int)arr[doc];
            }

            public long longVal(int doc) {
                return (long)arr[doc];
            }

            public double doubleVal(int doc) {
                return arr[doc];
            }

            public String strVal(int doc) {
                return Double.toString(arr[doc]);
            }

            public String toString(int doc) {
                return DoubleFieldSource.this.description() + '=' + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != DoubleFieldSource.class) {
            return false;
        }
        DoubleFieldSource other = (DoubleFieldSource)o;
        return super.equals(other) && this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    public int hashCode() {
        int h = this.parser == null ? Float.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

