/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.html.Block;
import org.mortbay.html.Break;
import org.mortbay.html.Composite;
import org.mortbay.html.Element;
import org.mortbay.html.Font;
import org.mortbay.html.Form;
import org.mortbay.html.Heading;
import org.mortbay.html.Input;
import org.mortbay.html.Link;
import org.mortbay.html.Page;
import org.mortbay.html.Target;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Container;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class AdminServlet
extends HttpServlet {
    static Log log = LogFactory.getLog(AdminServlet.class);
    private Collection _servers;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._servers = HttpServer.getHttpServers();
    }

    private String doAction(HttpServletRequest request) throws IOException {
        String action = request.getParameter("A");
        if ("exit all servers".equalsIgnoreCase(action)) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        LogSupport.ignore(log, e);
                    }
                    log.info((Object)"Stopping All servers");
                    Iterator s = AdminServlet.this._servers.iterator();
                    while (s.hasNext()) {
                        HttpServer server = (HttpServer)s.next();
                        try {
                            server.stop();
                        }
                        catch (Exception e) {
                            LogSupport.ignore(log, e);
                        }
                    }
                    log.info((Object)"Exiting JVM");
                    System.exit(1);
                }
            }).start();
            throw new HttpException(503);
        }
        boolean start = "start".equalsIgnoreCase(action);
        String id = request.getParameter("ID");
        StringTokenizer tok = new StringTokenizer(id, ":");
        int tokens = tok.countTokens();
        String target = null;
        try {
            target = tok.nextToken();
            int t = Integer.parseInt(target);
            Iterator s = this._servers.iterator();
            Container server = null;
            while (s.hasNext() && t >= 0) {
                if (t-- == 0) {
                    server = (HttpServer)s.next();
                    continue;
                }
                s.next();
            }
            if (tokens == 1) {
                if (start) {
                    server.start();
                } else {
                    server.stop();
                }
            } else if (tokens == 3) {
                String l = tok.nextToken() + ":" + tok.nextToken();
                HttpListener[] listeners = ((HttpServer)server).getListeners();
                for (int i2 = 0; i2 < listeners.length; ++i2) {
                    HttpListener listener = listeners[i2];
                    if (listener.toString().indexOf(l) < 0) continue;
                    if (start) {
                        listener.start();
                        continue;
                    }
                    listener.stop();
                }
            } else {
                String host = tok.nextToken();
                if ("null".equals(host)) {
                    host = null;
                }
                String contextPath = tok.nextToken();
                target = target + ":" + host + ":" + contextPath;
                if (contextPath.length() > 1) {
                    contextPath = contextPath + "/*";
                }
                int contextIndex = Integer.parseInt(tok.nextToken());
                target = target + ":" + contextIndex;
                HttpContext context = ((HttpServer)server).getContext(host, contextPath, contextIndex);
                if (tokens == 4) {
                    if (start) {
                        context.start();
                    } else {
                        context.stop();
                    }
                } else if (tokens == 5) {
                    int handlerIndex = Integer.parseInt(tok.nextToken());
                    HttpHandler handler = context.getHandlers()[handlerIndex];
                    if (start) {
                        handler.start();
                    } else {
                        handler.stop();
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        catch (Error e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        return target;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getQueryString() != null && request.getQueryString().length() > 0) {
            String target = this.doAction(request);
            response.sendRedirect(request.getContextPath() + request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "") + (target != null ? "#" + target : ""));
            return;
        }
        Page page = new Page();
        page.title(this.getServletInfo());
        page.addHeader("");
        page.attribute("text", "#000000");
        page.attribute("bgcolor", "#FFFFFF");
        page.attribute("link", "#606CC0");
        page.attribute("vlink", "#606CC0");
        page.attribute("alink", "#606CC0");
        page.add(new Block("b").add(new Font(3, true).add(this.getServletInfo())));
        page.add(Break.rule);
        Form form = new Form(request.getContextPath() + request.getServletPath() + "?A=exit");
        form.method("GET");
        form.add(new Input("submit", "A", "Exit All Servers"));
        page.add(form);
        page.add(Break.rule);
        page.add(new Heading(3, (Object)"Components:"));
        org.mortbay.html.List sList = new org.mortbay.html.List("ol");
        page.add(sList);
        int i1 = 0;
        Iterator s = this._servers.iterator();
        while (s.hasNext()) {
            String id1 = "" + i1++;
            HttpServer server = (HttpServer)s.next();
            Composite sItem = sList.newItem();
            sItem.add("<B>HttpServer&nbsp;");
            sItem.add(this.lifeCycle(request, id1, server));
            sItem.add("</B>");
            sItem.add(Break.line);
            sItem.add("<B>Listeners:</B>");
            org.mortbay.html.List lList = new org.mortbay.html.List("ul");
            sItem.add(lList);
            HttpListener[] listeners = server.getListeners();
            for (int i2 = 0; i2 < listeners.length; ++i2) {
                HttpListener listener = listeners[i2];
                String id2 = id1 + ":" + listener;
                lList.add(this.lifeCycle(request, id2, listener));
            }
            Map hostMap = server.getHostMap();
            sItem.add("<B>Contexts:</B>");
            org.mortbay.html.List hcList = new org.mortbay.html.List("ul");
            sItem.add(hcList);
            Iterator i2 = hostMap.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry hEntry = i2.next();
                String host = (String)hEntry.getKey();
                PathMap contexts = (PathMap)hEntry.getValue();
                Iterator i3 = contexts.entrySet().iterator();
                while (i3.hasNext()) {
                    Map.Entry cEntry = i3.next();
                    String contextPath = (String)cEntry.getKey();
                    List contextList = (List)cEntry.getValue();
                    Composite hcItem = hcList.newItem();
                    if (host != null) {
                        hcItem.add("Host=" + host + ":");
                    }
                    hcItem.add("ContextPath=" + contextPath);
                    String id3 = id1 + ":" + host + ":" + (contextPath.length() > 2 ? contextPath.substring(0, contextPath.length() - 2) : contextPath);
                    org.mortbay.html.List cList = new org.mortbay.html.List("ol");
                    hcItem.add(cList);
                    for (int i4 = 0; i4 < contextList.size(); ++i4) {
                        String id4 = id3 + ":" + i4;
                        Composite cItem = cList.newItem();
                        HttpContext hc = (HttpContext)contextList.get(i4);
                        cItem.add(this.lifeCycle(request, id4, hc));
                        cItem.add("<BR>ResourceBase=" + hc.getResourceBase());
                        cItem.add("<BR>ClassPath=" + hc.getClassPath());
                        org.mortbay.html.List hList = new org.mortbay.html.List("ol");
                        cItem.add(hList);
                        int handlers = hc.getHandlers().length;
                        for (int i5 = 0; i5 < handlers; ++i5) {
                            String id5 = id4 + ":" + i5;
                            HttpHandler handler = hc.getHandlers()[i5];
                            Composite hItem = hList.newItem();
                            hItem.add(this.lifeCycle(request, id5, handler, handler.getName()));
                            if (!(handler instanceof ServletHandler)) continue;
                            hItem.add("<BR>" + ((ServletHandler)handler).getServletMap());
                        }
                    }
                }
            }
            sItem.add("<P>");
        }
        response.setContentType("text/html");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache,no-store");
        PrintWriter writer = response.getWriter();
        page.write(writer);
        ((Writer)writer).flush();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String target = null;
        response.sendRedirect(request.getContextPath() + request.getServletPath() + "/" + Long.toString(System.currentTimeMillis(), 36) + (target != null ? "#" + target : ""));
    }

    private Element lifeCycle(HttpServletRequest request, String id, LifeCycle lc) {
        return this.lifeCycle(request, id, lc, lc.toString());
    }

    private Element lifeCycle(HttpServletRequest request, String id, LifeCycle lc, String name) {
        Composite comp = new Composite();
        comp.add(new Target(id));
        Font font = new Font();
        comp.add(font);
        font.color(lc.isStarted() ? "green" : "red");
        font.add(name);
        String action = lc.isStarted() ? "Stop" : "Start";
        comp.add("&nbsp;[");
        comp.add(new Link(URI.addPaths(request.getContextPath(), request.getServletPath()) + "?T=" + Long.toString(System.currentTimeMillis(), 36) + "&A=" + action + "&ID=" + UrlEncoded.encodeString(id), (Object)action));
        comp.add("]");
        return comp;
    }

    public String getServletInfo() {
        return "HTTP Admin";
    }
}

