/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class SignedBinary {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;

    private SignedBinary() {
    }

    public static final short getShort(byte[] buffer, int offset) {
        return (short)(((buffer[offset + 0] & 0xFF) << 8) + ((buffer[offset + 1] & 0xFF) << 0));
    }

    public static final int getInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + ((buffer[offset + 3] & 0xFF) << 0);
    }

    public static final long getLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + (((long)buffer[offset + 7] & 0xFFL) << 0);
    }

    public static final void shortToBigEndianBytes(byte[] buffer, int offset, short v) {
        buffer[offset++] = (byte)(v >>> 8 & 0xFF);
        buffer[offset++] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void intToBigEndianBytes(byte[] buffer, int offset, int v) {
        buffer[offset++] = (byte)(v >>> 24 & 0xFF);
        buffer[offset++] = (byte)(v >>> 16 & 0xFF);
        buffer[offset++] = (byte)(v >>> 8 & 0xFF);
        buffer[offset++] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBigEndianBytes(byte[] buffer, int offset, long v) {
        buffer[offset++] = (byte)(v >>> 56 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 48 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 40 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 32 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 24 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 16 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 8 & 0xFFL);
        buffer[offset++] = (byte)(v >>> 0 & 0xFFL);
    }
}

