/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.EncodedInputStream;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetLogWriter;

public class Request {
    protected byte[] bytes_;
    protected int offset_;
    private static final int MAX_MARKS_NESTING = 10;
    private int[] markStack_ = new int[10];
    private int top_ = 0;
    protected CcsidManager ccsidManager_;
    private int dssLengthLocation_ = 0;
    private int correlationID_ = 0;
    private boolean simpleDssFinalize = false;
    protected boolean passwordIncluded_ = false;
    protected int passwordStart_ = 0;
    protected int passwordLength_ = 0;
    protected NetAgent netAgent_;

    Request(NetAgent netAgent, int minSize, CcsidManager ccsidManager) {
        this.netAgent_ = netAgent;
        this.bytes_ = new byte[minSize];
        this.ccsidManager_ = ccsidManager;
        this.clearBuffer();
    }

    Request(NetAgent netAgent, CcsidManager ccsidManager, int bufferSize) {
        this(netAgent, bufferSize, ccsidManager);
    }

    protected final void clearBuffer() {
        this.offset_ = 0;
        this.top_ = 0;
        for (int i = 0; i < this.markStack_.length && this.markStack_[i] != 0; ++i) {
            this.markStack_[i] = 0;
        }
        this.dssLengthLocation_ = 0;
    }

    final void initialize() {
        this.clearBuffer();
        this.correlationID_ = 0;
    }

    final void setCcsidMgr(CcsidManager ccsidManager) {
        this.ccsidManager_ = ccsidManager;
    }

    protected final void ensureLength(int length) {
        if (length > this.bytes_.length) {
            byte[] newBytes = new byte[Math.max(this.bytes_.length << 1, length)];
            System.arraycopy(this.bytes_, 0, newBytes, 0, this.offset_);
            this.bytes_ = newBytes;
        }
    }

    protected final void createCommand() {
        this.buildDss(false, false, false, 1, ++this.correlationID_, false);
    }

    protected void createXACommand() {
        this.buildDss(false, false, false, 5, ++this.correlationID_, false);
    }

    final void createCommandData() {
        this.buildDss(true, false, false, 3, this.correlationID_, false);
    }

    final void createEncryptedCommandData() {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, false, false, 4, this.correlationID_, false);
        } else {
            this.buildDss(true, false, false, 3, this.correlationID_, false);
        }
    }

    private final void buildDss(boolean dssHasSameCorrelator, boolean chainedToNextStructure, boolean nextHasSameCorrelator, int dssType, int corrId, boolean simpleFinalizeBuildingNextDss) {
        if (this.doesRequestContainData()) {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(dssHasSameCorrelator);
            }
        }
        this.ensureLength(this.offset_ + 6);
        this.dssLengthLocation_ = this.offset_;
        this.bytes_[this.offset_++] = -1;
        this.bytes_[this.offset_++] = -1;
        this.bytes_[this.offset_++] = -48;
        if (chainedToNextStructure) {
            dssType |= 0x40;
            if (nextHasSameCorrelator) {
                dssType |= 0x10;
            }
        }
        this.bytes_[this.offset_++] = (byte)(dssType & 0xFF);
        this.bytes_[this.offset_++] = (byte)(corrId >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(corrId & 0xFF);
        this.simpleDssFinalize = simpleFinalizeBuildingNextDss;
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        this.writePlainScalarStream(chained, chainedWithSameCorrelator, codePoint, in, writeNullByte, parameterIndex);
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, int length, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.writeEncryptedScalarStream(chained, chainedWithSameCorrelator, codePoint, length, in, writeNullByte, parameterIndex);
        } else {
            this.writePlainScalarStream(chained, chainedWithSameCorrelator, codePoint, length, in, writeNullByte, parameterIndex);
        }
    }

    private final void writeEncryptedScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, int length, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        int leftToRead = length;
        int extendedLengthByteCount = this.prepScalarStream(chained, chainedWithSameCorrelator, writeNullByte, leftToRead);
        int bytesToRead = writeNullByte ? Utils.min(leftToRead, 32756 - extendedLengthByteCount) : Utils.min(leftToRead, 32757 - extendedLengthByteCount);
        byte[] lengthAndCodepoint = this.buildLengthAndCodePointForEncryptedLob(codePoint, leftToRead, writeNullByte, extendedLengthByteCount);
        byte[] clearedBytes = new byte[leftToRead];
        int bytesRead = 0;
        int totalBytesRead = 0;
        int pos = 0;
        do {
            try {
                bytesRead = in.read(clearedBytes, pos, leftToRead);
                totalBytesRead += bytesRead;
            }
            catch (IOException e) {
                this.padScalarStreamForError(leftToRead, bytesToRead);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(parameterIndex), (Object)e.getMessage(), (Throwable)e));
                return;
            }
            if (bytesRead == -1) {
                this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("58009.C.17"), (Object)new Integer(parameterIndex)));
                return;
            }
            pos += bytesRead;
        } while ((leftToRead -= bytesRead) > 0);
        try {
            if (in.read() != -1) {
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), new Integer(parameterIndex)));
            }
        }
        catch (IOException e) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), (Object)new Integer(parameterIndex), (Object)e.getMessage(), (Throwable)e));
        }
        byte[] newClearedBytes = new byte[clearedBytes.length + lengthAndCodepoint.length];
        System.arraycopy(lengthAndCodepoint, 0, newClearedBytes, 0, lengthAndCodepoint.length);
        System.arraycopy(clearedBytes, 0, newClearedBytes, lengthAndCodepoint.length, clearedBytes.length);
        byte[] encryptedBytes = this.netAgent_.netConnection_.getEncryptionManager().encryptData(newClearedBytes, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
        int encryptedBytesLength = encryptedBytes.length;
        int sendingLength = this.bytes_.length - this.offset_;
        if (encryptedBytesLength > this.bytes_.length - this.offset_) {
            System.arraycopy(encryptedBytes, 0, this.bytes_, this.offset_, this.bytes_.length - this.offset_);
            this.offset_ = Short.MAX_VALUE;
            try {
                this.sendBytes(this.netAgent_.getOutputStream());
            }
            catch (IOException ioe) {
                this.netAgent_.throwCommunicationsFailure(ioe);
            }
        } else {
            System.arraycopy(encryptedBytes, 0, this.bytes_, this.offset_, encryptedBytesLength);
            this.offset_ += encryptedBytes.length;
        }
        encryptedBytesLength -= sendingLength;
        while (encryptedBytesLength > 0) {
            this.offset_ = 0;
            if (encryptedBytesLength - 32765 > 0) {
                this.bytes_[this.offset_++] = -1;
                this.bytes_[this.offset_++] = -1;
                System.arraycopy(encryptedBytes, sendingLength, this.bytes_, this.offset_, 32765);
                encryptedBytesLength -= 32765;
                sendingLength += 32765;
                this.offset_ = Short.MAX_VALUE;
                try {
                    this.sendBytes(this.netAgent_.getOutputStream());
                }
                catch (IOException ioe) {
                    this.netAgent_.throwCommunicationsFailure(ioe);
                }
                continue;
            }
            int leftlength = encryptedBytesLength + 2;
            this.bytes_[this.offset_++] = (byte)(leftlength >>> 8 & 0xFF);
            this.bytes_[this.offset_++] = (byte)(leftlength & 0xFF);
            System.arraycopy(encryptedBytes, sendingLength, this.bytes_, this.offset_, encryptedBytesLength);
            this.offset_ += encryptedBytesLength;
            this.dssLengthLocation_ = this.offset_;
            encryptedBytesLength = 0;
        }
    }

    private final void writePlainScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, int length, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        int leftToRead = length;
        int extendedLengthByteCount = this.prepScalarStream(chained, chainedWithSameCorrelator, writeNullByte, leftToRead);
        int bytesToRead = writeNullByte ? Utils.min(leftToRead, 32756 - extendedLengthByteCount) : Utils.min(leftToRead, 32757 - extendedLengthByteCount);
        this.buildLengthAndCodePointForLob(codePoint, leftToRead, writeNullByte, extendedLengthByteCount);
        int bytesRead = 0;
        int totalBytesRead = 0;
        while (true) {
            try {
                bytesRead = in.read(this.bytes_, this.offset_, bytesToRead);
                totalBytesRead += bytesRead;
            }
            catch (IOException e) {
                this.padScalarStreamForError(leftToRead, bytesToRead);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(parameterIndex), (Object)e.getMessage(), (Throwable)e));
                return;
            }
            if (bytesRead == -1) {
                this.padScalarStreamForError(leftToRead, bytesToRead);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN017.S"), new Integer(parameterIndex)));
                return;
            }
            this.offset_ += bytesRead;
            leftToRead -= bytesRead;
            if ((bytesToRead -= bytesRead) > 0) continue;
            bytesToRead = this.flushScalarStreamSegment(leftToRead, bytesToRead);
            if (leftToRead <= 0) break;
        }
        try {
            if (in.read() != -1) {
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), new Integer(parameterIndex)));
            }
        }
        catch (IOException e) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), (Object)new Integer(parameterIndex), (Object)e.getMessage(), (Throwable)e));
        }
    }

    private final void writePlainScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        in = new BufferedInputStream(in);
        this.flushExistingDSS();
        this.ensureLength(Short.MAX_VALUE);
        this.buildDss(true, chained, chainedWithSameCorrelator, 3, this.correlationID_, true);
        int spareInDss = writeNullByte ? 32756 : 32757;
        this.buildLengthAndCodePointForLob(codePoint, writeNullByte);
        try {
            int bytesRead = 0;
            while ((bytesRead = in.read(this.bytes_, this.offset_, spareInDss)) > -1) {
                this.offset_ += bytesRead;
                if ((spareInDss -= bytesRead) > 0) continue;
                if (Request.peekStream((BufferedInputStream)in)) {
                    this.flushScalarStreamSegment();
                    this.bytes_[this.offset_++] = -1;
                    this.bytes_[this.offset_++] = -1;
                    spareInDss = 32765;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            SqlException sqlex = new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(parameterIndex), (Object)e.getMessage(), (Throwable)e);
            this.netAgent_.accumulateReadException(sqlex);
            return;
        }
        try {
            if (in.read() != -1) {
                SqlException sqlex = new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), new Integer(parameterIndex));
                this.netAgent_.accumulateReadException(sqlex);
            }
        }
        catch (IOException e) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), (Object)new Integer(parameterIndex), (Object)e.getMessage(), (Throwable)e));
        }
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, int length, Reader r, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        this.writeScalarStream(chained, chainedWithSameCorrelator, codePoint, length * 2, EncodedInputStream.createUTF16BEStream(r), writeNullByte, parameterIndex);
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, Reader r, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        this.writeScalarStream(chained, chainedWithSameCorrelator, codePoint, EncodedInputStream.createUTF16BEStream(r), writeNullByte, parameterIndex);
    }

    protected final int prepScalarStream(boolean chained, boolean chainedWithSameCorrelator, boolean writeNullByte, int leftToRead) throws DisconnectException {
        int extendedLengthByteCount;
        int nullIndicatorSize = 0;
        if (writeNullByte) {
            extendedLengthByteCount = this.calculateExtendedLengthByteCount((long)leftToRead + 4L + 1L);
            nullIndicatorSize = 1;
        } else {
            extendedLengthByteCount = this.calculateExtendedLengthByteCount(leftToRead + 4);
        }
        if ((long)(10 + extendedLengthByteCount + nullIndicatorSize) + (long)leftToRead + (long)this.offset_ > 32767L) {
            try {
                if (this.simpleDssFinalize) {
                    this.finalizeDssLength();
                } else {
                    this.finalizePreviousChainedDss(true);
                }
                this.sendBytes(this.netAgent_.getOutputStream());
            }
            catch (IOException e) {
                this.netAgent_.throwCommunicationsFailure(e);
            }
        }
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, chained, chainedWithSameCorrelator, 4, this.correlationID_, true);
        } else {
            this.buildDss(true, chained, chainedWithSameCorrelator, 3, this.correlationID_, true);
        }
        return extendedLengthByteCount;
    }

    protected final void flushExistingDSS() throws DisconnectException {
        try {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(true);
            }
            this.sendBytes(this.netAgent_.getOutputStream());
        }
        catch (IOException e) {
            this.netAgent_.throwCommunicationsFailure(e);
        }
    }

    protected final int flushScalarStreamSegment(int leftToRead, int bytesToRead) throws DisconnectException {
        int newBytesToRead = bytesToRead;
        if (leftToRead != 0) {
            if (Utils.min(2 + leftToRead, Short.MAX_VALUE) > this.bytes_.length - this.offset_) {
                try {
                    this.sendBytes(this.netAgent_.getOutputStream());
                }
                catch (IOException ioe) {
                    this.netAgent_.throwCommunicationsFailure(ioe);
                }
            }
            this.dssLengthLocation_ = this.offset_;
            this.bytes_[this.offset_++] = -1;
            this.bytes_[this.offset_++] = -1;
            newBytesToRead = Utils.min(leftToRead, 32765);
        }
        return newBytesToRead;
    }

    protected final int flushScalarStreamSegment() throws DisconnectException {
        try {
            this.sendBytes(this.netAgent_.getOutputStream());
        }
        catch (IOException ioe) {
            this.netAgent_.throwCommunicationsFailure(ioe);
        }
        this.dssLengthLocation_ = this.offset_;
        return Short.MAX_VALUE;
    }

    protected final void padScalarStreamForError(int leftToRead, int bytesToRead) throws DisconnectException {
        while (true) {
            this.bytes_[this.offset_++] = 0;
            --leftToRead;
            if (--bytesToRead > 0) continue;
            bytesToRead = this.flushScalarStreamSegment(leftToRead, bytesToRead);
            if (leftToRead <= 0) break;
        }
    }

    private final void writeExtendedLengthBytes(int extendedLengthByteCount, long length) {
        int shiftSize = (extendedLengthByteCount - 1) * 8;
        for (int i = 0; i < extendedLengthByteCount; ++i) {
            this.bytes_[this.offset_++] = (byte)(length >>> shiftSize & 0xFFL);
            shiftSize -= 8;
        }
    }

    private final byte[] writeExtendedLengthBytesForEncryption(int extendedLengthByteCount, long length) {
        int shiftSize = (extendedLengthByteCount - 1) * 8;
        byte[] extendedLengthBytes = new byte[extendedLengthByteCount];
        for (int i = 0; i < extendedLengthByteCount; ++i) {
            extendedLengthBytes[i] = (byte)(length >>> shiftSize & 0xFFL);
            shiftSize -= 8;
        }
        return extendedLengthBytes;
    }

    protected final void finalizePreviousChainedDss(boolean dssHasSameCorrelator) {
        this.finalizeDssLength();
        int n = this.dssLengthLocation_ + 3;
        this.bytes_[n] = (byte)(this.bytes_[n] | 0x40);
        if (dssHasSameCorrelator) {
            int n2 = this.dssLengthLocation_ + 3;
            this.bytes_[n2] = (byte)(this.bytes_[n2] | 0x10);
        }
    }

    protected final boolean doesRequestContainData() {
        return this.offset_ != 0;
    }

    protected final void finalizeDssLength() {
        int totalSize = this.offset_ - this.dssLengthLocation_;
        int bytesRequiringContDssHeader = totalSize - Short.MAX_VALUE;
        if (bytesRequiringContDssHeader > 0) {
            int dataToShift;
            int contDssHeaderCount = bytesRequiringContDssHeader / 32765;
            if (bytesRequiringContDssHeader % 32765 != 0) {
                ++contDssHeaderCount;
            }
            int dataByte = this.offset_ - 1;
            int shiftOffset = contDssHeaderCount * 2;
            this.ensureLength(this.offset_ + shiftOffset);
            this.offset_ += shiftOffset;
            boolean passOne = true;
            do {
                if ((dataToShift = bytesRequiringContDssHeader % 32765) == 0) {
                    dataToShift = 32765;
                }
                System.arraycopy(this.bytes_, (dataByte -= dataToShift) + 1, this.bytes_, dataByte + shiftOffset + 1, dataToShift);
                int twoByteContDssHeader = dataToShift + 2;
                if (passOne) {
                    passOne = false;
                } else if (twoByteContDssHeader == Short.MAX_VALUE) {
                    twoByteContDssHeader = 65535;
                }
                this.bytes_[dataByte + shiftOffset - 1] = (byte)(twoByteContDssHeader >>> 8 & 0xFF);
                this.bytes_[dataByte + shiftOffset] = (byte)(twoByteContDssHeader & 0xFF);
                shiftOffset -= 2;
            } while ((bytesRequiringContDssHeader -= dataToShift) > 0);
            totalSize = 65535;
        }
        this.bytes_[this.dssLengthLocation_] = (byte)(totalSize >>> 8 & 0xFF);
        this.bytes_[this.dssLengthLocation_ + 1] = (byte)(totalSize & 0xFF);
    }

    protected final void markLengthBytes(int codePoint) {
        this.ensureLength(this.offset_ + 4);
        this.mark();
        this.offset_ += 2;
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
    }

    private final void mark() {
        this.markStack_[this.top_++] = this.offset_;
    }

    private final int popMark() {
        return this.markStack_[--this.top_];
    }

    protected final void markForCachingPKGNAMCSN() {
        this.mark();
    }

    protected final int popMarkForCachingPKGNAMCSN() {
        return this.popMark();
    }

    protected final void updateLengthBytes() throws SqlException {
        int lengthLocation = this.popMark();
        int length = this.offset_ - lengthLocation;
        int extendedLengthByteCount = this.calculateExtendedLengthByteCount(length);
        if (extendedLengthByteCount != 0) {
            this.ensureLength(this.offset_ + extendedLengthByteCount);
            int extendedLength = length - 4;
            int extendedLengthLocation = lengthLocation + 4;
            System.arraycopy(this.bytes_, extendedLengthLocation, this.bytes_, extendedLengthLocation + extendedLengthByteCount, extendedLength);
            int shiftSize = (extendedLengthByteCount - 1) * 8;
            for (int i = 0; i < extendedLengthByteCount; ++i) {
                this.bytes_[extendedLengthLocation++] = (byte)(extendedLength >>> shiftSize & 0xFF);
                shiftSize -= 8;
            }
            this.offset_ += extendedLengthByteCount;
            length = extendedLengthByteCount + 4;
            length |= 0x8000;
        }
        this.bytes_[lengthLocation] = (byte)(length >>> 8 & 0xFF);
        this.bytes_[lengthLocation + 1] = (byte)(length & 0xFF);
    }

    private final int calculateExtendedLengthByteCount(long ddmSize) {
        if (ddmSize <= 32767L) {
            return 0;
        }
        if (ddmSize <= Integer.MAX_VALUE) {
            return 4;
        }
        if (ddmSize <= 0x7FFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    final void padBytes(byte padByte, int length) {
        this.ensureLength(this.offset_ + length);
        for (int i = 0; i < length; ++i) {
            this.bytes_[this.offset_++] = padByte;
        }
    }

    final void write1Byte(int value) {
        this.ensureLength(this.offset_ + 1);
        this.bytes_[this.offset_++] = (byte)(value & 0xFF);
    }

    final void buildTripletHeader(int tripletLength, int tripletType, int tripletId) {
        this.ensureLength(this.offset_ + 3);
        this.bytes_[this.offset_++] = (byte)(tripletLength & 0xFF);
        this.bytes_[this.offset_++] = (byte)(tripletType & 0xFF);
        this.bytes_[this.offset_++] = (byte)(tripletId & 0xFF);
    }

    final void writeLidAndLengths(int[][] lidAndLengthOverrides, int count, int offset) {
        this.ensureLength(this.offset_ + count * 3);
        int i = 0;
        while (i < count) {
            this.bytes_[this.offset_++] = (byte)(lidAndLengthOverrides[offset][0] & 0xFF);
            this.bytes_[this.offset_++] = (byte)(lidAndLengthOverrides[offset][1] >>> 8 & 0xFF);
            this.bytes_[this.offset_++] = (byte)(lidAndLengthOverrides[offset][1] & 0xFF);
            ++i;
            ++offset;
        }
    }

    final void writeLidAndLengths(int[][] lidAndLengthOverrides, int count, int offset, boolean mddRequired, Hashtable map) {
        if (!mddRequired) {
            this.writeLidAndLengths(lidAndLengthOverrides, count, offset);
        } else {
            this.ensureLength(this.offset_ + count * 3);
            int i = 0;
            while (i < count) {
                int protocolType = lidAndLengthOverrides[offset][0];
                Object entry = map.get(new Integer(protocolType));
                int overrideLid = entry == null ? protocolType : (Integer)entry;
                this.bytes_[this.offset_++] = (byte)(overrideLid & 0xFF);
                this.bytes_[this.offset_++] = (byte)(lidAndLengthOverrides[offset][1] >>> 8 & 0xFF);
                this.bytes_[this.offset_++] = (byte)(lidAndLengthOverrides[offset][1] & 0xFF);
                ++i;
                ++offset;
            }
        }
    }

    final void write2Bytes(int value) {
        this.ensureLength(this.offset_ + 2);
        this.bytes_[this.offset_++] = (byte)(value >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value & 0xFF);
    }

    final void write4Bytes(long value) {
        this.ensureLength(this.offset_ + 4);
        this.bytes_[this.offset_++] = (byte)(value >>> 24 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 16 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 8 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value & 0xFFL);
    }

    final void writeBytes(byte[] buf, int length) {
        this.ensureLength(this.offset_ + length);
        System.arraycopy(buf, 0, this.bytes_, this.offset_, length);
        this.offset_ += length;
    }

    final void writeBytes(byte[] buf) {
        this.ensureLength(this.offset_ + buf.length);
        System.arraycopy(buf, 0, this.bytes_, this.offset_, buf.length);
        this.offset_ += buf.length;
    }

    final void writeCodePoint4Bytes(int codePoint, int value) {
        this.ensureLength(this.offset_ + 4);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value & 0xFF);
    }

    protected final void writeScalar1Byte(int codePoint, int value) {
        this.ensureLength(this.offset_ + 5);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 5;
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value & 0xFF);
    }

    final void writeScalar2Bytes(int codePoint, int value) {
        this.ensureLength(this.offset_ + 6);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 6;
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value & 0xFF);
    }

    protected final void writeScalar4Bytes(int codePoint, long value) {
        this.ensureLength(this.offset_ + 8);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 8;
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value >>> 24 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 16 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 8 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value & 0xFFL);
    }

    final void writeScalar8Bytes(int codePoint, long value) {
        this.ensureLength(this.offset_ + 12);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 12;
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        this.bytes_[this.offset_++] = (byte)(value >>> 56 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 48 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 40 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 32 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 24 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 16 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value >>> 8 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(value & 0xFFL);
    }

    final void writeLengthCodePoint(int length, int codePoint) {
        this.ensureLength(this.offset_ + 4);
        this.bytes_[this.offset_++] = (byte)(length >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(length & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
    }

    final byte[] writeEXTDTALengthCodePointForEncryption(int length, int codePoint) {
        byte[] clearedBytes = new byte[]{(byte)(length >>> 8 & 0xFF), (byte)(length & 0xFF), (byte)(codePoint >>> 8 & 0xFF), (byte)(codePoint & 0xFF)};
        return clearedBytes;
    }

    final void writeScalarBytes(int codePoint, byte[] buf, int length) {
        this.ensureLength(this.offset_ + length + 4);
        this.bytes_[this.offset_++] = (byte)(length + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(length + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        for (int i = 0; i < length; ++i) {
            this.bytes_[this.offset_++] = buf[i];
        }
    }

    final void writeScalarHeader(int codePoint, int dataLength) {
        this.ensureLength(this.offset_ + dataLength + 4);
        this.bytes_[this.offset_++] = (byte)(dataLength + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(dataLength + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
    }

    final void writeScalarString(int codePoint, String string) throws SqlException {
        this.writeScalarString(codePoint, string, 0, Integer.MAX_VALUE, null);
    }

    final void writeScalarString(int codePoint, String string, int byteMinLength, int byteLengthLimit, String sqlState) throws SqlException {
        int maxByteLength = this.ccsidManager_.maxBytesPerChar() * string.length();
        this.ensureLength(this.offset_ + maxByteLength + 4);
        int lengthOffset = this.offset_;
        this.offset_ += 2;
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        this.offset_ = this.ccsidManager_.convertFromUCS2(string, this.bytes_, this.offset_, this.netAgent_);
        int stringByteLength = this.offset_ - lengthOffset - 4;
        if (stringByteLength > byteLengthLimit) {
            this.offset_ = lengthOffset;
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId(sqlState), string);
        }
        if (stringByteLength < byteMinLength) {
            for (int i = stringByteLength; i < byteMinLength; ++i) {
                this.bytes_[this.offset_++] = this.ccsidManager_.space_;
            }
            stringByteLength = byteMinLength;
        }
        int totalLength = stringByteLength + 4;
        this.bytes_[lengthOffset] = (byte)(totalLength >>> 8 & 0xFF);
        this.bytes_[lengthOffset + 1] = (byte)(totalLength & 0xFF);
    }

    final void writeScalarPaddedString(String string, int paddedLength) throws SqlException {
        int stringLength = string.length();
        this.ensureLength(this.offset_ + paddedLength);
        this.offset_ = this.ccsidManager_.convertFromUCS2(string, this.bytes_, this.offset_, this.netAgent_);
        for (int i = 0; i < paddedLength - stringLength; ++i) {
            this.bytes_[this.offset_++] = this.ccsidManager_.space_;
        }
    }

    final void writeScalarBytes(int codePoint, byte[] buff) {
        int buffLength = buff.length;
        this.ensureLength(this.offset_ + buffLength + 4);
        this.bytes_[this.offset_++] = (byte)(buffLength + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(buffLength + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        System.arraycopy(buff, 0, this.bytes_, this.offset_, buffLength);
        this.offset_ += buffLength;
    }

    final void writeScalarBytes(int codePoint, byte[] buff, int start, int length) {
        this.ensureLength(this.offset_ + length + 4);
        this.bytes_[this.offset_++] = (byte)(length + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(length + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        System.arraycopy(buff, start, this.bytes_, this.offset_, length);
        this.offset_ += length;
    }

    final void writeScalarPaddedBytes(int codePoint, byte[] buff, int paddedLength, byte padByte) {
        int buffLength = buff.length;
        this.ensureLength(this.offset_ + paddedLength + 4);
        this.bytes_[this.offset_++] = (byte)(paddedLength + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(paddedLength + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(codePoint & 0xFF);
        System.arraycopy(buff, 0, this.bytes_, this.offset_, buffLength);
        this.offset_ += buffLength;
        for (int i = 0; i < paddedLength - buffLength; ++i) {
            this.bytes_[this.offset_++] = padByte;
        }
    }

    final void writeScalarPaddedBytes(byte[] buff, int paddedLength, byte padByte) {
        int buffLength = buff.length;
        this.ensureLength(this.offset_ + paddedLength);
        System.arraycopy(buff, 0, this.bytes_, this.offset_, buffLength);
        this.offset_ += buffLength;
        for (int i = 0; i < paddedLength - buffLength; ++i) {
            this.bytes_[this.offset_++] = padByte;
        }
    }

    protected void flush(OutputStream socketOutputStream) throws IOException {
        if (this.doesRequestContainData()) {
            this.finalizeDssLength();
            this.sendBytes(socketOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendBytes(OutputStream socketOutputStream) throws IOException {
        try {
            socketOutputStream.write(this.bytes_, 0, this.offset_);
            socketOutputStream.flush();
        }
        finally {
            if (this.netAgent_.logWriter_ != null && this.passwordIncluded_) {
                this.maskOutPassword();
                this.passwordIncluded_ = false;
            }
            if (this.netAgent_.loggingEnabled()) {
                ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.bytes_, 0, this.offset_, 1, "Request", "flush", 1);
            }
            this.clearBuffer();
        }
    }

    final void maskOutPassword() {
        try {
            String maskChar = "*";
            StringBuffer mask = new StringBuffer();
            for (int i = 0; i < this.passwordLength_; ++i) {
                mask.append(maskChar);
            }
            this.ccsidManager_.convertFromUCS2(mask.toString(), this.bytes_, this.passwordStart_, this.netAgent_);
        }
        catch (SqlException sqle) {
            for (int i = 0; i < this.passwordLength_; ++i) {
                this.bytes_[this.passwordStart_ + i] = -1;
            }
        }
    }

    final void writeByte(byte v) {
        this.ensureLength(this.offset_ + 1);
        this.bytes_[this.offset_++] = v;
    }

    final void writeShort(short v) {
        this.ensureLength(this.offset_ + 2);
        SignedBinary.shortToBigEndianBytes(this.bytes_, this.offset_, v);
        this.offset_ += 2;
    }

    void writeInt(int v) {
        this.ensureLength(this.offset_ + 4);
        SignedBinary.intToBigEndianBytes(this.bytes_, this.offset_, v);
        this.offset_ += 4;
    }

    final void writeLong(long v) {
        this.ensureLength(this.offset_ + 8);
        SignedBinary.longToBigEndianBytes(this.bytes_, this.offset_, v);
        this.offset_ += 8;
    }

    protected void writeShortFdocaData(short v) {
        this.ensureLength(this.offset_ + 2);
        SignedBinary.shortToBigEndianBytes(this.bytes_, this.offset_, v);
        this.offset_ += 2;
    }

    protected void writeIntFdocaData(int v) {
        this.ensureLength(this.offset_ + 4);
        SignedBinary.intToBigEndianBytes(this.bytes_, this.offset_, v);
        this.offset_ += 4;
    }

    protected void writeLongFdocaData(long v) {
        this.ensureLength(this.offset_ + 8);
        SignedBinary.longToBigEndianBytes(this.bytes_, this.offset_, v);
        this.offset_ += 8;
    }

    protected void writeFloat(float v) {
        this.ensureLength(this.offset_ + 4);
        FloatingPoint.floatToIeee754Bytes(this.bytes_, this.offset_, v);
        this.offset_ += 4;
    }

    protected void writeDouble(double v) {
        this.ensureLength(this.offset_ + 8);
        FloatingPoint.doubleToIeee754Bytes(this.bytes_, this.offset_, v);
        this.offset_ += 8;
    }

    final void writeBigDecimal(BigDecimal v, int declaredPrecision, int declaredScale) throws SqlException {
        this.ensureLength(this.offset_ + 16);
        int length = Decimal.bigDecimalToPackedDecimalBytes(this.bytes_, this.offset_, v, declaredPrecision, declaredScale);
        this.offset_ += length;
    }

    final void writeDate(Date date) throws SqlException {
        try {
            this.ensureLength(this.offset_ + 10);
            DateTime.dateToDateBytes(this.bytes_, this.offset_, date);
            this.offset_ += 10;
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Date", (Object)"DATE", (Throwable)e);
        }
    }

    final void writeTime(Time time) throws SqlException {
        try {
            this.ensureLength(this.offset_ + 8);
            DateTime.timeToTimeBytes(this.bytes_, this.offset_, time);
            this.offset_ += 8;
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Time", (Object)"TIME", (Throwable)e);
        }
    }

    final void writeTimestamp(Timestamp timestamp) throws SqlException {
        try {
            this.ensureLength(this.offset_ + 26);
            DateTime.timestampToTimestampBytes(this.bytes_, this.offset_, timestamp);
            this.offset_ += 26;
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Timestamp", (Object)"TIMESTAMP", (Throwable)e);
        }
    }

    final void writeBoolean(boolean v) {
        this.ensureLength(this.offset_ + 1);
        this.bytes_[this.offset_++] = (byte)((v ? 1 : 0) & 0xFF);
    }

    final void writeSingleorMixedCcsidLDString(String s, String encoding) throws SqlException {
        byte[] b;
        try {
            b = s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"String", (Object)"byte", (Throwable)e);
        }
        if (b.length > Short.MAX_VALUE) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22028"), "32767");
        }
        this.ensureLength(this.offset_ + b.length + 2);
        this.writeLDBytesX(b.length, b);
    }

    final void writeLDBytes(byte[] bytes) {
        this.ensureLength(this.offset_ + bytes.length + 2);
        this.writeLDBytesX(bytes.length, bytes);
    }

    private final void writeLDBytesX(int ldSize, byte[] bytes) {
        this.bytes_[this.offset_++] = (byte)(ldSize >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(ldSize & 0xFF);
        System.arraycopy(bytes, 0, this.bytes_, this.offset_, bytes.length);
        this.offset_ += bytes.length;
    }

    final void writeDDMString(String s) throws SqlException {
        this.ensureLength(this.offset_ + s.length());
        this.offset_ = this.ccsidManager_.convertFromUCS2(s, this.bytes_, this.offset_, this.netAgent_);
    }

    private byte[] buildLengthAndCodePointForEncryptedLob(int codePoint, int leftToRead, boolean writeNullByte, int extendedLengthByteCount) throws DisconnectException {
        byte[] lengthAndCodepoint = new byte[4];
        byte[] extendedLengthBytes = new byte[extendedLengthByteCount];
        if (extendedLengthByteCount > 0) {
            lengthAndCodepoint = this.writeEXTDTALengthCodePointForEncryption(32772 + extendedLengthByteCount, codePoint);
            extendedLengthBytes = writeNullByte ? this.writeExtendedLengthBytesForEncryption(extendedLengthByteCount, leftToRead + 1) : this.writeExtendedLengthBytesForEncryption(extendedLengthByteCount, leftToRead);
        } else {
            lengthAndCodepoint = writeNullByte ? this.writeEXTDTALengthCodePointForEncryption(leftToRead + 4 + 1, codePoint) : this.writeEXTDTALengthCodePointForEncryption(leftToRead + 4, codePoint);
        }
        if (extendedLengthByteCount > 0) {
            byte[] newLengthAndCodepoint = new byte[4 + extendedLengthBytes.length];
            System.arraycopy(lengthAndCodepoint, 0, newLengthAndCodepoint, 0, lengthAndCodepoint.length);
            System.arraycopy(extendedLengthBytes, 0, newLengthAndCodepoint, lengthAndCodepoint.length, extendedLengthBytes.length);
            lengthAndCodepoint = newLengthAndCodepoint;
        }
        if (writeNullByte) {
            byte[] nullByte = new byte[1 + lengthAndCodepoint.length];
            System.arraycopy(lengthAndCodepoint, 0, nullByte, 0, lengthAndCodepoint.length);
            nullByte[lengthAndCodepoint.length] = 0;
            lengthAndCodepoint = nullByte;
        }
        return lengthAndCodepoint;
    }

    private void buildLengthAndCodePointForLob(int codePoint, int leftToRead, boolean writeNullByte, int extendedLengthByteCount) throws DisconnectException {
        if (extendedLengthByteCount > 0) {
            this.writeLengthCodePoint(32772 + extendedLengthByteCount, codePoint);
            if (writeNullByte) {
                this.writeExtendedLengthBytes(extendedLengthByteCount, leftToRead + 1);
            } else {
                this.writeExtendedLengthBytes(extendedLengthByteCount, leftToRead);
            }
        } else if (writeNullByte) {
            this.writeLengthCodePoint(leftToRead + 4 + 1, codePoint);
        } else {
            this.writeLengthCodePoint(leftToRead + 4, codePoint);
        }
        if (writeNullByte) {
            this.write1Byte(0);
        }
    }

    private void buildLengthAndCodePointForLob(int codePoint, boolean writeNullByte) throws DisconnectException {
        this.writeLengthCodePoint(32772, codePoint);
        if (writeNullByte) {
            this.write1Byte(0);
        }
    }

    public void setDssLengthLocation(int location) {
        this.dssLengthLocation_ = location;
    }

    public void setCorrelationID(int id) {
        this.correlationID_ = id;
    }

    private static boolean peekStream(BufferedInputStream in) throws IOException {
        in.mark(1);
        boolean notYet = in.read() > -1;
        in.reset();
        return notYet;
    }
}

