/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.FdocaSimpleDataArray;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;

public class Typdef
implements Cloneable {
    static final short CCSIDDBC = 1;
    static final short CCSIDMBC = 2;
    static final short CCSIDSBC = 3;
    static final short NOCCSID = 0;
    static final short FIXEDLENGTH = 0;
    static final short TWOBYTELENGTH = 1;
    static final short ONEBYTELENGTH = 2;
    static final short DECIMALLENGTH = 3;
    static final short LOBLENGTH = 4;
    public static final String UTF8ENCODING = "UTF8";
    private static final int OVERRIDE_TABLE_SIZE = 255;
    private static final int[] fdocaTypeToRepresentationMap_ = new int[]{0, 4, 2, 7, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final FdocaSimpleDataArray[] environmentTables_ = new FdocaSimpleDataArray[]{null, null, new FdocaSimpleDataArray(2, 35, 1, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(3, 163, 1, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(4, 35, 1, 0, 0, 0, 2, 0), new FdocaSimpleDataArray(5, 163, 1, 0, 0, 0, 2, 0), new FdocaSimpleDataArray(6, 35, 1, 0, 0, 0, 1, 0), new FdocaSimpleDataArray(7, 163, 1, 0, 0, 0, 1, 0), new FdocaSimpleDataArray(8, 72, 72, 0, 0, 0, 16, 0), new FdocaSimpleDataArray(9, 200, 72, 0, 0, 0, 16, 0), new FdocaSimpleDataArray(10, 72, 72, 0, 0, 0, 8, 0), new FdocaSimpleDataArray(11, 200, 72, 0, 0, 0, 8, 0), new FdocaSimpleDataArray(12, 72, 72, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(13, 200, 72, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(14, 48, 48, 0, 0, 0, 31, 3), new FdocaSimpleDataArray(15, 176, 48, 0, 0, 0, 31, 3), null, null, null, null, null, null, new FdocaSimpleDataArray(22, 35, 1, 0, 0, 0, 8, 0), new FdocaSimpleDataArray(23, 163, 1, 0, 0, 0, 8, 0), new FdocaSimpleDataArray(24, 1, 0, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(25, 129, 0, 0, 0, 0, 4, 0), null, new FdocaSimpleDataArray(27, 129, 0, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(28, 1, 0, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(29, 129, 0, 0, 0, 0, 4, 0), new FdocaSimpleDataArray(30, 2, 5, 0, 0, 1, 40, 1), new FdocaSimpleDataArray(31, 130, 5, 0, 0, 1, 40, 1), new FdocaSimpleDataArray(32, 16, 0, 3, 1, 0, 10, 0), new FdocaSimpleDataArray(33, 144, 0, 3, 1, 0, 10, 0), new FdocaSimpleDataArray(34, 16, 0, 3, 1, 0, 8, 0), new FdocaSimpleDataArray(35, 144, 0, 3, 1, 0, 8, 0), new FdocaSimpleDataArray(36, 16, 0, 3, 1, 0, 26, 0), new FdocaSimpleDataArray(37, 144, 0, 3, 1, 0, 26, 0), new FdocaSimpleDataArray(38, 1, 4, 0, 0, 0, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(39, 129, 4, 0, 0, 0, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(40, 2, 5, 0, 0, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(41, 130, 5, 0, 0, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(42, 2, 5, 0, 0, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(43, 130, 5, 0, 0, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(44, 3, 7, 0, 0, 1, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(45, 131, 3, 0, 0, 1, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(46, 20, 3, 3, 1, 1, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(47, 148, 3, 3, 1, 1, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(48, 16, 0, 3, 1, 0, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(49, 144, 0, 3, 1, 0, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(50, 17, 2, 3, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(51, 145, 2, 3, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(52, 17, 2, 3, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(53, 145, 2, 3, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(54, 16, 0, 1, 2, 0, 16383, 0), new FdocaSimpleDataArray(55, 144, 0, 1, 2, 0, 16383, 0), new FdocaSimpleDataArray(56, 17, 2, 1, 2, 1, 16383, 1), new FdocaSimpleDataArray(57, 145, 2, 1, 2, 1, 16383, 1), new FdocaSimpleDataArray(58, 17, 2, 1, 2, 1, 16383, 1), new FdocaSimpleDataArray(59, 145, 2, 1, 2, 1, 16383, 1), new FdocaSimpleDataArray(60, 16, 0, 2, 1, 0, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(61, 144, 0, 2, 1, 0, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(62, 17, 2, 2, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(63, 145, 2, 2, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(64, 17, 2, 2, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(65, 145, 2, 2, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(66, 20, 3, 2, 1, 1, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(67, 148, 3, 2, 1, 1, Short.MAX_VALUE, 0), new FdocaSimpleDataArray(68, 7, 1, 0, 0, 1, 255, 2), new FdocaSimpleDataArray(69, 135, 1, 0, 0, 1, 255, 2), new FdocaSimpleDataArray(70, 25, 1, 3, 1, 1, 255, 2), new FdocaSimpleDataArray(71, 153, 1, 3, 1, 1, 255, 2), new FdocaSimpleDataArray(72, 25, 1, 2, 1, 1, 255, 2), new FdocaSimpleDataArray(73, 153, 1, 2, 1, 1, 255, 2), null, null, new FdocaSimpleDataArray(76, 17, 2, 3, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(77, 145, 2, 3, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(78, 17, 2, 2, 1, 1, Short.MAX_VALUE, 1), new FdocaSimpleDataArray(79, 145, 2, 2, 1, 1, Short.MAX_VALUE, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new FdocaSimpleDataArray(200, 80, 0, 0, 0, 1, 8, 4), new FdocaSimpleDataArray(201, 208, 0, 0, 0, 1, 8, 4), new FdocaSimpleDataArray(202, 81, 8, 3, 1, 1, 8, 4), new FdocaSimpleDataArray(203, 209, 8, 3, 1, 1, 8, 4), new FdocaSimpleDataArray(204, 81, 10, 1, 2, 1, 8, 4), new FdocaSimpleDataArray(205, 209, 10, 1, 2, 1, 8, 4), new FdocaSimpleDataArray(206, 81, 9, 2, 1, 1, 8, 4), new FdocaSimpleDataArray(207, 209, 9, 2, 1, 1, 8, 4)};
    private static final int[] protocolToJdbcTypes_ = new int[]{0, 0, 4, 4, 5, 5, -6, -6, 3, 3, 8, 8, 7, 7, 3, 3, 3, 3, 3, 3, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, 0, 0, 91, 91, 92, 92, 93, 93, -2, -2, -3, -3, -4, -4, -3, -3, 1, 1, 1, 1, 12, 12, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 12, 12, -1, -1, 1, 1, -3, -3, 12, 12, 12, 12, 0, 0, 12, 12, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2004, 2004, 2005, 2005, 0, 0, 2005, 2005};
    private NetAgent netAgent_;
    private String typdefnam_;
    private int ccsidSbc_;
    private boolean ccsidSbcSet_;
    private String ccsidSbcEncoding_;
    private int ccsidDbc_;
    private boolean ccsidDbcSet_;
    private String ccsidDbcEncoding_;
    private int ccsidMbc_;
    private boolean ccsidMbcSet_;
    private String ccsidMbcEncoding_;
    protected int environment_;
    private boolean mddOverride_ = false;
    private FdocaSimpleDataArray[] overrideTable_ = new FdocaSimpleDataArray[255];

    Typdef(NetAgent netAgent) throws DisconnectException {
        this.initialize(netAgent, 0, false, 0, false, 0, false, null);
    }

    Typdef(NetAgent netAgent, int ccsidSbc, String typdefnam) throws DisconnectException {
        this.initialize(netAgent, ccsidSbc, true, 0, false, 0, false, typdefnam);
    }

    public Typdef(NetAgent netAgent, int ccsidSbc, String typdefnam, int ccsidDbc, int ccsidMbc) throws DisconnectException {
        this.initialize(netAgent, ccsidSbc, true, ccsidMbc, true, ccsidDbc, true, typdefnam);
    }

    private void initialize(NetAgent netAgent, int ccsidSbc, boolean ccsidSbcSet, int ccsidMbc, boolean ccsidMbcSet, int ccsidDbc, boolean ccsidDbcSet, String typdefnam) throws DisconnectException {
        this.netAgent_ = netAgent;
        this.ccsidSbc_ = ccsidSbc;
        this.ccsidSbcSet_ = ccsidSbcSet;
        this.ccsidSbcEncoding_ = null;
        this.ccsidMbc_ = ccsidMbc;
        this.ccsidMbcSet_ = ccsidMbcSet;
        this.ccsidMbcEncoding_ = null;
        this.ccsidDbc_ = ccsidDbc;
        this.ccsidDbcSet_ = ccsidDbcSet;
        this.ccsidDbcEncoding_ = null;
        this.setTypdefnam(typdefnam);
    }

    String getTypdefnam() {
        return this.typdefnam_;
    }

    void setTypdefnam(String typdefnam) throws DisconnectException {
        this.typdefnam_ = typdefnam;
        if (this.typdefnam_ == null) {
            return;
        }
    }

    int getCcsidSbc() {
        return this.ccsidSbc_;
    }

    void setCcsidSbc(int ccsid) {
        this.ccsidSbc_ = ccsid;
        this.ccsidSbcSet_ = true;
        this.ccsidSbcEncoding_ = null;
    }

    void clearCcsidSbc() {
        this.ccsidSbc_ = 0;
        this.ccsidSbcSet_ = false;
        this.ccsidSbcEncoding_ = null;
    }

    boolean isCcsidSbcSet() {
        return this.ccsidSbcSet_;
    }

    String getCcsidSbcEncoding() throws DisconnectException {
        if (this.ccsidSbcEncoding_ == null) {
            this.ccsidSbcEncoding_ = UTF8ENCODING;
        }
        return this.ccsidSbcEncoding_;
    }

    int getCcsidDbc() {
        return this.ccsidDbc_;
    }

    void setCcsidDbc(int ccsid) {
        this.ccsidDbc_ = ccsid;
        this.ccsidDbcSet_ = true;
        this.ccsidDbcEncoding_ = null;
    }

    void clearCcsidDbc() {
        this.ccsidDbc_ = 0;
        this.ccsidDbcSet_ = false;
        this.ccsidDbcEncoding_ = null;
    }

    boolean isCcsidDbcSet() {
        return this.ccsidDbcSet_;
    }

    String getCcsidDbcEncoding() throws DisconnectException {
        if (this.ccsidDbcEncoding_ == null) {
            this.ccsidDbcEncoding_ = UTF8ENCODING;
        }
        return this.ccsidDbcEncoding_;
    }

    int getCcsidMbc() {
        return this.ccsidMbc_;
    }

    void setCcsidMbc(int ccsid) {
        this.ccsidMbc_ = ccsid;
        this.ccsidMbcSet_ = true;
        this.ccsidMbcEncoding_ = null;
    }

    void clearCcsidMbc() {
        this.ccsidMbc_ = 0;
        this.ccsidMbcSet_ = false;
        this.ccsidMbcEncoding_ = null;
    }

    boolean isCcsidMbcSet() {
        return this.ccsidMbcSet_;
    }

    String getCcsidMbcEncoding() throws DisconnectException {
        if (this.ccsidMbcEncoding_ == null) {
            this.ccsidMbcEncoding_ = UTF8ENCODING;
        }
        return this.ccsidMbcEncoding_;
    }

    int getByteOrder() {
        return 1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void updateColumn(NetCursor netCursor, int columnIndex, int protocolLid, int protocolLength) throws DisconnectException {
        FdocaSimpleDataArray sda = environmentTables_[protocolLid];
        if (this.mddOverride_ && this.overrideTable_[protocolLid] != null) {
            sda = this.overrideTable_[protocolLid];
        }
        if (sda == null) {
            this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("58009.C.18")));
        }
        netCursor.nullable_[columnIndex] = sda.protocolType_ % 2 == 1;
        switch (sda.ccsid_) {
            case 3: {
                netCursor.charsetName_[columnIndex] = this.getCcsidSbcEncoding();
                netCursor.ccsid_[columnIndex] = this.ccsidSbc_;
                break;
            }
            case 2: {
                if (this.isCcsidMbcSet() && this.ccsidMbc_ != 0) {
                    netCursor.charsetName_[columnIndex] = this.getCcsidMbcEncoding();
                    netCursor.ccsid_[columnIndex] = this.ccsidMbc_;
                    break;
                }
                netCursor.charsetName_[columnIndex] = null;
                netCursor.ccsid_[columnIndex] = 0;
                break;
            }
            case 1: {
                if (this.isCcsidDbcSet() && this.ccsidDbc_ != 0) {
                    netCursor.charsetName_[columnIndex] = this.getCcsidDbcEncoding();
                    netCursor.ccsid_[columnIndex] = this.ccsidDbc_;
                    break;
                }
                netCursor.charsetName_[columnIndex] = null;
                netCursor.ccsid_[columnIndex] = 0;
                break;
            }
            default: {
                netCursor.charsetName_[columnIndex] = UTF8ENCODING;
                netCursor.ccsid_[columnIndex] = sda.ccsid_;
            }
        }
        if (sda.protocolType_ >= 200 && sda.protocolType_ <= 207) {
            netCursor.fdocaLength_[columnIndex] = protocolLength;
            netCursor.hasLobs_ = true;
        } else {
            netCursor.fdocaLength_[columnIndex] = protocolLength;
        }
        netCursor.jdbcTypes_[columnIndex] = protocolToJdbcTypes_[sda.protocolType_];
        netCursor.typeToUseForComputingDataLength_[columnIndex] = sda.typeToUseForComputingDataLength_;
        switch (netCursor.typeToUseForComputingDataLength_[columnIndex]) {
            case 3: {
                netCursor.maximumRowSize_ += 17;
                break;
            }
            case 4: {
                netCursor.maximumRowSize_ += 1 + (netCursor.fdocaLength_[columnIndex] & Short.MAX_VALUE);
                break;
            }
            default: {
                netCursor.maximumRowSize_ += 1 + netCursor.fdocaLength_[columnIndex] + 2;
            }
        }
        if (sda.characterSize_ == 2) {
            netCursor.isGraphic_[columnIndex] = true;
        }
    }

    void clearMddOverrides() {
        if (!this.mddOverride_) {
            return;
        }
        this.mddOverride_ = false;
        for (int i = 0; i < 255; ++i) {
            this.overrideTable_[i] = null;
        }
    }

    void setMddOverride(int protocolType, int fdocaTripletLid, int fdocaFieldType, int ccsid, int characterSize, int mode, int length) {
        this.mddOverride_ = true;
        if (this.overrideTable_[fdocaTripletLid] == null) {
            this.overrideTable_[fdocaTripletLid] = new FdocaSimpleDataArray(protocolType, fdocaFieldType, fdocaTypeToRepresentationMap_[fdocaFieldType & 0x7F], ccsid, characterSize, mode, length, this.mapFdocaTypeToTypeToUseForComputingDataLength(fdocaFieldType));
        } else {
            this.overrideTable_[fdocaTripletLid].update(protocolType, fdocaFieldType, fdocaTypeToRepresentationMap_[fdocaFieldType & 0x7F], ccsid, characterSize, mode, length, this.mapFdocaTypeToTypeToUseForComputingDataLength(fdocaFieldType));
        }
    }

    private int mapFdocaTypeToTypeToUseForComputingDataLength(int fdocaFieldType) {
        switch (fdocaFieldType & 0x7F) {
            case 2: 
            case 17: {
                return 1;
            }
            case 48: 
            case 50: {
                return 3;
            }
            case 80: 
            case 81: {
                return 4;
            }
            case 7: 
            case 25: {
                return 2;
            }
        }
        return 0;
    }
}

