/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.info;

public abstract class JVMInfo {
    public static final int JDK_ID;
    public static final int J2SE_14 = 4;
    public static final int J2SE_142 = 5;
    public static final int J2SE_15 = 6;
    public static final int J2SE_16 = 7;
    public static final boolean J2ME;
    public static final int JAVA_SQL_TYPES_BOOLEAN;

    private static boolean vmCheck(String vmVersion, String id) {
        return vmVersion.equals(id) || vmVersion.startsWith(id + "_");
    }

    public static String derbyVMLevel() {
        switch (JDK_ID) {
            case 4: {
                return J2ME ? "J2ME - JDBC for CDC/FP 1.1" : "J2SE 1.4 - JDBC 3.0";
            }
            case 5: {
                return "J2SE 1.4.2 - JDBC 3.0";
            }
            case 6: {
                return "J2SE 5.0 - JDBC 3.0";
            }
            case 7: {
                return "Java SE 6 - JDBC 4.0";
            }
        }
        return "?-?";
    }

    static {
        boolean isJ2ME;
        int id;
        String javaVersion;
        String javaSpec;
        try {
            javaSpec = System.getProperty("java.specification.name");
        }
        catch (SecurityException se) {
            javaSpec = null;
        }
        try {
            javaVersion = System.getProperty("java.specification.version", "1.4");
        }
        catch (SecurityException se) {
            javaVersion = "1.4";
        }
        if (javaSpec != null && (javaSpec.startsWith("J2ME") || javaSpec.indexOf("Profile") > -1 && javaSpec.indexOf("Specification") > -1)) {
            id = 4;
            isJ2ME = true;
        } else {
            isJ2ME = false;
            if (javaVersion.equals("1.4")) {
                String vmVersion = System.getProperty("java.version", "1.4.0");
                id = JVMInfo.vmCheck(vmVersion, "1.4.0") || JVMInfo.vmCheck(vmVersion, "1.4.1") ? 4 : 5;
            } else if (javaVersion.equals("1.5")) {
                id = 6;
            } else if (javaVersion.equals("1.6")) {
                id = 7;
            } else {
                id = 4;
                try {
                    if (Float.valueOf(javaVersion).floatValue() > 1.6f) {
                        id = 7;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        JDK_ID = id;
        J2ME = isJ2ME;
        JAVA_SQL_TYPES_BOOLEAN = isJ2ME || id >= 4 ? 16 : -7;
    }
}

