/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ReferencedKeyConstraintDescriptor
extends KeyConstraintDescriptor {
    private final int constraintType;
    int referenceCount;
    private ConstraintDescriptorList fkEnabledConstraintList;
    private ConstraintDescriptorList fkConstraintList;
    private boolean checkedSelfReferencing;
    private boolean hasSelfReferencing;

    protected ReferencedKeyConstraintDescriptor(int constraintType, DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] columns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, boolean isEnabled, int referenceCount) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, columns, constraintId, indexId, schemaDesc, isEnabled);
        this.referenceCount = referenceCount;
        this.constraintType = constraintType;
    }

    public final int getConstraintType() {
        return this.constraintType;
    }

    public boolean hasSelfReferencingFK(ConstraintDescriptorList cdl, int type) throws StandardException {
        this.checkType(type);
        if (this.checkedSelfReferencing) {
            return this.hasSelfReferencing;
        }
        if (cdl == null) {
            cdl = this.getForeignKeyConstraints(type);
        }
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ForeignKeyConstraintDescriptor fkcd;
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!(cd instanceof ForeignKeyConstraintDescriptor) || !(fkcd = (ForeignKeyConstraintDescriptor)cd).getReferencedConstraintId().equals(this.getUUID())) continue;
            this.hasSelfReferencing = true;
            break;
        }
        return this.hasSelfReferencing;
    }

    public boolean hasNonSelfReferencingFK(int type) throws StandardException {
        boolean hasNonSelfReferenceFk = false;
        this.checkType(type);
        ConstraintDescriptorList cdl = this.getForeignKeyConstraints(type);
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ForeignKeyConstraintDescriptor fkcd;
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!(cd instanceof ForeignKeyConstraintDescriptor) || (fkcd = (ForeignKeyConstraintDescriptor)cd).getTableId().equals(this.getTableId())) continue;
            hasNonSelfReferenceFk = true;
            break;
        }
        return hasNonSelfReferenceFk;
    }

    public ConstraintDescriptorList getForeignKeyConstraints(int type) throws StandardException {
        this.checkType(type);
        if (type == 1) {
            if (!this.isReferenced()) {
                return new ConstraintDescriptorList();
            }
            if (this.fkEnabledConstraintList != null) {
                return this.fkEnabledConstraintList;
            }
            if (this.fkConstraintList == null) {
                this.fkConstraintList = this.getDataDictionary().getForeignKeys(this.constraintId);
            }
            this.fkEnabledConstraintList = this.fkConstraintList.getConstraintDescriptorList(true);
            return this.fkEnabledConstraintList;
        }
        if (type == 2) {
            if (this.fkConstraintList == null) {
                this.fkConstraintList = this.getDataDictionary().getForeignKeys(this.constraintId);
            }
            return this.fkConstraintList.getConstraintDescriptorList(false);
        }
        if (this.fkConstraintList == null) {
            this.fkConstraintList = this.getDataDictionary().getForeignKeys(this.constraintId);
        }
        return this.fkConstraintList;
    }

    public boolean isReferenced() {
        return this.referenceCount != 0;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public int incrementReferenceCount() {
        return this.referenceCount++;
    }

    public int decrementReferenceCount() {
        return this.referenceCount--;
    }

    public boolean needsToFire(int stmtType, int[] modifiedCols) {
        if (!this.isEnabled) {
            return false;
        }
        if (!this.isReferenced() || stmtType == 1) {
            return false;
        }
        if (stmtType == 4 || stmtType == 2) {
            return true;
        }
        return ReferencedKeyConstraintDescriptor.doColumnsIntersect(modifiedCols, this.getReferencedColumns());
    }

    private void checkType(int type) throws StandardException {
        switch (type) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SanityManager.THROWASSERT("constraint type " + type + " is invalid");
            }
        }
    }
}

