/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLDouble
extends NumberDataType {
    static final int DOUBLE_LENGTH = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDouble.class);
    private double value;
    private boolean isnull;

    public int getInt() throws StandardException {
        if (this.value > 2.147483648E9 || this.value < -2.147483649E9) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    public byte getByte() throws StandardException {
        if (this.value > 128.0 || this.value < -129.0) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    public short getShort() throws StandardException {
        if (this.value > 32768.0 || this.value < -32769.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    public long getLong() throws StandardException {
        if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        return (long)this.value;
    }

    public float getFloat() throws StandardException {
        if (Float.isInfinite((float)this.value)) {
            throw StandardException.newException("22003", "REAL");
        }
        return (float)this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public int typeToBigDecimal() {
        return 1;
    }

    public boolean getBoolean() {
        return this.value != 0.0;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.value);
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    void setObject(Object theValue) throws StandardException {
        this.setValue((Double)theValue);
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getDouble());
    }

    public int getLength() {
        return 32;
    }

    public String getTypeName() {
        return "DOUBLE";
    }

    public int getTypeFormatId() {
        return 79;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeDouble(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readDouble();
        this.isnull = false;
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readDouble();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0.0;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        double otherValue;
        double thisValue = this.getDouble();
        if (thisValue == (otherValue = arg.getDouble())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLDouble(this.value, this.isnull);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("error on clone,  value = " + this.value + " isnull = " + this.isnull, se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLDouble();
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
        double dv = resultSet.getDouble(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
        this.value = this.isnull ? 0.0 : NumberDataType.normalizeDOUBLE(dv);
    }

    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 8);
            return;
        }
        ps.setDouble(position, this.value);
    }

    public final void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateDouble(position, this.value);
    }

    public SQLDouble() {
        this.isnull = true;
    }

    public SQLDouble(double val) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(val);
    }

    public SQLDouble(Double obj) throws StandardException {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = NumberDataType.normalizeDOUBLE(obj);
        }
    }

    private SQLDouble(double val, boolean startsnull) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(val);
        this.isnull = startsnull;
    }

    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0.0;
            this.isnull = true;
        } else {
            double doubleValue = 0.0;
            try {
                doubleValue = Double.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.value = NumberDataType.normalizeDOUBLE(doubleValue);
            this.isnull = false;
        }
    }

    public void setValue(double theValue) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(theValue);
        this.isnull = false;
    }

    public void setValue(float theValue) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(theValue);
        this.isnull = false;
    }

    public void setValue(long theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    public void setValue(Number theValue) throws StandardException {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Double)) {
            SanityManager.THROWASSERT("SQLDouble.setValue(Number) passed a " + theValue.getClass());
        }
        this.setValue(theValue.doubleValue());
    }

    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        this.setValue(bigDecimal.doubleValue());
    }

    public void setValue(boolean theValue) {
        this.value = theValue ? 1.0 : 0.0;
        this.isnull = false;
    }

    public int typePrecedence() {
        return 90;
    }

    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() == right.getDouble());
    }

    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() != right.getDouble());
    }

    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() < right.getDouble());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() > right.getDouble());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() <= right.getDouble());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() >= right.getDouble());
    }

    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        double tmpresult = addend1.getDouble() + addend2.getDouble();
        result.setValue(tmpresult);
        return result;
    }

    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        double tmpresult = left.getDouble() - right.getDouble();
        result.setValue(tmpresult);
        return result;
    }

    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        double rightValue;
        if (result == null) {
            result = new SQLDouble();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        double leftValue = left.getDouble();
        double tempResult = leftValue * (rightValue = right.getDouble());
        if (tempResult == 0.0 && leftValue != 0.0 && rightValue != 0.0) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        result.setValue(tempResult);
        return result;
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        double divisorValue = divisor.getDouble();
        if (divisorValue == 0.0) {
            throw StandardException.newException("22012");
        }
        double dividendValue = dividend.getDouble();
        double divideResult = dividendValue / divisorValue;
        if (Double.isNaN(divideResult)) {
            throw StandardException.newException("22012");
        }
        if (divideResult == 0.0 && dividendValue != 0.0) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        result.setValue(divideResult);
        return result;
    }

    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        double minusResult = -this.getDouble();
        result.setValue(minusResult);
        return result;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0.0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Double.toString(this.value);
    }

    public int hashCode() {
        long longVal = (long)this.value;
        double doubleLongVal = longVal;
        if (doubleLongVal != this.value) {
            longVal = Double.doubleToLongBits(this.value);
        }
        return (int)(longVal ^ longVal >> 32);
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

