/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.JarDBFile;
import org.apache.derby.io.StorageFile;

public class JarStorageFactory
extends BaseStorageFactory {
    ZipFile zipData;

    StorageFile newPersistentFile(String path) {
        return new JarDBFile(this, path);
    }

    StorageFile newPersistentFile(String directoryName, String fileName) {
        if (directoryName == null || directoryName.length() == 0) {
            return this.newPersistentFile(fileName);
        }
        return new JarDBFile(this, directoryName, fileName);
    }

    StorageFile newPersistentFile(StorageFile directoryName, String fileName) {
        if (directoryName == null) {
            return this.newPersistentFile(fileName);
        }
        return new JarDBFile((JarDBFile)directoryName, fileName);
    }

    void doInit() throws IOException {
        if (this.dataDirectory == null) {
            return;
        }
        int offset = 0;
        while (offset < this.dataDirectory.length() & Character.isSpaceChar(this.dataDirectory.charAt(offset))) {
            ++offset;
        }
        int leftParen = -1;
        int rightParen = -1;
        if (offset < this.dataDirectory.length() && (leftParen = this.dataDirectory.indexOf(40, offset)) >= 0) {
            rightParen = this.dataDirectory.indexOf(41, leftParen + 1);
        }
        File jarFile = null;
        if (rightParen > 0) {
            jarFile = this.getJarFile(this.dataDirectory.substring(leftParen + 1, rightParen));
            offset = rightParen + 1;
            while (offset < this.dataDirectory.length() & Character.isSpaceChar(this.dataDirectory.charAt(offset))) {
                ++offset;
            }
            this.dataDirectory = this.dataDirectory.substring(offset, this.dataDirectory.length());
        } else {
            jarFile = this.getJarFile(this.dataDirectory);
            this.dataDirectory = "";
        }
        this.zipData = new ZipFile(jarFile);
        this.canonicalName = "(" + jarFile.getCanonicalPath() + ")" + this.dataDirectory;
        this.separatedDataDirectory = this.dataDirectory + '/';
        this.createTempDir();
    }

    public void shutdown() {
        if (this.zipData != null) {
            try {
                this.zipData.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipData = null;
        }
    }

    private File getJarFile(String name) {
        File jarFile = new File(name);
        if (this.home != null && !jarFile.isAbsolute()) {
            jarFile = new File(this.home, name);
        }
        return jarFile;
    }
}

