/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;

public class EmbedDatabaseMetaData
extends ConnectionChild
implements DatabaseMetaData,
PrivilegedAction {
    private final String url;
    private GenericConstantActionFactory constantActionFactory;
    private static Properties queryDescriptions;
    private static Properties queryDescriptions_net;

    public EmbedDatabaseMetaData(EmbedConnection connection, String url) throws SQLException {
        super(connection);
        this.url = url;
    }

    private Properties getQueryDescriptions(boolean net) {
        Properties p;
        Properties properties = p = net ? queryDescriptions_net : queryDescriptions;
        if (p != null) {
            return p;
        }
        this.loadQueryDescriptions();
        return net ? queryDescriptions_net : queryDescriptions;
    }

    private void PBloadQueryDescriptions() {
        String[] files = new String[]{"metadata.properties", "/org/apache/derby/impl/sql/catalog/metadata_net.properties"};
        Properties[] props = new Properties[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                props[i] = new Properties();
                InputStream is = this.getClass().getResourceAsStream(files[i]);
                props[i].load(is);
                is.close();
                continue;
            }
            catch (IOException ioe) {
                SanityManager.THROWASSERT("Error reading " + files[i], ioe);
            }
        }
        queryDescriptions = props[0];
        queryDescriptions_net = props[1];
    }

    public boolean allProceduresAreCallable() {
        return true;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public final String getURL() {
        if (this.url == null) {
            return this.url;
        }
        int attributeStart = this.url.indexOf(59);
        if (attributeStart == -1) {
            return this.url;
        }
        return this.url.substring(0, attributeStart);
    }

    public String getUserName() {
        return this.getEmbedConnection().getTR().getUserName();
    }

    public boolean isReadOnly() {
        return this.getLanguageConnectionContext().getDatabase().isReadOnly();
    }

    public boolean nullsAreSortedHigh() {
        return true;
    }

    public boolean nullsAreSortedLow() {
        return false;
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return Monitor.getMonitor().getEngineVersion().getProductName();
    }

    public String getDatabaseProductVersion() {
        ProductVersionHolder myPVH = Monitor.getMonitor().getEngineVersion();
        return myPVH.getVersionBuildString(true);
    }

    public String getDriverName() {
        return "Apache Derby Embedded JDBC Driver";
    }

    public String getDriverVersion() {
        return this.getDatabaseProductVersion();
    }

    public int getDriverMajorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMinorVersion();
    }

    public boolean usesLocalFiles() {
        return true;
    }

    public boolean usesLocalFilePerTable() {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "ALIAS,BIGINT,BOOLEAN,CALL,CLASS,COPY,DB2J_DEBUG,EXECUTE,EXPLAIN,FILE,FILTER,GETCURRENTCONNECTION,INDEX,INSTANCEOF,METHOD,NEW,OFF,PROPERTIES,RECOMPILE,RENAME,RUNTIMESTATISTICS,STATEMENT,STATISTICS,TIMING,WAIT";
    }

    public String getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,RADIANS,RAND,SIGN,SIN,SQRT,TAN";
    }

    public String getStringFunctions() {
        return "CONCAT,LENGTH,LCASE,LOCATE,LTRIM,RTRIM,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() {
        return "USER";
    }

    public String getTimeDateFunctions() {
        return "CURDATE,CURTIME,HOUR,MINUTE,MONTH,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,YEAR";
    }

    public String getSearchStringEscape() {
        return "";
    }

    public String getExtraNameCharacters() {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return false;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsMultipleResultSets() {
        return true;
    }

    public boolean supportsMultipleTransactions() {
        return true;
    }

    public boolean supportsNonNullableColumns() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    public String getSchemaTerm() {
        return "SCHEMA";
    }

    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    public String getCatalogTerm() {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public String getCatalogSeparator() {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsPositionedDelete() {
        return true;
    }

    public boolean supportsPositionedUpdate() {
        return true;
    }

    public boolean supportsSelectForUpdate() {
        return true;
    }

    public boolean supportsStoredProcedures() {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 128;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxCursorNameLength() {
        return 128;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public int getMaxSchemaNameLength() {
        return 128;
    }

    public int getMaxProcedureNameLength() {
        return 128;
    }

    public int getMaxCatalogNameLength() {
        return 0;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 30;
    }

    public int getDefaultTransactionIsolation() {
        return 2;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 8 || level == 4 || level == 2 || level == 1;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.doGetProcs(catalog, schemaPattern, procedureNamePattern, "getProcedures40");
    }

    public ResultSet getProceduresForODBC(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.doGetProcs(catalog, schemaPattern, procedureNamePattern, "odbc_getProcedures");
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.doGetProcs(catalog, schemaPattern, functionNamePattern, "getFunctions");
    }

    private ResultSet doGetProcs(String catalog, String schemaPattern, String procedureNamePattern, String queryName) throws SQLException {
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(procedureNamePattern));
        return s.executeQuery();
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetProcCols(catalog, schemaPattern, procedureNamePattern, columnNamePattern, "getProcedureColumns40");
    }

    public ResultSet getProcedureColumnsForODBC(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetProcCols(catalog, schemaPattern, procedureNamePattern, columnNamePattern, "odbc_getProcedureColumns");
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String parameterNamePattern) throws SQLException {
        return this.doGetProcCols(catalog, schemaPattern, functionNamePattern, parameterNamePattern, "getFunctionColumns");
    }

    private ResultSet doGetProcCols(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern, String queryName) throws SQLException {
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(2, EmbedDatabaseMetaData.swapNull(procedureNamePattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        return s.executeQuery();
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        int i;
        PreparedStatement s = this.getPreparedQuery("getTables");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        int numberOfTableTypesInDerby = 4;
        if (types == null) {
            types = new String[]{"TABLE", "VIEW", "SYNONYM", "SYSTEM TABLE"};
        }
        String[] typeParams = new String[4];
        for (i = 0; i < 4; ++i) {
            typeParams[i] = null;
        }
        for (i = 0; i < types.length; ++i) {
            if ("TABLE".equals(types[i])) {
                typeParams[0] = "T";
                continue;
            }
            if ("VIEW".equals(types[i])) {
                typeParams[1] = "V";
                continue;
            }
            if ("SYNONYM".equals(types[i])) {
                typeParams[2] = "A";
                continue;
            }
            if (!"SYSTEM TABLE".equals(types[i]) && !"SYSTEM_TABLE".equals(types[i])) continue;
            typeParams[3] = "S";
        }
        for (i = 0; i < 4; ++i) {
            if (typeParams[i] == null) {
                s.setNull(i + 4, 1);
                continue;
            }
            s.setString(i + 4, typeParams[i]);
        }
        return s.executeQuery();
    }

    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.getSimpleQuery("getCatalogs");
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.getSimpleQuery("getTableTypes");
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetCols(catalog, schemaPattern, tableNamePattern, columnNamePattern, "getColumns");
    }

    public ResultSet getColumnsForODBC(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetCols(catalog, schemaPattern, tableNamePattern, columnNamePattern, "odbc_getColumns");
    }

    private ResultSet doGetCols(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, String queryName) throws SQLException {
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        s.setString(4, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        return s.executeQuery();
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getColumnPrivileges");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        s.setString(4, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        return s.executeQuery();
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("getTablePrivileges");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        return s.executeQuery();
    }

    public ResultSet getBestRowIdentifier(String catalogPattern, String schemaPattern, String table, int scope, boolean nullable) throws SQLException {
        return this.doGetBestRowId(catalogPattern, schemaPattern, table, scope, nullable, "");
    }

    public ResultSet getBestRowIdentifierForODBC(String catalogPattern, String schemaPattern, String table, int scope, boolean nullable) throws SQLException {
        return this.doGetBestRowId(catalogPattern, schemaPattern, table, scope, nullable, "odbc_");
    }

    private ResultSet doGetBestRowId(String catalogPattern, String schemaPattern, String table, int scope, boolean nullable, String queryPrefix) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        int nullableInIntForm = 0;
        if (nullable) {
            nullableInIntForm = 1;
        }
        if (catalogPattern == null) {
            catalogPattern = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (scope < 0 || scope > 2) {
            PreparedStatement ps = this.getPreparedQuery("getBestRowIdentifierEmpty");
            return ps.executeQuery();
        }
        PreparedStatement ps = this.getPreparedQuery("getBestRowIdentifierPrimaryKey");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        ResultSet rs = ps.executeQuery();
        boolean done = rs.next();
        String constraintId = "";
        if (done) {
            constraintId = rs.getString(1);
        }
        rs.close();
        ps.close();
        if (done) {
            ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierPrimaryKeyColumns");
            ps.setString(1, constraintId);
            ps.setString(2, constraintId);
            return ps.executeQuery();
        }
        ps = this.getPreparedQuery("getBestRowIdentifierUniqueConstraint");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        rs = ps.executeQuery();
        done = rs.next();
        if (done) {
            constraintId = rs.getString(1);
        }
        rs.close();
        ps.close();
        if (done) {
            ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierUniqueKeyColumns");
            ps.setString(1, constraintId);
            ps.setString(2, constraintId);
            ps.setInt(3, nullableInIntForm);
            return ps.executeQuery();
        }
        ps = this.getPreparedQuery("getBestRowIdentifierUniqueIndex");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        rs = ps.executeQuery();
        done = rs.next();
        long indexNum = 0L;
        if (done) {
            indexNum = rs.getLong(1);
        }
        rs.close();
        ps.close();
        if (done) {
            ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierUniqueIndexColumns");
            ps.setLong(1, indexNum);
            ps.setInt(2, nullableInIntForm);
            return ps.executeQuery();
        }
        ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierAllColumns");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        ps.setInt(4, scope);
        ps.setInt(5, nullableInIntForm);
        return ps.executeQuery();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.doGetVersionCols(catalog, schema, table, "getVersionColumns");
    }

    public ResultSet getVersionColumnsForODBC(String catalog, String schema, String table) throws SQLException {
        return this.doGetVersionCols(catalog, schema, table, "odbc_getVersionColumns");
    }

    private ResultSet doGetVersionCols(String catalog, String schema, String table, String queryName) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        return s.executeQuery();
    }

    private boolean notInSoftUpgradeMode() throws SQLException {
        boolean notInSoftUpgradeMode;
        if (this.getEmbedConnection().isClosed()) {
            throw Util.noCurrentConnection();
        }
        try {
            notInSoftUpgradeMode = this.getLanguageConnectionContext().getDataDictionary().checkVersion(-1, null);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        return notInSoftUpgradeMode;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("getPrimaryKeys");
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        return s.executeQuery();
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getImportedKeys");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        return s.executeQuery();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getCrossReference");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        s.setString(4, EmbedDatabaseMetaData.swapNull(null));
        s.setString(5, EmbedDatabaseMetaData.swapNull(null));
        s.setString(6, EmbedDatabaseMetaData.swapNull(null));
        return s.executeQuery();
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryTable == null || foreignTable == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getCrossReference");
        s.setString(1, EmbedDatabaseMetaData.swapNull(primaryCatalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(primarySchema));
        s.setString(3, primaryTable);
        s.setString(4, EmbedDatabaseMetaData.swapNull(foreignCatalog));
        s.setString(5, EmbedDatabaseMetaData.swapNull(foreignSchema));
        s.setString(6, foreignTable);
        return s.executeQuery();
    }

    public ResultSet getCrossReferenceForODBC(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("odbc_getCrossReference");
        s.setString(1, EmbedDatabaseMetaData.swapNull(primaryCatalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(primarySchema));
        s.setString(3, EmbedDatabaseMetaData.swapNull(primaryTable));
        s.setString(4, EmbedDatabaseMetaData.swapNull(foreignCatalog));
        s.setString(5, EmbedDatabaseMetaData.swapNull(foreignSchema));
        s.setString(6, EmbedDatabaseMetaData.swapNull(foreignTable));
        return s.executeQuery();
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.getSimpleQuery("getTypeInfo");
    }

    public ResultSet getTypeInfoForODBC() throws SQLException {
        return this.getSimpleQuery("odbc_getTypeInfo");
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.doGetIndexInfo(catalog, schema, table, unique, approximate, "getIndexInfo");
    }

    public ResultSet getIndexInfoForODBC(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.doGetIndexInfo(catalog, schema, table, unique, approximate, "odbc_getIndexInfo");
    }

    private ResultSet doGetIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate, String queryName) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        int approximateInInt = 0;
        if (approximate) {
            approximateInInt = 1;
        }
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        s.setBoolean(4, unique);
        s.setInt(5, approximateInInt);
        return s.executeQuery();
    }

    public boolean supportsResultSetType(int type) {
        return type == 1003 || type == 1004;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type != 1005;
    }

    public boolean ownUpdatesAreVisible(int type) {
        return type == 1004;
    }

    public boolean ownDeletesAreVisible(int type) {
        return type == 1004;
    }

    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) {
        return type == 1003;
    }

    public boolean othersDeletesAreVisible(int type) {
        return type == 1003;
    }

    public boolean othersInsertsAreVisible(int type) {
        return type == 1003;
    }

    public boolean updatesAreDetected(int type) {
        return type == 1004;
    }

    public boolean deletesAreDetected(int type) {
        return type == 1004;
    }

    public boolean insertsAreDetected(int type) {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        int getClassTypes = 0;
        if (types != null && types.length >= 1) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != 2000) continue;
                getClassTypes = 1;
            }
        } else {
            getClassTypes = 1;
        }
        PreparedStatement s = this.getPreparedQuery("getUDTs");
        s.setInt(1, 2000);
        s.setString(2, catalog);
        s.setString(3, schemaPattern);
        s.setString(4, EmbedDatabaseMetaData.swapNull(typeNamePattern));
        s.setInt(5, getClassTypes);
        return s.executeQuery();
    }

    public Connection getConnection() {
        return this.getEmbedConnection().getApplicationConnection();
    }

    public boolean supportsStatementPooling() {
        return false;
    }

    public boolean supportsSavepoints() {
        return true;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    public boolean supportsResultSetHoldability(int holdability) {
        return true;
    }

    public int getResultSetHoldability() {
        return 1;
    }

    public int getDatabaseMajorVersion() {
        ProductVersionHolder pvh = Monitor.getMonitor().getEngineVersion();
        if (pvh == null) {
            return -1;
        }
        return pvh.getMajorVersion();
    }

    public int getDatabaseMinorVersion() {
        ProductVersionHolder pvh = Monitor.getMonitor().getEngineVersion();
        if (pvh == null) {
            return -1;
        }
        return pvh.getMinorVersion();
    }

    public int getJDBCMajorVersion() {
        return 3;
    }

    public int getJDBCMinorVersion() {
        return 0;
    }

    public int getSQLStateType() {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getSimpleQuery("getSuperTypes");
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getSimpleQuery("getSuperTables");
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getSimpleQuery("getAttributes");
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getSimpleQuery("getClientInfoProperties");
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("getSchemas");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        return s.executeQuery();
    }

    public ResultSet getClientCachedMetaData() throws SQLException {
        return this.getSimpleQuery("METADATA", true);
    }

    private ResultSet getSimpleQuery(String nameKey, boolean net) throws SQLException {
        PreparedStatement ps = this.getPreparedQuery(nameKey, net);
        if (ps == null) {
            return null;
        }
        return ps.executeQuery();
    }

    protected ResultSet getSimpleQuery(String nameKey) throws SQLException {
        return this.getSimpleQuery(nameKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedQueryUsingSystemTables(String nameKey, boolean net) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement ps = null;
            try {
                String queryText = this.getQueryDescriptions(net).getProperty(nameKey);
                if (queryText == null) {
                    throw Util.notImplemented(nameKey);
                }
                ps = this.prepareSPS(nameKey, queryText, net);
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            return ps;
        }
    }

    private PreparedStatement getPreparedQuery(String queryName, boolean net) throws SQLException {
        PreparedStatement s;
        if (this.notInSoftUpgradeMode() && !this.isReadOnly()) {
            s = this.getPreparedQueryUsingSystemTables(queryName, net);
        } else {
            try {
                String queryText = this.getQueryFromDescription(queryName, net);
                s = this.getEmbedConnection().prepareMetaDataStatement(queryText);
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
        }
        return s;
    }

    protected PreparedStatement getPreparedQuery(String queryName) throws SQLException {
        return this.getPreparedQuery(queryName, false);
    }

    private String getQueryFromDescription(String queryName, boolean net) throws StandardException {
        DataDictionary dd = this.getLanguageConnectionContext().getDataDictionary();
        if (!dd.checkVersion(140, null)) {
            if (queryName.equals("getColumnPrivileges")) {
                queryName = "getColumnPrivileges_10_1";
            }
            if (queryName.equals("getTablePrivileges")) {
                queryName = "getTablePrivileges_10_1";
            }
        }
        return this.getQueryDescriptions(net).getProperty(queryName);
    }

    private PreparedStatement prepareSPS(String spsName, String spsText, boolean net) throws StandardException, SQLException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        lcc.beginNestedTransaction(true);
        DataDictionary dd = this.getLanguageConnectionContext().getDataDictionary();
        SPSDescriptor spsd = dd.getSPSDescriptor(spsName, net ? dd.getSysIBMSchemaDescriptor() : dd.getSystemSchemaDescriptor());
        lcc.commitNestedTransaction();
        if (spsd == null) {
            throw Util.notImplemented(spsName);
        }
        String queryText = "EXECUTE STATEMENT " + (net ? "SYSIBM" : "SYS") + ".\"" + spsName + "\"";
        return this.getEmbedConnection().prepareMetaDataStatement(queryText);
    }

    protected static final String swapNull(String s) {
        return s == null ? "%" : s;
    }

    private GenericConstantActionFactory getGenericConstantActionFactory() throws StandardException {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory execFactory = (GenericExecutionFactory)this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
            this.constantActionFactory = execFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return this.getEmbedConnection().getLanguageConnection();
    }

    private void loadQueryDescriptions() {
        AccessController.doPrivileged(this);
    }

    public final Object run() {
        this.PBloadQueryDescriptions();
        return null;
    }
}

