/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public final class NumericConstantNode
extends ConstantNode {
    public void init(Object arg1) throws StandardException {
        boolean valueInP;
        Boolean isNullable;
        int precision = 0;
        int scal = 0;
        int maxwidth = 0;
        TypeId typeId = null;
        int typeid = 0;
        if (arg1 instanceof TypeId) {
            typeId = (TypeId)arg1;
            isNullable = Boolean.TRUE;
            valueInP = false;
            maxwidth = 0;
        } else {
            isNullable = Boolean.FALSE;
            valueInP = true;
        }
        switch (this.getNodeType()) {
            case 75: {
                precision = 5;
                scal = 0;
                if (!valueInP) break;
                maxwidth = 2;
                typeid = -6;
                this.setValue(this.getDataValueFactory().getDataValue((Byte)arg1));
                break;
            }
            case 70: {
                precision = 10;
                scal = 0;
                if (!valueInP) break;
                maxwidth = 4;
                typeid = 4;
                this.setValue(new SQLInteger((Integer)arg1));
                break;
            }
            case 74: {
                precision = 5;
                scal = 0;
                if (!valueInP) break;
                maxwidth = 2;
                typeid = 5;
                this.setValue(this.getDataValueFactory().getDataValue((Short)arg1));
                break;
            }
            case 71: {
                precision = 19;
                scal = 0;
                if (!valueInP) break;
                maxwidth = 8;
                typeid = -5;
                this.setValue(this.getDataValueFactory().getDataValue((Long)arg1));
                break;
            }
            case 67: {
                if (valueInP) {
                    NumberDataValue constantDecimal = this.getDataValueFactory().getDecimalDataValue((String)arg1);
                    typeid = 3;
                    precision = constantDecimal.getDecimalValuePrecision();
                    scal = constantDecimal.getDecimalValueScale();
                    maxwidth = DataTypeUtilities.computeMaxWidth(precision, scal);
                    this.setValue(constantDecimal);
                    break;
                }
                precision = 5;
                scal = 0;
                maxwidth = 31;
                break;
            }
            case 68: {
                precision = 52;
                scal = 0;
                if (!valueInP) break;
                maxwidth = 8;
                typeid = 8;
                this.setValue(this.getDataValueFactory().getDataValue((Double)arg1));
                break;
            }
            case 69: {
                precision = 23;
                scal = 0;
                if (!valueInP) break;
                maxwidth = 4;
                typeid = 7;
                this.setValue(this.getDataValueFactory().getDataValue((Float)arg1));
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected nodeType = " + this.getNodeType());
            }
        }
        this.setType(typeId != null ? typeId : TypeId.getBuiltInTypeId(typeid), precision, scal, isNullable, maxwidth);
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getObject();
    }

    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        switch (this.getNodeType()) {
            case 70: {
                mb.push(this.value.getInt());
                break;
            }
            case 75: {
                mb.push(this.value.getByte());
                break;
            }
            case 74: {
                mb.push(this.value.getShort());
                break;
            }
            case 67: {
                if (!JVMInfo.J2ME) {
                    mb.pushNewStart("java.math.BigDecimal");
                }
                mb.push(this.value.getString());
                if (JVMInfo.J2ME) break;
                mb.pushNewComplete(1);
                break;
            }
            case 68: {
                mb.push(this.value.getDouble());
                break;
            }
            case 69: {
                mb.push(this.value.getFloat());
                break;
            }
            case 71: {
                mb.push(this.value.getLong());
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected nodeType = " + this.getNodeType());
            }
        }
    }
}

