/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysisRequestHandlerBase
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("analysis", this.doAnalysis(req));
    }

    protected abstract NamedList doAnalysis(SolrQueryRequest var1) throws Exception;

    protected NamedList<List<NamedList>> analyzeValue(String value, AnalysisContext context) {
        Analyzer analyzer = context.getAnalyzer();
        if (!TokenizerChain.class.isInstance(analyzer)) {
            TokenStream tokenStream = null;
            try {
                tokenStream = analyzer.reusableTokenStream(context.getFieldName(), (Reader)new StringReader(value));
                tokenStream.reset();
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            NamedList namedList = new NamedList();
            namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(this.analyzeTokenStream(tokenStream), context));
            return namedList;
        }
        TokenizerChain tokenizerChain = (TokenizerChain)analyzer;
        CharFilterFactory[] cfiltfacs = tokenizerChain.getCharFilterFactories();
        TokenizerFactory tfac = tokenizerChain.getTokenizerFactory();
        TokenFilterFactory[] filtfacs = tokenizerChain.getTokenFilterFactories();
        NamedList namedList = new NamedList();
        if (cfiltfacs != null) {
            String source = value;
            for (CharFilterFactory cfiltfac : cfiltfacs) {
                CharStream reader = CharReader.get((Reader)new StringReader(source));
                reader = cfiltfac.create(reader);
                source = this.writeCharStream(namedList, reader);
            }
        }
        Tokenizer tokenStream = tfac.create(tokenizerChain.charStream(new StringReader(value)));
        List<Token> tokens = this.analyzeTokenStream((TokenStream)tokenStream);
        namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(tokens, context));
        ListBasedTokenStream listBasedTokenStream = new ListBasedTokenStream(tokens);
        for (TokenFilterFactory tokenFilterFactory : filtfacs) {
            tokenStream = tokenFilterFactory.create(listBasedTokenStream);
            List<Token> tokenList = this.analyzeTokenStream((TokenStream)tokenStream);
            namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(tokenList, context));
            listBasedTokenStream = new ListBasedTokenStream(tokenList);
        }
        return namedList;
    }

    protected List<Token> analyzeValue(String value, Analyzer analyzer) {
        TokenStream tokenStream = analyzer.tokenStream("", (Reader)new StringReader(value));
        return this.analyzeTokenStream(tokenStream);
    }

    private List<Token> analyzeTokenStream(TokenStream tokenStream) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token reusableToken = new Token();
        Token token = null;
        try {
            while ((token = tokenStream.next(reusableToken)) != null) {
                tokens.add((Token)token.clone());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error occured while iterating over tokenstream", ioe);
        }
        return tokens;
    }

    private List<NamedList> convertTokensToNamedLists(List<Token> tokens, AnalysisContext context) {
        ArrayList<NamedList> tokensNamedLists = new ArrayList<NamedList>();
        Collections.sort(tokens, new Comparator<Token>(){

            @Override
            public int compare(Token o1, Token o2) {
                return o1.endOffset() - o2.endOffset();
            }
        });
        int position = 0;
        FieldType fieldType = context.getFieldType();
        for (Token token : tokens) {
            SimpleOrderedMap tokenNamedList = new SimpleOrderedMap();
            String text = fieldType.indexedToReadable(token.term());
            tokenNamedList.add("text", (Object)text);
            if (!text.equals(token.term())) {
                tokenNamedList.add("raw_text", (Object)token.term());
            }
            tokenNamedList.add("type", (Object)token.type());
            tokenNamedList.add("start", (Object)token.startOffset());
            tokenNamedList.add("end", (Object)token.endOffset());
            tokenNamedList.add("position", (Object)(position += token.getPositionIncrement()));
            if (context.getTermsToMatch().contains(token.term())) {
                tokenNamedList.add("match", (Object)true);
            }
            if (token.getPayload() != null) {
                tokenNamedList.add("payload", (Object)token.getPayload());
            }
            tokensNamedLists.add((NamedList)tokenNamedList);
        }
        return tokensNamedLists;
    }

    private String writeCharStream(NamedList out, CharStream input) {
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        int len = 0;
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        out.add(input.getClass().getName(), (Object)sb.toString());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AnalysisContext {
        private final String fieldName;
        private final FieldType fieldType;
        private final Analyzer analyzer;
        private final Set<String> termsToMatch;

        public AnalysisContext(FieldType fieldType, Analyzer analyzer, Set<String> termsToMatch) {
            this(null, fieldType, analyzer, termsToMatch);
        }

        public AnalysisContext(String fieldName, FieldType fieldType, Analyzer analyzer) {
            this(fieldName, fieldType, analyzer, Collections.EMPTY_SET);
        }

        public AnalysisContext(String fieldName, FieldType fieldType, Analyzer analyzer, Set<String> termsToMatch) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.analyzer = analyzer;
            this.termsToMatch = termsToMatch;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Set<String> getTermsToMatch() {
            return this.termsToMatch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListBasedTokenStream
    extends TokenStream {
        private final Iterator<Token> tokenIterator;

        ListBasedTokenStream(List<Token> tokens) {
            this.tokenIterator = tokens.iterator();
        }

        public Token next(Token token) throws IOException {
            return this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        }
    }
}

