/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TrieTokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateFieldSource;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieDateField
extends DateField {
    protected int precisionStepArg;
    protected int precisionStep;

    public TrieDateField() {
        this.precisionStep = this.precisionStepArg = 8;
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String p = args.remove("precisionStep");
        if (p != null) {
            this.precisionStepArg = Integer.parseInt(p);
        }
        this.precisionStep = this.precisionStepArg;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
        CharFilterFactory[] filterFactories = new CharFilterFactory[]{};
        TokenFilterFactory[] tokenFilterFactories = new TokenFilterFactory[]{};
        this.analyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(TrieField.TrieTypes.DATE, this.precisionStep), tokenFilterFactories);
        this.queryAnalyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(TrieField.TrieTypes.DATE, Integer.MAX_VALUE), tokenFilterFactories);
    }

    @Override
    public Date toObject(Fieldable f) {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, TrieField.badFieldString(f));
        }
        return new Date(TrieField.toLong(arr));
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_LONG_PARSER, top);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        return new TrieDateFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return new TrieDateFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            xmlWriter.writeStr(name, TrieField.badFieldString(f));
            return;
        }
        xmlWriter.writeDate(name, new Date(TrieField.toLong(arr)));
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            writer.writeStr(name, TrieField.badFieldString(f), true);
            return;
        }
        writer.writeDate(name, new Date(TrieField.toLong(arr)));
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public int getPrecisionStep() {
        return this.precisionStepArg;
    }

    @Override
    public String storedToReadable(Fieldable f) {
        return this.toExternal(f);
    }

    @Override
    public String readableToIndexed(String val) {
        return NumericUtils.longToPrefixCoded((long)super.parseMath(null, val).getTime());
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    @Override
    public String toExternal(Fieldable f) {
        byte[] arr = f.binaryValue();
        if (arr == null) {
            return TrieField.badFieldString(f);
        }
        return super.toExternal(new Date(TrieField.toLong(arr)));
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return super.toExternal(new Date(NumericUtils.prefixCodedToLong((String)indexedForm)));
    }

    @Override
    public String storedToIndexed(Fieldable f) {
        return this.readableToIndexed(this.storedToReadable(f));
    }

    @Override
    public Field createField(SchemaField field, String externalVal, float boost) {
        Field f;
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        if (!indexed && !stored) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        int ps = this.precisionStep;
        byte[] arr = null;
        NumericTokenStream ts = null;
        long time = super.parseMath(null, externalVal).getTime();
        if (stored) {
            arr = TrieField.toArr(time);
        }
        if (indexed) {
            ts = new NumericTokenStream(ps).setLongValue(time);
        }
        if (stored) {
            f = new Field(field.getName(), arr, Field.Store.YES);
            if (indexed) {
                f.setTokenStream((TokenStream)ts);
            }
        } else {
            f = new Field(field.getName(), (TokenStream)ts);
        }
        f.setOmitNorms(field.omitNorms());
        f.setOmitTermFreqAndPositions(field.omitTf());
        f.setBoost(boost);
        return f;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        return this.getRangeQuery(parser, field, min == null ? null : super.parseMath(null, min), max == null ? null : super.parseMath(null, max), minInclusive, maxInclusive);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField sf, Date min, Date max, boolean minInclusive, boolean maxInclusive) {
        int ps = this.precisionStep;
        NumericRangeQuery query = NumericRangeQuery.newLongRange((String)sf.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(min.getTime())), (Long)(max == null ? null : Long.valueOf(max.getTime())), (boolean)minInclusive, (boolean)maxInclusive);
        return query;
    }
}

