/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInjectionEngine {
    private final MockUtil mockUtil = new MockUtil();

    public void injectMocksOnFields(Set<Field> testClassFields, Set<Object> mocks, Object testClass) {
        for (Field field : testClassFields) {
            Object fieldInstance = null;
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                fieldInstance = field.get(testClass);
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems injecting dependencies in " + field.getName(), e);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
            for (Class<?> fieldClass = fieldInstance.getClass(); fieldClass != Object.class; fieldClass = fieldClass.getSuperclass()) {
                this.injectMockCandidate(fieldClass, mocks, fieldInstance);
            }
        }
    }

    private void injectMockCandidate(Class<?> awaitingInjectionClazz, Set<Object> mocks, Object fieldInstance) {
        for (Field field : awaitingInjectionClazz.getDeclaredFields()) {
            List<Object> mockCandidates = this.selectMockCondidatesOnType(mocks, field.getType());
            if (mockCandidates.size() > 1) {
                mockCandidates = this.selectMockCandidateOnName(mockCandidates, field.getName());
            }
            if (mockCandidates.size() != 1) continue;
            this.inject(field, fieldInstance, mockCandidates.get(0));
        }
    }

    private void inject(Field field, Object fieldInstance, Object matchingMock) {
        try {
            new FieldSetter(fieldInstance, field).set(matchingMock);
        }
        catch (Exception e) {
            throw new MockitoException("Problems injecting dependency in " + field.getName(), e);
        }
    }

    private List<Object> selectMockCandidateOnName(Collection<Object> mocks, String fieldName) {
        ArrayList<Object> mockNameMatches = new ArrayList<Object>();
        for (Object mock : mocks) {
            if (!fieldName.equals(this.mockUtil.getMockName(mock).toString())) continue;
            mockNameMatches.add(mock);
        }
        return mockNameMatches;
    }

    private List<Object> selectMockCondidatesOnType(Collection<Object> mocks, Class<?> fieldClass) {
        ArrayList<Object> mockTypeMatches = new ArrayList<Object>();
        for (Object mock : mocks) {
            if (!fieldClass.isAssignableFrom(mock.getClass())) continue;
            mockTypeMatches.add(mock);
        }
        return mockTypeMatches;
    }
}

