/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.io.Serializable;
import org.mockito.MockSettings;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.listeners.MockingProgressListener;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.IOngoingStubbing;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.MockingProgressImpl;
import org.mockito.verification.VerificationMode;

public class ThreadSafeMockingProgress
implements MockingProgress,
Serializable {
    private static final long serialVersionUID = 6839454041642082618L;
    private static ThreadLocal<MockingProgress> mockingProgress = new ThreadLocal();

    static MockingProgress threadSafely() {
        if (mockingProgress.get() == null) {
            mockingProgress.set(new MockingProgressImpl());
        }
        return mockingProgress.get();
    }

    public void reportOngoingStubbing(IOngoingStubbing iOngoingStubbing) {
        ThreadSafeMockingProgress.threadSafely().reportOngoingStubbing(iOngoingStubbing);
    }

    public IOngoingStubbing pullOngoingStubbing() {
        return ThreadSafeMockingProgress.threadSafely().pullOngoingStubbing();
    }

    public void verificationStarted(VerificationMode verify) {
        ThreadSafeMockingProgress.threadSafely().verificationStarted(verify);
    }

    public VerificationMode pullVerificationMode() {
        return ThreadSafeMockingProgress.threadSafely().pullVerificationMode();
    }

    public void stubbingStarted() {
        ThreadSafeMockingProgress.threadSafely().stubbingStarted();
    }

    public void validateState() {
        ThreadSafeMockingProgress.threadSafely().validateState();
    }

    public void stubbingCompleted(Invocation invocation) {
        ThreadSafeMockingProgress.threadSafely().stubbingCompleted(invocation);
    }

    public String toString() {
        return ThreadSafeMockingProgress.threadSafely().toString();
    }

    public void reset() {
        ThreadSafeMockingProgress.threadSafely().reset();
    }

    public void resetOngoingStubbing() {
        ThreadSafeMockingProgress.threadSafely().resetOngoingStubbing();
    }

    public ArgumentMatcherStorage getArgumentMatcherStorage() {
        return ThreadSafeMockingProgress.threadSafely().getArgumentMatcherStorage();
    }

    public void mockingStarted(Object mock, Class classToMock, MockSettings mockSettings) {
        ThreadSafeMockingProgress.threadSafely().mockingStarted(mock, classToMock, mockSettings);
    }

    public void setListener(MockingProgressListener listener) {
        ThreadSafeMockingProgress.threadSafely().setListener(listener);
    }
}

