/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoidMethodStubbableImpl<T>
implements VoidMethodStubbable<T> {
    private final T mock;
    private InvocationContainerImpl invocationContainerImpl;

    public VoidMethodStubbableImpl(T mock, InvocationContainerImpl invocationContainerImpl) {
        this.mock = mock;
        this.invocationContainerImpl = invocationContainerImpl;
    }

    @Override
    public VoidMethodStubbable<T> toThrow(Throwable throwable) {
        this.invocationContainerImpl.addAnswerForVoidMethod(new ThrowsException(throwable));
        return this;
    }

    @Override
    public VoidMethodStubbable<T> toReturn() {
        this.invocationContainerImpl.addAnswerForVoidMethod(new DoesNothing());
        return this;
    }

    @Override
    public VoidMethodStubbable<T> toAnswer(Answer<?> answer) {
        this.invocationContainerImpl.addAnswerForVoidMethod(answer);
        return this;
    }

    @Override
    public T on() {
        return this.mock;
    }
}

