/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswersValidator {
    private Reporter reporter = new Reporter();

    public void validate(Answer<?> answer, Invocation invocation) {
        if (answer instanceof ThrowsException) {
            this.validateException((ThrowsException)answer, invocation);
        }
        if (answer instanceof Returns) {
            this.validateReturnValue((Returns)answer, invocation);
        }
        if (answer instanceof DoesNothing) {
            this.validateDoNothing((DoesNothing)answer, invocation);
        }
        if (answer instanceof CallsRealMethods) {
            this.validateMockingConcreteClass((CallsRealMethods)answer, invocation);
        }
    }

    private void validateMockingConcreteClass(CallsRealMethods answer, Invocation invocation) {
        if (invocation.isDeclaredOnInterface()) {
            this.reporter.cannotCallRealMethodOnInterface();
        }
    }

    private void validateDoNothing(DoesNothing answer, Invocation invocation) {
        if (!invocation.isVoid()) {
            this.reporter.onlyVoidMethodsCanBeSetToDoNothing();
        }
    }

    private void validateReturnValue(Returns answer, Invocation invocation) {
        if (invocation.isVoid()) {
            this.reporter.cannotStubVoidMethodWithAReturnValue(invocation.getMethod().getName());
        }
        if (answer.returnsNull() && invocation.returnsPrimitive()) {
            this.reporter.wrongTypeOfReturnValue(invocation.printMethodReturnType(), "null", invocation.getMethodName());
        }
        if (!answer.returnsNull() && !invocation.isValidReturnType(answer.getReturnType())) {
            this.reporter.wrongTypeOfReturnValue(invocation.printMethodReturnType(), answer.printReturnType(), invocation.getMethodName());
        }
    }

    private void validateException(ThrowsException answer, Invocation invocation) {
        Throwable throwable = answer.getThrowable();
        if (throwable == null) {
            this.reporter.cannotStubWithNullThrowable();
        }
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return;
        }
        if (!invocation.isValidException(throwable)) {
            this.reporter.checkedExceptionInvalid(throwable);
        }
    }
}

