/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogExecutorService;
import org.apache.cassandra.db.commitlog.BatchCommitLogExecutorServiceMBean;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ICommitLogExecutorService;
import org.apache.cassandra.utils.WrappedRunnable;

class BatchCommitLogExecutorService
extends AbstractCommitLogExecutorService
implements ICommitLogExecutorService,
BatchCommitLogExecutorServiceMBean {
    private final BlockingQueue<CheaterFutureTask> queue;
    private final ArrayList<CheaterFutureTask> incompleteTasks = new ArrayList();
    private final ArrayList taskValues = new ArrayList();

    public BatchCommitLogExecutorService() {
        this(DatabaseDescriptor.getConcurrentWriters());
    }

    public BatchCommitLogExecutorService(int queueSize) {
        this.queue = new LinkedBlockingQueue<CheaterFutureTask>(queueSize);
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                while (true) {
                    BatchCommitLogExecutorService.this.processWithSyncBatch();
                    ++BatchCommitLogExecutorService.this.completedTaskCount;
                }
            }
        };
        new Thread((Runnable)runnable, "COMMIT-LOG-WRITER").start();
        BatchCommitLogExecutorService.registerMBean(this);
    }

    @Override
    public long getPendingTasks() {
        return this.queue.size();
    }

    private void processWithSyncBatch() throws Exception {
        CheaterFutureTask firstTask = this.queue.take();
        if (!(firstTask.getRawCallable() instanceof CommitLog.LogRecordAdder)) {
            firstTask.run();
            return;
        }
        this.incompleteTasks.clear();
        this.taskValues.clear();
        long end = System.nanoTime() + (long)(1000000.0 * DatabaseDescriptor.getCommitLogSyncBatchWindow());
        this.incompleteTasks.add(firstTask);
        this.taskValues.add(firstTask.getRawCallable().call());
        while (!this.queue.isEmpty() && ((CheaterFutureTask)this.queue.peek()).getRawCallable() instanceof CommitLog.LogRecordAdder && System.nanoTime() < end) {
            CheaterFutureTask task = (CheaterFutureTask)this.queue.remove();
            this.incompleteTasks.add(task);
            this.taskValues.add(task.getRawCallable().call());
        }
        try {
            CommitLog.instance.sync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.incompleteTasks.size(); ++i) {
            this.incompleteTasks.get(i).set(this.taskValues.get(i));
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new CheaterFutureTask<T>(callable);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.queue.put((CheaterFutureTask)command);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(CommitLog.LogRecordAdder adder) {
        try {
            this.submit(adder).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CheaterFutureTask<V>
    extends FutureTask<V> {
        private final Callable rawCallable;

        public CheaterFutureTask(Callable<V> callable) {
            super(callable);
            this.rawCallable = callable;
        }

        public Callable getRawCallable() {
            return this.rawCallable;
        }

        @Override
        public void set(V v) {
            super.set(v);
        }
    }
}

