/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.UUIDGen;

public class TimeUUIDType
extends AbstractType {
    public static final TimeUUIDType instance = new TimeUUIDType();

    TimeUUIDType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        int res = TimeUUIDType.compareTimestampBytes(o1, o2);
        if (res != 0) {
            return res;
        }
        return o1.compareTo(o2);
    }

    private static int compareTimestampBytes(ByteBuffer o1, ByteBuffer o2) {
        int o1Pos = o1.position() + o1.arrayOffset();
        int o2Pos = o2.position() + o2.arrayOffset();
        int d = (o1.array()[o1Pos + 6] & 0xF) - (o2.array()[o2Pos + 6] & 0xF);
        if (d != 0) {
            return d;
        }
        d = (o1.array()[o1Pos + 7] & 0xFF) - (o2.array()[o2Pos + 7] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.array()[o1Pos + 4] & 0xFF) - (o2.array()[o2Pos + 4] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.array()[o1Pos + 5] & 0xFF) - (o2.array()[o2Pos + 5] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.array()[o1Pos + 0] & 0xFF) - (o2.array()[o2Pos + 0] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.array()[o1Pos + 1] & 0xFF) - (o2.array()[o2Pos + 1] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.array()[o1Pos + 2] & 0xFF) - (o2.array()[o2Pos + 2] & 0xFF);
        if (d != 0) {
            return d;
        }
        return (o1.array()[o1Pos + 3] & 0xFF) - (o2.array()[o2Pos + 3] & 0xFF);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        UUID uuid = UUIDGen.getUUID(bytes);
        if (uuid.version() != 1) {
            throw new MarshalException("TimeUUID only makes sense with version 1 UUIDs");
        }
        return uuid.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        UUID uuid = UUID.fromString(source);
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("TimeUUID supports only version 1 UUIDs");
        }
        return ByteBuffer.wrap(UUIDGen.decompose(uuid));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 16 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("TimeUUID should be 16 or 0 bytes (%d)", bytes.remaining()));
        }
        ByteBuffer slice = bytes.slice();
        if (bytes.remaining() > 0) {
            slice.position(6);
            if ((slice.get() & 0xF0) != 16) {
                throw new MarshalException("Invalid version for TimeUUID type.");
            }
        }
    }
}

