/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.connection.BackgroundCassandraHostService;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.connection.HThriftClient;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ExceptionsTranslator;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHostRetryService
extends BackgroundCassandraHostService {
    private static Logger log = LoggerFactory.getLogger(CassandraHostRetryService.class);
    public static final int DEF_QUEUE_SIZE = 3;
    public static final int DEF_RETRY_DELAY = 10;
    private final LinkedBlockingQueue<CassandraHost> downedHostQueue;
    private final ExceptionsTranslator exceptionsTranslator;

    public CassandraHostRetryService(HConnectionManager connectionManager, CassandraHostConfigurator cassandraHostConfigurator) {
        super(connectionManager, cassandraHostConfigurator);
        this.exceptionsTranslator = connectionManager.exceptionsTranslator;
        this.retryDelayInSeconds = cassandraHostConfigurator.getRetryDownedHostsDelayInSeconds();
        this.downedHostQueue = new LinkedBlockingQueue(cassandraHostConfigurator.getRetryDownedHostsQueueSize());
        this.sf = this.executor.scheduleWithFixedDelay(new RetryRunner(), this.retryDelayInSeconds, this.retryDelayInSeconds, TimeUnit.SECONDS);
        log.info("Downed Host Retry service started with queue size {} and retry delay {}s", (Object)cassandraHostConfigurator.getRetryDownedHostsQueueSize(), (Object)this.retryDelayInSeconds);
    }

    @Override
    void shutdown() {
        log.info("Downed Host retry shutdown hook called");
        if (this.sf != null) {
            this.sf.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        log.info("Downed Host retry shutdown complete");
    }

    public void add(CassandraHost cassandraHost) {
        this.downedHostQueue.add(cassandraHost);
        if (log.isInfoEnabled()) {
            log.info("Host detected as down was added to retry queue: {}", (Object)cassandraHost.getName());
        }
    }

    public boolean contains(CassandraHost cassandraHost) {
        return this.downedHostQueue.contains(cassandraHost);
    }

    public Set<CassandraHost> getDownedHosts() {
        return Collections.unmodifiableSet(new HashSet<CassandraHost>(this.downedHostQueue));
    }

    @Override
    public void applyRetryDelay() {
        this.sf.cancel(false);
        this.executor.schedule(new RetryRunner(), (long)this.retryDelayInSeconds, TimeUnit.SECONDS);
    }

    public void flushQueue() {
        this.downedHostQueue.clear();
        log.info("Downed Host retry queue flushed.");
    }

    class RetryRunner
    implements Runnable {
        RetryRunner() {
        }

        @Override
        public void run() {
            CassandraHost cassandraHost = (CassandraHost)CassandraHostRetryService.this.downedHostQueue.poll();
            if (cassandraHost == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Retry service fired... nothing to do.");
                }
                return;
            }
            boolean reconnected = this.verifyConnection(cassandraHost);
            log.info("Downed Host retry status {} with host: {}", (Object)reconnected, (Object)cassandraHost.getName());
            if (reconnected) {
                CassandraHostRetryService.this.connectionManager.addCassandraHost(cassandraHost);
            }
            if (!reconnected && cassandraHost != null) {
                CassandraHostRetryService.this.downedHostQueue.add(cassandraHost);
            }
        }

        private boolean verifyConnection(CassandraHost cassandraHost) {
            if (cassandraHost == null) {
                return false;
            }
            boolean found = false;
            HThriftClient client = new HThriftClient(cassandraHost);
            try {
                client.open();
                found = client.getCassandra().describe_cluster_name() != null;
                client.close();
            }
            catch (HectorTransportException he) {
                log.error("Downed {} host still appears to be down: {}", (Object)cassandraHost, (Object)he.getMessage());
            }
            catch (Exception ex) {
                log.error("Downed Host retry failed attempt to verify CassandraHost", (Throwable)ex);
            }
            return found;
        }
    }
}

