/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.prettyprint.cassandra.connection.CassandraHostRetryService;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.HThriftClient;
import me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import me.prettyprint.cassandra.connection.NodeAutoDiscoverService;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ExceptionsTranslator;
import me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.JmxMonitor;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.hector.api.ClockResolution;
import me.prettyprint.hector.api.exceptions.HCassandraInternalException;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.exceptions.HTimedOutException;
import me.prettyprint.hector.api.exceptions.HUnavailableException;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import me.prettyprint.hector.api.exceptions.PoolExhaustedException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(HConnectionManager.class);
    private static final Logger perf4jLogger = LoggerFactory.getLogger((String)"me.prettyprint.cassandra.hector.TimingLogger");
    private final NonBlockingHashMap<CassandraHost, ConcurrentHClientPool> hostPools;
    private CassandraHostRetryService cassandraHostRetryService;
    private NodeAutoDiscoverService nodeAutoDiscoverService;
    private LoadBalancingPolicy loadBalancingPolicy;
    private final ClockResolution clock;
    final ExceptionsTranslator exceptionsTranslator;
    private CassandraClientMonitor monitor;

    public HConnectionManager(CassandraHostConfigurator cassandraHostConfigurator) {
        this.loadBalancingPolicy = cassandraHostConfigurator.getLoadBalancingPolicy();
        this.clock = cassandraHostConfigurator.getClockResolution();
        this.hostPools = new NonBlockingHashMap();
        if (cassandraHostConfigurator.getRetryDownedHosts()) {
            this.cassandraHostRetryService = new CassandraHostRetryService(this, cassandraHostConfigurator);
        }
        for (CassandraHost host : cassandraHostConfigurator.buildCassandraHosts()) {
            try {
                ConcurrentHClientPool chcp = new ConcurrentHClientPool(host);
                this.hostPools.put((Object)host, (Object)chcp);
            }
            catch (HectorTransportException hte) {
                log.error("Could not start connection pool for host {}", (Object)host);
                if (this.cassandraHostRetryService == null) continue;
                this.cassandraHostRetryService.add(host);
            }
        }
        if (cassandraHostConfigurator.getAutoDiscoverHosts()) {
            this.nodeAutoDiscoverService = new NodeAutoDiscoverService(this, cassandraHostConfigurator);
        }
        this.monitor = JmxMonitor.getInstance(this).getCassandraMonitor();
        this.exceptionsTranslator = new ExceptionsTranslatorImpl();
    }

    public void addCassandraHost(CassandraHost cassandraHost) {
        if (!this.getHosts().contains(cassandraHost)) {
            this.hostPools.put((Object)cassandraHost, (Object)new ConcurrentHClientPool(cassandraHost));
            log.info("Added host {} to pool", (Object)cassandraHost.getName());
        } else {
            log.info("Host already existed for pool {}", (Object)cassandraHost.getName());
        }
    }

    public void removeCassandraHost(CassandraHost cassandraHost) {
        boolean removed = this.getHosts().contains(cassandraHost);
        if (removed) {
            ConcurrentHClientPool pool = (ConcurrentHClientPool)this.hostPools.remove((Object)cassandraHost);
            if (pool != null) {
                pool.shutdown();
            } else {
                removed = false;
                log.info("removeCassandraHost attempt miss for CassandraHost {} May have been beaten by another thread?", (Object)cassandraHost);
            }
        }
        log.info("Remove status for CassandraHost pool {} was {}", (Object)cassandraHost, (Object)removed);
    }

    public Set<CassandraHost> getHosts() {
        return Collections.unmodifiableSet(this.hostPools.keySet());
    }

    public List<String> getStatusPerPool() {
        ArrayList<String> stats = new ArrayList<String>();
        for (ConcurrentHClientPool clientPool : this.hostPools.values()) {
            stats.add(clientPool.getStatusAsString());
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operateWithFailover(Operation<?> op) throws HectorException {
        Slf4JStopWatch stopWatch = new Slf4JStopWatch(perf4jLogger);
        int retries = Math.min(op.failoverPolicy.numRetries, this.hostPools.size());
        HThriftClient client = null;
        boolean success = false;
        boolean retryable = false;
        HashSet<CassandraHost> excludeHosts = new HashSet<CassandraHost>();
        while (!success) {
            try {
                client = this.getClientFromLBPolicy(excludeHosts);
                Cassandra.Client c = client.getCassandra();
                if (op.keyspaceName != null) {
                    c.set_keyspace(op.keyspaceName);
                }
                if (!op.credentials.isEmpty()) {
                    c.login(new AuthenticationRequest(op.credentials));
                }
                op.executeAndSetResult(c, client.cassandraHost);
                success = true;
                stopWatch.stop(op.stopWatchTagName + ".success_");
                break;
            }
            catch (Exception ex) {
                HectorException he = this.exceptionsTranslator.translate(ex);
                if (he instanceof HInvalidRequestException || he instanceof HCassandraInternalException) {
                    throw he;
                }
                if (he instanceof HUnavailableException || he instanceof HectorTransportException) {
                    --retries;
                    client.close();
                    this.markHostAsDown(client);
                    excludeHosts.add(client.cassandraHost);
                    retryable = true;
                    if (retries > 0) {
                        this.monitor.incCounter(CassandraClientMonitor.Counter.RECOVERABLE_TRANSPORT_EXCEPTIONS);
                    }
                } else if (he instanceof HTimedOutException) {
                    retryable = true;
                    this.monitor.incCounter(CassandraClientMonitor.Counter.RECOVERABLE_TIMED_OUT_EXCEPTIONS);
                    client.close();
                } else if (he instanceof PoolExhaustedException) {
                    retryable = true;
                    --retries;
                    if (this.hostPools.size() == 1) {
                        throw he;
                    }
                    this.monitor.incCounter(CassandraClientMonitor.Counter.POOL_EXHAUSTED);
                    excludeHosts.add(client.cassandraHost);
                }
                if (retries == 0 || !retryable) {
                    throw he;
                }
                log.error("Could not fullfill request on this host {}", (Object)client);
                log.error("Exception: ", (Throwable)he);
                this.monitor.incCounter(CassandraClientMonitor.Counter.SKIP_HOST_SUCCESS);
                this.sleepBetweenHostSkips(op.failoverPolicy);
            }
            finally {
                if (!success) {
                    this.monitor.incCounter(op.failCounter);
                    stopWatch.stop(op.stopWatchTagName + ".fail_");
                }
                this.releaseClient(client);
            }
        }
    }

    private void sleepBetweenHostSkips(FailoverPolicy failoverPolicy) {
        if (failoverPolicy.sleepBetweenHostsMilli > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Will sleep for {} millisec", (Object)failoverPolicy.sleepBetweenHostsMilli);
            }
            try {
                Thread.sleep(failoverPolicy.sleepBetweenHostsMilli);
            }
            catch (InterruptedException e) {
                log.warn("Sleep between hosts interrupted", (Throwable)e);
            }
        }
    }

    private HThriftClient getClientFromLBPolicy(Set<CassandraHost> excludeHosts) {
        HThriftClient client;
        if (this.hostPools.size() == 0) {
            throw new HectorException("All host pools marked down. Retry burden pushed out to client.");
        }
        try {
            client = this.loadBalancingPolicy.getPool(this.hostPools.values(), excludeHosts).borrowClient();
        }
        catch (Exception e) {
            throw new HectorException("General exception in getClientFromLBPolicy", e);
        }
        return client;
    }

    void releaseClient(HThriftClient client) {
        if (client == null) {
            return;
        }
        ConcurrentHClientPool pool = (ConcurrentHClientPool)this.hostPools.get((Object)client.cassandraHost);
        if (pool != null) {
            pool.releaseClient(client);
        } else {
            log.info("Client {} released to inactive or dead pool. Closing.", (Object)client);
            client.close();
        }
    }

    HThriftClient borrowClient() {
        return this.getClientFromLBPolicy(null);
    }

    void markHostAsDown(HThriftClient client) {
        log.error("MARK HOST AS DOWN TRIGGERED for host {}", (Object)client.cassandraHost.getName());
        ConcurrentHClientPool pool = (ConcurrentHClientPool)this.hostPools.remove((Object)client.cassandraHost);
        if (pool != null) {
            log.error("Pool state on shutdown: {}", (Object)pool.getStatusAsString());
            pool.shutdown();
            this.cassandraHostRetryService.add(client.cassandraHost);
        }
        client.close();
    }

    public Set<CassandraHost> getDownedHosts() {
        return this.cassandraHostRetryService.getDownedHosts();
    }

    public Collection<ConcurrentHClientPool> getActivePools() {
        return Collections.unmodifiableCollection(this.hostPools.values());
    }

    public long createClock() {
        return this.clock.createClock();
    }

    public void shutdown() {
        log.info("Shutdown called on HConnectionManager");
        if (this.cassandraHostRetryService != null) {
            this.cassandraHostRetryService.shutdown();
        }
        if (this.nodeAutoDiscoverService != null) {
            this.nodeAutoDiscoverService.shutdown();
        }
        for (ConcurrentHClientPool pool : this.hostPools.values()) {
            try {
                pool.shutdown();
            }
            catch (IllegalArgumentException iae) {
                log.error("Out of order in HConnectionManager shutdown()?: {}", (Object)iae.getMessage());
            }
        }
    }
}

