/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.Collections;
import java.util.Map;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.model.ExecutionResult;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.KeyspaceServiceImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.exceptions.HectorException;

public class ExecutingKeyspace
implements Keyspace {
    private static final Map<String, String> EMPTY_CREDENTIALS = Collections.emptyMap();
    private ConsistencyLevelPolicy consistencyLevelPolicy;
    private FailoverPolicy failoverPolicy;
    private final HConnectionManager connectionManager;
    private final String keyspace;
    private final Map<String, String> credentials;

    public ExecutingKeyspace(String keyspace, HConnectionManager connectionManager, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy) {
        this(keyspace, connectionManager, consistencyLevelPolicy, failoverPolicy, EMPTY_CREDENTIALS);
    }

    public ExecutingKeyspace(String keyspace, HConnectionManager connectionManager, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        Assert.noneNull(keyspace, consistencyLevelPolicy, connectionManager);
        this.keyspace = keyspace;
        this.connectionManager = connectionManager;
        this.consistencyLevelPolicy = consistencyLevelPolicy;
        this.failoverPolicy = failoverPolicy;
        this.credentials = credentials;
    }

    @Override
    public void setConsistencyLevelPolicy(ConsistencyLevelPolicy cp) {
        this.consistencyLevelPolicy = cp;
    }

    public String toString() {
        return "ExecutingKeyspace(" + this.keyspace + "," + this.connectionManager + ")";
    }

    @Override
    public long createClock() {
        return this.connectionManager.createClock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ExecutionResult<T> doExecute(KeyspaceOperationCallback<T> koc) throws HectorException {
        KeyspaceServiceImpl ks = null;
        try {
            ks = new KeyspaceServiceImpl(this.keyspace, this.consistencyLevelPolicy, this.connectionManager, this.failoverPolicy, this.credentials);
            ExecutionResult<T> executionResult = koc.doInKeyspaceAndMeasure(ks);
            return executionResult;
        }
        finally {
            if (ks != null) {
                // empty if block
            }
        }
    }
}

