/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.prettyprint.hector.api.Serializer;

public abstract class AbstractSerializer<T>
implements Serializer<T> {
    @Override
    public abstract ByteBuffer toByteBuffer(T var1);

    @Override
    public byte[] toBytes(T obj) {
        ByteBuffer bb = this.toByteBuffer(obj);
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public T fromBytes(byte[] bytes) {
        return this.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    @Override
    public abstract T fromByteBuffer(ByteBuffer var1);

    @Override
    public Set<ByteBuffer> toBytesSet(List<T> list) {
        HashSet<ByteBuffer> bytesList = new HashSet<ByteBuffer>();
        for (T s : list) {
            bytesList.add(this.toByteBuffer(s));
        }
        return bytesList;
    }

    @Override
    public List<T> fromBytesSet(Set<ByteBuffer> set) {
        ArrayList<T> objList = new ArrayList<T>();
        for (ByteBuffer b : set) {
            objList.add(this.fromByteBuffer(b));
        }
        return objList;
    }

    @Override
    public List<ByteBuffer> toBytesList(List<T> list) {
        ArrayList<ByteBuffer> bytesList = new ArrayList<ByteBuffer>();
        for (T s : list) {
            bytesList.add(this.toByteBuffer(s));
        }
        return bytesList;
    }

    @Override
    public List<T> fromBytesList(List<ByteBuffer> list) {
        ArrayList<T> objList = new ArrayList<T>();
        for (ByteBuffer s : list) {
            objList.add(this.fromByteBuffer(s));
        }
        return objList;
    }

    @Override
    public <V> Map<ByteBuffer, V> toBytesMap(Map<T, V> map) {
        LinkedHashMap<ByteBuffer, V> bytesMap = new LinkedHashMap<ByteBuffer, V>();
        for (Map.Entry<T, V> entry : map.entrySet()) {
            bytesMap.put(this.toByteBuffer(entry.getKey()), entry.getValue());
        }
        return bytesMap;
    }

    @Override
    public <V> Map<T, V> fromBytesMap(Map<ByteBuffer, V> map) {
        LinkedHashMap<T, V> objMap = new LinkedHashMap<T, V>();
        for (Map.Entry<ByteBuffer, V> entry : map.entrySet()) {
            objMap.put(this.fromByteBuffer(entry.getKey()), entry.getValue());
        }
        return objMap;
    }
}

