/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ExceptionsTranslator;
import me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.JmxMonitor;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.hector.api.ClockResolution;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCluster
implements Cluster {
    private static final Map<String, String> EMPTY_CREDENTIALS = Collections.emptyMap();
    private final Logger log = LoggerFactory.getLogger(AbstractCluster.class);
    protected final HConnectionManager connectionManager;
    private final String name;
    private final CassandraHostConfigurator configurator;
    private final ClockResolution clockResolution = CassandraHost.DEFAULT_TIMESTAMP_RESOLUTION;
    private final FailoverPolicy failoverPolicy;
    private final CassandraClientMonitor cassandraClientMonitor;
    private Set<String> knownClusterHosts;
    private Set<CassandraHost> knownPoolHosts;
    protected final ExceptionsTranslator xtrans;
    private final Map<String, String> credentials;

    public AbstractCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        this(clusterName, cassandraHostConfigurator, EMPTY_CREDENTIALS);
    }

    public AbstractCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator, Map<String, String> credentials) {
        this.connectionManager = new HConnectionManager(cassandraHostConfigurator);
        this.name = clusterName;
        this.configurator = cassandraHostConfigurator;
        this.failoverPolicy = FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE;
        this.cassandraClientMonitor = JmxMonitor.getInstance(this.connectionManager).getCassandraMonitor();
        this.xtrans = new ExceptionsTranslatorImpl();
        this.credentials = Collections.unmodifiableMap(credentials);
    }

    @Override
    public HConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public Set<CassandraHost> getKnownPoolHosts(boolean refresh) {
        if (refresh || this.knownPoolHosts == null) {
            this.knownPoolHosts = this.connectionManager.getHosts();
            if (this.log.isInfoEnabled()) {
                this.log.info("found knownPoolHosts: {}", this.knownPoolHosts);
            }
        }
        return this.knownPoolHosts;
    }

    @Override
    public void addHost(CassandraHost cassandraHost, boolean skipApplyConfig) {
        if (!skipApplyConfig && this.configurator != null) {
            this.configurator.applyConfig(cassandraHost);
        }
        this.connectionManager.addCassandraHost(cassandraHost);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<KeyspaceDefinition> describeKeyspaces() throws HectorException {
        Operation<List<KeyspaceDefinition>> op = new Operation<List<KeyspaceDefinition>>(OperationType.META_READ, this.getCredentials()){

            @Override
            public List<KeyspaceDefinition> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return ThriftKsDef.fromThriftList(cassandra.describe_keyspaces());
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public String describeClusterName() throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_cluster_name();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String describeThriftVersion() throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_version();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public KeyspaceDefinition describeKeyspace(final String keyspace) throws HectorException {
        Operation<KeyspaceDefinition> op = new Operation<KeyspaceDefinition>(OperationType.META_READ, this.getCredentials()){

            @Override
            public KeyspaceDefinition execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return new ThriftKsDef(cassandra.describe_keyspace(keyspace));
                }
                catch (NotFoundException nfe) {
                    this.setException(AbstractCluster.this.xtrans.translate(nfe));
                    return null;
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (KeyspaceDefinition)op.getResult();
    }

    @Override
    public String getClusterName() throws HectorException {
        this.log.info("in execute with client");
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    AbstractCluster.this.log.info("in execute with client {}", (Object)cassandra);
                    return cassandra.describe_cluster_name();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String dropKeyspace(final String keyspace) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.system_drop_keyspace(keyspace);
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String describePartitioner() throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (AbstractCluster.this.log.isInfoEnabled()) {
                        AbstractCluster.this.log.info("in execute with client {}", (Object)cassandra);
                    }
                    return cassandra.describe_partitioner();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String dropColumnFamily(String keyspaceName, final String columnFamily) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE, keyspaceName, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.system_drop_column_family(columnFamily);
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public Map<String, String> getCredentials() {
        return this.credentials;
    }
}

