/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.prettyprint.cassandra.service.ThriftColumnDef;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.cassandra.thrift.CfDef;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ThriftCfDef
implements ColumnFamilyDefinition {
    private final String keyspace;
    private final String name;
    private ColumnType columnType;
    private ComparatorType comparatorType;
    private ComparatorType subComparatorType;
    private String comment;
    private double rowCacheSize;
    private int rowCacheSavePeriodInSeconds;
    private double keyCacheSize;
    private double readRepairChance;
    private List<ColumnDefinition> columnMetadata;
    private int gcGraceSeconds;
    private String defaultValidationClass;
    private int id;
    private int maxCompactionThreshold;
    private int minCompactionThreshold;

    public ThriftCfDef(CfDef d) {
        Assert.notNull(d, "CfDef is null");
        this.keyspace = d.keyspace;
        this.name = d.name;
        this.columnType = ColumnType.getFromValue(d.column_type);
        this.comparatorType = ComparatorType.getByClassName(d.comparator_type);
        this.subComparatorType = ComparatorType.getByClassName(d.subcomparator_type);
        this.comment = d.comment;
        this.rowCacheSize = d.row_cache_size;
        this.rowCacheSavePeriodInSeconds = d.row_cache_save_period_in_seconds;
        this.keyCacheSize = d.key_cache_size;
        this.readRepairChance = d.read_repair_chance;
        this.columnMetadata = ThriftColumnDef.fromThriftList(d.column_metadata);
        this.gcGraceSeconds = d.gc_grace_seconds;
        this.defaultValidationClass = d.default_validation_class;
        this.id = d.id;
        this.minCompactionThreshold = d.min_compaction_threshold;
        this.maxCompactionThreshold = d.max_compaction_threshold;
    }

    public ThriftCfDef(ColumnFamilyDefinition columnFamilyDefinition) {
        this.keyspace = columnFamilyDefinition.getKeyspaceName();
        this.name = columnFamilyDefinition.getName();
        this.columnType = columnFamilyDefinition.getColumnType();
        this.comparatorType = columnFamilyDefinition.getComparatorType();
        this.subComparatorType = columnFamilyDefinition.getSubComparatorType();
        this.comment = columnFamilyDefinition.getComment();
        this.rowCacheSize = columnFamilyDefinition.getRowCacheSize();
        this.rowCacheSavePeriodInSeconds = columnFamilyDefinition.getRowCacheSavePeriodInSeconds();
        this.keyCacheSize = columnFamilyDefinition.getKeyCacheSize();
        this.readRepairChance = columnFamilyDefinition.getReadRepairChance();
        this.columnMetadata = columnFamilyDefinition.getColumnMetadata();
        this.gcGraceSeconds = columnFamilyDefinition.getGcGraceSeconds();
        this.defaultValidationClass = columnFamilyDefinition.getDefaultValidationClass();
        this.id = columnFamilyDefinition.getId();
        this.minCompactionThreshold = columnFamilyDefinition.getMinCompactionThreshold();
        this.maxCompactionThreshold = columnFamilyDefinition.getMaxCompactionThreshold();
    }

    public ThriftCfDef(String keyspace, String columnFamilyName) {
        this.keyspace = keyspace;
        this.name = columnFamilyName;
        this.columnMetadata = Collections.emptyList();
        this.columnType = ColumnType.STANDARD;
        this.comparatorType = ComparatorType.BYTESTYPE;
    }

    public ThriftCfDef(String keyspace, String columnFamilyName, ComparatorType comparatorType) {
        this(keyspace, columnFamilyName);
        if (comparatorType != null) {
            this.comparatorType = comparatorType;
        }
    }

    public ThriftCfDef(String keyspace, String columnFamilyName, ComparatorType comparatorType, List<ColumnDefinition> columnMetadata) {
        this(keyspace, columnFamilyName, comparatorType);
        if (columnMetadata != null) {
            this.columnMetadata = columnMetadata;
        }
    }

    public static List<ColumnFamilyDefinition> fromThriftList(List<CfDef> cfDefs) {
        if (cfDefs == null || cfDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ColumnFamilyDefinition> l = new ArrayList<ColumnFamilyDefinition>(cfDefs.size());
        for (CfDef d : cfDefs) {
            l.add(new ThriftCfDef(d));
        }
        return l;
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public ComparatorType getComparatorType() {
        return this.comparatorType;
    }

    @Override
    public ComparatorType getSubComparatorType() {
        return this.subComparatorType;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public double getRowCacheSize() {
        return this.rowCacheSize;
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSavePeriodInSeconds;
    }

    @Override
    public double getKeyCacheSize() {
        return this.keyCacheSize;
    }

    @Override
    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    @Override
    public List<ColumnDefinition> getColumnMetadata() {
        return this.columnMetadata;
    }

    @Override
    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public static List<CfDef> toThriftList(List<ColumnFamilyDefinition> cfDefs) {
        if (cfDefs == null || cfDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CfDef> l = new ArrayList<CfDef>(cfDefs.size());
        for (ColumnFamilyDefinition d : cfDefs) {
            l.add(((ThriftCfDef)d).toThrift());
        }
        return l;
    }

    public CfDef toThrift() {
        CfDef d = new CfDef(this.keyspace, this.name);
        d.setColumn_metadata(ThriftColumnDef.toThriftList(this.columnMetadata));
        d.setColumn_type(this.columnType.getValue());
        d.setComment(this.comment);
        d.setComparator_type(this.comparatorType.getClassName());
        d.setDefault_validation_class(this.defaultValidationClass);
        d.setGc_grace_seconds(this.gcGraceSeconds);
        d.setId(this.id);
        d.setKey_cache_size(this.keyCacheSize);
        d.setMax_compaction_threshold(this.maxCompactionThreshold);
        d.setMin_compaction_threshold(this.minCompactionThreshold);
        d.setRead_repair_chance(this.readRepairChance);
        d.setRow_cache_size(this.rowCacheSize);
        if (this.subComparatorType != null) {
            d.setSubcomparator_type(this.subComparatorType.getClassName());
        }
        return d;
    }

    @Override
    public String getDefaultValidationClass() {
        return this.defaultValidationClass;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    @Override
    public int getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public void setColumnType(ColumnType columnType) {
        this.columnType = columnType;
    }

    public void setComparatorType(ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
    }

    public void setSubComparatorType(ComparatorType subComparatorType) {
        this.subComparatorType = subComparatorType;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setRowCacheSize(double rowCacheSize) {
        this.rowCacheSize = rowCacheSize;
    }

    public void setRowCacheSavePeriodInSeconds(int rowCacheSavePeriodInSeconds) {
        this.rowCacheSavePeriodInSeconds = rowCacheSavePeriodInSeconds;
    }

    public void setKeyCacheSize(double keyCacheSize) {
        this.keyCacheSize = keyCacheSize;
    }

    public void setReadRepairChance(double readRepairChance) {
        this.readRepairChance = readRepairChance;
    }

    public void setColumnMetadata(List<ColumnDefinition> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    public void setGcGraceSeconds(int gcGraceSeconds) {
        this.gcGraceSeconds = gcGraceSeconds;
    }

    public void setDefaultValidationClass(String defaultValidationClass) {
        this.defaultValidationClass = defaultValidationClass;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMaxCompactionThreshold(int maxCompactionThreshold) {
        this.maxCompactionThreshold = maxCompactionThreshold;
    }

    public void setMinCompactionThreshold(int minCompactionThreshold) {
        this.minCompactionThreshold = minCompactionThreshold;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

