/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ThriftColumnDef
implements ColumnDefinition {
    private final ByteBuffer name;
    private final String validationClass;
    private final ColumnIndexType indexType;
    private final String indexName;

    public ThriftColumnDef(ColumnDef cd) {
        Assert.notNull(cd, "ColumnDef is null");
        this.name = cd.name;
        this.validationClass = cd.validation_class;
        this.indexType = this.indexTypeFromThrift(cd.index_type);
        this.indexName = cd.index_name;
    }

    public ThriftColumnDef(ColumnDefinition columnDefinition) {
        this.name = columnDefinition.getName();
        this.validationClass = columnDefinition.getValidationClass();
        this.indexType = columnDefinition.getIndexType();
        this.indexName = columnDefinition.getIndexName();
    }

    private ColumnIndexType indexTypeFromThrift(IndexType tIndexType) {
        switch (tIndexType) {
            case KEYS: {
                return ColumnIndexType.KEYS;
            }
        }
        throw new RuntimeException("Unknown thrift IndexType: " + tIndexType);
    }

    public static List<ColumnDefinition> fromThriftList(List<ColumnDef> columnDefs) {
        if (columnDefs == null || columnDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDefinition> l = new ArrayList<ColumnDefinition>(columnDefs.size());
        for (ColumnDef cd : columnDefs) {
            l.add(new ThriftColumnDef(cd));
        }
        return l;
    }

    @Override
    public ByteBuffer getName() {
        return this.name;
    }

    @Override
    public String getValidationClass() {
        return this.validationClass;
    }

    @Override
    public ColumnIndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public static List<ColumnDef> toThriftList(List<ColumnDefinition> columnDefs) {
        if (columnDefs == null || columnDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDef> l = new ArrayList<ColumnDef>(columnDefs.size());
        for (ColumnDefinition d : columnDefs) {
            l.add(new ThriftColumnDef(d).toThrift());
        }
        return l;
    }

    private ColumnDef toThrift() {
        ColumnDef d = new ColumnDef();
        d.setIndex_name(this.indexName);
        d.setIndex_type(this.indexTypeToThrift(this.indexType));
        d.setName(this.name);
        d.setValidation_class(this.validationClass);
        return d;
    }

    private IndexType indexTypeToThrift(ColumnIndexType indexType2) {
        switch (indexType2) {
            case KEYS: {
                return IndexType.KEYS;
            }
        }
        throw new RuntimeException("Unknown ColumnIndexType value: " + (Object)((Object)indexType2));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

