/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import org.apache.cassandra.thrift.KsDef;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ThriftKsDef
implements KeyspaceDefinition {
    private final String name;
    private String strategyClass;
    private Map<String, String> strategyOptions;
    private int replicationFactor;
    private final List<ColumnFamilyDefinition> cfDefs;

    public ThriftKsDef(KsDef k) {
        Assert.notNull(k, "KsDef is null");
        this.name = k.name;
        this.strategyClass = k.strategy_class;
        this.strategyOptions = k.strategy_options;
        this.replicationFactor = k.replication_factor;
        this.cfDefs = ThriftCfDef.fromThriftList(k.cf_defs);
    }

    public ThriftKsDef(String keyspaceName, String strategyClass, int replicationFactor, List<ColumnFamilyDefinition> cfDefs) {
        this.name = keyspaceName;
        this.strategyClass = strategyClass;
        this.replicationFactor = replicationFactor;
        this.cfDefs = cfDefs;
    }

    public ThriftKsDef(String keyspaceName) {
        this.name = keyspaceName;
        this.cfDefs = new ArrayList<ColumnFamilyDefinition>();
        this.replicationFactor = 1;
    }

    public ThriftKsDef(KeyspaceDefinition keyspaceDefinition) {
        this.name = keyspaceDefinition.getName();
        this.strategyClass = keyspaceDefinition.getStrategyClass();
        this.strategyOptions = keyspaceDefinition.getStrategyOptions();
        this.replicationFactor = keyspaceDefinition.getReplicationFactor();
        this.cfDefs = keyspaceDefinition.getCfDefs();
    }

    public static List<KeyspaceDefinition> fromThriftList(List<KsDef> ks) {
        if (ks == null || ks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyspaceDefinition> l = new ArrayList<KeyspaceDefinition>(ks.size());
        for (KsDef k : ks) {
            l.add(new ThriftKsDef(k));
        }
        return l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStrategyClass() {
        return this.strategyClass;
    }

    @Override
    public Map<String, String> getStrategyOptions() {
        return Collections.unmodifiableMap(this.strategyOptions);
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public List<ColumnFamilyDefinition> getCfDefs() {
        return Collections.unmodifiableList(this.cfDefs);
    }

    public KsDef toThrift() {
        return new KsDef(this.name, this.strategyClass, this.replicationFactor, ThriftCfDef.toThriftList(this.cfDefs));
    }

    public void setStrategyClass(String strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setStrategyOptions(Map<String, String> strategyOptions) {
        this.strategyOptions = strategyOptions;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

