/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class SynonymMap {
    private final HashMap table;
    private static final String[] EMPTY = new String[0];
    private static final boolean DEBUG = false;

    public SynonymMap(InputStream input) throws IOException {
        this.table = input == null ? new HashMap(0) : this.read(SynonymMap.toByteArray(input));
    }

    public String[] getSynonyms(String word) {
        Object syns = this.table.get(word);
        if (syns == null) {
            return EMPTY;
        }
        if (syns instanceof String) {
            return new String[]{(String)syns};
        }
        String[] synonyms = (String[])syns;
        String[] copy = new String[synonyms.length];
        System.arraycopy(synonyms, 0, copy, 0, synonyms.length);
        return copy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = new TreeMap(this.table).keySet().iterator();
        int count = 0;
        int f0 = 0;
        int f1 = 0;
        int f2 = 0;
        int f3 = 0;
        while (iter.hasNext()) {
            String word = (String)iter.next();
            buf.append(word + ":");
            String[] synonyms = this.getSynonyms(word);
            buf.append(Arrays.asList(synonyms));
            buf.append("\n");
            count += synonyms.length;
            if (synonyms.length == 0) {
                ++f0;
            }
            if (synonyms.length == 1) {
                ++f1;
            }
            if (synonyms.length == 2) {
                ++f2;
            }
            if (synonyms.length != 3) continue;
            ++f3;
        }
        buf.append("\n\nkeys=" + this.table.size() + ", synonyms=" + count + ", f0=" + f0 + ", f1=" + f1 + ", f2=" + f2 + ", f3=" + f3);
        return buf.toString();
    }

    protected String analyze(String word) {
        return word.toLowerCase();
    }

    private static boolean isValid(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private HashMap read(byte[] data) {
        int WORDS = 109144;
        int GROUPS = 125745;
        HashMap<String, ArrayList<Integer>> word2Groups = new HashMap<String, ArrayList<Integer>>(WORDS);
        HashMap<Integer, ArrayList<String>> group2Words = new HashMap<Integer, ArrayList<String>>(GROUPS);
        HashMap<String, String> internedWords = new HashMap<String, String>(WORDS);
        Charset charset = Charset.forName("UTF-8");
        int lastNum = -1;
        Integer lastGroup = null;
        int len = data.length;
        int i = 0;
        while (i < len) {
            ArrayList<Integer> groups;
            while (i < len && data[i] != 40) {
                ++i;
            }
            if (i >= len) break;
            ++i;
            int num = 0;
            while (i < len && data[i] != 44) {
                num = 10 * num + (data[i] - 48);
                ++i;
            }
            ++i;
            while (i < len && data[i] != 39) {
                ++i;
            }
            int start = ++i;
            while (true) {
                if (i < len && data[i] != 39) {
                    ++i;
                    continue;
                }
                if (++i >= len || data[i] == 44) break;
            }
            if (i >= len) break;
            String word = charset.decode(ByteBuffer.wrap(data, start, i - start - 1)).toString();
            if (!SynonymMap.isValid(word) || (word = this.analyze(word)) == null || word.length() == 0) continue;
            String w = (String)internedWords.get(word);
            if (w == null) {
                word = new String(word);
                internedWords.put(word, word);
            } else {
                word = w;
            }
            Integer group = lastGroup;
            if (num != lastNum) {
                lastGroup = group = new Integer(num);
                lastNum = num;
            }
            if ((groups = (ArrayList<Integer>)word2Groups.get(word)) == null) {
                groups = new ArrayList<Integer>(1);
                word2Groups.put(word, groups);
            }
            groups.add(group);
            ArrayList<String> words = (ArrayList<String>)group2Words.get(group);
            if (words == null) {
                words = new ArrayList<String>(1);
                group2Words.put(group, words);
            }
            words.add(word);
        }
        HashMap word2Syns = this.createIndex(word2Groups, group2Words);
        word2Groups = null;
        group2Words = null;
        return this.optimize(word2Syns, internedWords);
    }

    private HashMap createIndex(Map word2Groups, Map group2Words) {
        HashMap<String, String[]> word2Syns = new HashMap<String, String[]>();
        Iterator iter = word2Groups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ArrayList group = (ArrayList)entry.getValue();
            String word = (String)entry.getKey();
            TreeSet synonyms = new TreeSet();
            int i = group.size();
            while (--i >= 0) {
                ArrayList words = (ArrayList)group2Words.get(group.get(i));
                int j = words.size();
                while (--j >= 0) {
                    Object synonym = words.get(j);
                    if (synonym == word) continue;
                    synonyms.add(synonym);
                }
            }
            int size = synonyms.size();
            if (size <= 0) continue;
            String[] syns = new String[size];
            if (size == 1) {
                syns[0] = (String)synonyms.first();
            } else {
                synonyms.toArray(syns);
            }
            word2Syns.put(word, syns);
        }
        return word2Syns;
    }

    private HashMap optimize(HashMap word2Syns, HashMap internedWords) {
        int len = 0;
        int size = word2Syns.size();
        String[][] allSynonyms = new String[size][];
        String[] words = new String[size];
        Iterator iter = word2Syns.entrySet().iterator();
        for (int j = 0; j < size; ++j) {
            Map.Entry entry = iter.next();
            allSynonyms[j] = (String[])entry.getValue();
            words[j] = (String)entry.getKey();
            len += words[j].length();
        }
        StringBuffer buf = new StringBuffer(len);
        for (int j = 0; j < size; ++j) {
            buf.append(words[j]);
        }
        String allWords = new String(buf.toString());
        buf = null;
        int p = 0;
        for (int j = 0; j < size; ++j) {
            String word = words[j];
            internedWords.put(word, allWords.substring(p, p + word.length()));
            p += word.length();
        }
        for (int j = 0; j < size; ++j) {
            String[] syns = allSynonyms[j];
            int k = syns.length;
            while (--k >= 0) {
                syns[k] = (String)internedWords.get(syns[k]);
            }
            Object replacement = syns;
            if (syns.length == 1) {
                replacement = syns[0];
            }
            word2Syns.remove(words[j]);
            word2Syns.put(internedWords.get(words[j]), replacement);
        }
        return word2Syns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream input) throws IOException {
        try {
            byte[] byArray;
            int n;
            int len = Math.max(256, input.available());
            byte[] buffer = new byte[len];
            byte[] output = new byte[len];
            len = 0;
            while ((n = input.read(buffer)) >= 0) {
                if (len + n > output.length) {
                    byte[] tmp = new byte[Math.max(output.length << 1, len + n)];
                    System.arraycopy(output, 0, tmp, 0, len);
                    System.arraycopy(buffer, 0, tmp, len, n);
                    buffer = output;
                    output = tmp;
                } else {
                    System.arraycopy(buffer, 0, output, len, n);
                }
                len += n;
            }
            if (len == output.length) {
                byArray = output;
                return byArray;
            }
            buffer = null;
            buffer = new byte[len];
            System.arraycopy(output, 0, buffer, 0, len);
            byArray = buffer;
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

