/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.simpl.JobWrapper;
import org.quartz.simpl.TriggerComparator;
import org.quartz.simpl.TriggerWrapper;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMJobStore
implements JobStore {
    protected HashMap jobsByFQN = new HashMap(1000);
    protected HashMap triggersByFQN = new HashMap(1000);
    protected HashMap jobsByGroup = new HashMap(25);
    protected HashMap triggersByGroup = new HashMap(25);
    protected TreeSet timeTriggers = new TreeSet(new TriggerComparator());
    protected HashMap calendarsByName = new HashMap(25);
    protected ArrayList triggers = new ArrayList(1000);
    protected final Object lock = new Object();
    protected HashSet pausedTriggerGroups = new HashSet();
    protected HashSet pausedJobGroups = new HashSet();
    protected HashSet blockedJobs = new HashSet();
    protected long misfireThreshold = 5000L;
    protected SchedulerSignaler signaler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static AtomicLong ftrCtr = new AtomicLong(System.currentTimeMillis());

    protected Logger getLog() {
        return this.log;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) {
        this.signaler = signaler;
        this.getLog().info("RAMJobStore initialized.");
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    public void shutdown() {
    }

    public boolean supportsPersistence() {
        return false;
    }

    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws JobPersistenceException {
        this.storeJob(ctxt, newJob, false);
        this.storeTrigger(ctxt, newTrigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException {
        JobWrapper jw = new JobWrapper((JobDetail)newJob.clone());
        boolean repl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.jobsByFQN.get(jw.key) != null) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newJob);
                }
                repl = true;
            }
            if (!repl) {
                HashMap<String, JobWrapper> grpMap = (HashMap<String, JobWrapper>)this.jobsByGroup.get(newJob.getGroup());
                if (grpMap == null) {
                    grpMap = new HashMap<String, JobWrapper>(100);
                    this.jobsByGroup.put(newJob.getGroup(), grpMap);
                }
                grpMap.put(newJob.getName(), jw);
                this.jobsByFQN.put(jw.key, jw);
            } else {
                JobWrapper orig = (JobWrapper)this.jobsByFQN.get(jw.key);
                orig.jobDetail = jw.jobDetail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) {
        String key = JobWrapper.getJobNameKey(jobName, groupName);
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            HashMap grpMap;
            Trigger[] trigger = this.getTriggersForJob(ctxt, jobName, groupName);
            for (int i = 0; i < trigger.length; ++i) {
                Trigger trig = trigger[i];
                this.removeTrigger(ctxt, trig.getName(), trig.getGroup());
                found = true;
            }
            found = this.jobsByFQN.remove(key) != null | found;
            if (found && (grpMap = (HashMap)this.jobsByGroup.get(groupName)) != null) {
                grpMap.remove(jobName);
                if (grpMap.size() == 0) {
                    this.jobsByGroup.remove(groupName);
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws JobPersistenceException {
        TriggerWrapper tw = new TriggerWrapper((Trigger)newTrigger.clone());
        Object object = this.lock;
        synchronized (object) {
            if (this.triggersByFQN.get(tw.key) != null) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newTrigger);
                }
                this.removeTrigger(ctxt, newTrigger.getName(), newTrigger.getGroup(), false);
            }
            if (this.retrieveJob(ctxt, newTrigger.getJobName(), newTrigger.getJobGroup()) == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getFullJobName() + ") referenced by the trigger does not exist.");
            }
            this.triggers.add(tw);
            HashMap<String, TriggerWrapper> grpMap = (HashMap<String, TriggerWrapper>)this.triggersByGroup.get(newTrigger.getGroup());
            if (grpMap == null) {
                grpMap = new HashMap<String, TriggerWrapper>(100);
                this.triggersByGroup.put(newTrigger.getGroup(), grpMap);
            }
            grpMap.put(newTrigger.getName(), tw);
            this.triggersByFQN.put(tw.key, tw);
            if (this.pausedTriggerGroups.contains(newTrigger.getGroup()) || this.pausedJobGroups.contains(newTrigger.getJobGroup())) {
                tw.state = 4;
                if (this.blockedJobs.contains(tw.jobKey)) {
                    tw.state = 6;
                }
            } else if (this.blockedJobs.contains(tw.jobKey)) {
                tw.state = 5;
            } else {
                this.timeTriggers.add(tw);
            }
        }
    }

    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        return this.removeTrigger(ctxt, triggerName, groupName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName, boolean removeOrphanedJob) {
        String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = found = this.triggersByFQN.remove(key) != null;
            if (found) {
                TriggerWrapper tw = null;
                HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
                if (grpMap != null) {
                    grpMap.remove(triggerName);
                    if (grpMap.size() == 0) {
                        this.triggersByGroup.remove(groupName);
                    }
                }
                Iterator tgs = this.triggers.iterator();
                while (tgs.hasNext()) {
                    tw = (TriggerWrapper)tgs.next();
                    if (!key.equals(tw.key)) continue;
                    tgs.remove();
                    break;
                }
                this.timeTriggers.remove(tw);
                if (removeOrphanedJob) {
                    JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(tw.trigger.getJobName(), tw.trigger.getJobGroup()));
                    Trigger[] trigs = this.getTriggersForJob(ctxt, tw.trigger.getJobName(), tw.trigger.getJobGroup());
                    if (!(trigs != null && trigs.length != 0 || jw.jobDetail.isDurable())) {
                        this.removeJob(ctxt, tw.trigger.getJobName(), tw.trigger.getJobGroup());
                    }
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
        boolean found = false;
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.remove(key);
            boolean bl = found = tw != null;
            if (found) {
                if (!tw.getTrigger().getJobName().equals(newTrigger.getJobName()) || !tw.getTrigger().getJobGroup().equals(newTrigger.getJobGroup())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                tw = null;
                HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
                if (grpMap != null) {
                    grpMap.remove(triggerName);
                    if (grpMap.size() == 0) {
                        this.triggersByGroup.remove(groupName);
                    }
                }
                Iterator tgs = this.triggers.iterator();
                while (tgs.hasNext()) {
                    tw = (TriggerWrapper)tgs.next();
                    if (!key.equals(tw.key)) continue;
                    tgs.remove();
                    break;
                }
                this.timeTriggers.remove(tw);
                try {
                    this.storeTrigger(ctxt, newTrigger, false);
                }
                catch (JobPersistenceException jpe) {
                    this.storeTrigger(ctxt, tw.getTrigger(), false);
                    throw jpe;
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(jobName, groupName));
            return jw != null ? (JobDetail)jw.jobDetail.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
            return tw != null ? (Trigger)tw.getTrigger().clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
            if (tw == null) {
                return -1;
            }
            if (tw.state == 3) {
                return 2;
            }
            if (tw.state == 4) {
                return 1;
            }
            if (tw.state == 6) {
                return 1;
            }
            if (tw.state == 5) {
                return 4;
            }
            if (tw.state == 7) {
                return 3;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCalendar(SchedulingContext ctxt, String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException {
        calendar = (Calendar)calendar.clone();
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.calendarsByName.get(name);
            if (obj != null && !replaceExisting) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + name + "' already exists.");
            }
            if (obj != null) {
                this.calendarsByName.remove(name);
            }
            this.calendarsByName.put(name, calendar);
            if (obj != null && updateTriggers) {
                for (TriggerWrapper tw : this.getTriggerWrappersForCalendar(name)) {
                    Trigger trig = tw.getTrigger();
                    boolean removed = this.timeTriggers.remove(tw);
                    trig.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                    if (!removed) continue;
                    this.timeTriggers.add(tw);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        int numRefs = 0;
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.triggers.iterator();
            while (itr.hasNext()) {
                Trigger trigg = ((TriggerWrapper)itr.next()).trigger;
                if (trigg.getCalendarName() == null || !trigg.getCalendarName().equals(calName)) continue;
                ++numRefs;
            }
        }
        if (numRefs > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove(calName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) {
        Object object = this.lock;
        synchronized (object) {
            Calendar cal = (Calendar)this.calendarsByName.get(calName);
            if (cal != null) {
                return (Calendar)cal.clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfJobs(SchedulingContext ctxt) {
        Object object = this.lock;
        synchronized (object) {
            return this.jobsByFQN.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTriggers(SchedulingContext ctxt) {
        Object object = this.lock;
        synchronized (object) {
            return this.triggers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCalendars(SchedulingContext ctxt) {
        Object object = this.lock;
        synchronized (object) {
            return this.calendarsByName.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobNames(SchedulingContext ctxt, String groupName) {
        String[] outList = null;
        Object object = this.lock;
        synchronized (object) {
            HashMap grpMap = (HashMap)this.jobsByGroup.get(groupName);
            if (grpMap != null) {
                outList = new String[grpMap.size()];
                int outListPos = 0;
                for (JobWrapper jw : grpMap.values()) {
                    if (jw == null) continue;
                    outList[outListPos++] = jw.jobDetail.getName();
                }
            } else {
                outList = new String[]{};
            }
        }
        return outList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCalendarNames(SchedulingContext ctxt) {
        Object object = this.lock;
        synchronized (object) {
            Set names = this.calendarsByName.keySet();
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) {
        String[] outList = null;
        Object object = this.lock;
        synchronized (object) {
            HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
            if (grpMap != null) {
                outList = new String[grpMap.size()];
                int outListPos = 0;
                for (TriggerWrapper tw : grpMap.values()) {
                    if (tw == null) continue;
                    outList[outListPos++] = tw.trigger.getName();
                }
            } else {
                outList = new String[]{};
            }
        }
        return outList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobGroupNames(SchedulingContext ctxt) {
        String[] outList = null;
        Object object = this.lock;
        synchronized (object) {
            outList = new String[this.jobsByGroup.size()];
            int outListPos = 0;
            Iterator keys = this.jobsByGroup.keySet().iterator();
            while (keys.hasNext()) {
                outList[outListPos++] = (String)keys.next();
            }
        }
        return outList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerGroupNames(SchedulingContext ctxt) {
        String[] outList = null;
        Object object = this.lock;
        synchronized (object) {
            outList = new String[this.triggersByGroup.size()];
            int outListPos = 0;
            Iterator keys = this.triggersByGroup.keySet().iterator();
            while (keys.hasNext()) {
                outList[outListPos++] = (String)keys.next();
            }
        }
        return outList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) {
        ArrayList<Object> trigList = new ArrayList<Object>();
        String jobKey = JobWrapper.getJobNameKey(jobName, groupName);
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
                if (!tw.jobKey.equals(jobKey)) continue;
                trigList.add(tw.trigger.clone());
            }
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getTriggerWrappersForJob(String jobName, String groupName) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        String jobKey = JobWrapper.getJobNameKey(jobName, groupName);
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
                if (!tw.jobKey.equals(jobKey)) continue;
                trigList.add(tw);
            }
        }
        return trigList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getTriggerWrappersForCalendar(String calName) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
                String tcalName = tw.getTrigger().getCalendarName();
                if (tcalName == null || !tcalName.equals(calName)) continue;
                trigList.add(tw);
            }
        }
        return trigList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
            if (tw == null || tw.trigger == null) {
                return;
            }
            if (tw.state == 3) {
                return;
            }
            tw.state = tw.state == 5 ? 6 : 4;
            this.timeTriggers.remove(tw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pausedTriggerGroups.contains(groupName)) {
                return;
            }
            this.pausedTriggerGroups.add(groupName);
            String[] names = this.getTriggerNames(ctxt, groupName);
            for (int i = 0; i < names.length; ++i) {
                this.pauseTrigger(ctxt, names[i], groupName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            Trigger[] triggers = this.getTriggersForJob(ctxt, jobName, groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.pauseTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJobGroup(SchedulingContext ctxt, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.pausedJobGroups.contains(groupName)) {
                this.pausedJobGroups.add(groupName);
            }
            String[] jobNames = this.getJobNames(ctxt, groupName);
            for (int i = 0; i < jobNames.length; ++i) {
                Trigger[] triggers = this.getTriggersForJob(ctxt, jobNames[i], groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    this.pauseTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
            if (tw == null || tw.trigger == null) {
                return;
            }
            Trigger trig = tw.getTrigger();
            if (tw.state != 4 && tw.state != 6) {
                return;
            }
            tw.state = this.blockedJobs.contains(JobWrapper.getJobNameKey(trig.getJobName(), trig.getJobGroup())) ? 5 : 0;
            this.applyMisfire(tw);
            if (tw.state == 0) {
                this.timeTriggers.add(tw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            String[] names = this.getTriggerNames(ctxt, groupName);
            for (int i = 0; i < names.length; ++i) {
                String jobGroup;
                String key = TriggerWrapper.getTriggerNameKey(names[i], groupName);
                if (this.triggersByFQN.get(key) != null && this.pausedJobGroups.contains(jobGroup = ((TriggerWrapper)this.triggersByFQN.get(key)).getTrigger().getJobGroup())) continue;
                this.resumeTrigger(ctxt, names[i], groupName);
            }
            this.pausedTriggerGroups.remove(groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            Trigger[] triggers = this.getTriggersForJob(ctxt, jobName, groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.resumeTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJobGroup(SchedulingContext ctxt, String groupName) {
        Object object = this.lock;
        synchronized (object) {
            String[] jobNames = this.getJobNames(ctxt, groupName);
            if (this.pausedJobGroups.contains(groupName)) {
                this.pausedJobGroups.remove(groupName);
            }
            for (int i = 0; i < jobNames.length; ++i) {
                Trigger[] triggers = this.getTriggersForJob(ctxt, jobNames[i], groupName);
                for (int j = 0; j < triggers.length; ++j) {
                    this.resumeTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll(SchedulingContext ctxt) {
        Object object = this.lock;
        synchronized (object) {
            String[] names = this.getTriggerGroupNames(ctxt);
            for (int i = 0; i < names.length; ++i) {
                this.pauseTriggerGroup(ctxt, names[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll(SchedulingContext ctxt) {
        Object object = this.lock;
        synchronized (object) {
            this.pausedJobGroups.clear();
            String[] names = this.getTriggerGroupNames(ctxt);
            for (int i = 0; i < names.length; ++i) {
                this.resumeTriggerGroup(ctxt, names[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyMisfire(TriggerWrapper tw) {
        Date tnft;
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        if ((tnft = tw.trigger.getNextFireTime()) == null || tnft.getTime() > misfireTime) {
            return false;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(null, tw.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired((Trigger)tw.trigger.clone());
        tw.trigger.updateAfterMisfire(cal);
        if (tw.trigger.getNextFireTime() == null) {
            tw.state = 3;
            this.signaler.notifySchedulerListenersFinalized(tw.trigger);
            Object object = this.lock;
            synchronized (object) {
                this.timeTriggers.remove(tw);
            }
        } else if (tnft.equals(tw.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan) {
        TriggerWrapper tw = null;
        Object object = this.lock;
        synchronized (object) {
            while (tw == null) {
                try {
                    tw = (TriggerWrapper)this.timeTriggers.first();
                }
                catch (NoSuchElementException nsee) {
                    return null;
                }
                if (tw == null) {
                    return null;
                }
                if (tw.trigger.getNextFireTime() == null) {
                    this.timeTriggers.remove(tw);
                    tw = null;
                    continue;
                }
                this.timeTriggers.remove(tw);
                if (this.applyMisfire(tw)) {
                    if (tw.trigger.getNextFireTime() != null) {
                        this.timeTriggers.add(tw);
                    }
                    tw = null;
                    continue;
                }
                if (tw.trigger.getNextFireTime().getTime() > noLaterThan) {
                    this.timeTriggers.add(tw);
                    return null;
                }
                tw.state = 1;
                tw.trigger.setFireInstanceId(this.getFiredTriggerRecordId());
                Trigger trig = (Trigger)tw.trigger.clone();
                return trig;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
            if (tw != null && tw.state == 1) {
                tw.state = 0;
                this.timeTriggers.add(tw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) {
        Object object = this.lock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
            if (tw == null || tw.trigger == null) {
                return null;
            }
            if (tw.state != 1) {
                return null;
            }
            Calendar cal = null;
            if (tw.trigger.getCalendarName() != null && (cal = this.retrieveCalendar(ctxt, tw.trigger.getCalendarName())) == null) {
                return null;
            }
            Date prevFireTime = trigger.getPreviousFireTime();
            this.timeTriggers.remove(tw);
            tw.trigger.triggered(cal);
            trigger.triggered(cal);
            tw.state = 0;
            TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(ctxt, trigger.getJobName(), trigger.getJobGroup()), trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
            JobDetail job = bndle.getJobDetail();
            if (job.isStateful()) {
                ArrayList trigs = this.getTriggerWrappersForJob(job.getName(), job.getGroup());
                for (TriggerWrapper ttw : trigs) {
                    if (ttw.state == 0) {
                        ttw.state = 5;
                    }
                    if (ttw.state == 4) {
                        ttw.state = 6;
                    }
                    this.timeTriggers.remove(ttw);
                }
                this.blockedJobs.add(JobWrapper.getJobNameKey(job));
            } else if (tw.trigger.getNextFireTime() != null) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.timeTriggers.add(tw);
                }
            }
            return bndle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) {
        Object object = this.lock;
        synchronized (object) {
            String jobKey = JobWrapper.getJobNameKey(jobDetail.getName(), jobDetail.getGroup());
            JobWrapper jw = (JobWrapper)this.jobsByFQN.get(jobKey);
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
            if (jw != null) {
                JobDetail jd = jw.jobDetail;
                if (jd.isStateful()) {
                    JobDataMap newData = jobDetail.getJobDataMap();
                    if (newData != null) {
                        newData = (JobDataMap)newData.clone();
                        newData.clearDirtyFlag();
                    }
                    jd.setJobDataMap(newData);
                    this.blockedJobs.remove(JobWrapper.getJobNameKey(jd));
                    ArrayList trigs = this.getTriggerWrappersForJob(jd.getName(), jd.getGroup());
                    for (TriggerWrapper ttw : trigs) {
                        if (ttw.state == 5) {
                            ttw.state = 0;
                            this.timeTriggers.add(ttw);
                        }
                        if (ttw.state != 6) continue;
                        ttw.state = 4;
                    }
                    this.signaler.signalSchedulingChange(0L);
                }
            } else {
                this.blockedJobs.remove(JobWrapper.getJobNameKey(jobDetail));
            }
            if (tw != null) {
                if (triggerInstCode == 3) {
                    if (trigger.getNextFireTime() == null) {
                        if (tw.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
                        }
                    } else {
                        this.removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
                        this.signaler.signalSchedulingChange(0L);
                    }
                } else if (triggerInstCode == 2) {
                    tw.state = 3;
                    this.timeTriggers.remove(tw);
                    this.signaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == 5) {
                    this.getLog().info("Trigger " + trigger.getFullName() + " set to ERROR state.");
                    tw.state = 7;
                    this.signaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == 6) {
                    this.getLog().info("All triggers of Job " + trigger.getFullJobName() + " set to ERROR state.");
                    this.setAllTriggersOfJobToState(trigger.getJobName(), trigger.getJobGroup(), 7);
                    this.signaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == 4) {
                    this.setAllTriggersOfJobToState(trigger.getJobName(), trigger.getJobGroup(), 3);
                    this.signaler.signalSchedulingChange(0L);
                }
            }
        }
    }

    protected void setAllTriggersOfJobToState(String jobName, String jobGroup, int state) {
        ArrayList tws = this.getTriggerWrappersForJob(jobName, jobGroup);
        for (TriggerWrapper tw : tws) {
            tw.state = state;
            if (state == 0) continue;
            this.timeTriggers.remove(tw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String peekTriggers() {
        StringBuffer str = new StringBuffer();
        TriggerWrapper tw2 = null;
        Object object = this.lock;
        synchronized (object) {
            for (TriggerWrapper tw2 : this.triggersByFQN.values()) {
                str.append(tw2.trigger.getName());
                str.append("/");
            }
        }
        str.append(" | ");
        object = this.lock;
        synchronized (object) {
            for (TriggerWrapper tw2 : this.timeTriggers) {
                str.append(tw2.trigger.getName());
                str.append("->");
            }
        }
        return str.toString();
    }

    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        HashSet set = new HashSet();
        set.addAll(this.pausedTriggerGroups);
        return set;
    }

    public void setInstanceId(String schedInstId) {
    }

    public void setInstanceName(String schedName) {
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 5L;
    }

    public boolean isClustered() {
        return false;
    }
}

