/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import java.util.ArrayList;
import java.util.HashMap;
import lpg.lpgjavaruntime.Adjunct;
import lpg.lpgjavaruntime.ErrorToken;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.NullExportedSymbolsException;
import lpg.lpgjavaruntime.NullTerminalSymbolsException;
import lpg.lpgjavaruntime.ParseErrorCodes;
import lpg.lpgjavaruntime.Token;
import lpg.lpgjavaruntime.TokenStream;
import lpg.lpgjavaruntime.UndefinedEofSymbolException;
import lpg.lpgjavaruntime.UnimplementedTerminalsException;

public class PrsStream
implements TokenStream,
ParseErrorCodes {
    private LexStream lexStream;
    private int[] kindMap = null;
    private ArrayList tokens = new ArrayList();
    private ArrayList adjuncts = new ArrayList();
    private int index = 0;
    private int len = 0;

    public PrsStream() {
    }

    public PrsStream(LexStream lexStream) {
        this.lexStream = lexStream;
        if (lexStream != null) {
            lexStream.setPrsStream(this);
        }
        this.resetTokenStream();
    }

    public void remapTerminalSymbols(String[] ordered_parser_symbols, int eof_symbol) throws UndefinedEofSymbolException, NullExportedSymbolsException, NullTerminalSymbolsException, UnimplementedTerminalsException {
        String[] ordered_lexer_symbols = this.lexStream.orderedExportedSymbols();
        if (ordered_lexer_symbols == null) {
            throw new NullExportedSymbolsException();
        }
        if (ordered_parser_symbols == null) {
            throw new NullTerminalSymbolsException();
        }
        ArrayList<Integer> unimplemented_symbols = new ArrayList<Integer>();
        if (ordered_lexer_symbols != ordered_parser_symbols) {
            this.kindMap = new int[ordered_lexer_symbols.length];
            HashMap<String, Integer> terminal_map = new HashMap<String, Integer>();
            int i = 0;
            while (i < ordered_lexer_symbols.length) {
                terminal_map.put(ordered_lexer_symbols[i], new Integer(i));
                ++i;
            }
            i = 0;
            while (i < ordered_parser_symbols.length) {
                Integer k = (Integer)terminal_map.get(ordered_parser_symbols[i]);
                if (k != null) {
                    this.kindMap[k.intValue()] = i;
                } else {
                    if (i == eof_symbol) {
                        throw new UndefinedEofSymbolException();
                    }
                    unimplemented_symbols.add(new Integer(i));
                }
                ++i;
            }
        }
        if (unimplemented_symbols.size() > 0) {
            throw new UnimplementedTerminalsException(unimplemented_symbols);
        }
    }

    public final int mapKind(int kind) {
        return this.kindMap == null ? kind : this.kindMap[kind];
    }

    public String[] orderedTerminalSymbols() {
        return null;
    }

    public void resetTokenStream() {
        this.tokens = new ArrayList();
        this.index = 0;
        this.adjuncts = new ArrayList();
    }

    public void resetLexStream(LexStream lexStream) {
        this.lexStream = lexStream;
        if (lexStream != null) {
            lexStream.setPrsStream(this);
        }
    }

    public void makeToken(int startLoc, int endLoc, int kind) {
        Token token = new Token(this, startLoc, endLoc, this.mapKind(kind));
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        int index = this.tokens.size();
        ErrorToken token = new ErrorToken(this.getIToken(firsttok), this.getIToken(lasttok), this.getIToken(errortok), this.getStartOffset(firsttok), this.getEndOffset(lasttok), kind);
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
        return index;
    }

    public void addToken(IToken token) {
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    public void makeAdjunct(int startLoc, int endLoc, int kind) {
        int token_index = this.tokens.size() - 1;
        Adjunct adjunct = new Adjunct(this, startLoc, endLoc, this.mapKind(kind));
        adjunct.setAdjunctIndex(this.adjuncts.size());
        adjunct.setTokenIndex(token_index);
        this.adjuncts.add(adjunct);
    }

    public void addAdjunct(IToken adjunct) {
        int token_index = this.tokens.size() - 1;
        adjunct.setTokenIndex(token_index);
        adjunct.setAdjunctIndex(this.adjuncts.size());
        this.adjuncts.add(adjunct);
    }

    public String getTokenText(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.toString();
    }

    public int getStartOffset(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getStartOffset();
    }

    public int getEndOffset(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getEndOffset();
    }

    public int getTokenLength(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getEndOffset() - t.getStartOffset() + 1;
    }

    public int getLineNumberOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.lexStream.getLineNumberOfCharAt(t.getStartOffset());
    }

    public int getEndLineNumberOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.lexStream.getLineNumberOfCharAt(t.getEndOffset());
    }

    public int getColumnOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.lexStream.getColumnOfCharAt(t.getStartOffset());
    }

    public int getEndColumnOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.lexStream.getColumnOfCharAt(t.getEndOffset());
    }

    public int getFirstErrorToken(int i) {
        while (i >= this.len) {
            i = ((ErrorToken)this.tokens.get(i)).getFirstToken().getTokenIndex();
        }
        return i;
    }

    public int getLastErrorToken(int i) {
        while (i >= this.len) {
            i = ((ErrorToken)this.tokens.get(i)).getLastToken().getTokenIndex();
        }
        return i;
    }

    public char[] getInputChars() {
        return this.lexStream.getInputChars();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public void setSize() {
        this.len = this.tokens.size();
    }

    public int getTokenIndexAtCharacter(int offset) {
        int low = 0;
        int high = this.tokens.size();
        while (high > low) {
            int mid = (high + low) / 2;
            IToken mid_element = (IToken)this.tokens.get(mid);
            if (offset >= mid_element.getStartOffset() && offset <= mid_element.getEndOffset()) {
                return mid;
            }
            if (offset < mid_element.getStartOffset()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -(low - 1);
    }

    public IToken getTokenAtCharacter(int offset) {
        int tokenIndex = this.getTokenIndexAtCharacter(offset);
        return tokenIndex < 0 ? null : this.getTokenAt(tokenIndex);
    }

    public IToken getTokenAt(int i) {
        return (IToken)this.tokens.get(i);
    }

    public IToken getIToken(int i) {
        return (IToken)this.tokens.get(i);
    }

    public ArrayList getTokens() {
        return this.tokens;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public int getStreamLength() {
        return this.len;
    }

    public void setStreamIndex(int index) {
        this.index = index;
    }

    public void setStreamLength() {
        this.len = this.tokens.size();
    }

    public void setStreamLength(int len) {
        this.len = len;
    }

    public LexStream getLexStream() {
        return this.lexStream;
    }

    public void dumpTokens() {
        if (this.getSize() <= 2) {
            return;
        }
        System.out.println(" Kind \t Offset  Line \t Col \t Len  \tText\n");
        int i = 1;
        while (i < this.getSize() - 1) {
            this.dumpToken(i);
            ++i;
        }
    }

    public void dumpToken(int i) {
        System.out.print(" (" + this.getKind(i) + ")\t : ");
        System.out.print(this.getStartOffset(i));
        System.out.print(" \t " + this.getLineNumberOfTokenAt(i));
        System.out.print(" \t " + this.getColumnOfTokenAt(i));
        System.out.print(" \t " + this.getTokenLength(i));
        System.out.print("    \t" + this.getTokenText(i));
        System.out.println();
    }

    int next(int i) {
        return ++i < this.len ? i : this.len - 1;
    }

    int previous(int i) {
        return i <= 0 ? 0 : i - 1;
    }

    private IToken[] getAdjuncts(int i) {
        int start_index = ((IToken)this.tokens.get(i)).getAdjunctIndex();
        int end_index = ((IToken)this.tokens.get(this.getNext(i))).getAdjunctIndex();
        int size = end_index - start_index;
        IToken[] slice = new IToken[size];
        int j = start_index;
        int k = 0;
        while (j < end_index) {
            slice[k] = (IToken)this.adjuncts.get(j);
            ++j;
            ++k;
        }
        return slice;
    }

    public IToken[] getFollowingAdjuncts(int i) {
        return this.getAdjuncts(i);
    }

    public IToken[] getPreceedingAdjuncts(int i) {
        return this.getAdjuncts(this.getPrevious(i));
    }

    public ArrayList getAdjuncts() {
        return this.adjuncts;
    }

    public int getToken() {
        this.index = this.next(this.index);
        return this.index;
    }

    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.next(this.index) : this.len - 1;
        return this.index;
    }

    public int getKind(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getKind();
    }

    public int getNext(int i) {
        return ++i < this.len ? i : this.len - 1;
    }

    public int getPrevious(int i) {
        return i <= 0 ? 0 : i - 1;
    }

    public String getName(int i) {
        return this.getTokenText(i);
    }

    public int peek() {
        return this.next(this.index);
    }

    public void reset(int i) {
        this.index = this.previous(i);
    }

    public void reset() {
        this.index = 0;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int i) {
        return this.getLineNumberOfTokenAt(i);
    }

    public int getColumn(int i) {
        return this.getColumnOfTokenAt(i);
    }

    public int getEndLine(int i) {
        return this.getEndLineNumberOfTokenAt(i);
    }

    public int getEndColumn(int i) {
        return this.getEndColumnOfTokenAt(i);
    }

    public boolean afterEol(int i) {
        return i < 1 ? true : this.getEndLineNumberOfTokenAt(i - 1) < this.getLineNumberOfTokenAt(i);
    }

    public String getFileName() {
        return this.lexStream.getFileName();
    }

    public void reportError(int i, String code) {
        System.out.println("****" + code + " " + i);
        this.dumpToken(i);
    }

    public void reportError(int left_char, int right_char) {
    }

    public void reportError(int errorCode, String locationInfo, String tokenText) {
        this.lexStream.reportError(errorCode, locationInfo, tokenText);
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        if (errorCode == 6 || errorCode == 8) {
            tokenText = "";
        }
        if (!tokenText.equals("")) {
            tokenText = String.valueOf(tokenText) + ' ';
        }
        this.lexStream.reportError(errorCode, locationInfo, leftToken, rightToken, tokenText);
    }
}

