/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.CursorableLinkedList;
import org.apache.commons.pool.impl.EvictionTimer;

public class GenericKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final int DEFAULT_MAX_TOTAL = -1;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final boolean DEFAULT_LIFO = true;
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private int _maxTotal = -1;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private volatile boolean _testOnBorrow = false;
    private volatile boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private Map _poolMap = null;
    private int _totalActive = 0;
    private int _totalIdle = 0;
    private KeyedPoolableObjectFactory _factory = null;
    private Evictor _evictor = null;
    private CursorableLinkedList _poolList = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;
    private CursorableLinkedList.Cursor _evictionKeyCursor = null;
    private boolean _lifo = true;

    public GenericKeyedObjectPool() {
        this(null, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.maxTotal, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle, config.lifo);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, -1, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int maxTotal, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, maxTotal, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int maxTotal, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, maxTotal, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, true);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int maxTotal, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, boolean lifo) {
        this._factory = factory;
        this._maxActive = maxActive;
        this._lifo = lifo;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._maxTotal = maxTotal;
        this._minIdle = minIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._poolMap = new HashMap();
        this._poolList = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        this.notifyAll();
    }

    public synchronized int getMaxTotal() {
        return this._maxTotal;
    }

    public synchronized void setMaxTotal(int maxTotal) {
        this._maxTotal = maxTotal;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte whenExhaustedAction) {
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        this.notifyAll();
    }

    public synchronized void setMinIdle(int poolSize) {
        this._minIdle = poolSize;
    }

    public synchronized int getMinIdle() {
        return this._minIdle;
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    public synchronized void setConfig(Config conf) {
        this.setMaxIdle(conf.maxIdle);
        this.setMaxActive(conf.maxActive);
        this.setMaxTotal(conf.maxTotal);
        this.setMinIdle(conf.minIdle);
        this.setMaxWait(conf.maxWait);
        this.setWhenExhaustedAction(conf.whenExhaustedAction);
        this.setTestOnBorrow(conf.testOnBorrow);
        this.setTestOnReturn(conf.testOnReturn);
        this.setTestWhileIdle(conf.testWhileIdle);
        this.setNumTestsPerEvictionRun(conf.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(conf.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(conf.timeBetweenEvictionRunsMillis);
    }

    public synchronized boolean getLifo() {
        return this._lifo;
    }

    public synchronized void setLifo(boolean lifo) {
        this._lifo = lifo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject(Object key) throws Exception {
        ObjectTimestampPair pair;
        block38: {
            long starttime = System.currentTimeMillis();
            boolean newlyCreated = false;
            block26: while (true) {
                Object obj;
                pair = null;
                ObjectQueue pool = null;
                GenericKeyedObjectPool genericKeyedObjectPool = this;
                synchronized (genericKeyedObjectPool) {
                    this.assertOpen();
                    pool = (ObjectQueue)this._poolMap.get(key);
                    if (null == pool) {
                        pool = new ObjectQueue();
                        this._poolMap.put(key, pool);
                        this._poolList.add(key);
                    }
                    try {
                        pair = (ObjectTimestampPair)pool.queue.removeFirst();
                        if (null != pair) {
                            --this._totalIdle;
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    if (null == pair) {
                        if (this._maxTotal > 0 && this._totalActive + this._totalIdle >= this._maxTotal) {
                            this.clearOldest();
                        }
                        if (!(this._maxActive >= 0 && pool.activeCount >= this._maxActive || this._maxTotal >= 0 && this._totalActive + this._totalIdle >= this._maxTotal)) {
                            obj = this._factory.makeObject(key);
                            pair = new ObjectTimestampPair(obj);
                            newlyCreated = true;
                        } else {
                            switch (this._whenExhaustedAction) {
                                case 2: {
                                    obj = this._factory.makeObject(key);
                                    pair = new ObjectTimestampPair(obj);
                                    break;
                                }
                                case 0: {
                                    throw new NoSuchElementException();
                                }
                                case 1: {
                                    try {
                                        if (this._maxWait <= 0L) {
                                            this.wait();
                                        } else {
                                            long elapsed = System.currentTimeMillis() - starttime;
                                            long waitTime = this._maxWait - elapsed;
                                            if (waitTime > 0L) {
                                                this.wait(waitTime);
                                            }
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                    if (this._maxWait > 0L && System.currentTimeMillis() - starttime >= this._maxWait) {
                                        throw new NoSuchElementException("Timeout waiting for idle object");
                                    }
                                    continue block26;
                                }
                                default: {
                                    throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                                }
                            }
                        }
                    }
                    pool.incrementActiveCount();
                }
                try {
                    this._factory.activateObject(key, pair.value);
                }
                catch (Exception e) {
                    try {
                        this._factory.destroyObject(key, pair.value);
                        obj = this;
                        synchronized (obj) {
                            pool.decrementActiveCount();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (!newlyCreated) continue;
                    throw new NoSuchElementException("Could not create a validated object, cause: " + e.getMessage());
                }
                boolean invalid = true;
                try {
                    invalid = this._testOnBorrow && !this._factory.validateObject(key, pair.value);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!invalid) break block38;
                try {
                    this._factory.destroyObject(key, pair.value);
                    GenericKeyedObjectPool e = this;
                    synchronized (e) {
                        pool.decrementActiveCount();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (newlyCreated) break;
            }
            throw new NoSuchElementException("Could not create a validated object");
        }
        return pair.value;
    }

    public synchronized void clear() {
        Iterator entries = this._poolMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object key = entry.getKey();
            CursorableLinkedList list = ((ObjectQueue)entry.getValue()).queue;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    this._factory.destroyObject(key, ((ObjectTimestampPair)it.next()).value);
                }
                catch (Exception e) {
                    // empty catch block
                }
                it.remove();
            }
        }
        this._poolMap.clear();
        this._poolList.clear();
        this._totalIdle = 0;
        this.notifyAll();
    }

    public synchronized void clearOldest() {
        TreeMap map = new TreeMap();
        Iterator keyiter = this._poolMap.keySet().iterator();
        while (keyiter.hasNext()) {
            Object key = keyiter.next();
            CursorableLinkedList list = ((ObjectQueue)this._poolMap.get(key)).queue;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                map.put(it.next(), key);
            }
        }
        Set setPairKeys = map.entrySet();
        Iterator iter = setPairKeys.iterator();
        for (int itemsToRemove = (int)((double)map.size() * 0.15) + 1; iter.hasNext() && itemsToRemove > 0; --itemsToRemove) {
            Map.Entry entry = iter.next();
            Object key = entry.getValue();
            ObjectTimestampPair pairTimeStamp = (ObjectTimestampPair)entry.getKey();
            CursorableLinkedList list = ((ObjectQueue)this._poolMap.get(key)).queue;
            list.remove(pairTimeStamp);
            try {
                this._factory.destroyObject(key, pairTimeStamp.value);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (list.isEmpty()) {
                this._poolMap.remove(key);
                this._poolList.remove(key);
            }
            --this._totalIdle;
        }
        this.notifyAll();
    }

    public synchronized void clear(Object key) {
        ObjectQueue pool = (ObjectQueue)this._poolMap.remove(key);
        if (null == pool) {
            return;
        }
        this._poolList.remove(key);
        Iterator it = pool.queue.iterator();
        while (it.hasNext()) {
            try {
                this._factory.destroyObject(key, ((ObjectTimestampPair)it.next()).value);
            }
            catch (Exception e) {
                // empty catch block
            }
            it.remove();
            --this._totalIdle;
        }
        this.notifyAll();
    }

    public synchronized int getNumActive() {
        return this._totalActive;
    }

    public synchronized int getNumIdle() {
        return this._totalIdle;
    }

    public synchronized int getNumActive(Object key) {
        ObjectQueue pool = (ObjectQueue)this._poolMap.get(key);
        return pool != null ? pool.activeCount : 0;
    }

    public synchronized int getNumIdle(Object key) {
        ObjectQueue pool = (ObjectQueue)this._poolMap.get(key);
        return pool != null ? pool.queue.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object key, Object obj) throws Exception {
        block7: {
            try {
                this.addObjectToPool(key, obj, true);
            }
            catch (Exception e) {
                if (this._factory == null) break block7;
                try {
                    this._factory.destroyObject(key, obj);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                ObjectQueue pool = (ObjectQueue)this._poolMap.get(key);
                if (pool == null) break block7;
                GenericKeyedObjectPool genericKeyedObjectPool = this;
                synchronized (genericKeyedObjectPool) {
                    pool.decrementActiveCount();
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToPool(Object key, Object obj, boolean decrementNumActive) throws Exception {
        ObjectQueue pool;
        boolean success = true;
        if (this._testOnReturn && !this._factory.validateObject(key, obj)) {
            success = false;
        } else {
            this._factory.passivateObject(key, obj);
        }
        boolean shouldDestroy = !success;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            pool = (ObjectQueue)this._poolMap.get(key);
            if (null == pool) {
                pool = new ObjectQueue();
                this._poolMap.put(key, pool);
                this._poolList.add(key);
            }
            if (this.isClosed()) {
                shouldDestroy = true;
            } else if (this._maxIdle >= 0 && pool.queue.size() >= this._maxIdle) {
                shouldDestroy = true;
            } else if (success) {
                if (this._lifo) {
                    pool.queue.addFirst(new ObjectTimestampPair(obj));
                } else {
                    pool.queue.addLast(new ObjectTimestampPair(obj));
                }
                ++this._totalIdle;
            }
        }
        if (shouldDestroy) {
            try {
                this._factory.destroyObject(key, obj);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (decrementNumActive) {
            genericKeyedObjectPool = this;
            synchronized (genericKeyedObjectPool) {
                pool.decrementActiveCount();
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object key, Object obj) throws Exception {
        try {
            this._factory.destroyObject(key, obj);
        }
        finally {
            GenericKeyedObjectPool genericKeyedObjectPool = this;
            synchronized (genericKeyedObjectPool) {
                ObjectQueue pool = (ObjectQueue)this._poolMap.get(key);
                if (null == pool) {
                    pool = new ObjectQueue();
                    this._poolMap.put(key, pool);
                    this._poolList.add(key);
                }
                pool.decrementActiveCount();
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(Object key) throws Exception {
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        Object obj = this._factory.makeObject(key);
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            try {
                this.assertOpen();
                this.addObjectToPool(key, obj, false);
            }
            catch (IllegalStateException ex) {
                try {
                    this._factory.destroyObject(key, obj);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw ex;
            }
        }
    }

    public synchronized void preparePool(Object key, boolean populateImmediately) {
        ObjectQueue pool = (ObjectQueue)this._poolMap.get(key);
        if (null == pool) {
            pool = new ObjectQueue();
            this._poolMap.put(key, pool);
            this._poolList.add(key);
        }
        if (populateImmediately) {
            try {
                this.ensureMinIdle(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        super.close();
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.clear();
            if (null != this._evictionCursor) {
                this._evictionCursor.close();
                this._evictionCursor = null;
            }
            if (null != this._evictionKeyCursor) {
                this._evictionKeyCursor.close();
                this._evictionKeyCursor = null;
            }
            this.startEvictor(-1L);
        }
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    public synchronized void evict() throws Exception {
        Object key = null;
        if (this._evictionKeyCursor != null && this._evictionKeyCursor._lastReturned != null) {
            key = this._evictionKeyCursor._lastReturned.value();
        }
        int m = this.getNumTests();
        for (int i = 0; i < m; ++i) {
            if (this._poolMap == null || this._poolMap.size() == 0) continue;
            if (null == this._evictionKeyCursor) {
                this.resetEvictionKeyCursor();
                key = null;
            }
            if (null == this._evictionCursor) {
                if (this._evictionKeyCursor.hasNext()) {
                    key = this._evictionKeyCursor.next();
                    this.resetEvictionObjectCursor(key);
                } else {
                    this.resetEvictionKeyCursor();
                    if (this._evictionKeyCursor != null && this._evictionKeyCursor.hasNext()) {
                        key = this._evictionKeyCursor.next();
                        this.resetEvictionObjectCursor(key);
                    }
                }
            }
            if (this._evictionCursor == null) continue;
            if ((this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) && this._evictionKeyCursor != null) {
                if (this._evictionKeyCursor.hasNext()) {
                    key = this._evictionKeyCursor.next();
                    this.resetEvictionObjectCursor(key);
                } else {
                    this.resetEvictionKeyCursor();
                    if (this._evictionKeyCursor != null && this._evictionKeyCursor.hasNext()) {
                        key = this._evictionKeyCursor.next();
                        this.resetEvictionObjectCursor(key);
                    }
                }
            }
            if (this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) continue;
            ObjectTimestampPair pair = this._lifo ? (ObjectTimestampPair)this._evictionCursor.previous() : (ObjectTimestampPair)this._evictionCursor.next();
            boolean removeObject = false;
            if (this._minEvictableIdleTimeMillis > 0L && System.currentTimeMillis() - pair.tstamp > this._minEvictableIdleTimeMillis) {
                removeObject = true;
            }
            if (this._testWhileIdle && !removeObject) {
                boolean active = false;
                try {
                    this._factory.activateObject(key, pair.value);
                    active = true;
                }
                catch (Exception e) {
                    removeObject = true;
                }
                if (active) {
                    if (!this._factory.validateObject(key, pair.value)) {
                        removeObject = true;
                    } else {
                        try {
                            this._factory.passivateObject(key, pair.value);
                        }
                        catch (Exception e) {
                            removeObject = true;
                        }
                    }
                }
            }
            if (!removeObject) continue;
            try {
                ObjectQueue objectQueue;
                this._evictionCursor.remove();
                --this._totalIdle;
                this._factory.destroyObject(key, pair.value);
                if (this._minIdle != 0 || (objectQueue = (ObjectQueue)this._poolMap.get(key)) == null || !objectQueue.queue.isEmpty()) continue;
                this._poolMap.remove(key);
                this._poolList.remove(key);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void resetEvictionKeyCursor() {
        if (this._evictionKeyCursor != null) {
            this._evictionKeyCursor.close();
        }
        this._evictionKeyCursor = this._poolList.cursor();
        if (null != this._evictionCursor) {
            this._evictionCursor.close();
            this._evictionCursor = null;
        }
    }

    private void resetEvictionObjectCursor(Object key) {
        if (this._evictionCursor != null) {
            this._evictionCursor.close();
        }
        if (this._poolMap == null) {
            return;
        }
        ObjectQueue pool = (ObjectQueue)this._poolMap.get(key);
        if (pool != null) {
            CursorableLinkedList queue = pool.queue;
            this._evictionCursor = queue.cursor(this._lifo ? queue.size() : 0);
        }
    }

    private synchronized void ensureMinIdle() throws Exception {
        Iterator iterator = this._poolMap.keySet().iterator();
        if (this._minIdle > 0) {
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.ensureMinIdle(key);
            }
        }
    }

    private synchronized void ensureMinIdle(Object key) throws Exception {
        int numberToCreate = this.calculateDefecit(key);
        for (int i = 0; i < numberToCreate; ++i) {
            this.addObject(key);
        }
    }

    protected synchronized void startEvictor(long delay) {
        if (null != this._evictor) {
            EvictionTimer.cancel(this._evictor);
            this._evictor = null;
        }
        if (delay > 0L) {
            this._evictor = new Evictor();
            EvictionTimer.schedule(this._evictor, delay, delay);
        }
    }

    synchronized String debugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Active: ").append(this.getNumActive()).append("\n");
        buf.append("Idle: ").append(this.getNumIdle()).append("\n");
        Iterator it = this._poolMap.keySet().iterator();
        while (it.hasNext()) {
            buf.append("\t").append(this._poolMap.get(it.next())).append("\n");
        }
        return buf.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return this._numTestsPerEvictionRun;
        }
        return (int)Math.ceil((double)this._totalIdle / Math.abs((double)this._numTestsPerEvictionRun));
    }

    private int calculateDefecit(Object key) {
        int growLimit;
        int objectDefecit = 0;
        objectDefecit = this.getMinIdle() - this.getNumIdle(key);
        if (this.getMaxActive() > 0) {
            growLimit = Math.max(0, this.getMaxActive() - this.getNumActive(key) - this.getNumIdle(key));
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        if (this.getMaxTotal() > 0) {
            growLimit = Math.max(0, this.getMaxTotal() - this.getNumActive() - this.getNumIdle());
            objectDefecit = Math.min(objectDefecit, growLimit);
        }
        return objectDefecit;
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public int maxTotal = -1;
        public int minIdle = 0;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
        public boolean lifo = true;
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        public void run() {
            try {
                GenericKeyedObjectPool.this.evict();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                GenericKeyedObjectPool.this.ensureMinIdle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ObjectQueue {
        private int activeCount = 0;
        private final CursorableLinkedList queue = new CursorableLinkedList();

        private ObjectQueue() {
        }

        void incrementActiveCount() {
            GenericKeyedObjectPool.this._totalActive++;
            ++this.activeCount;
        }

        void decrementActiveCount() {
            GenericKeyedObjectPool.this._totalActive--;
            if (this.activeCount > 0) {
                --this.activeCount;
            }
        }
    }

    static class ObjectTimestampPair
    implements Comparable {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object val) {
            this(val, System.currentTimeMillis());
        }

        ObjectTimestampPair(Object val, long time) {
            this.value = val;
            this.tstamp = time;
        }

        public String toString() {
            return this.value + ";" + this.tstamp;
        }

        public int compareTo(Object obj) {
            return this.compareTo((ObjectTimestampPair)obj);
        }

        public int compareTo(ObjectTimestampPair other) {
            long tstampdiff = this.tstamp - other.tstamp;
            if (tstampdiff == 0L) {
                return System.identityHashCode(this) - System.identityHashCode(other);
            }
            return (int)Math.min(Math.max(tstampdiff, Integer.MIN_VALUE), Integer.MAX_VALUE);
        }
    }
}

