/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.AnnotationUtil;
import com.google.gwt.i18n.rebind.AnnotationsResource;
import com.google.gwt.i18n.rebind.ConstantsImplCreator;
import com.google.gwt.i18n.rebind.ConstantsWithLookupImplCreator;
import com.google.gwt.i18n.rebind.LocalizableGenerator;
import com.google.gwt.i18n.rebind.MessagesImplCreator;
import com.google.gwt.i18n.rebind.ResourceFactory;
import com.google.gwt.i18n.rebind.format.MessageCatalogFormat;
import com.google.gwt.i18n.rebind.keygen.KeyGenerator;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractGeneratorClassCreator;
import com.google.gwt.user.rebind.AbstractMethodCreator;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.MissingResourceException;

abstract class AbstractLocalizableImplCreator
extends AbstractGeneratorClassCreator {
    private KeyGenerator keyGenerator;
    private AbstractResource.ResourceList resourceList;
    private boolean isConstants;

    static String generateConstantOrMessageClass(TreeLogger logger, GeneratorContext context, GwtLocale locale, JClassType targetClass) throws UnableToCompleteException {
        LocalizableResource.Generate generate;
        JClassType messagesClass;
        JClassType constantsWithLookupClass;
        JClassType constantsClass;
        TypeOracle oracle = context.getTypeOracle();
        boolean seenError = false;
        try {
            constantsClass = oracle.getType(LocalizableGenerator.CONSTANTS_NAME);
            constantsWithLookupClass = oracle.getType(LocalizableGenerator.CONSTANTS_WITH_LOOKUP_NAME);
            messagesClass = oracle.getType(LocalizableGenerator.MESSAGES_NAME);
        }
        catch (NotFoundException e) {
            throw AbstractLocalizableImplCreator.error(logger, e);
        }
        String name = targetClass.getName();
        String packageName = targetClass.getPackage().getName();
        boolean assignableToConstants = constantsClass.isAssignableFrom(targetClass);
        boolean assignableToMessages = messagesClass.isAssignableFrom(targetClass);
        if (!assignableToConstants && !assignableToMessages) {
            return null;
        }
        if (assignableToConstants && assignableToMessages) {
            throw AbstractLocalizableImplCreator.error(logger, name + " cannot extend both Constants and Messages");
        }
        if (targetClass.isInterface() == null) {
            throw AbstractLocalizableImplCreator.error(logger, name + " must be an interface");
        }
        AbstractResource.ResourceList resourceList = null;
        try {
            resourceList = ResourceFactory.getBundle(logger, targetClass, locale, assignableToConstants, context.getResourcesOracle().getResourceMap());
        }
        catch (MissingResourceException e) {
            throw AbstractLocalizableImplCreator.error(logger, "Localization failed; there must be at least one resource accessible through the classpath in package '" + packageName + "' whose base name is '" + ResourceFactory.getResourceName(targetClass) + "'");
        }
        catch (IllegalArgumentException e) {
            throw AbstractLocalizableImplCreator.error(logger, e.getMessage());
        }
        GwtLocale generatedLocale = resourceList.findLeastDerivedLocale(logger, locale);
        String localeSuffix = String.valueOf('_');
        localeSuffix = localeSuffix + generatedLocale.getAsString();
        String resourceName = targetClass.getName().replace('.', '_');
        String className = resourceName + localeSuffix;
        PrintWriter pw = context.tryCreate(logger, packageName, className);
        if (pw != null) {
            ConstantsImplCreator c;
            ClassSourceFileComposerFactory factory = new ClassSourceFileComposerFactory(packageName, className);
            factory.addImplementedInterface(targetClass.getQualifiedSourceName());
            SourceWriter writer = factory.createSourceWriter(context, pw);
            if (constantsWithLookupClass.isAssignableFrom(targetClass)) {
                c = new ConstantsWithLookupImplCreator(logger, writer, targetClass, resourceList, context.getTypeOracle());
                c.emitClass(logger, generatedLocale);
            } else if (constantsClass.isAssignableFrom(targetClass)) {
                c = new ConstantsImplCreator(logger, writer, targetClass, resourceList, context.getTypeOracle());
                c.emitClass(logger, generatedLocale);
            } else {
                MessagesImplCreator messages = new MessagesImplCreator(logger, writer, targetClass, resourceList, context.getTypeOracle());
                messages.emitClass(logger, generatedLocale);
            }
            context.commit(logger, pw);
        }
        if ((generate = AnnotationUtil.getClassAnnotation(targetClass, LocalizableResource.Generate.class)) != null) {
            String path = generate.fileName();
            if ("[default]".equals(path)) {
                path = targetClass.getPackage().getName() + "." + targetClass.getName().replace('.', '_');
            } else if (path.endsWith(File.pathSeparator)) {
                path = path + targetClass.getName().replace('.', '_');
            }
            String[] genLocales = generate.locales();
            boolean found = false;
            if (genLocales.length != 0) {
                for (String genLocale : genLocales) {
                    if ("default".equals(genLocale)) {
                        try {
                            SelectionProperty localeProp = context.getPropertyOracle().getSelectionProperty(logger, "locale");
                            String defaultLocale = localeProp.getFallbackValue();
                            if (defaultLocale.length() > 0) {
                                genLocale = defaultLocale;
                            }
                        }
                        catch (BadPropertyValueException e) {
                            throw AbstractLocalizableImplCreator.error(logger, "Could not get 'locale' property");
                        }
                    }
                    if (!genLocale.equals(((Object)locale).toString())) continue;
                    found = true;
                    break;
                }
            } else {
                found = true;
            }
            if (found) {
                for (String genClassName : generate.format()) {
                    OutputStream outStr;
                    MessageCatalogFormat msgWriter = null;
                    try {
                        Class<MessageCatalogFormat> msgFormatClass = Class.forName(genClassName, false, MessageCatalogFormat.class.getClassLoader()).asSubclass(MessageCatalogFormat.class);
                        msgWriter = msgFormatClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        logger.log(TreeLogger.ERROR, "Error instantiating @Generate class " + genClassName, (Throwable)e);
                        seenError = true;
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        logger.log(TreeLogger.ERROR, "@Generate class " + genClassName + " illegal access", (Throwable)e);
                        seenError = true;
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        logger.log(TreeLogger.ERROR, "@Generate class " + genClassName + " not found");
                        seenError = true;
                        continue;
                    }
                    String genPath = path;
                    if (genLocales.length != 1) {
                        genPath = genPath + '_' + ((Object)locale).toString();
                    }
                    if ((outStr = context.tryCreateResource(logger, genPath = genPath + msgWriter.getExtension())) == null) continue;
                    TreeLogger branch = logger.branch(TreeLogger.INFO, "Generating " + genPath + " from " + className + " for locale " + locale, null);
                    PrintWriter out = null;
                    try {
                        out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outStr, "UTF-8")), false);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw AbstractLocalizableImplCreator.error(logger, e.getMessage());
                    }
                    try {
                        msgWriter.write(branch, ((Object)locale).toString(), resourceList, out, targetClass);
                        out.flush();
                        context.commitResource(logger, outStr).setPrivate(true);
                    }
                    catch (UnableToCompleteException e) {
                        seenError = true;
                    }
                }
            }
        }
        if (seenError) {
            throw new UnableToCompleteException();
        }
        return packageName + "." + className;
    }

    public AbstractLocalizableImplCreator(TreeLogger logger, SourceWriter writer, JClassType targetClass, AbstractResource.ResourceList resourceList, boolean isConstants) {
        super(writer, targetClass);
        this.resourceList = resourceList;
        this.isConstants = isConstants;
        try {
            this.keyGenerator = AnnotationsResource.getKeyGenerator(targetClass);
        }
        catch (AnnotationsResource.AnnotationsError e) {
            logger.log(TreeLogger.WARN, "Error getting key generator for " + targetClass.getQualifiedSourceName(), (Throwable)e);
        }
    }

    public AbstractResource.ResourceList getResourceBundle() {
        return this.resourceList;
    }

    protected String branchMessage() {
        return "Processing " + this.getTarget();
    }

    protected void delegateToCreator(TreeLogger logger, JMethod method, GwtLocale locale) throws UnableToCompleteException {
        AbstractMethodCreator methodCreator = this.getMethodCreator(logger, method);
        String key = this.getKey(logger, method);
        if (key == null) {
            logger.log(TreeLogger.ERROR, "Unable to get or compute key for method " + method.getName(), null);
            throw new UnableToCompleteException();
        }
        methodCreator.createMethodFor(logger, method, key, this.resourceList, locale);
    }

    protected String getKey(TreeLogger logger, JMethod method) {
        LocalizableResource.Key key = (LocalizableResource.Key)method.getAnnotation(LocalizableResource.Key.class);
        if (key != null) {
            return key.value();
        }
        return AnnotationsResource.getKey(logger, this.keyGenerator, method, this.isConstants);
    }
}

