/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.i18n.client.PluralRule;
import com.google.gwt.i18n.rebind.AnnotationsResource;
import com.google.gwt.i18n.rebind.LocaleUtils;
import com.google.gwt.i18n.shared.GwtLocale;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource {
    public static final int REPORT_KEYS_THRESHOLD = 30;
    protected GwtLocale matchLocale;
    private Set<String> keySet;
    private String path;

    protected static String getExtendedKey(String key, String extension) {
        if (extension != null) {
            key = key + '[' + extension + ']';
        }
        return key;
    }

    public AbstractResource(GwtLocale matchLocale) {
        this.matchLocale = matchLocale;
    }

    public Collection<String> getExtensions(String key) {
        return new ArrayList<String>();
    }

    public final String getRequiredString(String key) {
        return this.getRequiredStringExt(key, null);
    }

    public final String getRequiredStringExt(String key, String extension) {
        String s = this.getStringExt(key, extension);
        if (s == null) {
            ArrayList<AbstractResource> list = new ArrayList<AbstractResource>();
            list.add(this);
            throw new MissingResourceException(key, list);
        }
        return s;
    }

    public final String getString(String key) {
        return this.getStringExt(key, null);
    }

    public abstract String getStringExt(String var1, String var2);

    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            this.addToKeySet(this.keySet);
        }
        return this.keySet;
    }

    public boolean notEmpty() {
        return !this.keySet.isEmpty();
    }

    public String toString() {
        return "resource for " + this.path;
    }

    public String toVerboseString() {
        StringBuffer b = new StringBuffer();
        this.toVerboseStringAux(0, b);
        return b.toString();
    }

    abstract void addToKeySet(Set<String> var1);

    GwtLocale getMatchLocale() {
        return this.matchLocale;
    }

    String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    private void newLine(int indent, StringBuffer buf) {
        buf.append("\n");
        for (int i = 0; i < indent; ++i) {
            buf.append("\t");
        }
    }

    private void toVerboseStringAux(int indent, StringBuffer buf) {
        this.newLine(indent, buf);
        buf.append(this.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MissingResourceException
    extends RuntimeException {
        private String during;
        private String key;
        private String method;
        private List<AbstractResource> searchedResources;

        public MissingResourceException(String key, List<AbstractResource> searchedResources) {
            super("No resource found for key '" + key + "'");
            this.key = key;
            this.searchedResources = searchedResources;
        }

        public String getDuring() {
            return this.during;
        }

        public String getKey() {
            return this.key;
        }

        public String getMethod() {
            return this.method;
        }

        public List<AbstractResource> getSearchedResources() {
            return this.searchedResources;
        }

        public void setDuring(String during) {
            this.during = during;
        }

        public void setMethod(String method) {
            this.method = method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceList
    extends AbstractList<AbstractResource>
    implements Set<AbstractResource> {
        private List<AbstractResource> list = new ArrayList<AbstractResource>();
        private Map<String, PluralRule.PluralForm[]> pluralForms = new HashMap<String, PluralRule.PluralForm[]>();
        private Set<AbstractResource> set = new HashSet<AbstractResource>();

        @Override
        public boolean add(AbstractResource element) {
            if (this.set.contains(element)) {
                return false;
            }
            this.set.add(element);
            return this.list.add(element);
        }

        @Override
        public void add(int index, AbstractResource element) {
            if (this.set.contains(element)) {
                throw new IllegalArgumentException("Duplicate element");
            }
            this.set.add(element);
            this.list.add(index, element);
        }

        public void addToKeySet(Set<String> s) {
            for (AbstractResource resource : this.list) {
                resource.addToKeySet(s);
            }
        }

        public GwtLocale findLeastDerivedLocale(TreeLogger logger, GwtLocale locale) {
            GwtLocale defaultLocale;
            List<GwtLocale> searchList = locale.getCompleteSearchList();
            HashMap<GwtLocale, Integer> derivedIndex = new HashMap<GwtLocale, Integer>();
            for (int i = 0; i < searchList.size(); ++i) {
                derivedIndex.put(searchList.get(i), i);
            }
            GwtLocale best = defaultLocale = LocaleUtils.getLocaleFactory().getDefault();
            int bestIdx = Integer.MAX_VALUE;
            for (int i = 0; i < this.list.size(); ++i) {
                GwtLocale matchLocale = this.list.get(i).getMatchLocale();
                Integer wrappedIdx = (Integer)derivedIndex.get(matchLocale);
                if (wrappedIdx == null && (wrappedIdx = (Integer)derivedIndex.get(defaultLocale)) == null) {
                    assert (false) : "No default locale in search list";
                    continue;
                }
                int idx = wrappedIdx;
                if (idx >= bestIdx) continue;
                bestIdx = idx;
                best = matchLocale;
            }
            return best;
        }

        @Override
        public AbstractResource get(int index) {
            return this.list.get(index);
        }

        public AnnotationsResource getAnnotationsResource(TreeLogger logger, String key) {
            for (AbstractResource resource : this.list) {
                if (!(resource instanceof AnnotationsResource) || !resource.keySet.contains(key)) continue;
                return (AnnotationsResource)resource;
            }
            return null;
        }

        public Collection<String> getExtension(String key) {
            HashSet<String> extensions = new HashSet<String>();
            for (AbstractResource resource : this.list) {
                extensions.addAll(resource.getExtensions(key));
            }
            return extensions;
        }

        public PluralRule.PluralForm[] getPluralForms(String key) {
            return this.pluralForms.get(key);
        }

        public String getRequiredString(String key) throws MissingResourceException {
            String val = this.getString(key);
            if (val == null) {
                throw new MissingResourceException(key, this.list);
            }
            return val;
        }

        public String getRequiredStringExt(String key, String ext) throws MissingResourceException {
            String val = this.getStringExt(key, ext);
            if (val == null) {
                throw new MissingResourceException(AbstractResource.getExtendedKey(key, ext), this.list);
            }
            return val;
        }

        public String getString(String key) {
            for (AbstractResource resource : this.list) {
                String s = resource.getStringExt(key, null);
                if (s == null) continue;
                return s;
            }
            return null;
        }

        public String getStringExt(String key, String extension) {
            for (AbstractResource resource : this.list) {
                String s = resource.getStringExt(key, extension);
                if (s == null) continue;
                return s;
            }
            return null;
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public Iterator<AbstractResource> iterator() {
            return this.list.iterator();
        }

        public Set<String> keySet() {
            HashSet<String> keySet = new HashSet<String>();
            for (AbstractResource resource : this.list) {
                keySet.addAll(resource.keySet());
            }
            return keySet;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public AbstractResource remove(int index) {
            AbstractResource element = this.list.remove(index);
            this.set.remove(element);
            return element;
        }

        public void setPluralForms(String key, PluralRule.PluralForm[] forms) {
            if (!this.pluralForms.containsKey(key)) {
                this.pluralForms.put(key, forms);
            }
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

