/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.rebind;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.junit.client.impl.GWTRunner;
import com.google.gwt.junit.client.impl.JUnitHost;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTRunnerGenerator
extends Generator {
    private static final String GWT_RUNNER_NAME = GWTRunner.class.getName();

    private static String getPackagePrefix(JClassType classType) {
        String name = classType.getPackage().getName();
        return name.length() == 0 ? name : name + '.';
    }

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        String userAgent;
        String moduleName;
        JClassType requestedClass;
        if (!GWT_RUNNER_NAME.equals(typeName)) {
            logger.log(TreeLogger.ERROR, "This generator may only be used with " + GWT_RUNNER_NAME, null);
            throw new UnableToCompleteException();
        }
        try {
            requestedClass = context.getTypeOracle().getType(typeName);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Could not find type '" + typeName + "'; please see the log, as this usually indicates a previous error ", (Throwable)e);
            throw new UnableToCompleteException();
        }
        try {
            ConfigurationProperty prop = context.getPropertyOracle().getConfigurationProperty("junit.moduleName");
            moduleName = (String)prop.getValues().get(0);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Could not resolve junit.moduleName property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        try {
            SelectionProperty prop = context.getPropertyOracle().getSelectionProperty(logger, "user.agent");
            userAgent = prop.getCurrentValue();
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Could not resolve user.agent property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        String generatedClass = requestedClass.getName().replace('.', '_') + "Impl" + userAgent;
        String packageName = requestedClass.getPackage().getName();
        String qualifiedStubClassName = packageName + "." + generatedClass;
        SourceWriter sourceWriter = this.getSourceWriter(logger, context, packageName, generatedClass, GWT_RUNNER_NAME);
        if (sourceWriter != null) {
            TreeSet<String> testClasses;
            Set<JUnitHost.TestInfo> moduleTests;
            GWTTestCase.TestModuleInfo moduleInfo = GWTTestCase.getTestsForModule(moduleName);
            Set<JUnitHost.TestInfo> set = moduleTests = moduleInfo == null ? null : moduleInfo.getTests();
            if (moduleTests == null || moduleTests.isEmpty()) {
                JClassType[] allTestTypes = this.getAllPossibleTestTypes(context.getTypeOracle());
                testClasses = this.getTestTypesForModule(logger, moduleName, allTestTypes);
            } else {
                testClasses = new TreeSet();
                for (JUnitHost.TestInfo testInfo : moduleTests) {
                    testClasses.add(testInfo.getTestClass());
                }
            }
            this.writeCreateNewTestCaseMethod(testClasses, sourceWriter);
            this.writeGetUserAgentPropertyMethod(userAgent, sourceWriter);
            sourceWriter.commit(logger);
        }
        return qualifiedStubClassName;
    }

    private JClassType[] getAllPossibleTestTypes(TypeOracle typeOracle) {
        JClassType gwtTestType = typeOracle.findType(GWTTestCase.class.getName());
        if (gwtTestType != null) {
            return gwtTestType.getSubtypes();
        }
        return new JClassType[0];
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext ctx, String packageName, String className, String superclassName) {
        PrintWriter printWriter = ctx.tryCreate(logger, packageName, className);
        if (printWriter == null) {
            return null;
        }
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(packageName, className);
        composerFactory.setSuperclass(superclassName);
        composerFactory.addImport(GWTTestCase.class.getName());
        composerFactory.addImport(GWT.class.getName());
        return composerFactory.createSourceWriter(ctx, printWriter);
    }

    private Set<String> getTestTypesForModule(TreeLogger logger, String moduleName, JClassType[] allTestTypes) {
        TreeSet<String> testClasses = new TreeSet<String>();
        for (JClassType classType : allTestTypes) {
            block4: {
                if (!classType.isPublic() || classType.isAbstract() || !classType.isDefaultInstantiable()) continue;
                String className = GWTRunnerGenerator.getPackagePrefix(classType) + classType.getName().replace('.', '$');
                try {
                    Class<?> testClass = Class.forName(className);
                    GWTTestCase instantiated = (GWTTestCase)((Object)testClass.newInstance());
                    if (!moduleName.equals(instantiated.getModuleName())) {
                    }
                    break block4;
                }
                catch (Throwable e) {
                    logger.log(TreeLogger.INFO, "Error determining if test class '" + className + "' is a part of the current module; skipping; expect subsequent errors if this test class is run", e);
                }
                continue;
            }
            testClasses.add(classType.getQualifiedSourceName());
        }
        return testClasses;
    }

    private void writeCreateNewTestCaseMethod(Set<String> testClasses, SourceWriter sw) {
        sw.println();
        sw.println("protected final GWTTestCase createNewTestCase(String testClass) {");
        sw.indent();
        boolean isFirst = true;
        for (String className : testClasses) {
            if (isFirst) {
                isFirst = false;
            } else {
                sw.print("else ");
            }
            sw.println("if (testClass.equals(\"" + className + "\")) {");
            sw.indentln("return GWT.create(" + className + ".class);");
            sw.println("}");
        }
        sw.println("return null;");
        sw.outdent();
        sw.println("}");
    }

    private void writeGetUserAgentPropertyMethod(String userAgent, SourceWriter sw) {
        sw.println();
        sw.println("protected final String getUserAgentProperty() {");
        sw.indent();
        sw.println("return \"" + userAgent + "\";");
        sw.outdent();
        sw.println("}");
    }
}

